/*
 * Decompiled with CFR 0.152.
 */
package com.cz.widget.recyclerview.adapter.wrapper.header;

import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import com.cz.widget.recyclerview.adapter.WrapperAdapter;
import com.cz.widget.recyclerview.adapter.listener.OnItemClickListener;
import com.cz.widget.recyclerview.adapter.listener.OnItemLongClickListener;
import com.cz.widget.recyclerview.adapter.wrapper.WrapperAdapterDataObserver;
import java.util.ArrayList;
import java.util.List;

public class HeaderWrapperAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder>
implements WrapperAdapter {
    private final int TYPE_EXTRAS = -1;
    private final RecyclerView.AdapterDataObserver adapterDataObserve = new WrapperAdapterDataObserver<HeaderWrapperAdapter>(this);
    private final List<FixedViewInfo> headerViewArray = new ArrayList<FixedViewInfo>();
    private final List<FixedViewInfo> footerViewArray = new ArrayList<FixedViewInfo>();
    private int fixedViewCount = 0;
    private RecyclerView.Adapter adapter;
    private OnItemClickListener itemClickListener;
    private OnItemLongClickListener longClickListener;

    public HeaderWrapperAdapter(@Nullable RecyclerView.Adapter adapter) {
        if (null != adapter) {
            this.adapter = adapter;
            this.adapter.registerAdapterDataObserver(this.adapterDataObserve);
        }
    }

    public void setAdapter(@NonNull RecyclerView.Adapter adapter) {
        RecyclerView.Adapter oldAdapter = this.adapter;
        if (null != oldAdapter) {
            oldAdapter.unregisterAdapterDataObserver(this.adapterDataObserve);
        }
        this.adapter = adapter;
        this.adapter.registerAdapterDataObserver(this.adapterDataObserve);
        this.notifyDataSetChanged();
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        RecyclerView.LayoutManager manager;
        super.onAttachedToRecyclerView(recyclerView);
        if (null != this.adapter) {
            this.adapter.onAttachedToRecyclerView(recyclerView);
        }
        if ((manager = recyclerView.getLayoutManager()) instanceof GridLayoutManager) {
            final GridLayoutManager gridLayoutManager = (GridLayoutManager)manager;
            final GridLayoutManager.SpanSizeLookup spanSizeLookup = gridLayoutManager.getSpanSizeLookup();
            gridLayoutManager.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup(){

                public int getSpanSize(int position) {
                    int spanSize;
                    int n = spanSize = HeaderWrapperAdapter.this.isExtraPosition(position) ? gridLayoutManager.getSpanCount() : 1;
                    if (null != spanSizeLookup) {
                        return Math.max(spanSize, spanSizeLookup.getSpanSize(position));
                    }
                    return spanSize;
                }
            });
        }
    }

    protected boolean isExtraPosition(int position) {
        return this.isHeaderPosition(position) || this.isFooterPosition(position);
    }

    public void onViewAttachedToWindow(RecyclerView.ViewHolder holder) {
        super.onViewAttachedToWindow(holder);
        ViewGroup.LayoutParams lp = holder.itemView.getLayoutParams();
        if (lp != null && lp instanceof StaggeredGridLayoutManager.LayoutParams && this.isExtraPosition(holder.getAdapterPosition())) {
            StaggeredGridLayoutManager.LayoutParams p = (StaggeredGridLayoutManager.LayoutParams)lp;
            p.setFullSpan(true);
        }
    }

    protected boolean isHeaderPosition(int position) {
        int headerViewCount = this.getHeaderViewCount();
        return position < headerViewCount;
    }

    protected boolean isFooterPosition(int position) {
        int startPosition = this.getFooterStartPosition();
        return startPosition <= position;
    }

    private int getFooterStartPosition() {
        int itemCount = this.getItemCount();
        int footerViewCount = this.getFooterViewCount();
        return itemCount - footerViewCount;
    }

    public int getHeaderViewCount() {
        return this.headerViewArray.size();
    }

    public int getFooterViewCount() {
        return this.footerViewArray.size();
    }

    public void addHeaderView(@NonNull View view) {
        int viewType = -1 - this.fixedViewCount++;
        this.headerViewArray.add(new FixedViewInfo(viewType, view));
        this.notifyItemInserted(this.headerViewArray.size() - 1);
    }

    protected void addFooterView(@NonNull View view, int index) {
        int footerViewCount = this.getFooterViewCount();
        if (0 > index || index > footerViewCount) {
            throw new IllegalArgumentException("The footer index is out of bound!");
        }
        int viewType = -1 - this.fixedViewCount++;
        this.footerViewArray.add(index, new FixedViewInfo(viewType, view));
        int startPosition = this.getFooterStartPosition();
        this.notifyItemInserted(startPosition + index);
    }

    public void addFooterView(@NonNull View view) {
        int footerViewCount = this.getFooterViewCount();
        this.addFooterView(view, footerViewCount);
    }

    @Nullable
    public View getHeaderView(int index) {
        View view = null;
        int headerViewCount = this.getHeaderViewCount();
        if (0 <= index && index < headerViewCount) {
            view = this.headerViewArray.get((int)index).view;
        }
        return view;
    }

    @Nullable
    public View getFooterView(int index) {
        View view = null;
        int footerViewCount = this.getFooterViewCount();
        if (0 <= index && index < footerViewCount) {
            view = this.footerViewArray.get((int)index).view;
        }
        return view;
    }

    public View findView(@IdRes int id) {
        View findView = this.findViewInternal(this.headerViewArray, id);
        if (null == findView) {
            findView = this.findViewInternal(this.footerViewArray, id);
        }
        return findView;
    }

    private View findViewInternal(List<FixedViewInfo> viewArray, @IdRes int id) {
        View findView = null;
        for (int i = 0; i < viewArray.size(); ++i) {
            FixedViewInfo viewItem = viewArray.get(i);
            View view = viewItem.view.findViewById(id);
            if (null == view) continue;
            findView = view;
            break;
        }
        return findView;
    }

    public void removeHeaderView(View view) {
        if (null == view) {
            return;
        }
        this.removeHeaderView(this.indexOfView(this.headerViewArray, view));
    }

    public int indexOfHeaderView(View view) {
        return this.indexOfView(this.headerViewArray, view);
    }

    public void removeHeaderView(int position) {
        if (this.isHeaderPosition(position)) {
            this.headerViewArray.remove(position);
            this.notifyItemRemoved(position);
        }
    }

    public void removeFooterView(View view) {
        if (null == view) {
            return;
        }
        this.removeFooterView(this.indexOfView(this.footerViewArray, view));
    }

    public void clearHeaderViews() {
        int headerViewCount = this.getHeaderViewCount();
        this.headerViewArray.clear();
        this.notifyItemRangeRemoved(0, headerViewCount);
    }

    public void removeFooterView(int position) {
        int footerViewCount = this.getFooterViewCount();
        if (0 <= position && position < footerViewCount) {
            this.footerViewArray.remove(position);
            int startFooterStartPosition = this.getFooterStartPosition();
            this.notifyItemRemoved(startFooterStartPosition + position);
        }
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        RecyclerView.ViewHolder holder;
        if (-1 >= viewType) {
            View extraView = this.getExtraView(this.headerViewArray, this.footerViewArray, viewType);
            holder = new RecyclerView.ViewHolder(extraView){};
        } else {
            holder = this.adapter.onCreateViewHolder(parent, viewType);
        }
        return holder;
    }

    private int indexOfView(List<FixedViewInfo> items, View view) {
        int index = -1;
        for (int i = 0; i < items.size(); ++i) {
            FixedViewInfo viewItem = items.get(i);
            if (viewItem.view != view) continue;
            index = i;
            break;
        }
        return index;
    }

    private View getExtraView(List<FixedViewInfo> headerViews, List<FixedViewInfo> footerViews, int type) {
        FixedViewInfo viewItem;
        int i;
        View view = null;
        for (i = 0; i < headerViews.size(); ++i) {
            viewItem = headerViews.get(i);
            if (viewItem.viewType != type) continue;
            view = viewItem.view;
            break;
        }
        if (null == view) {
            for (i = 0; i < footerViews.size(); ++i) {
                viewItem = footerViews.get(i);
                if (viewItem.viewType != type) continue;
                view = viewItem.view;
                break;
            }
        }
        return view;
    }

    public void onBindViewHolder(final RecyclerView.ViewHolder holder, int position) {
        if (!this.isExtraPosition(position) && null != this.adapter) {
            int extraViewCount = this.getExtraViewCount(position);
            this.adapter.onBindViewHolder(holder, position - extraViewCount);
            if (!holder.itemView.hasOnClickListeners()) {
                holder.itemView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        int adapterPosition = holder.getAdapterPosition();
                        int itemPosition = adapterPosition - HeaderWrapperAdapter.this.getExtraViewCount(adapterPosition);
                        if (HeaderWrapperAdapter.this.onItemClick(v, itemPosition, adapterPosition) && null != HeaderWrapperAdapter.this.itemClickListener) {
                            HeaderWrapperAdapter.this.itemClickListener.onItemClick(v, itemPosition, adapterPosition);
                        }
                    }
                });
            }
            if (!holder.itemView.isLongClickable()) {
                holder.itemView.setOnLongClickListener(new View.OnLongClickListener(){

                    public boolean onLongClick(View v) {
                        int adapterPosition = holder.getAdapterPosition();
                        int itemPosition = adapterPosition - HeaderWrapperAdapter.this.getExtraViewCount(adapterPosition);
                        if (null != HeaderWrapperAdapter.this.longClickListener) {
                            return HeaderWrapperAdapter.this.longClickListener.onLongItemClick(v, itemPosition, adapterPosition);
                        }
                        return false;
                    }
                });
            }
        }
    }

    protected boolean onItemClick(View v, int position, int adapterPosition) {
        return true;
    }

    public int getAdapterItemCount() {
        int itemCount = 0;
        if (null != this.adapter) {
            itemCount = this.adapter.getItemCount();
        }
        return itemCount;
    }

    public int getItemCount() {
        int headerViewCount = this.getHeaderViewCount();
        int adapterItemCount = this.getAdapterItemCount();
        int footerViewCount = this.getFooterViewCount();
        return headerViewCount + adapterItemCount + footerViewCount;
    }

    public int getItemViewType(int position) {
        int adapterItemCount;
        int adapterPosition;
        int itemType = -1;
        if (this.isHeaderPosition(position)) {
            itemType = this.headerViewArray.get((int)position).viewType;
        } else if (this.isFooterPosition(position)) {
            int startFooterStartPosition = this.getFooterStartPosition();
            itemType = this.footerViewArray.get((int)(position - startFooterStartPosition)).viewType;
        } else if (this.adapter != null && (adapterPosition = position - this.getExtraViewCount(position)) < (adapterItemCount = this.getAdapterItemCount())) {
            itemType = this.adapter.getItemViewType(adapterPosition);
        }
        return itemType;
    }

    public long getItemId(int position) {
        int itemCount;
        if (this.adapter != null && !this.isExtraPosition(position) && (position = -this.getExtraViewCount(position)) < (itemCount = this.adapter.getItemCount())) {
            return this.adapter.getItemId(position);
        }
        return -1L;
    }

    public void onViewRecycled(@NonNull RecyclerView.ViewHolder holder) {
        super.onViewRecycled(holder);
        if (null != this.adapter) {
            this.adapter.onViewRecycled(holder);
        }
    }

    public void onDetachedFromRecyclerView(@NonNull RecyclerView recyclerView) {
        super.onDetachedFromRecyclerView(recyclerView);
        if (null != this.adapter) {
            this.adapter.onDetachedFromRecyclerView(recyclerView);
        }
    }

    public void onViewDetachedFromWindow(@NonNull RecyclerView.ViewHolder holder) {
        super.onViewDetachedFromWindow(holder);
    }

    public void setOnItemClickListener(OnItemClickListener listener) {
        this.itemClickListener = listener;
    }

    public void setOnItemLongClickListener(OnItemLongClickListener listener) {
        this.longClickListener = listener;
    }

    @Override
    public RecyclerView.Adapter getAdapter() {
        return this.adapter;
    }

    @Override
    public int getOffsetPosition(int position) {
        int extraViewCount = this.getHeaderViewCount();
        return extraViewCount + position;
    }

    @Override
    public int getExtraViewCount(int position) {
        return this.getHeaderViewCount();
    }

    @Override
    public void onChanged() {
        this.notifyDataSetChanged();
    }

    @Override
    public void itemRangeInsert(int positionStart, int itemCount) {
        int offsetPosition = this.getOffsetPosition(positionStart);
        this.notifyItemRangeInserted(offsetPosition, itemCount);
    }

    @Override
    public void itemRangeChanged(int positionStart, int itemCount) {
        int offsetPosition = this.getOffsetPosition(positionStart);
        this.notifyItemRangeChanged(offsetPosition, itemCount);
    }

    @Override
    public void itemRangeChanged(int positionStart, int itemCount, @Nullable Object payload) {
        int offsetPosition = this.getOffsetPosition(positionStart);
        this.notifyItemRangeChanged(offsetPosition, itemCount, payload);
    }

    @Override
    public void itemRangeRemoved(int positionStart, int itemCount) {
        int offsetPosition = this.getOffsetPosition(positionStart);
        this.notifyItemRangeRemoved(offsetPosition, itemCount);
    }

    @Override
    public void itemRangeMoved(int fromPosition, int toPosition, int itemCount) {
        int offsetPosition = this.getOffsetPosition(fromPosition);
        this.notifyItemMoved(offsetPosition, toPosition);
    }

    public static class FixedViewInfo {
        public final int viewType;
        public final View view;

        public FixedViewInfo(int viewType, View view) {
            this.viewType = viewType;
            this.view = view;
        }
    }
}

