/*
 * Decompiled with CFR 0.152.
 */
package com.cz.widget.recyclerview.adapter.wrapper.dynamic;

import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;
import com.cz.widget.recyclerview.adapter.wrapper.header.HeaderWrapperAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class DynamicWrapperAdapter
extends HeaderWrapperAdapter {
    private static final int TYPE_DYNAMIC = -256;
    private List<FixedViewInfo> fixedViewInfoList = new ArrayList<FixedViewInfo>();
    private int dynamicCount = 0;

    public DynamicWrapperAdapter(@Nullable RecyclerView.Adapter adapter) {
        super(adapter);
    }

    @Override
    public View findView(int id) {
        View findView = super.findView(id);
        if (null == findView) {
            for (int i = 0; i < this.fixedViewInfoList.size(); ++i) {
                FixedViewInfo fixedViewInfo = this.fixedViewInfoList.get(i);
                View view = fixedViewInfo.view.findViewById(id);
                if (null == view) continue;
                findView = view;
                break;
            }
        }
        return findView;
    }

    public void addAdapterView(@NonNull View view, int position) {
        for (FixedViewInfo fixedViewInfo : this.fixedViewInfoList) {
            if (fixedViewInfo.position < position) continue;
            ++fixedViewInfo.position;
        }
        int viewType = -256 + this.dynamicCount++;
        this.fixedViewInfoList.add(new FixedViewInfo(viewType, view, position));
        Collections.sort(this.fixedViewInfoList, new Comparator<FixedViewInfo>(){

            @Override
            public int compare(FixedViewInfo o1, FixedViewInfo o2) {
                return o1.position - o2.position;
            }
        });
        this.notifyItemInserted(position);
    }

    public void removeAdapterView(@Nullable View view) {
        int index = -1;
        for (int i = 0; i < this.fixedViewInfoList.size(); ++i) {
            FixedViewInfo fixedViewInfo = this.fixedViewInfoList.get(i);
            if (fixedViewInfo.view != view) continue;
            index = i;
            break;
        }
        if (-1 != index) {
            this.removeAdapterView(index);
        }
    }

    public void removeAdapterView(int position) {
        FixedViewInfo removeViewInfo = this.fixedViewInfoList.remove(position);
        for (int i = 0; i < this.fixedViewInfoList.size(); ++i) {
            FixedViewInfo fixedViewInfo = this.fixedViewInfoList.get(i);
            if (fixedViewInfo.position <= removeViewInfo.position) continue;
            --fixedViewInfo.position;
        }
        this.notifyItemRemoved(removeViewInfo.position);
    }

    public int findPosition(int position) {
        if (this.fixedViewInfoList.isEmpty()) {
            return -1;
        }
        int low = 0;
        int high = this.fixedViewInfoList.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            FixedViewInfo fixedViewInfo = this.fixedViewInfoList.get(mid);
            if (position < fixedViewInfo.position) {
                high = mid - 1;
                continue;
            }
            if (position > fixedViewInfo.position) {
                low = mid + 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    protected void setFixedViewPosition(int index, int position) {
        FixedViewInfo fixedViewInfo = this.fixedViewInfoList.get(index);
        if (null != fixedViewInfo) {
            fixedViewInfo.position = position;
        }
        Collections.sort(this.fixedViewInfoList, new Comparator<FixedViewInfo>(){

            @Override
            public int compare(FixedViewInfo o1, FixedViewInfo o2) {
                return o1.position - o2.position;
            }
        });
    }

    public int getExtraViewCount() {
        return this.fixedViewInfoList.size();
    }

    @Nullable
    private View findAdapterView(int viewType) {
        View findView = null;
        for (FixedViewInfo fixedViewInfo : this.fixedViewInfoList) {
            if (fixedViewInfo.viewType != viewType) continue;
            findView = fixedViewInfo.view;
        }
        return findView;
    }

    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = this.findAdapterView(viewType);
        if (null != view) {
            return new RecyclerView.ViewHolder(view){};
        }
        return super.onCreateViewHolder(parent, viewType);
    }

    @Override
    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        int findPosition = this.findPosition(position);
        if (-1 == findPosition) {
            super.onBindViewHolder(holder, position);
        }
    }

    @Override
    public int getItemViewType(int position) {
        int findPosition = this.findPosition(position);
        if (-1 == findPosition) {
            return super.getItemViewType(position);
        }
        int viewType = 0;
        for (FixedViewInfo fixedViewInfo : this.fixedViewInfoList) {
            if (fixedViewInfo.position != position) continue;
            viewType = fixedViewInfo.viewType;
        }
        return viewType;
    }

    @Override
    public int getItemCount() {
        int itemCount = super.getItemCount();
        return this.fixedViewInfoList.size() + itemCount;
    }

    @Override
    public long getItemId(int position) {
        return super.getItemId(position);
    }

    @Override
    public void itemRangeInsert(int positionStart, int itemCount) {
        int position = this.getOffsetPosition(positionStart);
        for (FixedViewInfo fixedViewInfo : this.fixedViewInfoList) {
            if (position >= fixedViewInfo.position) continue;
            fixedViewInfo.position += itemCount;
        }
        if (-1 != this.findPosition(position)) {
            this.notifyItemRangeInserted(position + 1, itemCount);
        } else {
            this.notifyItemRangeInserted(position, itemCount);
        }
    }

    @Override
    public void itemRangeRemoved(int position, int itemCount) {
        int positionStart = this.getOffsetPosition(position);
        int adapterItemCount = this.getItemCount();
        int positionEnd = Math.min(adapterItemCount + itemCount, this.getOffsetPosition(positionStart + itemCount));
        int acrossItemCount = positionEnd - positionStart;
        Iterator<FixedViewInfo> iterator = this.fixedViewInfoList.iterator();
        while (iterator.hasNext()) {
            FixedViewInfo fixedViewInfo = iterator.next();
            if (positionStart > fixedViewInfo.position || fixedViewInfo.position >= positionEnd) continue;
            iterator.remove();
        }
        for (FixedViewInfo fixedViewInfo : this.fixedViewInfoList) {
            if (positionEnd > fixedViewInfo.position) continue;
            fixedViewInfo.position -= acrossItemCount;
        }
        this.notifyItemRangeRemoved(positionStart, acrossItemCount);
    }

    @Override
    public int getOffsetPosition(int position) {
        int itemCount = 0;
        int totalCount = position;
        int startPosition = this.getExtraViewCount(position);
        while (itemCount < startPosition) {
            int findPosition = this.findPosition(totalCount);
            if (-1 == findPosition) {
                ++itemCount;
            }
            ++totalCount;
        }
        return totalCount;
    }

    @Override
    public int getExtraViewCount(int position) {
        int extraViewCount = super.getExtraViewCount(position);
        int start = 0;
        int result = -1;
        int end = this.fixedViewInfoList.size() - 1;
        while (start <= end) {
            int middle = (start + end) / 2;
            FixedViewInfo fixedViewInfo = this.fixedViewInfoList.get(middle);
            if (position == fixedViewInfo.position) {
                result = middle;
                break;
            }
            if (position < fixedViewInfo.position) {
                end = middle - 1;
                continue;
            }
            start = middle + 1;
        }
        if (-1 == result) {
            result = start;
        }
        return extraViewCount + result;
    }

    @Override
    protected boolean isExtraPosition(int position) {
        return super.isExtraPosition(position) || -1 != this.findPosition(position);
    }

    @Override
    protected boolean onItemClick(View v, int position, int adapterPosition) {
        return super.onItemClick(v, position, adapterPosition);
    }

    public static class FixedViewInfo {
        public final int viewType;
        public final View view;
        public int position;

        public FixedViewInfo(int viewType, View view, int position) {
            this.viewType = viewType;
            this.view = view;
            this.position = position;
        }
    }
}

