/*
 * Decompiled with CFR 0.152.
 */
package com.cz.widget.recyclerview.adapter.support.swipe;

import android.content.Context;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.core.view.GestureDetectorCompat;
import androidx.recyclerview.widget.RecyclerView;

public class SwipeOverlayViewGroup {
    private OverlayViewGroup overlayViewGroup;

    public SwipeOverlayViewGroup(RecyclerView hostView) {
        this.overlayViewGroup = new OverlayViewGroup(hostView.getContext(), hostView);
    }

    ViewGroup getOverlayView() {
        return this.overlayViewGroup;
    }

    public void add(@NonNull View view) {
        this.overlayViewGroup.add(view);
    }

    public void remove(@NonNull View view) {
        this.overlayViewGroup.remove(view);
    }

    public int getChildCount() {
        return this.overlayViewGroup.getChildCount();
    }

    public View getChildAt(int index) {
        return this.overlayViewGroup.getChildAt(index);
    }

    public <T extends View> T findViewById(@IdRes int id) {
        return (T)this.overlayViewGroup.findViewById(id);
    }

    public void addView(View child) {
        this.overlayViewGroup.addView(child, -1);
    }

    public void addView(View child, int index) {
        this.overlayViewGroup.addView(child, index);
    }

    public void addView(View child, int width, int height) {
        this.overlayViewGroup.addView(child, width, height);
    }

    public void addView(View child, ViewGroup.LayoutParams params) {
        this.overlayViewGroup.addView(child, params);
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        this.overlayViewGroup.addView(child, index, params);
    }

    public View findAdapterView(int position) {
        View adapterView = null;
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View childView = this.getChildAt(i);
            LayoutParams layoutParams = (LayoutParams)childView.getLayoutParams();
            if (layoutParams.position != position) continue;
            adapterView = childView;
            break;
        }
        return adapterView;
    }

    private View findClickableViewInternal(View view, float x, float y) {
        View findView = null;
        if (view.isClickable() || view.isLongClickable()) {
            return view;
        }
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int childCount = viewGroup.getChildCount();
            for (int i = childCount - 1; i >= 0; --i) {
                View childView = viewGroup.getChildAt(i);
                if (!((float)childView.getLeft() <= x) || !((float)childView.getTop() <= y) || !((float)childView.getRight() >= x) || !((float)childView.getBottom() >= y)) continue;
                findView = this.findClickableViewInternal(childView, x, y);
                break;
            }
        }
        return findView;
    }

    public void removeAllViews() {
        this.overlayViewGroup.removeAllViews();
    }

    public void removeView(View view) {
        this.overlayViewGroup.removeView(view);
    }

    public void removeViewAt(int index) {
        this.overlayViewGroup.removeViewAt(index);
    }

    public void measureChild(View child, int parentWidthMeasureSpec, int parentHeightMeasureSpec) {
        this.overlayViewGroup.measureChild(child, parentWidthMeasureSpec, parentHeightMeasureSpec);
    }

    public boolean isEmpty() {
        return this.overlayViewGroup.isEmpty();
    }

    public class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public int position;

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
        }
    }

    public class OverlayViewGroup
    extends ViewGroup
    implements GestureDetector.OnGestureListener,
    RecyclerView.OnItemTouchListener {
        private final GestureDetectorCompat gestureDetector;
        final RecyclerView hostView;

        public OverlayViewGroup(Context context, RecyclerView hostView) {
            super(context);
            this.hostView = hostView;
            this.hostView.addOnItemTouchListener((RecyclerView.OnItemTouchListener)this);
            this.gestureDetector = new GestureDetectorCompat(context, (GestureDetector.OnGestureListener)this);
        }

        public void add(@NonNull View child) {
            if (child == null) {
                throw new IllegalArgumentException("view must be non-null");
            }
            if (child.getParent() instanceof ViewGroup) {
                ViewGroup parent = (ViewGroup)child.getParent();
                parent.removeView(child);
            }
            super.addView(child);
            this.invalidate();
        }

        public void setPressed(boolean pressed) {
            super.setPressed(pressed);
        }

        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
        }

        public void setActivated(boolean activated) {
            super.setActivated(activated);
        }

        public void setClickable(boolean clickable) {
            super.setClickable(clickable);
        }

        public void remove(@NonNull View view) {
            if (view == null) {
                throw new IllegalArgumentException("view must be non-null");
            }
            super.removeView(view);
            this.invalidate();
        }

        public void invalidate() {
            this.hostView.invalidate();
        }

        public void removeAllViews() {
            this.removeAllViews();
            this.invalidate();
        }

        public void removeView(View view) {
            super.removeView(view);
        }

        public void removeViewAt(int index) {
            super.removeViewAt(index);
        }

        public boolean isEmpty() {
            return 0 == this.getChildCount();
        }

        protected void onLayout(boolean changed, int l, int t, int r, int b) {
        }

        public void childDrawableStateChanged(View child) {
            super.childDrawableStateChanged(child);
            this.invalidate();
        }

        protected void drawableStateChanged() {
            super.drawableStateChanged();
            this.invalidate();
        }

        public void refreshDrawableState() {
            super.refreshDrawableState();
            this.invalidate();
        }

        public void measureChild(View child, int parentWidthMeasureSpec, int parentHeightMeasureSpec) {
            super.measureChild(child, parentWidthMeasureSpec, parentHeightMeasureSpec);
        }

        public boolean onInterceptTouchEvent(@NonNull RecyclerView rv, @NonNull MotionEvent event) {
            float y;
            float x;
            View view;
            int action = event.getActionMasked();
            if (action == 0 && null != (view = SwipeOverlayViewGroup.this.findClickableViewInternal((View)this, x = event.getX(), y = event.getY())) && view.isEnabled()) {
                view.setPressed(true);
                this.invalidate();
                return true;
            }
            return false;
        }

        public void onTouchEvent(@NonNull RecyclerView rv, @NonNull MotionEvent event) {
            float y;
            float x;
            View view;
            this.gestureDetector.onTouchEvent(event);
            int action = event.getActionMasked();
            if ((action == 1 || action == 3 || action == 6) && null != (view = SwipeOverlayViewGroup.this.findClickableViewInternal((View)this, x = event.getX(), y = event.getY())) && view.isEnabled()) {
                view.setPressed(false);
                this.invalidate();
            }
        }

        public void onRequestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        }

        public boolean onDown(MotionEvent e) {
            return false;
        }

        public void onShowPress(MotionEvent e) {
        }

        public boolean onSingleTapUp(MotionEvent e) {
            float y;
            float x = e.getX();
            View view = SwipeOverlayViewGroup.this.findClickableViewInternal((View)this, x, y = e.getY());
            if (null != view) {
                view.setPressed(false);
                if (view.isEnabled() && view.isClickable()) {
                    return view.performClick();
                }
                this.invalidate();
            }
            return false;
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            return false;
        }

        public void onLongPress(MotionEvent e) {
            float y;
            float x = e.getX();
            View view = SwipeOverlayViewGroup.this.findClickableViewInternal((View)this, x, y = e.getY());
            if (null != view) {
                view.setPressed(false);
                if (view.isEnabled() && view.isLongClickable()) {
                    view.performLongClick();
                }
                this.invalidate();
            }
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            return false;
        }

        protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
            return p instanceof LayoutParams;
        }

        protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
            return new LayoutParams(-2, -2);
        }

        protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
            return new LayoutParams(p);
        }

        public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
            Context context = this.getContext();
            return new LayoutParams(context, attrs);
        }
    }
}

