/*
 * Decompiled with CFR 0.152.
 */
package com.cz.widget.recyclerview.adapter;

import android.text.TextUtils;
import android.widget.Filter;
import android.widget.Filterable;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.cz.widget.recyclerview.adapter.BaseAdapter;
import java.util.ArrayList;
import java.util.List;

public abstract class FilterAdapter<VH extends RecyclerView.ViewHolder, E>
extends BaseAdapter<VH, E>
implements Filterable {
    private final ObjectFilter objectFilter = new ObjectFilter();
    private final List<E> queryList = new ArrayList();
    private String queryWord;

    public FilterAdapter(@NonNull List<E> itemList) {
        super(itemList);
    }

    public String getQueryWord() {
        return this.queryWord;
    }

    public Filter getFilter() {
        return this.objectFilter;
    }

    @Override
    public int getItemCount() {
        if (!TextUtils.isEmpty((CharSequence)this.queryWord)) {
            return this.queryList.size();
        }
        return super.getItemCount();
    }

    @Override
    public E getItem(int position) {
        if (!TextUtils.isEmpty((CharSequence)this.queryWord)) {
            return this.queryList.get(position);
        }
        return super.getItem(position);
    }

    protected abstract boolean filterObject(@NonNull E var1, @NonNull CharSequence var2);

    class ObjectFilter
    extends Filter {
        ObjectFilter() {
        }

        protected Filter.FilterResults performFiltering(CharSequence word) {
            Filter.FilterResults filterResults = new Filter.FilterResults();
            ArrayList resultItems = new ArrayList();
            List itemList = FilterAdapter.this.getItemList();
            if (TextUtils.isEmpty((CharSequence)word)) {
                FilterAdapter.this.queryWord = null;
            } else {
                FilterAdapter.this.queryWord = word.toString();
                for (Object item : itemList) {
                    if (!FilterAdapter.this.filterObject(item, word)) continue;
                    resultItems.add(item);
                }
            }
            filterResults.count = resultItems.size();
            filterResults.values = resultItems;
            return filterResults;
        }

        protected void publishResults(CharSequence constraint, Filter.FilterResults results) {
            this.publishItems(constraint, (List)results.values);
        }

        private void publishItems(CharSequence constraint, List<E> resultItems) {
            if (!TextUtils.isEmpty((CharSequence)constraint) && null != resultItems) {
                FilterAdapter.this.queryList.clear();
                FilterAdapter.this.queryList.addAll(resultItems);
            }
            FilterAdapter.this.notifyDataSetChanged();
        }
    }
}

