/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.springframework.ai.mcp.spec.ClientMcpTransport;
import org.springframework.ai.mcp.spec.McpSchema;
import org.springframework.ai.mcp.spec.ServerMcpTransport;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.core.scheduler.Schedulers;

public class MockMcpTransport
implements ClientMcpTransport,
ServerMcpTransport {
    private final AtomicInteger inboundMessageCount = new AtomicInteger(0);
    private final Sinks.Many<McpSchema.JSONRPCMessage> outgoing = Sinks.many().multicast().onBackpressureBuffer();
    private final Sinks.Many<McpSchema.JSONRPCMessage> inbound = Sinks.many().unicast().onBackpressureBuffer();
    private final Flux<McpSchema.JSONRPCMessage> outboundView = this.outgoing.asFlux().cache(1);
    private volatile boolean connected = false;

    public void simulateIncomingMessage(McpSchema.JSONRPCMessage message) {
        if (this.inbound.tryEmitNext((Object)message).isFailure()) {
            throw new RuntimeException("Failed to emit message " + message);
        }
        this.inboundMessageCount.incrementAndGet();
    }

    public Mono<Void> sendMessage(McpSchema.JSONRPCMessage message) {
        if (this.outgoing.tryEmitNext((Object)message).isFailure()) {
            return Mono.error((Throwable)new RuntimeException("Can't emit outgoing message " + message));
        }
        return Mono.empty();
    }

    public McpSchema.JSONRPCRequest getLastSentMessageAsRequest() {
        return (McpSchema.JSONRPCRequest)this.outboundView.blockFirst();
    }

    public McpSchema.JSONRPCNotification getLastSentMessageAsNotifiation() {
        return (McpSchema.JSONRPCNotification)this.outboundView.blockFirst();
    }

    public McpSchema.JSONRPCMessage getLastSentMessage() {
        return (McpSchema.JSONRPCMessage)this.outboundView.blockFirst();
    }

    public Mono<Void> connect(Function<Mono<McpSchema.JSONRPCMessage>, Mono<McpSchema.JSONRPCMessage>> handler) {
        if (this.connected) {
            return Mono.error((Throwable)new IllegalStateException("Already connected"));
        }
        this.connected = true;
        return this.inbound.asFlux().publishOn(Schedulers.boundedElastic()).flatMap(message -> Mono.just((Object)message).transform(handler)).doFinally(signal -> {
            this.connected = false;
        }).then();
    }

    public Mono<Void> closeGracefully() {
        return Mono.defer(() -> {
            this.connected = false;
            this.outgoing.tryEmitComplete();
            this.inbound.tryEmitComplete();
            return Mono.empty();
        });
    }

    public <T> T unmarshalFrom(Object data, TypeReference<T> typeRef) {
        return (T)new ObjectMapper().convertValue(data, typeRef);
    }
}

