/*
 * Decompiled with CFR 0.152.
 */
package com.mobfox.android.dmp.Process;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.os.Build;
import androidx.core.content.ContextCompat;
import com.mobfox.android.core.DLog;
import com.mobfox.android.core.services.MobFoxLocationService;
import com.mobfox.android.dmp.BroadcastRecivers.WifiListReceiver;
import com.mobfox.android.dmp.Process.BaseProcess;
import com.mobfox.android.dmp.SyncJsonArray;
import org.json.JSONArray;
import org.json.JSONObject;

public class ListScanProcess
extends BaseProcess {
    private static final String TAG = "ListScanProcess";
    static final String JSON_ID = "WAva";
    static final String LOCATION_ID = "Loc";
    WifiListReceiver receiver;
    SyncJsonArray locationData = new SyncJsonArray();

    public ListScanProcess(Context context) {
        super(context, TAG, JSON_ID);
    }

    @Override
    protected void collectData() {
        this.receiver = new WifiListReceiver(this.context);
        this.receiver.initReceiver();
        this.context.registerReceiver((BroadcastReceiver)this.receiver, this.receiver.getIntentFilter());
        JSONObject location = MobFoxLocationService.getInstance().getLastLocationJson(this.context);
        this.locationData.put(location);
        try {
            ListScanProcess.sleep(60000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (this.receiver.hasData()) {
            JSONArray array = this.receiver.getDataArray();
            this.addDataArrayToData(array);
            this.receiver.emptyData();
        }
        this.context.unregisterReceiver((BroadcastReceiver)this.receiver);
    }

    private void addDataArrayToData(JSONArray array) {
        for (int i = 0; i < array.length(); ++i) {
            try {
                this.dataArray.put(array.getJSONObject(i));
                continue;
            }
            catch (Exception e) {
                e.getLocalizedMessage();
            }
        }
    }

    @Override
    public void updatePermissions() {
        if (this.receiver == null) {
            this.receiver = new WifiListReceiver(this.context);
        }
        permitted = this.receiver.hasPermissions();
    }

    public JSONArray getLocationData() {
        return this.locationData.getDataArray();
    }

    public boolean hasLocationData() {
        return this.locationData != null && this.locationData.hasData();
    }

    public void emptyLocationData() {
        try {
            if (Build.VERSION.SDK_INT >= 19) {
                this.locationData.emptyData();
            }
        }
        catch (Exception e) {
            DLog.d(TAG, "error in emptying data: " + e.getLocalizedMessage());
        }
        if (this.locationData.length() > 0) {
            this.locationData = new SyncJsonArray();
        }
    }

    public String getLocationId() {
        return LOCATION_ID;
    }

    public boolean hasPermissions() {
        return ContextCompat.checkSelfPermission((Context)this.context, (String)"android.permission.ACCESS_WIFI_STATE") == 0 && ContextCompat.checkSelfPermission((Context)this.context, (String)"android.permission.CHANGE_WIFI_STATE") == 0 || ContextCompat.checkSelfPermission((Context)this.context, (String)"android.permission.ACCESS_COARSE_LOCATION") == 0 || ContextCompat.checkSelfPermission((Context)this.context, (String)"android.permission.ACCESS_FINE_LOCATION") == 0;
    }
}

