/*
 * Decompiled with CFR 0.152.
 */
package com.mobfox.android.dmp.BroadcastRecivers;

import android.content.Context;
import android.content.Intent;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import androidx.core.content.ContextCompat;
import com.mobfox.android.core.DLog;
import com.mobfox.android.core.utils.DateAndTimeUtils;
import com.mobfox.android.dmp.BroadcastRecivers.BaseReceiver;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class WifiListReceiver
extends BaseReceiver {
    static final String TAG = "WifiListReceiver";
    static final String JSON_ID = "WAva";
    WifiManager mainWifi;
    List<ScanResult> wifiList;
    Context context;

    public WifiListReceiver(Context c) {
        super(JSON_ID);
        this.context = c.getApplicationContext();
    }

    @Override
    public void initReceiver() {
        this.mainWifi = (WifiManager)this.context.getApplicationContext().getSystemService("wifi");
        if (this.mainWifi.isWifiEnabled()) {
            this.mainWifi.startScan();
        }
    }

    @Override
    public void onActionReceived(Context context, Intent intent) {
        if ((ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_COARSE_LOCATION") == 0 || ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_FINE_LOCATION") == 0) && this.mainWifi != null) {
            this.wifiList = this.mainWifi.getScanResults();
            WifiInfo wifiInfo = this.mainWifi.getConnectionInfo();
            for (int i = 0; i < this.wifiList.size(); ++i) {
                if (this.wifiList.get((int)i).SSID.equals(wifiInfo.getSSID())) continue;
                JSONObject jsonInfo = this.getJsonFromWifi(this.wifiList.get(i));
                this.dataArray.put(jsonInfo);
            }
        }
    }

    private JSONObject getJsonFromWifi(ScanResult scanResult) {
        JSONObject data = new JSONObject();
        try {
            data.put("bssid", (Object)scanResult.BSSID);
            data.put("ssid", (Object)scanResult.SSID);
            data.put("WStr", (Object)scanResult.toString());
            data.put("uTm", (Object)DateAndTimeUtils.getTimeFormat());
        }
        catch (JSONException e) {
            DLog.d(TAG, "Error: " + e.getLocalizedMessage());
        }
        return data;
    }

    @Override
    void fillActions() {
        this.intentActions.add("android.net.wifi.SCAN_RESULTS");
    }

    @Override
    public boolean hasPermissions() {
        return ContextCompat.checkSelfPermission((Context)this.context, (String)"android.permission.ACCESS_WIFI_STATE") == 0 && ContextCompat.checkSelfPermission((Context)this.context, (String)"android.permission.CHANGE_WIFI_STATE") == 0 && (ContextCompat.checkSelfPermission((Context)this.context, (String)"android.permission.ACCESS_COARSE_LOCATION") == 0 || ContextCompat.checkSelfPermission((Context)this.context, (String)"android.permission.ACCESS_FINE_LOCATION") == 0);
    }
}

