/*
 * Decompiled with CFR 0.152.
 */
package com.mobfox.android.core.utils;

import android.content.Context;
import android.graphics.Point;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.RelativeLayout;
import com.mobfox.android.core.DLog;

public class LayoutUtils {
    public static void setSmartDimensions(Context context, View view, int height) {
        int screenWidth = LayoutUtils.getScreenWidth(context);
        LayoutUtils.setDimensions(context, view, screenWidth, height);
    }

    public static void setDimensions(Context context, View view, int width, int height) {
        try {
            RelativeLayout.LayoutParams layout_params = (RelativeLayout.LayoutParams)view.getLayoutParams();
            layout_params.width = LayoutUtils.convertDpToPixel(width, context);
            layout_params.height = LayoutUtils.convertDpToPixel(height, context);
            view.setLayoutParams((ViewGroup.LayoutParams)layout_params);
        }
        catch (Exception e) {
            DLog.d("MobfoxSDK", "smart params error");
        }
    }

    public static Point getScreenSize(Context context) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        Display display = wm.getDefaultDisplay();
        Point size = new Point();
        display.getSize(size);
        int width = (int)LayoutUtils.convertPixelToDP(size.x, context);
        int height = (int)LayoutUtils.convertPixelToDP(size.y, context);
        Point resultInPixel = new Point(width, height);
        return resultInPixel;
    }

    public static int getScreenWidth(Context context) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        Display display = wm.getDefaultDisplay();
        Point size = new Point();
        display.getSize(size);
        int width = (int)LayoutUtils.convertPixelToDP(size.x, context);
        return width;
    }

    public static int getScreenHeight(Context context) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        Display display = wm.getDefaultDisplay();
        Point size = new Point();
        display.getSize(size);
        return size.y;
    }

    public static boolean aboveTheFold(Context context, View view) {
        int screenHeight = LayoutUtils.getScreenHeight(context);
        int[] location = new int[2];
        view.getLocationOnScreen(location);
        int bannerTop = location[1];
        if (bannerTop < 0) {
            return false;
        }
        return bannerTop < screenHeight;
    }

    public static int convertDpToPixel(float dp, Context context) {
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        float px = dp * ((float)metrics.densityDpi / 160.0f);
        return (int)Math.ceil(px);
    }

    public static float convertPixelToDP(float px, Context context) {
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        float dp = px / ((float)metrics.densityDpi / 160.0f);
        return dp;
    }
}

