/*
 * Decompiled with CFR 0.152.
 */
package com.mobfox.android.core.tags;

import android.content.Context;
import android.graphics.Point;
import com.mobfox.android.JSInterface.TagToAdAPI;
import com.mobfox.android.core.DLog;
import com.mobfox.android.core.MFXStorage;
import com.mobfox.android.core.MobfoxSettings;
import com.mobfox.android.core.javascriptengine.ControllerEngine;
import com.mobfox.android.core.tags.BaseTag;
import com.mobfox.android.core.utils.SizeUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class BannerHtmlTag
extends BaseTag {
    private String jsonResp;
    private String mAdapterName = "core";

    public BannerHtmlTag(Context c, String adapter, int width, int height, String html, String guid, String inHash, BaseTag.OnTagReadyCallback cb) throws Exception {
        super(c, width, height, html, guid, inHash, cb);
        MobfoxSettings.getInstance(this.context);
        this.addJavascriptInterface(new TagToAdAPI(this), "mobfox");
        this.mHtml = html;
        this.setDefaultParams(adapter);
    }

    void setDefaultParams(String adapter) {
        Point nearest = SizeUtils.getNearestFitSupported(new Point(this.adWidth, this.adHeight), false);
        MFXStorage.sharedInstance(this.context).setBasicParams(this.context, adapter);
        MFXStorage.sharedInstance(this.context).setBannerParams(nearest.x, nearest.y, this.mInvh);
        MFXStorage.sharedInstance(this.context).setGDPRParams(this.context);
    }

    public void closeTagAd() {
        this.destroy();
    }

    public void callTagFunc(final String name, String params, final String cb_id) {
        final BannerHtmlTag self = this;
        final String cbStr = String.format("%s(%s)", name, params);
        if (Thread.currentThread() == this.mainHandler.getLooper().getThread()) {
            self.evaluateJavascript(cbStr, null);
            if (cb_id != null) {
                ControllerEngine.getInstance().callControllerCallback(cb_id, null, "ok");
            }
        } else {
            this.mainHandler.post(new Runnable(){

                @Override
                public void run() {
                    self.evaluateJavascript(cbStr, null);
                    if (cb_id != null) {
                        DLog.v("MobfoxSDK", "dbg: ### <== BannerHtmlTag calls callCallback for " + name + " ###");
                        ControllerEngine.getInstance().callControllerCallback(cb_id, null, "ok");
                    }
                }
            });
        }
    }

    @Override
    public JSONObject getAd() {
        JSONObject ad = new JSONObject();
        try {
            ad.put("width", this.adWidth);
            ad.put("height", this.adHeight);
            ad.put("json", (Object)new JSONObject(this.jsonResp));
            ad.put("closeButton", false);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return ad;
    }

    @Override
    public String getAdType() {
        return "Banner";
    }

    @Override
    public void onSuccess() {
    }

    @Override
    public void onFail(String reason) {
    }

    @Override
    public void onComplete() {
    }

    @Override
    public void onFinished() {
    }

    @Override
    public void onClick(String url) {
    }

    @Override
    public void onClose() {
    }
}

