/*
 * Decompiled with CFR 0.152.
 */
package com.mobfox.android.core.networking;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import com.mobfox.android.core.DLog;
import com.mobfox.android.core.MFXStorage;
import com.mobfox.android.core.networking.AsyncCallback;
import com.mobfox.android.core.networking.AsyncCallbackBitmap;
import com.mobfox.android.core.networking.AsyncCallbackDrawable;
import com.mobfox.android.core.networking.AsyncCallbackJSON;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class MobFoxRequest {
    boolean testMode = false;
    String url;
    Map<String, String> parameters;
    Map<String, String> headers;
    Object data;
    int timeout = 0;

    public MobFoxRequest(String url) {
        this.url = url;
        this.parameters = new HashMap<String, String>();
        this.headers = new HashMap<String, String>();
    }

    private static void _call(String url, final String method, final Object data, final Map<String, String> reqHeaders, final int timeout, boolean testMode, final ResponseFormatter formatter, final AsyncCallback cb) {
        block6: {
            try {
                String query = "";
                if (method.equals("GET") && data instanceof HashMap) {
                    query = MFXStorage.toQuery((HashMap)data);
                }
                String fullURL = url;
                if (query.length() > 0) {
                    fullURL = url.indexOf("?") > 0 ? url + "&" + query : url + "?" + query;
                }
                final String finalURL = fullURL;
                AsyncTask<String, Void, String> t = new AsyncTask<String, Void, String>(){
                    int status;
                    Object response;
                    Map<String, List<String>> responseHeaders;
                    Exception err;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected String doInBackground(String ... params) {
                        HttpURLConnection con = null;
                        BufferedWriter writer = null;
                        try {
                            URL u = new URL(finalURL);
                            con = (HttpURLConnection)u.openConnection();
                            con.setUseCaches(true);
                            for (String h : reqHeaders.keySet()) {
                                con.setRequestProperty(h, (String)reqHeaders.get(h));
                            }
                            con.setRequestMethod(method);
                            con.setRequestProperty("User-Agent", System.getProperty("http.agent"));
                            if (timeout > 0) {
                                con.setConnectTimeout(timeout);
                                con.setReadTimeout(timeout);
                            }
                            if (method.equals("POST")) {
                                con.setDoInput(true);
                                con.setDoOutput(true);
                                OutputStream os = con.getOutputStream();
                                writer = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));
                                writer.write(data.toString());
                                writer.flush();
                                writer.close();
                                os.close();
                            }
                            this.status = con.getResponseCode();
                            this.response = formatter.format(con.getInputStream());
                            this.responseHeaders = con.getHeaderFields();
                            String string = "success";
                            return string;
                        }
                        catch (Exception e) {
                            this.err = e;
                            String string = null;
                            return string;
                        }
                        catch (Throwable e) {
                            this.err = e.getMessage() == null ? new Exception("Error in sending request to server") : new Exception(e.getMessage());
                            String string = null;
                            try {
                                if (con != null) {
                                    con.disconnect();
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            return string;
                        }
                        finally {
                            try {
                                if (con != null) {
                                    con.disconnect();
                                }
                            }
                            catch (Exception exception) {}
                        }
                    }

                    protected void onPostExecute(String code) {
                        if (cb == null) {
                            return;
                        }
                        if (code == null) {
                            cb.onError(this.err);
                        } else {
                            cb.onComplete(this.status, this.response, this.responseHeaders);
                        }
                    }
                };
                if (testMode) {
                    t.execute((Object[])new String[0]);
                } else {
                    t.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])new String[0]);
                }
            }
            catch (Throwable err) {
                DLog.d("MobFoxNetwork", "Unable to complete request!" + err.getMessage());
                if (cb == null) break block6;
                cb.onError(new Exception(err.toString()));
            }
        }
    }

    public void get(AsyncCallback cb) {
        MobFoxRequest._call(this.url, "GET", this.parameters, this.headers, this.timeout, this.testMode, new DefaultResponseFormatter(), cb);
    }

    public void post(AsyncCallback cb) {
        MobFoxRequest._call(this.url, "POST", this.data, this.headers, this.timeout, this.testMode, new DefaultResponseFormatter(), cb);
    }

    public void getJSON(final AsyncCallbackJSON cb) {
        this.get(new AsyncCallback(){

            @Override
            public void onComplete(int code, Object response, Map<String, List<String>> headers) {
                String jsonStr = (String)response;
                if (jsonStr == null || jsonStr.length() == 0) {
                    cb.onError(new Exception("empty json response."));
                    return;
                }
                try {
                    JSONObject json = new JSONObject((String)response);
                    cb.onComplete(code, json, headers);
                }
                catch (JSONException e) {
                    DLog.e("MobfoxSDK", "error parsing JSON response: " + response);
                    cb.onError((Exception)((Object)e));
                }
            }

            @Override
            public void onError(Exception e) {
                cb.onError(e);
            }
        });
    }

    public void getBitmap(final AsyncCallbackBitmap cb) {
        MobFoxRequest._call(this.url, "GET", this.parameters, this.headers, this.timeout, this.testMode, new ResponseFormatter(){

            @Override
            public Object format(InputStream response) {
                return BitmapFactory.decodeStream((InputStream)response);
            }
        }, new AsyncCallback(){

            @Override
            public void onComplete(int code, Object response, Map<String, List<String>> headers) {
                cb.onComplete(code, (Bitmap)response, headers);
            }

            @Override
            public void onError(Exception e) {
                cb.onError(e);
            }
        });
    }

    public void getDrawable(final AsyncCallbackDrawable cb) {
        MobFoxRequest._call(this.url, "GET", this.parameters, this.headers, this.timeout, this.testMode, new ResponseFormatter(){

            @Override
            public Object format(InputStream response) {
                return Drawable.createFromStream((InputStream)response, null);
            }
        }, new AsyncCallback(){

            @Override
            public void onComplete(int code, Object response, Map<String, List<String>> headers) {
                cb.onComplete(code, (Drawable)response, headers);
            }

            @Override
            public void onError(Exception e) {
                cb.onError(e);
            }
        });
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setParam(String key, String value) {
        this.parameters.put(key, value);
    }

    public void setParam(HashMap<String, String> params) {
        if (params != null) {
            this.parameters = params;
        }
    }

    public void setData(Object data) {
        this.data = data;
    }

    public void setHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public void setTestMode(boolean testMode) {
        this.testMode = testMode;
    }

    private class DefaultResponseFormatter
    implements ResponseFormatter {
        private DefaultResponseFormatter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object format(InputStream response) {
            StringBuilder sb = new StringBuilder();
            BufferedReader reader = new BufferedReader(new InputStreamReader(response));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    sb.append(line + "\n");
                }
            }
            catch (IOException e) {
                DLog.d("MobFoxNetwork", "IOException error reading response");
            }
            catch (Throwable e) {
                DLog.d("MobFoxNetwork", "error reading response");
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        DLog.d("MobFoxNetwork", "IOException error closing response inp stream");
                    }
                }
            }
            return sb.toString();
        }
    }

    private static interface ResponseFormatter {
        public Object format(InputStream var1);
    }
}

