/*
 * Decompiled with CFR 0.152.
 */
package com.mobfox.android.core.logging;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.database.sqlite.SQLiteBlobTooBigException;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Handler;
import com.mobfox.android.core.DLog;
import com.mobfox.android.core.MobfoxSettings;
import com.mobfox.android.core.javascriptengine.ControllerEngine;
import com.mobfox.android.core.logging.MobFoxReport;
import com.mobfox.android.core.logging.ReportsQueueDB;
import com.mobfox.android.core.logging.sReportsFlatItem;
import com.mobfox.android.core.networking.AsyncCallback;
import com.mobfox.android.core.networking.MobFoxRequest;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ReportsQueueManager {
    private static ReportsQueueManager singleton;
    private static final int SEND_TO_SERVER_DELAY = 4;
    private Context mCtx = null;
    private long mSessionRowID = -1L;
    private String mSessionGUID = null;
    private String mSessionStartTime = null;
    private long mSessionUTC = 0L;
    private String mSessionAppID = null;
    private String mSessionAppName = null;
    private String mSessionAppVer = null;
    private String mSessionSdkVer = null;
    private String mSessionUserAgent = null;
    private String mSessionPlatform = null;
    private JSONObject mInventoryHashDict = null;
    private Set<String> mSessionEventGroupsSet = null;
    private boolean mSessionReportCrash = false;
    private Handler mSendToServerHandler = new Handler();
    private long mSendToServerStartTime = 0L;
    private long mSendToServerCounter = 0L;
    private Runnable mSendToServerTask = new Runnable(){

        @Override
        public void run() {
            if (ReportsQueueManager.this.mSendToServerStartTime != 0L) {
                ReportsQueueManager.this.mSendToServerHandler.removeCallbacks(ReportsQueueManager.this.mSendToServerTask);
                ReportsQueueManager.this.mSendToServerStartTime = 0L;
                try {
                    ReportsQueueManager.this.SendReportToServer();
                }
                catch (SQLiteBlobTooBigException tbe) {
                    DLog.e("MobfoxSDK", "SQL blob too big error (Send Report To Server)");
                }
            }
        }
    };

    public void initAnalyticsSession(Context ctx, String invh, String eventGroup) {
        if (ctx == null) {
            return;
        }
        this.mCtx = ctx;
        DLog.v("MobFoxAnalytics", "dbg: ### start logging session ###");
        if (this.mSessionGUID != null) {
            if (this.mInventoryHashDict == null) {
                this.mInventoryHashDict = new JSONObject();
            }
            try {
                this.mInventoryHashDict.put(eventGroup, (Object)invh);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        if (this.mSessionGUID == null) {
            Date now = new Date();
            SimpleDateFormat df2 = new SimpleDateFormat("dd-MM-yyyy, HH:mm:ss.SSS");
            TimeZone tz = TimeZone.getDefault();
            int nHoursDiffFromUTC = tz.getOffset(now.getTime()) / 3600000;
            String ver = "";
            String nam = "";
            String pkg = ctx.getPackageName();
            try {
                PackageInfo packagInfo = ctx.getPackageManager().getPackageInfo(pkg, 0);
                ver = packagInfo.versionName;
                ApplicationInfo applicationInfo = ctx.getApplicationInfo();
                if (applicationInfo != null) {
                    int stringId = applicationInfo.labelRes;
                    if (stringId == 0) {
                        if (applicationInfo.nonLocalizedLabel != null) {
                            nam = applicationInfo.nonLocalizedLabel.toString();
                        } else if (applicationInfo.name != null) {
                            nam = applicationInfo.name;
                        }
                    } else {
                        nam = ctx.getString(stringId);
                    }
                }
            }
            catch (PackageManager.NameNotFoundException packagInfo) {
                // empty catch block
            }
            String userAgent = MobFoxReport.getUserAgent(ctx);
            this.mSessionGUID = UUID.randomUUID().toString();
            this.mSessionStartTime = df2.format(now);
            this.mSessionUTC = nHoursDiffFromUTC;
            this.mSessionAppID = pkg;
            this.mSessionAppName = nam;
            this.mSessionAppVer = ver;
            this.mSessionSdkVer = "Core_4.3.2";
            this.mSessionUserAgent = userAgent;
            this.mSessionPlatform = "Android";
            this.mInventoryHashDict = new JSONObject();
            try {
                this.mInventoryHashDict.put(eventGroup, (Object)invh);
            }
            catch (JSONException applicationInfo) {
                // empty catch block
            }
            this.mSessionEventGroupsSet = MobfoxSettings.getInstance(this.mCtx).getAnalyticsPrefReportEventGroups(this.mCtx);
            this.mSessionReportCrash = MobfoxSettings.getInstance(this.mCtx).getAnalyticsPrefReportCrashEvents(this.mCtx);
            ControllerEngine.aquireSdkLock();
            ReportsQueueDB reportsDB = new ReportsQueueDB(this.mCtx);
            if (reportsDB != null) {
                sReportsFlatItem newRec = this.createReportFlatItem(this.mCtx);
                newRec.validate();
                try {
                    reportsDB.open();
                    this.mSessionRowID = reportsDB.createReportItem(newRec);
                    reportsDB.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ControllerEngine.releaseSdkLock();
        }
    }

    private void DeleteSessionReportFromDB(long rowID) {
        ControllerEngine.aquireSdkLock();
        ReportsQueueDB reportsDB = new ReportsQueueDB(this.mCtx);
        if (reportsDB != null) {
            try {
                reportsDB.open();
                reportsDB.deleteMessageItem(rowID);
                reportsDB.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ControllerEngine.releaseSdkLock();
    }

    public void updateFlags(String ad) {
        if (this.mCtx == null) {
            return;
        }
        try {
            JSONObject adJson = new JSONObject(ad);
            if (adJson != null) {
                String DMP2;
                String crashReport;
                JSONObject analytics;
                if (adJson.has("analytics") && (analytics = adJson.getJSONObject("analytics")) != null) {
                    DLog.v("MobFoxAnalytics", "dbg: ### analytics: " + analytics.toString());
                    Set<String> currVal = MobfoxSettings.getInstance(this.mCtx).getAnalyticsPrefReportEventGroups(this.mCtx);
                    boolean hadChange = false;
                    Iterator iter = analytics.keys();
                    while (iter.hasNext()) {
                        String eventGroup = (String)iter.next();
                        try {
                            String value = analytics.getString(eventGroup);
                            if (value == null) continue;
                            boolean newVal = value.equalsIgnoreCase("YES");
                            if (newVal) {
                                if (currVal.contains(eventGroup)) continue;
                                hadChange = true;
                                currVal.add(eventGroup);
                                continue;
                            }
                            if (!currVal.contains(eventGroup)) continue;
                            hadChange = true;
                            currVal.remove(eventGroup);
                        }
                        catch (JSONException jSONException) {}
                    }
                    if (hadChange) {
                        MobfoxSettings.getInstance(this.mCtx).setAnalyticsPrefReportEventGroups(this.mCtx, currVal);
                    }
                }
                if (adJson.has("crashReport") && (crashReport = adJson.getString("crashReport")) != null) {
                    DLog.v("MobFoxAnalytics", "dbg: ### crashReport: " + crashReport);
                    boolean newVal = crashReport.equalsIgnoreCase("YES");
                    MobfoxSettings.getInstance(this.mCtx).setAnalyticsPrefReportCrashEvents(this.mCtx, newVal);
                }
                boolean bServerSaidNo = false;
                if (adJson.has("DMP") && (DMP2 = adJson.getString("DMP")) != null) {
                    DLog.v("MobFoxAnalytics", "dbg: ### DMP: " + DMP2);
                    bServerSaidNo = DMP2.equalsIgnoreCase("NO");
                }
                MobfoxSettings.getInstance(this.mCtx).setAnalyticsPrefReportDMPEvents(this.mCtx, !bServerSaidNo);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void addEventLog(String eventText, String eventGroup, String atLine) {
        if (this.mSessionGUID == null) {
            DLog.v("MobFoxAnalytics", "dbg: ### ERR: analytics session not initialized yet ###");
            return;
        }
        if (this.mCtx == null) {
            return;
        }
        if (this.mSessionEventGroupsSet != null && !this.mSessionEventGroupsSet.contains(eventGroup)) {
            DLog.v("MobFoxAnalytics", "dbg: ### analytics '" + eventGroup + "' is OFF ###");
            return;
        }
        Date now = new Date();
        SimpleDateFormat df2 = new SimpleDateFormat("dd-MM-yyyy, HH:mm:ss.SSS");
        String theTime = df2.format(now);
        AddEventAsyncTask tsk = new AddEventAsyncTask();
        if (tsk != null) {
            tsk.eventText = eventText;
            tsk.eventGroup = eventGroup;
            tsk.atLine = atLine;
            tsk.theTime = theTime;
            if (Build.VERSION.SDK_INT >= 11) {
                tsk.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new String[]{eventText});
            } else {
                tsk.execute(new String[]{eventText});
            }
        }
    }

    public static String getLineNumber() {
        int level = 3;
        StackTraceElement[] traces = Thread.currentThread().getStackTrace();
        return " at " + traces[level] + " ";
    }

    public void addCrashLog(JSONObject crashData) {
        if (this.mSessionGUID == null) {
            DLog.v("MobFoxAnalytics", "dbg: ### ERR: analytics session not initialized yet ###");
            return;
        }
        if (this.mCtx == null) {
            return;
        }
        if (!this.mSessionReportCrash) {
            DLog.v("MobFoxAnalytics", "dbg: ### analytics 'report crash' is OFF ###");
            return;
        }
        Date now = new Date();
        SimpleDateFormat df2 = new SimpleDateFormat("dd-MM-yyyy, HH:mm:ss.SSS");
        String theTime = df2.format(now);
        AddCrashAsyncTask tsk = new AddCrashAsyncTask();
        if (tsk != null) {
            tsk.crashJson = crashData;
            tsk.theTime = theTime;
            if (Build.VERSION.SDK_INT >= 11) {
                tsk.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new JSONObject[]{crashData});
            } else {
                tsk.execute(new JSONObject[]{crashData});
            }
        }
    }

    private sReportsFlatItem createReportFlatItem(Context ctx) {
        sReportsFlatItem newRec = new sReportsFlatItem();
        newRec.sessionGUID = this.mSessionGUID;
        newRec.sessionStartTime = this.mSessionStartTime;
        newRec.sessionUTC = this.mSessionUTC;
        newRec.sessionAppID = this.mSessionAppID;
        newRec.sessionAppName = this.mSessionAppName;
        newRec.sessionAppVer = this.mSessionAppVer;
        newRec.sessionSdkVer = this.mSessionSdkVer;
        newRec.sessionUserAgent = this.mSessionUserAgent;
        newRec.sessionPlatform = this.mSessionPlatform;
        return newRec;
    }

    private void SendReportToServer() {
        DLog.v("MobFoxAnalytics", "dbg: ### send queued data to server... ###");
        JSONObject newRec = null;
        JSONObject error = null;
        long recRowID = -1L;
        ControllerEngine.aquireSdkLock();
        ReportsQueueDB reportsDB = new ReportsQueueDB(this.mCtx);
        if (reportsDB != null) {
            Cursor cAll = null;
            try {
                reportsDB.open();
                cAll = reportsDB.fetchAllReportItems();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (cAll != null) {
                if (ReportsQueueDB.TryGetCount(cAll) > 0 && ReportsQueueDB.TryMoveToFirst(cAll)) {
                    boolean bFoundSomthingToSend = false;
                    do {
                        sReportsFlatItem rec;
                        if ((rec = this.GetRecFromCursor(cAll)) == null || this.mSessionGUID != null && rec.sessionGUID.equalsIgnoreCase(this.mSessionGUID)) continue;
                        bFoundSomthingToSend = true;
                        if (rec.jsonArrayCrashes.equalsIgnoreCase("[]")) {
                            DLog.v("MobFoxAnalytics", "dbg: ###");
                            DLog.v("MobFoxAnalytics", "dbg: ### Report queue was empty, so not sent to server... ###");
                            DLog.v("MobFoxAnalytics", "dbg: ###");
                            reportsDB.deleteMessageItem(rec.rowID);
                            continue;
                        }
                        recRowID = rec.rowID;
                        newRec = new JSONObject();
                        error = new JSONObject();
                        try {
                            error.put("AppVer", (Object)rec.sessionAppVer);
                            error.put("UA", (Object)rec.sessionUserAgent);
                            error.put("UTC", rec.sessionUTC);
                            error.put("SdkVersion", (Object)rec.sessionSdkVer);
                            error.put("AppID", (Object)rec.sessionAppID);
                            error.put("AppName", (Object)rec.sessionAppName);
                            error.put("GUID", (Object)rec.sessionGUID);
                            error.put("Platform", (Object)rec.sessionPlatform);
                            error.put("Crash", (Object)rec.jsonArrayCrashes);
                            newRec.put("error", (Object)error);
                            DLog.v("MobFoxAnalytics", "dbg: ###");
                            DLog.v("MobFoxAnalytics", "dbg: ### Send: " + newRec.toString());
                        }
                        catch (JSONException e) {
                            cAll.close();
                            cAll = null;
                        }
                        catch (Exception ee) {
                            cAll.close();
                            cAll = null;
                        }
                    } while (!bFoundSomthingToSend && ReportsQueueDB.TryMoveToNext(cAll));
                    if (bFoundSomthingToSend) {
                        this.TriggerSendToServer();
                    }
                }
                if (cAll != null) {
                    cAll.close();
                }
            }
            reportsDB.close();
        }
        ControllerEngine.releaseSdkLock();
        if (newRec != null) {
            final long theRowID = recRowID;
            MobFoxRequest req = new MobFoxRequest("https://sdk.starbolt.io/api/logs/errors/native");
            req.setHeader("Content-Length", String.valueOf(newRec.toString().length()));
            req.setHeader("Content-Type", "application/json");
            req.setData(newRec);
            req.post(new AsyncCallback(){

                @Override
                public void onComplete(int code, Object response, Map<String, List<String>> headers) {
                    DLog.v("MobFoxAnalytics", "dbg: ### Log sent to server... " + code);
                    DLog.v("MobFoxAnalytics", "dbg: ###");
                    ReportsQueueManager.this.DeleteSessionReportFromDB(theRowID);
                }

                @Override
                public void onError(Exception e) {
                    DLog.v("MobFoxAnalytics", "dbg: ### Error sending log to server: " + e.getMessage());
                    DLog.v("MobFoxAnalytics", "dbg: ###");
                }
            });
        }
    }

    private sReportsFlatItem GetRecFromCursor(Cursor c) {
        try {
            sReportsFlatItem rec = new sReportsFlatItem();
            rec.sessionGUID = c.getString(c.getColumnIndex("report_session_GUID"));
            rec.sessionStartTime = c.getString(c.getColumnIndex("report_session_START_TIME"));
            rec.sessionUTC = c.getLong(c.getColumnIndex("report_session_UTC"));
            rec.sessionAppID = c.getString(c.getColumnIndex("report_session_APP_ID"));
            rec.sessionAppName = c.getString(c.getColumnIndex("report_session_APP_NAME"));
            rec.sessionAppVer = c.getString(c.getColumnIndex("report_session_APP_VER"));
            rec.sessionSdkVer = c.getString(c.getColumnIndex("report_session_SDK_VER"));
            rec.sessionUserAgent = c.getString(c.getColumnIndex("report_session_UA"));
            rec.sessionPlatform = c.getString(c.getColumnIndex("report_session_PLATFORM"));
            rec.jsonArrayLogs = c.getString(c.getColumnIndex("logs_array"));
            rec.jsonArrayCrashes = c.getString(c.getColumnIndex("crashes_array"));
            rec.rowID = c.getLong(c.getColumnIndex("_id"));
            rec.validate();
            return rec;
        }
        catch (SQLiteBlobTooBigException tbe) {
            DLog.e("MobfoxSDK", "SQL blob too big error (get rec from cursor)");
            return null;
        }
    }

    private void StopSendToServer() {
        if (this.mSendToServerStartTime != 0L) {
            this.mSendToServerHandler.removeCallbacks(this.mSendToServerTask);
            this.mSendToServerStartTime = 0L;
        }
    }

    private void TriggerSendToServer() {
        if (this.mSendToServerStartTime == 0L) {
            this.mSendToServerStartTime = System.currentTimeMillis();
            this.mSendToServerHandler.removeCallbacks(this.mSendToServerTask);
            this.mSendToServerHandler.postDelayed(this.mSendToServerTask, 4000L);
        }
    }

    private ReportsQueueManager() {
        singleton = this;
        this.TriggerSendToServer();
    }

    public static ReportsQueueManager getInstance() {
        if (singleton == null) {
            singleton = new ReportsQueueManager();
        }
        return singleton;
    }

    private class AddCrashAsyncTask
    extends AsyncTask<JSONObject, String, JSONObject> {
        public JSONObject crashJson;
        public String theTime;

        private AddCrashAsyncTask() {
        }

        protected JSONObject doInBackground(JSONObject ... params) {
            try {
                String cause = this.crashJson.getString("cause");
                String error_message = this.crashJson.getString("error_message");
                JSONArray arrStack = this.crashJson.getJSONArray("stack");
                JSONObject newCrashItem = new JSONObject();
                newCrashItem.put("Time", (Object)this.theTime);
                newCrashItem.put("Reason", (Object)cause);
                newCrashItem.put("Stack", (Object)arrStack.toString());
                ControllerEngine.aquireSdkLock();
                ReportsQueueDB reportsDB = new ReportsQueueDB(ReportsQueueManager.this.mCtx);
                if (reportsDB != null) {
                    try {
                        reportsDB.open();
                        reportsDB.addCrashItemToMessage(ReportsQueueManager.this.mSessionRowID, newCrashItem);
                        reportsDB.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ControllerEngine.releaseSdkLock();
                return newCrashItem;
            }
            catch (JSONException e) {
                e.printStackTrace();
                return null;
            }
        }

        protected void onPostExecute(JSONObject newRec) {
        }
    }

    private class AddEventAsyncTask
    extends AsyncTask<String, String, JSONObject> {
        public String eventText;
        public String eventGroup;
        public String atLine;
        public String theTime;

        private AddEventAsyncTask() {
        }

        protected JSONObject doInBackground(String ... params) {
            String Module = null;
            String File2 = null;
            String Line = null;
            int index1 = this.atLine.indexOf("(");
            int index2 = this.atLine.indexOf(")");
            if (index1 != -1 && index2 != -1 && index2 > index1) {
                Module = this.atLine.startsWith(" at ") ? this.atLine.substring(4, index1) : this.atLine.substring(0, index1);
                String inPrenthesis = this.atLine.substring(index1 + 1, index2);
                int index3 = inPrenthesis.indexOf(":");
                if (index3 != -1) {
                    File2 = inPrenthesis.substring(0, index3);
                    Line = inPrenthesis.substring(index3 + 1);
                } else {
                    File2 = null;
                    Line = inPrenthesis;
                }
            }
            try {
                JSONObject newLogItem = new JSONObject();
                newLogItem.put("Time", (Object)this.theTime);
                newLogItem.put("File", File2);
                newLogItem.put("Module", (Object)Module);
                newLogItem.put("Line", Line);
                newLogItem.put("Event", (Object)this.eventText);
                newLogItem.put("group", (Object)this.eventGroup);
                if (ReportsQueueManager.this.mInventoryHashDict != null) {
                    try {
                        String invH = ReportsQueueManager.this.mInventoryHashDict.getString(this.eventGroup);
                        if (invH != null) {
                            newLogItem.put("InvH", (Object)invH);
                        }
                    }
                    catch (JSONException invH) {
                        // empty catch block
                    }
                }
                DLog.v("MobFoxAnalytics", "dbg: ### addEvent: " + newLogItem.toString());
                ControllerEngine.aquireSdkLock();
                ReportsQueueDB reportsDB = new ReportsQueueDB(ReportsQueueManager.this.mCtx);
                if (reportsDB != null) {
                    try {
                        reportsDB.open();
                        reportsDB.addLogItemToMessage(ReportsQueueManager.this.mSessionRowID, newLogItem);
                        reportsDB.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ControllerEngine.releaseSdkLock();
                return newLogItem;
            }
            catch (JSONException e) {
                e.printStackTrace();
                return null;
            }
        }

        protected void onPostExecute(JSONObject newRec) {
        }
    }
}

