/*
 * Decompiled with CFR 0.152.
 */
package com.mobfox.android.core.logging;

import android.content.Context;
import android.os.Looper;
import android.webkit.WebView;
import com.mobfox.android.core.DLog;
import com.mobfox.android.core.MFXUtils;
import com.mobfox.android.core.logging.ReportsQueueManager;
import com.mobfox.android.core.networking.AsyncCallback;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class MobFoxReport
implements Thread.UncaughtExceptionHandler {
    private Context context;
    private static String ua = "";
    private Thread.UncaughtExceptionHandler defaultHandler;
    private static boolean isRegistered = false;

    private void setDefaultHandler(Thread.UncaughtExceptionHandler defaultHandler) {
        this.defaultHandler = defaultHandler;
    }

    public static synchronized void register(Context c) {
        if (isRegistered) {
            return;
        }
        MobFoxReport crashCatcher = new MobFoxReport(c);
        Thread.UncaughtExceptionHandler defaultHandler = Thread.getDefaultUncaughtExceptionHandler();
        if (defaultHandler != null) {
            crashCatcher.setDefaultHandler(defaultHandler);
        }
        Thread.setDefaultUncaughtExceptionHandler(crashCatcher);
        isRegistered = true;
    }

    MobFoxReport(Context context) {
        this.context = context;
        ua = MobFoxReport.getUserAgent(context);
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        MobFoxReport.postCrash(this.context, e, new AsyncCallback(){

            @Override
            public void onComplete(int code, Object response, Map<String, List<String>> headers) {
                DLog.d("MobFoxGraylog", "grey log on complete, code: " + code);
            }

            @Override
            public void onError(Exception e) {
                DLog.d("MobFoxGraylog", "grey log on error");
            }
        });
        if (this.defaultHandler != null) {
            this.defaultHandler.uncaughtException(t, e);
        }
    }

    static JSONArray getErrorStack(Exception e) {
        try {
            StackTraceElement[] elements;
            JSONArray stack = new JSONArray();
            for (StackTraceElement ste : elements = e.getStackTrace()) {
                String s = ste.getClassName() + ", " + ste.getFileName() + ":" + ste.getLineNumber() + " >> " + ste.getMethodName() + "()";
                stack.put((Object)s);
            }
            return stack;
        }
        catch (Exception err) {
            return new JSONArray();
        }
    }

    static String getErrorMessage(Exception e) {
        try {
            return e.getMessage();
        }
        catch (Exception err) {
            return "";
        }
    }

    public static String getUserAgent(Context context) {
        if (Looper.getMainLooper().getThread() == Thread.currentThread()) {
            try {
                String ua = new WebView(context).getSettings().getUserAgentString();
                return ua;
            }
            catch (Throwable err) {
                DLog.d("getUserAgent", "Error" + err.getLocalizedMessage());
            }
        }
        return "Android - unable to get user agent";
    }

    static String getCurrentThreadName() {
        try {
            return Thread.currentThread().getName();
        }
        catch (Exception err) {
            return "";
        }
    }

    public static String getCause(Exception e) {
        try {
            return e.getCause().toString();
        }
        catch (Exception err) {
            return "";
        }
    }

    static String getPublisherPackage(Context context) {
        try {
            return context.getPackageName();
        }
        catch (Exception err) {
            return "";
        }
    }

    public static JSONObject getLogJson(Context context) {
        JSONObject json = new JSONObject();
        if (ua == null || ua.isEmpty()) {
            ua = MobFoxReport.getUserAgent(context);
        }
        try {
            json.put("short_message", (Object)SHORT_MESSAGE.ANDROID.toString());
            json.put("current_thread", (Object)MobFoxReport.getCurrentThreadName());
            json.put("ua", (Object)ua);
            json.put("publisher_package", (Object)MobFoxReport.getPublisherPackage(context));
            json.put("host", (Object)"MobFox.Android");
            json.put("sdk_version", (Object)"Core_4.3.2");
            return json;
        }
        catch (Exception e) {
            return json;
        }
    }

    public static void post(JSONObject data, AsyncCallback cb) {
        ReportsQueueManager.getInstance().addCrashLog(data);
    }

    public static void postException(Context context, Throwable t, AsyncCallback cb) {
        Exception e = new Exception(t);
        try {
            JSONObject log = MobFoxReport.getLogJson(context);
            boolean crashInBanner = false;
            boolean crashInInterstitial = false;
            boolean crashInRewarded = false;
            boolean crashInNative = false;
            String cause = "";
            try {
                cause = t.getCause().toString();
            }
            catch (Exception err) {
                cause = MobFoxReport.getCause(e);
            }
            JSONArray myStack = new JSONArray();
            try {
                StackTraceElement[] elements;
                for (StackTraceElement ste : elements = t.getStackTrace()) {
                    String s = ste.getClassName() + ", " + ste.getFileName() + ":" + ste.getLineNumber() + " >> " + ste.getMethodName() + "()";
                    myStack.put((Object)s);
                    if (!crashInBanner && s.contains("com.mobfox.android.Ads.Banner")) {
                        crashInBanner = true;
                    }
                    if (!crashInInterstitial && s.contains("com.mobfox.android.Ads.Interstitial")) {
                        crashInInterstitial = true;
                    }
                    if (!crashInRewarded && s.contains("com.mobfox.android.Ads.Rewarded")) {
                        crashInRewarded = true;
                    }
                    if (crashInNative || !s.contains("com.mobfox.android.Ads.Native")) continue;
                    crashInNative = true;
                }
            }
            catch (Exception err) {
                myStack = MobFoxReport.getErrorStack(e);
            }
            String error_message = "";
            try {
                error_message = t.getMessage();
            }
            catch (Exception err) {
                error_message = MobFoxReport.getErrorMessage(e);
            }
            log.put("cause", (Object)cause);
            log.put("stack", (Object)myStack);
            log.put("error_message", (Object)error_message);
            log.put("short_message", (Object)SHORT_MESSAGE.ANDROID.toString());
            log.put("facility", (Object)"exception");
            MobFoxReport.post(log, cb);
            if (crashInBanner) {
                MFXUtils.call_onBannerFailed(context, e.getLocalizedMessage());
            }
            if (crashInInterstitial) {
                MFXUtils.call_onInterstitialFailed(context, e.getLocalizedMessage());
            }
            if (crashInRewarded) {
                MFXUtils.call_onRewardedFailed(context, e.getLocalizedMessage());
            }
            if (crashInNative) {
                MFXUtils.call_onNativeFailed(context, e.getLocalizedMessage());
            }
        }
        catch (Exception err) {
            DLog.d("MobFoxGraylog", "incomplete");
        }
    }

    private static void postCrash(Context context, Throwable t, AsyncCallback cb) {
        Exception e = new Exception(t);
        try {
            JSONObject log = MobFoxReport.getLogJson(context);
            boolean crashInBanner = false;
            boolean crashInInterstitial = false;
            boolean crashInRewarded = false;
            boolean crashInNative = false;
            String cause = "";
            try {
                cause = t.getCause().toString();
            }
            catch (Exception err) {
                cause = MobFoxReport.getCause(e);
            }
            JSONArray myStack = new JSONArray();
            try {
                StackTraceElement[] elements;
                for (StackTraceElement ste : elements = t.getStackTrace()) {
                    String s = ste.getClassName() + ", " + ste.getFileName() + ":" + ste.getLineNumber() + " >> " + ste.getMethodName() + "()";
                    myStack.put((Object)s);
                    if (!crashInBanner && s.contains("com.mobfox.android.Ads.Banner")) {
                        crashInBanner = true;
                    }
                    if (!crashInInterstitial && s.contains("com.mobfox.android.Ads.Interstitial")) {
                        crashInInterstitial = true;
                    }
                    if (!crashInRewarded && s.contains("com.mobfox.android.Ads.Rewarded")) {
                        crashInRewarded = true;
                    }
                    if (crashInNative || !s.contains("com.mobfox.android.Ads.Native")) continue;
                    crashInNative = true;
                }
            }
            catch (Exception err) {
                myStack = MobFoxReport.getErrorStack(e);
            }
            String error_message = "";
            try {
                error_message = t.getMessage();
            }
            catch (Exception err) {
                error_message = MobFoxReport.getErrorMessage(e);
            }
            log.put("cause", (Object)cause);
            log.put("stack", (Object)myStack);
            log.put("error_message", (Object)error_message);
            log.put("short_message", (Object)SHORT_MESSAGE.CRASH.toString());
            log.put("facility", (Object)"crash");
            MobFoxReport.post(log, cb);
            if (crashInBanner) {
                MFXUtils.call_onBannerFailed(context, e.getLocalizedMessage());
            }
            if (crashInInterstitial) {
                MFXUtils.call_onInterstitialFailed(context, e.getLocalizedMessage());
            }
            if (crashInRewarded) {
                MFXUtils.call_onRewardedFailed(context, e.getLocalizedMessage());
            }
            if (crashInNative) {
                MFXUtils.call_onNativeFailed(context, e.getLocalizedMessage());
            }
        }
        catch (Exception err) {
            DLog.d("MobFoxGraylog", "incomplete");
        }
    }

    static enum SHORT_MESSAGE {
        CRASH,
        ANDROID;

    }
}

