/*
 * Decompiled with CFR 0.152.
 */
package com.mobfox.android.core;

import android.content.Context;
import android.content.res.AssetManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import androidx.core.content.ContextCompat;
import com.android.volley.VolleyError;
import com.mobfox.android.core.DLog;
import com.mobfox.android.core.MFXStorage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MFXUtils {
    private static String fakePub1 = "  {\n    \"_id\": \"5d513eb32d888c14fe7570fd\",\n    \"invh\": \"fc57543a03d1a12362211f2a5771dbe6\",\n    \"publisher_id\": 96631856,\n    \"device\": \"android\",\n    \"app_identifier\": \"com.mobfox.mfxsdkcore.MFXTester\",\n    \"createdAt\": \"2019-08-12T10:25:55.609Z\",\n    \"updatedAt\": \"2019-08-12T10:25:55.609Z\",\n    \"sdk\": {\n      \"platform\": \"\",\n      \"version\": \"\"\n    },\n    \"waterfall\": {\n      \"interstitial\": [\n        \n      ],\n      \"banner\": [\n        \"html\"\n      ]\n    },\n    \"features\": {\n      \"reporting\": false,\n      \"monitoring\": false,\n      \"backgroundColor\": \"#ffffff\",\n      \"override\": false,\n      \"openInExternal\": true\n    },\n    \"videoSettings\": {\n      \"muted\": false,\n      \"skip\": true,\n      \"skipAfter\": null,\n      \"skipIfDurationIsGreater\": null,\n      \"minDuration\": null,\n      \"maxDuration\": null\n    },\n    \"override\": null,\n    \"glispa\": {\n      \"pub_id\": null,\n      \"placement\": null\n    },\n    \"kill\": false\n  },\n";

    public static String getAppID(Context ctx) {
        if (ctx == null) {
            return "null";
        }
        return ctx.getPackageName();
    }

    public static boolean hasPermissions(Context context) {
        try {
            if (ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_WIFI_STATE") == 0 && ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.CHANGE_WIFI_STATE") == 0 && (ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_COARSE_LOCATION") == 0 || ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_FINE_LOCATION") == 0)) {
                return true;
            }
        }
        catch (Exception e) {
            DLog.d("hasPermissions", "error checking for permissions");
        }
        return false;
    }

    public static String getBundleId(Context context) {
        String bundle_id = "";
        try {
            bundle_id = context.getPackageName();
        }
        catch (Throwable e) {
            DLog.d("MobfoxSDK", "bundle error");
        }
        return bundle_id;
    }

    public static Double getCPM(JSONObject response) {
        if (response == null) {
            return null;
        }
        double cpm = response.optDouble(MFXUtils.validateName(response, "cpm"), -1.0);
        if (cpm >= 0.0) {
            return cpm;
        }
        JSONObject ad = response.optJSONObject(MFXUtils.validateName(response, "ad"));
        JSONObject request = ad != null ? ad.optJSONObject(MFXUtils.validateName(response, "request")) : null;
        double d = cpm = request != null ? request.optDouble(MFXUtils.validateName(response, "cpmPrice"), -1.0) : -1.0;
        if (cpm >= 0.0) {
            return cpm;
        }
        JSONObject headers = ad != null ? ad.optJSONObject(MFXUtils.validateName(response, "headers")) : null;
        double d2 = cpm = headers != null ? headers.optDouble(MFXUtils.validateName(response, "X-Pricing-CPM"), -1.0) : -1.0;
        if (cpm >= 0.0) {
            return cpm;
        }
        headers = response.optJSONObject(MFXUtils.validateName(response, "headers"));
        double d3 = cpm = headers != null ? headers.optDouble(MFXUtils.validateName(response, "X-Pricing-CPM"), -1.0) : -1.0;
        if (cpm >= 0.0) {
            return cpm;
        }
        return null;
    }

    public static String validateName(JSONObject dict, String in_name) {
        String name = in_name;
        if (dict.has(name)) {
            return name;
        }
        name = in_name.toLowerCase();
        if (dict.has(name)) {
            return name;
        }
        name = in_name.toUpperCase();
        if (dict.has(name)) {
            return name;
        }
        return in_name;
    }

    public static String getStringFromDict(JSONObject dict, String name) {
        try {
            String res = dict.getString(name);
            return res;
        }
        catch (JSONException e) {
            return "";
        }
    }

    public static JSONObject getDictFromDict(JSONObject dict, String name) {
        try {
            JSONObject res = dict.getJSONObject(name);
            return res;
        }
        catch (JSONException e) {
            return null;
        }
    }

    public static JSONArray getArrayFromDict(JSONObject dict, String name) {
        try {
            JSONArray res = dict.getJSONArray(name);
            return res;
        }
        catch (JSONException e) {
            return null;
        }
    }

    public static int getIntFromDict(JSONObject dict, String name) {
        try {
            int res = dict.getInt(name);
            return res;
        }
        catch (JSONException e) {
            return 0;
        }
    }

    public static boolean getBoolFromDict(JSONObject dict, String name) {
        try {
            boolean res = dict.getBoolean(name);
            return res;
        }
        catch (JSONException e) {
            return false;
        }
    }

    public static boolean isConnected(Context ctx) {
        try {
            if (ctx != null) {
                ConnectivityManager connMgr = (ConnectivityManager)ctx.getSystemService("connectivity");
                if (connMgr == null) {
                    return false;
                }
                NetworkInfo wifi = connMgr.getNetworkInfo(1);
                NetworkInfo mobile = connMgr.getNetworkInfo(0);
                if (wifi.isConnectedOrConnecting()) {
                    return true;
                }
                return mobile.isConnectedOrConnecting();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static String readFileContentFromAssetsFolder(Context ctx, String filename) {
        if (MFXStorage.sharedInstance(ctx).getPrefBool("ReadLocalJS", false)) {
            AssetManager mgr = ctx.getAssets();
            try {
                InputStream in = mgr.open(filename, 3);
                String sHTML = MFXUtils.StreamToString(in);
                in.close();
                return sHTML;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private static String StreamToString(InputStream in) throws IOException {
        int n;
        if (in == null) {
            return "";
        }
        StringWriter writer = new StringWriter();
        char[] buffer = new char[1024];
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
        while ((n = reader.read(buffer)) != -1) {
            ((Writer)writer).write(buffer, 0, n);
        }
        return ((Object)writer).toString();
    }

    public static void call_onBannerFailed(Context context, String msg) {
        String className = "MobfoxSDK";
        String packageName = "com.mobfox.android";
        String staticMethodName = "ReportBannerCrash";
        Class[] formalParameters = new Class[]{String.class};
        Object[] effectiveParameters = new Object[]{msg};
        try {
            Class<?> clazz = Class.forName(packageName + "." + className);
            Method method = clazz.getMethod(staticMethodName, formalParameters);
            method.invoke(null, effectiveParameters);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void call_onInterstitialFailed(Context context, String msg) {
        String className = "MobfoxSDK";
        String packageName = "com.mobfox.android";
        String staticMethodName = "ReportInterstitialCrash";
        Class[] formalParameters = new Class[]{String.class};
        Object[] effectiveParameters = new Object[]{msg};
        try {
            Class<?> clazz = Class.forName(packageName + "." + className);
            Method method = clazz.getMethod(staticMethodName, formalParameters);
            method.invoke(null, effectiveParameters);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void call_onRewardedFailed(Context context, String msg) {
        String className = "MobfoxSDK";
        String packageName = "com.mobfox.android";
        String staticMethodName = "ReportRewardedCrash";
        Class[] formalParameters = new Class[]{String.class};
        Object[] effectiveParameters = new Object[]{msg};
        try {
            Class<?> clazz = Class.forName(packageName + "." + className);
            Method method = clazz.getMethod(staticMethodName, formalParameters);
            method.invoke(null, effectiveParameters);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void call_onNativeFailed(Context context, String msg) {
        String className = "MobfoxSDK";
        String packageName = "com.mobfox.android";
        String staticMethodName = "ReportBativeCrash";
        Class[] formalParameters = new Class[]{String.class};
        Object[] effectiveParameters = new Object[]{msg};
        try {
            Class<?> clazz = Class.forName(packageName + "." + className);
            Method method = clazz.getMethod(staticMethodName, formalParameters);
            method.invoke(null, effectiveParameters);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String TranslateVolleyError(VolleyError error) {
        if (error == null) {
            return "Unknown volley error(1)";
        }
        String szClass = error.getClass().toString();
        if (szClass.equalsIgnoreCase("class com.android.volley.NoConnectionError")) {
            return "There seems to be a problem with your internet connection";
        }
        if (szClass.equalsIgnoreCase("class com.android.volley.TimeoutError")) {
            return "Request timed out";
        }
        if (szClass.equalsIgnoreCase("class com.android.volley.ParseError")) {
            return "Error parsing response";
        }
        if (error.networkResponse != null && error.networkResponse.statusCode == 0) {
            return "Bad response format";
        }
        return error.getMessage();
    }

    public static JSONObject getFake1Pub() {
        try {
            JSONObject res = new JSONObject(fakePub1);
            return res;
        }
        catch (JSONException e) {
            return null;
        }
    }
}

