/*
 * Decompiled with CFR 0.152.
 */
package com.mobfox.android;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.view.ViewGroup;
import com.mobfox.android.Ads.BannerInner;
import com.mobfox.android.Ads.InterstitialInner;
import com.mobfox.android.Ads.NativeInner;
import com.mobfox.android.core.DLog;
import com.mobfox.android.core.MFXConfiguration;
import com.mobfox.android.core.MFXStorage;
import com.mobfox.android.core.MFXUtils;
import com.mobfox.android.core.MobfoxSettings;
import com.mobfox.android.core.Networking;
import com.mobfox.android.core.javascriptengine.ControllerEngine;
import com.mobfox.android.core.javascriptengine.JavascriptEngine;
import com.mobfox.android.core.logging.MobFoxReport;
import com.mobfox.android.dmp.utils.DMPUtils;
import java.util.ArrayList;
import java.util.Map;

public class MobfoxSDK {
    private static volatile MobfoxSDK instance = null;
    private static volatile Context mAppContext = null;
    private static String mControllerJSScript = null;
    private static ControllerEngine mControllerEngine = null;
    private ArrayList<OnLoadSdkCallback> mArrLoadCompletions = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MobfoxSDK sharedInstance(Context ctx) {
        if (instance != null) return instance;
        Class<MobfoxSDK> clazz = MobfoxSDK.class;
        synchronized (MobfoxSDK.class) {
            if (instance != null) return instance;
            instance = new MobfoxSDK(ctx);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void init(Context ctx) {
        if (instance == null) {
            Class<MobfoxSDK> clazz = MobfoxSDK.class;
            // MONITORENTER : com.mobfox.android.MobfoxSDK.class
            if (instance == null) {
                instance = new MobfoxSDK(ctx);
            }
            // MONITOREXIT : clazz
        }
        DLog.d("MobfoxSDK", "dbg: ### inited SDK ###");
    }

    public static String getSdkVersion() {
        return "4.3.2";
    }

    private MobfoxSDK(Context ctx) {
        if (instance != null) {
            throw new RuntimeException("Use sharedInstance() method to get the single instance of this class.");
        }
        mAppContext = ctx;
        MobfoxSDK.setDemoAge("");
        MobfoxSDK.setDemoGender("");
        MobfoxSDK.setDemoKeywords("");
        MobfoxSDK.setLongitude(0.0);
        MobfoxSDK.setLatitude(0.0);
        MobfoxSettings.getInstance(ctx);
        Networking.sharedInstance(ctx);
        if (MFXConfiguration.sharedInstance(ctx).needToStartDMP(ctx)) {
            DMPUtils.postDMPFromDMP(ctx);
            DMPUtils.startMobFoxServiceFromDMP(ctx, true);
        }
        DLog.release("MobfoxSDK", "dbg: ###");
        DLog.release("MobfoxSDK", "dbg: ### new instance SDK(4.3.2) ###");
        DLog.release("MobfoxSDK", "dbg: ###");
        this.performSdkLoadWithCompletion(ctx, "SDKConstructor", new OnLoadSdkCallback(){

            @Override
            public void onLoadResult(String error) {
                if (error == null) {
                    DLog.release("MobfoxSDK", "dbg: ### SDK loaded OK ###");
                } else {
                    DLog.release("MobfoxSDK", "dbg: ### SDK load error: " + error);
                }
            }
        });
    }

    public static boolean isInitialized() {
        if (instance == null) {
            DLog.e("MobfoxSDK", "######################################################");
            DLog.e("MobfoxSDK", "###                                                ###");
            DLog.e("MobfoxSDK", "### Looks like you did not initialize MobfoxSDK    ###");
            DLog.e("MobfoxSDK", "###                                                ###");
            DLog.e("MobfoxSDK", "### Please add a call to 'MobfoxSDK.init(context)' ###");
            DLog.e("MobfoxSDK", "### in your app 'Application' object, or at any    ###");
            DLog.e("MobfoxSDK", "### point in your app BEFORE starting to use the   ###");
            DLog.e("MobfoxSDK", "### Mobfox SDK                                     ###");
            DLog.e("MobfoxSDK", "###                                                ###");
            DLog.e("MobfoxSDK", "######################################################");
            return false;
        }
        return true;
    }

    public static boolean isReady() {
        if (!MobfoxSDK.isInitialized()) {
            return false;
        }
        if (mControllerEngine == null) {
            return false;
        }
        return mControllerEngine.isEngineReady();
    }

    @Deprecated
    public static void setGDPR(boolean subjectToGDPR) {
    }

    @Deprecated
    public static void setGDPRConsentString(String consentString) {
    }

    public static void setCOPPA(boolean subjectToCOPPA) {
        if (mAppContext != null) {
            DLog.release("MobfoxSDK", "dbg: ### setCOPPA(" + subjectToCOPPA + ") ###");
            MFXStorage.sharedInstance(mAppContext).setPrefString("key_subject_to_coppa", subjectToCOPPA ? "1" : "0");
        }
    }

    public static void setDemoAge(String demoAge) {
        if (mAppContext != null) {
            DLog.release("MobfoxSDK", "dbg: ### setDemoAge(" + demoAge + ") ###");
            if (MFXStorage.sharedInstance(mAppContext).canWeSendPrivateInfo(mAppContext)) {
                MFXStorage.sharedInstance(mAppContext).setPrefString("demo_age", demoAge);
            } else {
                MFXStorage.sharedInstance(mAppContext).deletePrefString("demo_age");
            }
        }
    }

    public static void setDemoGender(String demoGender) {
        if (mAppContext != null) {
            DLog.release("MobfoxSDK", "dbg: ### setDemoGender(" + demoGender + ") ###");
            if (MFXStorage.sharedInstance(mAppContext).canWeSendPrivateInfo(mAppContext)) {
                MFXStorage.sharedInstance(mAppContext).setPrefString("demo_gender", demoGender);
            } else {
                MFXStorage.sharedInstance(mAppContext).deletePrefString("demo_gender");
            }
        }
    }

    public static void setDemoKeywords(String demoKeywords) {
        if (mAppContext != null) {
            DLog.release("MobfoxSDK", "dbg: ### setDemoKeywords(" + demoKeywords + ") ###");
            MFXStorage.sharedInstance(mAppContext).setPrefString("demo_keywords", demoKeywords);
        }
    }

    public static void setLatitude(double latitude) {
        if (mAppContext != null) {
            DLog.release("MobfoxSDK", "dbg: ### setLatitude(" + latitude + ") ###");
            if (MFXStorage.sharedInstance(mAppContext).canWeSendPrivateInfo(mAppContext)) {
                MFXStorage.sharedInstance(mAppContext).setPrefDouble("adapter_latitude", latitude);
            } else {
                MFXStorage.sharedInstance(mAppContext).deletePrefDouble("adapter_latitude");
            }
        }
    }

    public static void setLongitude(double longitude) {
        if (mAppContext != null) {
            DLog.release("MobfoxSDK", "dbg: ### setLongitude(" + longitude + ") ###");
            if (MFXStorage.sharedInstance(mAppContext).canWeSendPrivateInfo(mAppContext)) {
                MFXStorage.sharedInstance(mAppContext).setPrefDouble("adapter_longitude", longitude);
            } else {
                MFXStorage.sharedInstance(mAppContext).deletePrefDouble("adapter_longitude");
            }
        }
    }

    public static void onPause(Context appCtx) {
        if (mControllerEngine != null) {
            mControllerEngine.onPause(appCtx);
        }
    }

    public static void onResume(Context appCtx) {
        if (mControllerEngine != null) {
            mControllerEngine.onResume(appCtx);
        }
    }

    public static void onDestroy(Context appCtx) {
        if (mControllerEngine != null) {
            ControllerEngine.onDestroy(appCtx);
        }
    }

    public static boolean onBackPressed(Context appCtx) {
        if (mControllerEngine != null) {
            return ControllerEngine.onBackPressed(appCtx);
        }
        return false;
    }

    private void sendAllCompletions(String error) {
        if (this.mArrLoadCompletions != null) {
            ControllerEngine.aquireSdkLock();
            ArrayList<OnLoadSdkCallback> currCompletions = new ArrayList<OnLoadSdkCallback>(this.mArrLoadCompletions);
            ControllerEngine.releaseSdkLock();
            while (currCompletions.size() > 0) {
                OnLoadSdkCallback completion = currCompletions.get(0);
                if (completion != null) {
                    completion.onLoadResult(error);
                }
                currCompletions.remove(0);
            }
            ControllerEngine.aquireSdkLock();
            this.mArrLoadCompletions.clear();
            ControllerEngine.releaseSdkLock();
        }
    }

    public void performSdkLoadWithCompletion(final Context ctx, String calledFrom, OnLoadSdkCallback completion) {
        DLog.d("MobfoxSDK", "dbg: ### perform Sdk Load (" + calledFrom + ") ###");
        ControllerEngine.aquireSdkLock();
        if (this.mArrLoadCompletions == null) {
            this.mArrLoadCompletions = new ArrayList();
        }
        this.mArrLoadCompletions.add(completion);
        ControllerEngine.releaseSdkLock();
        if (this.mArrLoadCompletions.size() == 1) {
            DLog.d("MobfoxSDK", "dbg: ### perform Sdk Load - initing ###");
            MFXConfiguration.sharedInstance(ctx).makeSureConfigsAreLoaded(ctx, new MFXConfiguration.OnConfigCallback(){

                @Override
                public void onConfigResult(String error, String value) {
                    if (error != null) {
                        DLog.d("MobfoxSDK", "dbg: ### make Sure Configs Loaded - error: " + error);
                        MobfoxSDK.this.sendAllCompletions(error);
                        return;
                    }
                    DLog.d("MobfoxSDK", "dbg: ### make Sure Configs Loaded - OK ###");
                    MobfoxSDK.this.startControllerJS(ctx, new OnLoadSdkCallback(){

                        @Override
                        public void onLoadResult(String error) {
                            if (error != null) {
                                DLog.d("MobfoxSDK", "dbg: ### start controller js - error: " + error);
                                MobfoxSDK.this.sendAllCompletions(error);
                                return;
                            }
                            DLog.d("MobfoxSDK", "dbg: ### start controller js - OK ###");
                            MobfoxSDK.this.sendAllCompletions(null);
                        }
                    });
                }
            });
        }
    }

    private void startControllerJS(final Context ctx, final OnLoadSdkCallback completion) {
        DLog.d("MobfoxSDK", "dbg: ### start controller js... ###");
        mControllerJSScript = MFXConfiguration.sharedInstance(ctx).getControllerScript(ctx);
        if (mControllerJSScript.length() == 0) {
            DLog.e("MobfoxSDK", "dbg: ### start controller js: no script ###");
            if (completion != null) {
                completion.onLoadResult("No controller script");
            }
            return;
        }
        if (ControllerEngine.controllerReady()) {
            DLog.d("MobfoxSDK", "dbg: ### start controller js - already loaded and ready ###");
            if (completion != null) {
                completion.onLoadResult(null);
            }
            return;
        }
        String fromFile = MFXUtils.readFileContentFromAssetsFolder(ctx, "controller.html");
        if (fromFile != null) {
            mControllerJSScript = fromFile;
        }
        String ua = MobFoxReport.getUserAgent(ctx);
        DLog.release("MobfoxSDK", "dbg: ### UA=" + ua);
        Activity ctxForUse = null;
        try {
            ctxForUse = (Activity)ctx;
            ctxForUse.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    MobfoxSDK.this.CreateContollerJS(ctx, completion);
                }
            });
        }
        catch (ClassCastException cce) {
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    MobfoxSDK.this.CreateContollerJS(ctx, completion);
                }
            });
        }
    }

    private void CreateContollerJS(Context ctx, final OnLoadSdkCallback completion) {
        block2: {
            try {
                mControllerEngine = ControllerEngine.sharedInstance(ctx, mControllerJSScript, new JavascriptEngine.OnReadyCallback(){

                    @Override
                    public void onReady(JavascriptEngine engine) {
                        if (completion != null) {
                            completion.onLoadResult(null);
                        }
                    }
                });
            }
            catch (JavascriptEngine.JavascriptEngineInitException e) {
                if (completion == null) break block2;
                completion.onLoadResult(e != null ? e.getMessage() : "Controller unknown error");
            }
        }
    }

    protected static void ReportBannerCrash(String code) {
        DLog.e("MobfoxSDK", "######################################################");
        DLog.e("MobfoxSDK", "### MFXBanner crashed: " + code);
        DLog.e("MobfoxSDK", "######################################################");
    }

    protected static void ReportRewardedCrash(String code) {
        DLog.e("MobfoxSDK", "######################################################");
        DLog.e("MobfoxSDK", "### MFXRewarded crashed: " + code);
        DLog.e("MobfoxSDK", "######################################################");
    }

    protected static void ReportInterstitialCrash(String code) {
        DLog.e("MobfoxSDK", "######################################################");
        DLog.e("MobfoxSDK", "### MFXInterstitial crashed: " + code);
        DLog.e("MobfoxSDK", "######################################################");
    }

    protected static void ReportNativeCrash(String code) {
        DLog.e("MobfoxSDK", "######################################################");
        DLog.e("MobfoxSDK", "### MFXNative crashed: " + code);
        DLog.e("MobfoxSDK", "######################################################");
    }

    public static MFXBanner createBanner(Context ctx, int width, int height, String invh, MFXBannerListener listener) {
        DLog.release("MobfoxSDK", "dbg: ### createBanner(" + width + ", " + height + ", " + invh + ") ###");
        MFXBanner newBanner = new MFXBanner(ctx, width, height, invh, listener);
        return newBanner;
    }

    public static void loadBanner(MFXBanner mAd) {
        if (mAd != null) {
            DLog.release("MobfoxSDK", "dbg: ### loadBanner() ###");
            mAd.loadBanner();
        }
    }

    public static void addBannerViewTo(MFXBanner mAd, ViewGroup targetView) {
        if (mAd != null) {
            DLog.release("MobfoxSDK", "dbg: ### addBannerViewTo() ###");
            mAd.addBannerViewTo(targetView);
        }
    }

    public static void setBannerListener(MFXBanner mAd, MFXBannerListener listener) {
        if (mAd != null) {
            mAd.setBannerListener(listener);
        }
    }

    public static void setBannerRefresh(MFXBanner mAd, int intervalInSeconds) {
        if (mAd != null) {
            DLog.release("MobfoxSDK", "dbg: ### setBannerRefresh(" + intervalInSeconds + ") ###");
            mAd.setBannerRefresh(intervalInSeconds);
        }
    }

    public static void releaseBanner(MFXBanner mAd) {
        if (mAd != null) {
            DLog.release("MobfoxSDK", "dbg: ### releaseBanner() ###");
            mAd.releaseBanner();
        }
    }

    public static void setBannerFloorPrice(MFXBanner mAd, float floorPrice) {
        if (mAd != null) {
            DLog.release("MobfoxSDK", "dbg: ### setBannerFloorPrice(" + floorPrice + ") ###");
            mAd.setBannerFloorPrice(floorPrice);
        }
    }

    public static void setBannerAdapterName(MFXBanner mAd, String adapterName) {
        if (mAd != null) {
            mAd.setBannerAdapterName(adapterName);
        }
    }

    public static MFXInterstitial createInterstitial(Context ctx, String invh, MFXInterstitialListener listener) {
        DLog.release("MobfoxSDK", "dbg: ### createInterstitial(" + invh + ") ###");
        MFXInterstitial newInterstitial = new MFXInterstitial(ctx, invh, listener);
        return newInterstitial;
    }

    public static void loadInterstitial(MFXInterstitial mAd) {
        if (mAd != null) {
            DLog.release("MobfoxSDK", "dbg: ### loadInterstitial() ###");
            mAd.loadInterstitial();
        }
    }

    public static void showInterstitial(MFXInterstitial mAd) {
        if (mAd != null) {
            DLog.release("MobfoxSDK", "dbg: ### showInterstitial() ###");
            mAd.showInterstitial();
        }
    }

    public static void setInterstitialListener(MFXInterstitial mAd, MFXInterstitialListener listener) {
        if (mAd != null) {
            mAd.setInterstitialListener(listener);
        }
    }

    public static void releaseInterstitial(MFXInterstitial mAd) {
        if (mAd != null) {
            DLog.release("MobfoxSDK", "dbg: ### releaseInterstitial() ###");
            mAd.releaseInterstitial();
        }
    }

    public static void setInterstitialFloorPrice(MFXInterstitial mAd, float floorPrice) {
        if (mAd != null) {
            DLog.release("MobfoxSDK", "dbg: ### setInterstitialFloorPrice(" + floorPrice + ") ###");
            mAd.setInterstitialFloorPrice(floorPrice);
        }
    }

    public static void setInterstitialAdapterName(MFXInterstitial mAd, String adapterName) {
        if (mAd != null) {
            mAd.setInterstitialAdapterName(adapterName);
        }
    }

    public static MFXNative createNative(Context ctx, String invh, MFXNativeListener listener) {
        DLog.release("MobfoxSDK", "dbg: ### createNative(" + invh + ") ###");
        MFXNative newNative = new MFXNative(ctx, invh, listener);
        return newNative;
    }

    public static void loadNative(MFXNative mAd) {
        if (mAd != null) {
            DLog.release("MobfoxSDK", "dbg: ### loadNative() ###");
            mAd.loadNative();
        }
    }

    public static void loadNativeImages(MFXNative mAd) {
        if (mAd != null) {
            DLog.release("MobfoxSDK", "dbg: ### loadNativeImages() ###");
            mAd.loadImages();
        }
    }

    public static void registerNativeForInteraction(Context c, MFXNative mAd, View layout) {
        if (mAd != null) {
            DLog.release("MobfoxSDK", "dbg: ### registerNativeForInteraction() ###");
            mAd.registerNativeForInteraction(c, layout);
        }
    }

    public static void setNativeListener(MFXNative mAd, MFXNativeListener listener) {
        if (mAd != null) {
            mAd.setNativeListener(listener);
        }
    }

    public static void callToActionClicked(MFXNative mAd) {
        if (mAd != null) {
            mAd.callToActionClicked();
        }
    }

    public static String getNativeLink(MFXNative mAd) {
        if (mAd != null) {
            return mAd.getLink();
        }
        return null;
    }

    public static Map<String, String> getNativeTexts(MFXNative mAd) {
        if (mAd != null) {
            return mAd.getTexts();
        }
        return null;
    }

    public static Map<String, String> getNativeImageUrls(MFXNative mAd) {
        if (mAd != null) {
            return mAd.getImageUrls();
        }
        return null;
    }

    public static Map<String, Bitmap> getNativeImageBitmaps(MFXNative mAd) {
        if (mAd != null) {
            return mAd.getImageBitmaps();
        }
        return null;
    }

    public static void setNativeAdContext(MFXNative mAd, MFXNative.NativeAdContext context) {
        if (mAd != null) {
            DLog.release("MobfoxSDK", "dbg: ### setNativeAdContext(" + (Object)((Object)context) + ") ###");
            mAd.setNativeAdContext(context);
        }
    }

    public static void setNativeAdPlacementType(MFXNative mAd, MFXNative.NativeAdPlacementType type) {
        if (mAd != null) {
            DLog.release("MobfoxSDK", "dbg: ### setNativeAdPlacementType(" + (Object)((Object)type) + ") ###");
            mAd.setNativeAdPlacementType(type);
        }
    }

    public static void setNativeAdIconImage(MFXNative mAd, boolean bRequired, int size) {
        if (mAd != null) {
            DLog.release("MobfoxSDK", "dbg: ### setNativeAdIconImage(" + bRequired + ", " + size + ") ###");
            mAd.setNativeAdIconImage(bRequired, size);
        }
    }

    public static void setNativeAdMainImage(MFXNative mAd, boolean bRequired, int width, int height) {
        if (mAd != null) {
            DLog.release("MobfoxSDK", "dbg: ### setNativeAdMainImage(" + bRequired + ", " + width + ", " + height + ") ###");
            mAd.setNativeAdMainImage(bRequired, width, height);
        }
    }

    public static void setNativeAdTitle(MFXNative mAd, boolean bRequired, int length) {
        if (mAd != null) {
            DLog.release("MobfoxSDK", "dbg: ### setNativeAdTitle(" + bRequired + ", " + length + ") ###");
            mAd.setNativeAdTitle(bRequired, length);
        }
    }

    public static void setNativeAdDesc(MFXNative mAd, boolean bRequired, int length) {
        if (mAd != null) {
            DLog.release("MobfoxSDK", "dbg: ### setNativeAdDesc(" + bRequired + ", " + length + ") ###");
            mAd.setNativeAdDesc(bRequired, length);
        }
    }

    public static void releaseNative(MFXNative mAd) {
        if (mAd != null) {
            DLog.release("MobfoxSDK", "dbg: ### releaseNative() ###");
            mAd.releaseNative();
        }
    }

    public static void setNativeFloorPrice(MFXNative mAd, float floorPrice) {
        if (mAd != null) {
            DLog.release("MobfoxSDK", "dbg: ### setNativeFloorPrice(" + floorPrice + ") ###");
            mAd.setNativeFloorPrice(floorPrice);
        }
    }

    public static void setNativeAdapterName(MFXNative mAd, String adapterName) {
        if (mAd != null) {
            mAd.setNativeAdapterName(adapterName);
        }
    }

    public static class MFXNative {
        private MFXNative mNative;
        private MFXNativeListener mNativeListener;
        private NativeInner mNativeInner;
        private NativeInner.NativeInnerListener mNativeInnerListener = new NativeInner.NativeInnerListener(){

            @Override
            public void onNativeLoaded(NativeInner aNative, Map<String, String> textItems) {
                if (MFXNative.this.mNativeListener != null) {
                    MFXNative.this.mNativeListener.onNativeLoaded(MFXNative.this.mNative);
                }
            }

            @Override
            public void onNativeImagesReady(NativeInner aNative, Map<String, String> textItems, Map<String, Bitmap> imageItems) {
                if (MFXNative.this.mNativeListener != null) {
                    MFXNative.this.mNativeListener.onNativeImagesReady(MFXNative.this.mNative);
                }
            }

            @Override
            public void onNativeLoadFailed(NativeInner aNative, String code) {
                if (MFXNative.this.mNativeListener != null) {
                    MFXNative.this.mNativeListener.onNativeLoadFailed(MFXNative.this.mNative, code);
                }
            }

            @Override
            public void onNativeClicked(NativeInner aNative) {
                if (MFXNative.this.mNativeListener != null) {
                    MFXNative.this.mNativeListener.onNativeClicked(MFXNative.this.mNative);
                }
            }
        };

        public MFXNative(Context context, String invh, MFXNativeListener listener) {
            this.mNative = this;
            this.mNativeInner = new NativeInner(context);
            if (this.mNativeInner != null) {
                this.mNativeInner.setInvh(invh);
                this.setNativeListener(listener);
            }
        }

        private void loadNative() {
            if (this.mNativeInner != null) {
                this.mNativeInner.load();
            }
        }

        private void loadImages() {
            if (this.mNativeInner != null) {
                this.mNativeInner.loadImages();
            }
        }

        private void registerNativeForInteraction(Context c, View layout) {
            if (this.mNativeInner != null) {
                this.mNativeInner.registerViewForInteraction(c, layout);
            }
        }

        private void setNativeListener(MFXNativeListener listener) {
            if (this.mNativeInner != null) {
                this.mNativeListener = listener;
                if (listener == null) {
                    this.mNativeInner.setListener(null);
                } else {
                    this.mNativeInner.setListener(this.mNativeInnerListener);
                }
            }
        }

        private void callToActionClicked() {
            if (this.mNativeInner != null) {
                this.mNativeInner.callToActionClicked();
            }
        }

        private String getLink() {
            if (this.mNativeInner != null) {
                this.mNativeInner.getLink();
            }
            return null;
        }

        private Map<String, String> getTexts() {
            if (this.mNativeInner != null) {
                return this.mNativeInner.getTexts();
            }
            return null;
        }

        private Map<String, String> getImageUrls() {
            if (this.mNativeInner != null) {
                return this.mNativeInner.getImageUrls();
            }
            return null;
        }

        private Map<String, Bitmap> getImageBitmaps() {
            if (this.mNativeInner != null) {
                return this.mNativeInner.getImageBitmaps();
            }
            return null;
        }

        private void setNativeAdContext(NativeAdContext context) {
            if (this.mNativeInner != null) {
                this.mNativeInner.setNativeAdContext(context);
            }
        }

        private void setNativeAdPlacementType(NativeAdPlacementType type) {
            if (this.mNativeInner != null) {
                this.mNativeInner.setNativeAdPlacementType(type);
            }
        }

        private void setNativeAdIconImage(boolean bRequired, int size) {
            if (this.mNativeInner != null) {
                this.mNativeInner.setNativeAdIconImage(bRequired, size);
            }
        }

        private void setNativeAdMainImage(boolean bRequired, int width, int height) {
            if (this.mNativeInner != null) {
                this.mNativeInner.setNativeAdMainImage(bRequired, width, height);
            }
        }

        private void setNativeAdTitle(boolean bRequired, int length) {
            if (this.mNativeInner != null) {
                this.mNativeInner.setNativeAdTitle(bRequired, length);
            }
        }

        private void setNativeAdDesc(boolean bRequired, int length) {
            if (this.mNativeInner != null) {
                this.mNativeInner.setNativeAdDesc(bRequired, length);
            }
        }

        private void releaseNative() {
            if (this.mNativeInner != null && mControllerEngine != null) {
                mControllerEngine.releaseNative(this.mNativeInner.getGuid());
            }
        }

        private void setNativeFloorPrice(float floorPrice) {
            if (this.mNativeInner != null) {
                this.mNativeInner.setNativeFloorPrice(floorPrice);
            }
        }

        private void setNativeAdapterName(String adapterName) {
            if (this.mNativeInner != null) {
                this.mNativeInner.setNativeAdapterName(adapterName);
            }
        }

        public static class Tracker {
            private String type;
            private String url;

            public Tracker(String type, String url) {
                this.type = type;
                this.url = url;
            }

            public String getType() {
                return this.type;
            }

            public void setType(String type) {
                this.type = type;
            }

            public String getUrl() {
                return this.url;
            }

            public void setUrl(String url) {
                this.url = url;
            }
        }

        public static enum NativeAdPlacementType {
            IN_FEED,
            ATOMIC,
            OUTSIDE,
            RECOMMENDATION;

        }

        public static enum NativeAdContext {
            CONTENT,
            SOCIAL,
            PRODUCT;

        }
    }

    public static class MFXInterstitial {
        private MFXInterstitial mInterstitial;
        private MFXInterstitialListener mInterstitialListener;
        private InterstitialInner mInterstitialInner;
        private InterstitialInner.InterstitialInnerListener mInterstitialInnerListener = new InterstitialInner.InterstitialInnerListener(){

            @Override
            public void onInterstitialLoaded(InterstitialInner interstitial) {
                if (MFXInterstitial.this.mInterstitialListener != null) {
                    MFXInterstitial.this.mInterstitialListener.onInterstitialLoaded(MFXInterstitial.this.mInterstitial);
                }
            }

            @Override
            public void onInterstitialLoadFailed(InterstitialInner interstitial, String code) {
                if (MFXInterstitial.this.mInterstitialListener != null) {
                    MFXInterstitial.this.mInterstitialListener.onInterstitialLoadFailed(MFXInterstitial.this.mInterstitial, code);
                }
            }

            @Override
            public void onInterstitialClosed(InterstitialInner interstitial) {
                if (MFXInterstitial.this.mInterstitialListener != null) {
                    MFXInterstitial.this.mInterstitialListener.onInterstitialClosed(MFXInterstitial.this.mInterstitial);
                }
            }

            @Override
            public void onInterstitialClicked(InterstitialInner interstitial, String url) {
                if (MFXInterstitial.this.mInterstitialListener != null) {
                    MFXInterstitial.this.mInterstitialListener.onInterstitialClicked(MFXInterstitial.this.mInterstitial, url);
                }
            }

            @Override
            public void onInterstitialShown(InterstitialInner interstitial) {
                if (MFXInterstitial.this.mInterstitialListener != null) {
                    MFXInterstitial.this.mInterstitialListener.onInterstitialShown(MFXInterstitial.this.mInterstitial);
                }
            }

            @Override
            public void onInterstitialFinished(InterstitialInner interstitial) {
                if (MFXInterstitial.this.mInterstitialListener != null) {
                    MFXInterstitial.this.mInterstitialListener.onInterstitialFinished(MFXInterstitial.this.mInterstitial);
                }
            }
        };

        public MFXInterstitial(Context context, String hash, MFXInterstitialListener listener) {
            this.mInterstitial = this;
            this.mInterstitialListener = listener;
            this.mInterstitialInner = listener == null ? new InterstitialInner(context, hash, false, null) : new InterstitialInner(context, hash, false, this.mInterstitialInnerListener);
        }

        private void loadInterstitial() {
            if (this.mInterstitialInner != null) {
                this.mInterstitialInner.load();
            }
        }

        private void showInterstitial() {
            if (this.mInterstitialInner != null) {
                this.mInterstitialInner.show();
            }
        }

        private void setInterstitialListener(MFXInterstitialListener listener) {
            if (this.mInterstitialInner != null) {
                this.mInterstitialListener = listener;
                if (listener == null) {
                    this.mInterstitialInner.setListener(null);
                } else {
                    this.mInterstitialInner.setListener(this.mInterstitialInnerListener);
                }
            }
        }

        private void releaseInterstitial() {
            if (this.mInterstitialInner != null && mControllerEngine != null) {
                mControllerEngine.releaseInterstitial(this.mInterstitialInner.getGuid());
            }
        }

        private void setInterstitialFloorPrice(float floorPrice) {
            if (this.mInterstitialInner != null) {
                this.mInterstitialInner.setInterstitialFloorPrice(floorPrice);
            }
        }

        private void setInterstitialAdapterName(String adapterName) {
            if (this.mInterstitialInner != null) {
                this.mInterstitialInner.setInterstitialAdapterName(adapterName);
            }
        }
    }

    public static class MFXBanner {
        private MFXBanner mBanner;
        private MFXBannerListener mBannerListener;
        private BannerInner mBannerInner;
        private BannerInner.BannerInnerListener mBannerInnerListener = new BannerInner.BannerInnerListener(){

            @Override
            public void onBannerLoadFailed(BannerInner banner, String code) {
                if (MFXBanner.this.mBannerListener != null) {
                    MFXBanner.this.mBannerListener.onBannerLoadFailed(MFXBanner.this.mBanner, code);
                }
            }

            @Override
            public void onBannerLoaded(BannerInner banner) {
                if (MFXBanner.this.mBannerListener != null) {
                    MFXBanner.this.mBannerListener.onBannerLoaded(MFXBanner.this.mBanner);
                }
            }

            @Override
            public void onBannerShown(BannerInner banner) {
                if (MFXBanner.this.mBannerListener != null) {
                    MFXBanner.this.mBannerListener.onBannerShown(MFXBanner.this.mBanner);
                }
            }

            @Override
            public void onBannerClosed(BannerInner banner) {
                if (MFXBanner.this.mBannerListener != null) {
                    MFXBanner.this.mBannerListener.onBannerClosed(MFXBanner.this.mBanner);
                }
            }

            @Override
            public void onBannerFinished(BannerInner banner) {
                if (MFXBanner.this.mBannerListener != null) {
                    MFXBanner.this.mBannerListener.onBannerFinished(MFXBanner.this.mBanner);
                }
            }

            @Override
            public void onBannerClicked(BannerInner banner, String url) {
                if (MFXBanner.this.mBannerListener != null) {
                    MFXBanner.this.mBannerListener.onBannerClicked(MFXBanner.this.mBanner, url);
                }
            }
        };

        public MFXBanner(Context context, int width, int height, String invh, MFXBannerListener listener) {
            this.mBanner = this;
            this.mBannerListener = listener;
            this.mBannerInner = listener == null ? new BannerInner(context, width, height, invh, null) : new BannerInner(context, width, height, invh, this.mBannerInnerListener);
        }

        private void loadBanner() {
            if (this.mBannerInner != null) {
                this.mBannerInner.load();
            }
        }

        private void addBannerViewTo(ViewGroup targetView) {
            if (this.mBannerInner != null) {
                this.mBannerInner.addBannerViewTo(targetView);
            }
        }

        private void setBannerListener(MFXBannerListener listener) {
            if (this.mBannerInner != null) {
                this.mBannerListener = listener;
                if (listener == null) {
                    this.mBannerInner.setListener(null);
                } else {
                    this.mBannerInner.setListener(this.mBannerInnerListener);
                }
            }
        }

        private void setBannerRefresh(int intervalInSeconds) {
            if (this.mBannerInner != null && (intervalInSeconds == 0 || intervalInSeconds >= 10)) {
                this.mBannerInner.setAppRefreshRate(intervalInSeconds);
            }
        }

        private void releaseBanner() {
            if (this.mBannerInner != null && mControllerEngine != null) {
                mControllerEngine.releaseBanner(this.mBannerInner.getGuid());
            }
        }

        private void setBannerFloorPrice(float floorPrice) {
            if (this.mBannerInner != null) {
                this.mBannerInner.setBannerFloorPrice(floorPrice);
            }
        }

        private void setBannerAdapterName(String adapterName) {
            if (this.mBannerInner != null) {
                this.mBannerInner.setBannerAdapterName(adapterName);
            }
        }
    }

    public static interface MFXNativeListener {
        public void onNativeLoaded(MFXNative var1);

        public void onNativeImagesReady(MFXNative var1);

        public void onNativeLoadFailed(MFXNative var1, String var2);

        public void onNativeClicked(MFXNative var1);
    }

    public static interface MFXInterstitialListener {
        public void onInterstitialLoadFailed(MFXInterstitial var1, String var2);

        public void onInterstitialLoaded(MFXInterstitial var1);

        public void onInterstitialShown(MFXInterstitial var1);

        public void onInterstitialClosed(MFXInterstitial var1);

        public void onInterstitialFinished(MFXInterstitial var1);

        public void onInterstitialClicked(MFXInterstitial var1, String var2);
    }

    public static interface MFXBannerListener {
        public void onBannerLoadFailed(MFXBanner var1, String var2);

        public void onBannerLoaded(MFXBanner var1);

        public void onBannerShown(MFXBanner var1);

        public void onBannerClosed(MFXBanner var1);

        public void onBannerFinished(MFXBanner var1);

        public void onBannerClicked(MFXBanner var1, String var2);
    }

    public static interface OnLoadSdkCallback {
        public void onLoadResult(String var1);
    }
}

