/*
 * Decompiled with CFR 0.152.
 */
package com.mobfox.android.Ads;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.view.View;
import com.mobfox.android.MobfoxSDK;
import com.mobfox.android.core.DLog;
import com.mobfox.android.core.InAppBrowser;
import com.mobfox.android.core.MFXStorage;
import com.mobfox.android.core.MFXUtils;
import com.mobfox.android.core.MobfoxSettings;
import com.mobfox.android.core.javascriptengine.ControllerEngine;
import com.mobfox.android.core.logging.MobFoxReport;
import com.mobfox.android.core.logging.ReportsQueueManager;
import com.mobfox.android.core.networking.AsyncCallback;
import com.mobfox.android.core.networking.AsyncCallbackBitmap;
import com.mobfox.android.core.networking.MobFoxRequest;
import com.mobfox.android.core.utils.MobFoxRunnable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class NativeInner {
    private NativeInnerListener mNativeInnerListener = null;
    private String mGuid = null;
    private String mInvh = null;
    private Double mCPM = null;
    private Context mContext = null;
    private NativeInner self;
    private ArrayList<MobfoxSDK.MFXNative.Tracker> mTrackerList;
    private ArrayList<MobfoxSDK.MFXNative.Tracker> mClickTrackerList;
    private HashMap<String, String> mTexts;
    private HashMap<String, String> mImageURLs;
    private HashMap<String, Bitmap> mImageBitmaps;
    private String mLink;
    private static String userAgent = null;
    private String mAdContext;
    private String mAdType;
    private boolean mIconRequired;
    private int mIconSize;
    private boolean mMainRequired;
    private int mMainWidth;
    private int mMainHeight;
    private boolean mTitleRequired;
    private int mTitlelength;
    private boolean mDescRequired;
    private int mDescLength;
    private float mFloorPrice = -1.0f;
    private String mAdapterName = "core";
    private Handler mainHandler;
    private NativeInnerListener emptyListener = new NativeInnerListener(){

        @Override
        public void onNativeLoaded(NativeInner aNative, Map<String, String> textItems) {
        }

        @Override
        public void onNativeImagesReady(NativeInner aNative, Map<String, String> textItems, Map<String, Bitmap> imageItems) {
        }

        @Override
        public void onNativeLoadFailed(NativeInner aNative, String code) {
        }

        @Override
        public void onNativeClicked(NativeInner aNative) {
        }
    };
    private int imagesLoaded = 0;
    private int imagedFailed = 0;
    private ImagesLoadedInnerListener listener;

    public NativeInner(Context context) {
        if (!MobfoxSDK.isInitialized()) {
            this.mContext = null;
            return;
        }
        this.mContext = context;
        this.mAdContext = "content";
        this.mAdType = "atomic";
        this.mIconRequired = true;
        this.mIconSize = 80;
        this.mMainRequired = true;
        this.mMainWidth = 1200;
        this.mMainHeight = 627;
        this.mTitleRequired = true;
        this.mTitlelength = 100;
        this.mDescRequired = true;
        this.mDescLength = 200;
        this.mAdapterName = "core";
        this.mGuid = UUID.randomUUID().toString();
        ControllerEngine.addNativeToMap(this);
        MobFoxReport.register(context);
        ReportsQueueManager.getInstance().addEventLog("Native constructor(1)", "native", ReportsQueueManager.getLineNumber());
        NativeInner.determineUserAgent(context);
        this.mainHandler = new Handler(context.getMainLooper());
        this.self = this;
        this.mNativeInnerListener = this.emptyListener;
        this.mTrackerList = new ArrayList();
        this.mClickTrackerList = new ArrayList();
        this.mTexts = new HashMap();
        this.mImageURLs = new HashMap();
        this.mImageBitmaps = new HashMap();
    }

    public void callToActionClicked() {
        this.handleClickOnNative();
    }

    public void setNativeAdContext(MobfoxSDK.MFXNative.NativeAdContext contextEnum) {
        switch (contextEnum) {
            case CONTENT: {
                this.mAdContext = "content";
                break;
            }
            case SOCIAL: {
                this.mAdContext = "social";
                break;
            }
            case PRODUCT: {
                this.mAdContext = "product";
            }
        }
    }

    public void setNativeAdPlacementType(MobfoxSDK.MFXNative.NativeAdPlacementType typeEnum) {
        switch (typeEnum) {
            case IN_FEED: {
                this.mAdContext = "in_feed";
                break;
            }
            case ATOMIC: {
                this.mAdContext = "atomic";
                break;
            }
            case OUTSIDE: {
                this.mAdContext = "outside";
                break;
            }
            case RECOMMENDATION: {
                this.mAdContext = "recommendation";
            }
        }
    }

    public void setNativeAdIconImage(boolean bRequired, int size) {
        this.mIconRequired = bRequired;
        this.mIconSize = size;
    }

    public void setNativeAdMainImage(boolean bRequired, int width, int height) {
        this.mMainRequired = bRequired;
        this.mMainWidth = width;
        this.mMainHeight = height;
    }

    public void setNativeAdTitle(boolean bRequired, int length) {
        this.mTitleRequired = bRequired;
        this.mTitlelength = length;
    }

    public void setNativeAdDesc(boolean bRequired, int length) {
        this.mDescRequired = bRequired;
        this.mDescLength = length;
    }

    public void setListener(NativeInnerListener nativeListener) {
        this.mNativeInnerListener = nativeListener != null ? nativeListener : this.emptyListener;
    }

    public void setInvh(String invh) {
        this.mInvh = invh;
    }

    public void load(String invh) {
        this.mInvh = invh;
        this.load();
    }

    public void load() {
        if (!MFXUtils.isConnected(this.mContext)) {
            if (this.mNativeInnerListener != null) {
                DLog.release("MobfoxSDK", "dbg: >>>> ### onNativeLoadFailed(No internet connection) ###");
                this.mNativeInnerListener.onNativeLoadFailed(null, "No internet connection");
            }
            return;
        }
        if (!MobfoxSDK.isInitialized()) {
            if (this.mNativeInnerListener != null) {
                DLog.release("MobfoxSDK", "dbg: >>>> ### onNativeLoadFailed(Mobfox SDK not initialized) ###");
                this.mNativeInnerListener.onNativeLoadFailed(null, "Mobfox SDK not initialized");
            }
            return;
        }
        this.loadWhenReady();
    }

    private void loadWhenReady() {
        MobfoxSDK.sharedInstance(this.mContext).performSdkLoadWithCompletion(this.mContext, "NativeLoad", new MobfoxSDK.OnLoadSdkCallback(){

            @Override
            public void onLoadResult(String error) {
                if (error != null) {
                    DLog.d("MobfoxSDK", "dbg: ### native load when ready error: " + error);
                } else {
                    DLog.d("MobfoxSDK", "dbg: ### native load when ready ###");
                }
                if (error != null) {
                    if (NativeInner.this.mNativeInnerListener != null) {
                        NativeInner.this.mNativeInnerListener.onNativeLoadFailed(null, error);
                    }
                    return;
                }
                NativeInner.this.mainHandler.postDelayed((Runnable)new MobFoxRunnable(NativeInner.this.mContext){

                    @Override
                    public void mobFoxRun() {
                        DLog.release("MobfoxSDK", "dbg: ### Init loading native... ###");
                        MobfoxSettings.getInstance(NativeInner.this.mContext).getAndDvId(NativeInner.this.mContext, true, new MobfoxSettings.Listener(){

                            @Override
                            public void onFinish(String and_id, boolean do_not_track) {
                                DLog.release("MobfoxSDK", "dbg: ### Loading native ###");
                                NativeInner.this.ReallyLoad();
                            }
                        });
                    }
                }, 200L);
            }
        });
    }

    private void ReallyLoad() {
        ReportsQueueManager.getInstance().initAnalyticsSession(this.mContext, this.mInvh, "native");
        MFXStorage.sharedInstance(this.mContext).setBasicParams(this.mContext, this.mAdapterName);
        MFXStorage.sharedInstance(this.mContext).setLocationParams(this.mContext);
        this.mCPM = null;
        MFXStorage.sharedInstance(this.mContext).setGDPRParams(this.mContext);
        JSONObject jsParams = new JSONObject();
        try {
            jsParams.put("guid", (Object)this.mGuid);
            jsParams.put("invh", (Object)this.mInvh);
            jsParams.put("n_context", (Object)this.mAdContext);
            jsParams.put("n_plcmttype", (Object)this.mAdType);
            jsParams.put("n_img_icon_req", (Object)(this.mIconRequired ? "1" : "0"));
            jsParams.put("n_img_icon_size", this.mIconSize);
            jsParams.put("n_img_large_req", (Object)(this.mMainRequired ? "1" : "0"));
            jsParams.put("n_img_large_w", this.mMainWidth);
            jsParams.put("n_img_large_h", this.mMainHeight);
            jsParams.put("n_title_req", (Object)(this.mTitleRequired ? "1" : "0"));
            jsParams.put("n_title_len", this.mTitlelength);
            jsParams.put("n_desc_req", (Object)(this.mDescRequired ? "1" : "0"));
            jsParams.put("n_desc_len", this.mDescLength);
            if (this.mFloorPrice >= 0.0f) {
                jsParams.put("r_floor", (double)this.mFloorPrice);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        ControllerEngine.getInstance().callNativeLoad(this.mContext, this, jsParams, this.mNativeInnerListener);
    }

    public void registerViewForInteraction(Context c, View layout) {
        if (layout != null) {
            layout.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    NativeInner.this.handleClickOnNative();
                }
            });
        }
    }

    private void handleClickOnNative() {
        try {
            String click_url;
            List<MobfoxSDK.MFXNative.Tracker> clickTrackerList = this.getClickTrackerList();
            if (clickTrackerList != null) {
                for (MobfoxSDK.MFXNative.Tracker t : clickTrackerList) {
                    MobFoxRequest req = new MobFoxRequest(t.getUrl());
                    req.get(null);
                }
            }
            if ((click_url = this.self.getLink()) != null) {
                InAppBrowser.OpenBrowserWithURL(this.mContext, click_url, this.mInvh);
            }
            ControllerEngine.callControllerFunc(this.mContext, this.mGuid, "NativeListener.Click");
        }
        catch (Throwable e) {
            DLog.d("MobfoxSDK", "browser activity failed");
        }
    }

    public void handleAdResponse(String adResponse) {
        String error;
        NativeInner self;
        block21: {
            self = this;
            error = null;
            try {
                JSONArray assets;
                JSONArray imptrackers;
                MobfoxSDK.MFXNative.Tracker tracker3;
                int i;
                JSONObject aNative;
                String x_pricing_cpm;
                JSONObject jsonResponse = new JSONObject(adResponse);
                error = MFXUtils.getStringFromDict(jsonResponse, "error");
                if (error.length() != 0) break block21;
                JSONObject headers = MFXUtils.getDictFromDict(jsonResponse, "headers");
                if (headers != null && headers.length() > 0 && headers.has(x_pricing_cpm = MFXUtils.validateName(headers, "X-Pricing-CPM"))) {
                    this.mCPM = headers.getDouble(x_pricing_cpm);
                }
                if ((aNative = MFXUtils.getDictFromDict(jsonResponse, "native")) == null) break block21;
                JSONObject link = MFXUtils.getDictFromDict(aNative, "link");
                if (link != null) {
                    this.mLink = MFXUtils.getStringFromDict(link, "url");
                    JSONArray clicktrackers = MFXUtils.getArrayFromDict(link, "clicktrackers");
                    for (i = 0; i < clicktrackers.length(); ++i) {
                        try {
                            tracker3 = new MobfoxSDK.MFXNative.Tracker("type_click", clicktrackers.getString(i));
                            this.mClickTrackerList.add(tracker3);
                            continue;
                        }
                        catch (JSONException tracker2) {
                            // empty catch block
                        }
                    }
                }
                if ((imptrackers = MFXUtils.getArrayFromDict(aNative, "imptrackers")) != null) {
                    for (i = 0; i < imptrackers.length(); ++i) {
                        try {
                            tracker3 = new MobfoxSDK.MFXNative.Tracker("type_imp", imptrackers.getString(i));
                            this.mTrackerList.add(tracker3);
                            continue;
                        }
                        catch (JSONException tracker3) {
                            // empty catch block
                        }
                    }
                }
                if ((assets = MFXUtils.getArrayFromDict(aNative, "assets")) == null) break block21;
                this.mTexts.clear();
                this.mImageURLs.clear();
                this.mImageBitmaps.clear();
                for (int i2 = 0; i2 < assets.length(); ++i2) {
                    JSONObject asset = assets.getJSONObject(i2);
                    String type = null;
                    if (asset.has("type")) {
                        type = asset.getString("type");
                    } else {
                        JSONObject ext = MFXUtils.getDictFromDict(asset, "ext");
                        if (ext != null) {
                            type = MFXUtils.getStringFromDict(ext, "type");
                        }
                    }
                    if (type == null || type.length() == 0) continue;
                    if (type.equals("icon") || type.equals("main")) {
                        try {
                            String url = asset.getJSONObject("img").getString("url");
                            this.mImageURLs.put(type, url);
                        }
                        catch (JSONException url) {
                            // empty catch block
                        }
                    }
                    if (!type.equals("title") && !type.equals("desc") && !type.equals("rating") && !type.equals("ctatext") && !type.equals("sponsored")) continue;
                    try {
                        String value = type.equals("title") ? asset.getJSONObject("title").getString("text") : asset.getJSONObject("data").getString("value");
                        this.mTexts.put(type, value);
                        continue;
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                }
            }
            catch (JSONException e) {
                error = e.getMessage();
            }
        }
        final String theError = error;
        if (this.mNativeInnerListener != null) {
            this.mainHandler.post((Runnable)new MobFoxRunnable(this.mContext){

                @Override
                public void mobFoxRun() {
                    if (theError != null && theError.length() > 0) {
                        DLog.release("MobfoxSDK", "dbg: >>>> ### onNativeLoadFailed(" + theError + ") ###");
                        NativeInner.this.mNativeInnerListener.onNativeLoadFailed(self, theError);
                    } else {
                        DLog.release("MobfoxSDK", "dbg: >>>> ### onNativeLoaded() ###");
                        NativeInner.this.mNativeInnerListener.onNativeLoaded(self, NativeInner.this.mTexts);
                        NativeInner.this.fireTrackers(NativeInner.this.mContext);
                    }
                }
            });
        }
    }

    private void fireTrackers(Context c) {
        final CountDownLatch trackersLeft = new CountDownLatch(this.mTrackerList.size());
        for (final MobfoxSDK.MFXNative.Tracker t : this.mTrackerList) {
            MobFoxRequest req = new MobFoxRequest(t.getUrl());
            req.get(new AsyncCallback(){

                @Override
                public void onComplete(int code, Object response, Map<String, List<String>> headers) {
                    DLog.d("MobfoxSDK", "fired tracker: " + t.getUrl());
                    trackersLeft.countDown();
                }

                @Override
                public void onError(Exception e) {
                    trackersLeft.countDown();
                }
            });
        }
    }

    public void loadImages() {
        this.loadImages(this.mContext, new ImagesLoadedInnerListener(){

            @Override
            public void onImagesLoaded(NativeInner ad) {
                NativeInner.this.mNativeInnerListener.onNativeImagesReady(NativeInner.this.self, NativeInner.this.mTexts, NativeInner.this.mImageBitmaps);
            }
        });
    }

    private void checkImagesDone() {
        if (this.imagesLoaded + this.imagedFailed == this.mImageURLs.size()) {
            this.listener.onImagesLoaded(this);
        }
    }

    public void loadImages(Context c, ImagesLoadedInnerListener listener) {
        this.listener = listener;
        if (this.mImageURLs.size() == 0) {
            return;
        }
        for (final Map.Entry<String, String> entry : this.mImageURLs.entrySet()) {
            MobFoxRequest req = new MobFoxRequest(entry.getValue());
            req.getBitmap(new AsyncCallbackBitmap(){

                @Override
                public void onComplete(int code, Bitmap bitmap, Map<String, List<String>> headers) {
                    NativeInner.this.mImageBitmaps.put(entry.getKey(), bitmap);
                    NativeInner.this.imagesLoaded++;
                    NativeInner.this.checkImagesDone();
                }

                @Override
                public void onError(Exception e) {
                    DLog.d("MobfoxSDK", "load bitmap failed");
                    NativeInner.this.imagedFailed++;
                    NativeInner.this.checkImagesDone();
                }
            });
        }
    }

    public void setNativeFloorPrice(float floorPrice) {
        this.mFloorPrice = floorPrice;
    }

    public void setNativeAdapterName(String adapterName) {
        this.mAdapterName = adapterName;
    }

    private static synchronized void determineUserAgent(Context ctx) {
        if (userAgent == null) {
            try {
                userAgent = MobFoxReport.getUserAgent(ctx);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getGuid() {
        return this.mGuid;
    }

    public String getInvh() {
        return this.mInvh;
    }

    public NativeInnerListener getListener() {
        return this.mNativeInnerListener;
    }

    public List<MobfoxSDK.MFXNative.Tracker> getTrackerList() {
        return this.mTrackerList;
    }

    public List<MobfoxSDK.MFXNative.Tracker> getClickTrackerList() {
        return this.mClickTrackerList;
    }

    public String getLink() {
        return this.mLink;
    }

    public Map<String, String> getTexts() {
        return this.mTexts;
    }

    public Map<String, String> getImageUrls() {
        return this.mImageURLs;
    }

    public Map<String, Bitmap> getImageBitmaps() {
        return this.mImageBitmaps;
    }

    public static interface ImagesLoadedInnerListener {
        public void onImagesLoaded(NativeInner var1);
    }

    public static enum NativeAdPlacementType {
        IN_FEED,
        ATOMIC,
        OUTSIDE,
        RECOMMENDATION;

    }

    public static enum NativeAdContext {
        CONTENT,
        SOCIAL,
        PRODUCT;

    }

    public static interface NativeInnerListener {
        public void onNativeLoaded(NativeInner var1, Map<String, String> var2);

        public void onNativeImagesReady(NativeInner var1, Map<String, String> var2, Map<String, Bitmap> var3);

        public void onNativeLoadFailed(NativeInner var1, String var2);

        public void onNativeClicked(NativeInner var1);
    }
}

