/*
 * Decompiled with CFR 0.152.
 */
package com.mobfox.android.dmp.utils;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import com.mobfox.android.core.DLog;
import com.mobfox.android.core.MFXConfiguration;
import com.mobfox.android.core.MobfoxSettings;
import com.mobfox.android.core.networking.AsyncCallback;
import com.mobfox.android.core.networking.MobFoxRequest;
import com.mobfox.android.dmp.Bundle;
import com.mobfox.android.dmp.DMPManager;
import com.mobfox.android.dmp.Decoder.BASE64Decoder;
import com.mobfox.android.dmp.Decoder.BASE64Encoder;
import com.mobfox.android.dmp.services.MobFoxService;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class DMPUtils {
    public static final String NEW_LINE = "\n";
    public static final String FILE_SEPARATOR = "\t";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(Context c, String name) {
        BufferedReader bufReader = null;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String line;
            FileInputStream fis = c.openFileInput(name);
            bufReader = new BufferedReader(new InputStreamReader(fis));
            String ls = System.getProperty("line.separator");
            while ((line = bufReader.readLine()) != null) {
                stringBuilder.append(line);
                if (!bufReader.ready()) continue;
                stringBuilder.append(ls);
            }
        }
        catch (Throwable t) {
            String string = null;
            return string;
        }
        finally {
            try {
                if (bufReader != null) {
                    bufReader.close();
                }
            }
            catch (IOException e) {
                return null;
            }
        }
        if (stringBuilder.toString().length() == 0) {
            return null;
        }
        return stringBuilder.toString();
    }

    public static void write(Context c, String name, String data) {
        DMPUtils.write(c, name, data, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(Context c, String name, String data, int mode) {
        BufferedWriter bufWriter = null;
        try {
            FileOutputStream fos = c.openFileOutput(name, mode);
            bufWriter = new BufferedWriter(new OutputStreamWriter(fos));
            bufWriter.write(data);
            bufWriter.flush();
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                if (bufWriter != null) {
                    bufWriter.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static String encodeXor(String s, String k) {
        BASE64Encoder enc = new BASE64Encoder();
        String result = null;
        try {
            byte[] out = DMPUtils.xorWithKey(s.getBytes(), k.getBytes());
            result = enc.encode(out).replaceAll("\\s", "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static byte[] xorWithKey(byte[] a, byte[] key) {
        byte[] out = new byte[a.length];
        for (int i = 0; i < a.length; ++i) {
            out[i] = (byte)(a[i] ^ key[i % key.length]);
        }
        return out;
    }

    public static String decodeXor(String s) {
        return DMPUtils.decodeXor(s, Bundle.KEY);
    }

    public static String decodeXor(String s, String key) {
        BASE64Decoder d = new BASE64Decoder();
        String result = null;
        try {
            byte[] encoded = d.decodeBuffer(s);
            byte[] out = DMPUtils.xorWithKey(encoded, key.getBytes());
            result = new String(out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void postDMPFromDMP(Context context) {
        try {
            DMPManager.updateDMP(context);
            DMPManager.postDMP(context, new DMPManager.DMPCallback(){

                @Override
                public void onPostCompleted() {
                    DLog.d("MobfoxSDK", "dmp post completed");
                }

                @Override
                public void onPostError() {
                    DLog.d("MobfoxSDK", "dmp post failed");
                }
            });
        }
        catch (Throwable e) {
            DLog.d("MobfoxSDK", "post dmp exception");
        }
    }

    public static void startMobFoxServiceFromDMP(Context context, boolean sendFirstTimeImmediately) {
        try {
            if (MobfoxSettings.getInstance(context).getAnalyticsPrefReportDMPEvents(context)) {
                MobFoxService.setSendFirstTimeImmediately(sendFirstTimeImmediately);
            }
            if (MFXConfiguration.sharedInstance(context).needToStartDMP(context)) {
                Intent service = new Intent(context, MobFoxService.class);
                context.startService(service);
            }
            DMPUtils.reportMobFoxConversion(context, MobfoxSettings.getInstance(context).get_oAndadvid());
        }
        catch (Exception e) {
            DLog.d("MobfoxSDK", "start uam exception");
        }
    }

    public static void stopMobFoxServiceFromDMP(Context context) {
        try {
            Intent service = new Intent(context, MobFoxService.class);
            context.stopService(service);
        }
        catch (Exception e) {
            DLog.d("MobfoxSDK", "start uam exception");
        }
    }

    public static boolean reportMobFoxConversion(Context context, String androidId) {
        if (androidId == null || androidId.isEmpty()) {
            return false;
        }
        SharedPreferences shared = PreferenceManager.getDefaultSharedPreferences((Context)context);
        boolean reportSent = shared.getBoolean("reportSent", false);
        if (!reportSent) {
            DLog.d("report", "first time: try to send reporting parameter");
            DMPUtils.sendMobFoxConversionReport(context, androidId);
            return true;
        }
        return false;
    }

    private static void sendMobFoxConversionReport(final Context context, String androidId) {
        MobFoxRequest req = new MobFoxRequest("https://tracker.mtrtb.com/tracker/mobfox_conversion");
        req.setParam("os", "android");
        req.setParam("bundle", DMPUtils.getBundleId(context));
        req.setParam("ifa", androidId);
        req.get(new AsyncCallback(){

            @Override
            public void onComplete(int code, Object response, Map<String, List<String>> headers) {
                DMPUtils.setMobFoxConversionReported(context);
            }

            @Override
            public void onError(Exception e) {
            }
        });
    }

    static void setMobFoxConversionReported(Context context) {
        SharedPreferences shared = PreferenceManager.getDefaultSharedPreferences((Context)context);
        SharedPreferences.Editor editor = shared.edit();
        editor.putBoolean("reportSent", true);
        editor.apply();
    }

    public static String getBundleId(Context context) {
        String bundle_id = "";
        try {
            bundle_id = context.getPackageName();
        }
        catch (Throwable e) {
            DLog.d("MobfoxSDK", "bundle error");
        }
        return bundle_id;
    }

    public static String getIPAddress(boolean useIPv4) {
        try {
            ArrayList<NetworkInterface> interfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface intf : interfaces) {
                ArrayList<InetAddress> addrs = Collections.list(intf.getInetAddresses());
                for (InetAddress addr : addrs) {
                    boolean isIPv4;
                    if (addr.isLoopbackAddress()) continue;
                    String sAddr = addr.getHostAddress();
                    boolean bl = isIPv4 = sAddr.indexOf(58) < 0;
                    if (useIPv4) {
                        if (!isIPv4) continue;
                        return sAddr;
                    }
                    if (isIPv4) continue;
                    int delim = sAddr.indexOf(37);
                    return delim < 0 ? sAddr.toUpperCase() : sAddr.substring(0, delim).toUpperCase();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "";
    }
}

