/*
 * Decompiled with CFR 0.152.
 */
package com.mobfox.android.dmp.services;

import android.content.BroadcastReceiver;
import android.content.Context;
import com.mobfox.android.core.DLog;
import com.mobfox.android.core.MobfoxSettings;
import com.mobfox.android.core.networking.AsyncCallback;
import com.mobfox.android.core.services.MobFoxLocationService;
import com.mobfox.android.dmp.BroadcastRecivers.BaseReceiver;
import com.mobfox.android.dmp.BroadcastRecivers.ScreenReceiver;
import com.mobfox.android.dmp.Process.BaseProcess;
import com.mobfox.android.dmp.Process.BatteryProcess;
import com.mobfox.android.dmp.Process.DeviceInfoProcess;
import com.mobfox.android.dmp.Process.ListScanProcess;
import com.mobfox.android.dmp.Process.RunningAppsProcess;
import com.mobfox.android.dmp.Process.WifiInfoProcess;
import com.mobfox.android.dmp.services.ServerSenderService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

class WorkerThread
extends Thread {
    private static final String TAG = "WorkerThread";
    private static final int INTERVAL_TIME_TO_SEND = 1800000;
    private static final int INTERVAL_TIME_TO_SEND_FIRST_TIME = 180000;
    private static int firstTimeInterval = 180000;
    private static int normalTimeInterval = 1800000;
    private Context context;
    private String andrId;
    private static long mLastSentTime = 0L;
    private static long mTimeInterval = 0L;
    private ArrayList<BaseProcess> requestedProcesses;
    private ArrayList<BaseReceiver> requestedReceiver;
    ListScanProcess connectionAndLocation;

    WorkerThread(Context c, boolean sendFirstTimeImmediately) {
        super(TAG);
        this.context = c.getApplicationContext();
        if (sendFirstTimeImmediately) {
            firstTimeInterval = 200;
        }
        mTimeInterval = normalTimeInterval;
        mLastSentTime = System.currentTimeMillis();
        this.requestedProcesses = new ArrayList();
        this.requestedReceiver = new ArrayList();
        this.andrId = "";
        this.getAndAdvId();
        this.intProcess();
    }

    @Override
    public void run() {
        try {
            this.startDataCollection();
            try {
                Thread.sleep(firstTimeInterval);
            }
            catch (InterruptedException e) {
                DLog.d("Error", e.getLocalizedMessage());
            }
            this.sendDMPDataToServer(this.context);
            while (!this.isInterrupted()) {
                if (this.isTimeToSend()) {
                    this.sendDMPDataToServer(this.context);
                    this.incTime();
                }
                try {
                    Thread.sleep(normalTimeInterval);
                }
                catch (InterruptedException e) {
                    DLog.d("Error", e.getLocalizedMessage());
                }
            }
            this.shoutDownDataCollection();
        }
        catch (Exception e) {
            this.shoutDownDataCollection();
            DLog.d(TAG, "Error in data thread " + e.getLocalizedMessage());
        }
        catch (Throwable t) {
            this.shoutDownDataCollection();
            DLog.d(TAG, "Error in data thread " + t.getLocalizedMessage());
        }
    }

    void startThread() {
        if (this.getState() == Thread.State.NEW) {
            this.start();
        }
    }

    void interruptThread() {
        this.interrupt();
    }

    private boolean isTimeToSend() {
        return mLastSentTime + mTimeInterval < System.currentTimeMillis();
    }

    private void incTime() {
        mLastSentTime = System.currentTimeMillis();
    }

    private void intProcess() {
        BatteryProcess batteryProcess = new BatteryProcess(this.context);
        WifiInfoProcess wifiProcess = new WifiInfoProcess(this.context);
        RunningAppsProcess appUsage = new RunningAppsProcess(this.context);
        batteryProcess.setDuration(1800000L);
        wifiProcess.setDuration(1800000L);
        appUsage.setDuration(60000L);
        this.requestedProcesses.add(batteryProcess);
        this.requestedProcesses.add(wifiProcess);
        ScreenReceiver screenReceiver = new ScreenReceiver();
        this.requestedReceiver.add(screenReceiver);
        this.connectionAndLocation = new ListScanProcess(this.context);
        this.connectionAndLocation.setDuration(1200000L);
        MobFoxLocationService.getInstance().initManager(this.context);
    }

    private void startDataCollection() {
        this.registerReceivers();
        this.startProcesses();
        this.startServices();
    }

    void shoutDownDataCollection() {
        try {
            this.sendDMPDataToServer(this.context);
            this.unregisterReceivers();
            this.stopProcesses();
            this.stopServices();
        }
        catch (Exception e) {
            DLog.d(TAG, "Error in shout down" + e.getLocalizedMessage());
        }
    }

    private void registerReceivers() {
        try {
            if (this.requestedReceiver != null && this.requestedReceiver.size() > 0) {
                for (int i = 0; i < this.requestedReceiver.size(); ++i) {
                    if (!this.requestedReceiver.get(i).hasPermissions()) continue;
                    this.requestedReceiver.get(i).initReceiver();
                    this.context.registerReceiver((BroadcastReceiver)this.requestedReceiver.get(i), this.requestedReceiver.get(i).getIntentFilter());
                }
            }
        }
        catch (Exception e) {
            DLog.d(TAG, "Error in registerReceivers " + e.getLocalizedMessage());
        }
    }

    private void unregisterReceivers() {
        try {
            if (this.requestedReceiver != null && this.requestedReceiver.size() > 0) {
                for (int i = 0; i < this.requestedReceiver.size(); ++i) {
                    if (this.requestedReceiver.get(i) == null || !this.requestedReceiver.get(i).hasPermissions()) continue;
                    this.context.unregisterReceiver((BroadcastReceiver)this.requestedReceiver.get(i));
                }
            }
        }
        catch (Exception e) {
            DLog.d(TAG, "Error in unregisterReceivers " + e.getLocalizedMessage());
        }
    }

    private void startProcesses() {
        for (int i = 0; i < this.requestedProcesses.size(); ++i) {
            if (this.requestedProcesses.get(i) == null || this.requestedProcesses.get(i).isAlive()) continue;
            this.requestedProcesses.get(i).start();
        }
        if (this.connectionAndLocation != null && this.connectionAndLocation.hasPermissions() && !this.connectionAndLocation.isAlive()) {
            this.connectionAndLocation.start();
        }
    }

    private void stopProcesses() {
        for (int i = 0; this.requestedProcesses != null && i < this.requestedProcesses.size(); ++i) {
            if (this.requestedProcesses.get(i) == null || !this.requestedProcesses.get(i).isAlive()) continue;
            this.requestedProcesses.get(i).interrupt();
        }
        if (this.connectionAndLocation != null && this.connectionAndLocation.isAlive()) {
            this.connectionAndLocation.interrupt();
        }
    }

    private void startServices() {
        if (MobFoxLocationService.getInstance() != null && MobFoxLocationService.getInstance().hasPermission(this.context)) {
            MobFoxLocationService.getInstance().requestPassiveLocation(this.context);
        }
    }

    private void stopServices() {
        if (MobFoxLocationService.getInstance() != null && MobFoxLocationService.getInstance().hasPermission(this.context)) {
            MobFoxLocationService.getInstance().stopLocationUpdates();
        }
    }

    private void sendDMPDataToServer(Context ctx) {
        if (!MobfoxSettings.getInstance(this.context).getAnalyticsPrefReportDMPEvents(this.context)) {
            this.emptyData();
            return;
        }
        try {
            DLog.d(TAG, "workerThread: sendDMPDataToServer");
            ServerSenderService.sendDmp(ctx, this.andrId, this.getData(), new AsyncCallback(){

                @Override
                public void onComplete(int code, Object response, Map<String, List<String>> headers) {
                    DLog.d(WorkerThread.TAG, "workerThread: onComplete");
                    WorkerThread.this.emptyData();
                }

                @Override
                public void onError(Exception e) {
                    DLog.d(WorkerThread.TAG, "workerThread: onError" + e.getLocalizedMessage());
                    WorkerThread.this.emptyData();
                }
            });
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void getAndAdvId() {
        MobfoxSettings.getInstance(this.context).getAndDvId(this.context, true, new MobfoxSettings.Listener(){

            @Override
            public void onFinish(String o_andadvid, boolean do_not_track) {
                if (o_andadvid != null) {
                    WorkerThread.this.andrId = o_andadvid;
                }
            }
        });
    }

    private JSONObject getData() throws JSONException {
        int i;
        JSONObject data = new JSONObject();
        for (i = 0; i < this.requestedProcesses.size(); ++i) {
            if (this.requestedProcesses.get(i) == null || !this.requestedProcesses.get(i).hasData()) continue;
            data.put(this.requestedProcesses.get(i).getDataId(), (Object)this.requestedProcesses.get(i).getDataArray());
        }
        for (i = 0; i < this.requestedReceiver.size(); ++i) {
            if (this.requestedReceiver.get(i) == null || !this.requestedReceiver.get(i).hasData()) continue;
            data.put(this.requestedReceiver.get(i).getDataId(), (Object)this.requestedReceiver.get(i).getDataArray());
        }
        if (MobFoxLocationService.getInstance() != null && MobFoxLocationService.getInstance().hasData()) {
            data.put(MobFoxLocationService.getInstance().getDataId(), (Object)MobFoxLocationService.getInstance().getDataArray());
        }
        if (this.connectionAndLocation.hasData()) {
            data.put(this.connectionAndLocation.getDataId(), (Object)this.connectionAndLocation.getDataArray());
        }
        if (this.connectionAndLocation.hasLocationData()) {
            data.put(this.connectionAndLocation.getLocationId(), (Object)this.connectionAndLocation.getLocationData());
        }
        if (!data.toString().equals("{}")) {
            DeviceInfoProcess deviceInfo = new DeviceInfoProcess(this.context);
            data.put(deviceInfo.getDataId(), (Object)deviceInfo.getDeviceInfo());
        }
        return data;
    }

    private void emptyData() {
        int i;
        for (i = 0; i < this.requestedProcesses.size(); ++i) {
            this.requestedProcesses.get(i).emptyData();
        }
        for (i = 0; i < this.requestedReceiver.size(); ++i) {
            this.requestedReceiver.get(i).emptyData();
        }
        this.connectionAndLocation.emptyData();
        this.connectionAndLocation.emptyLocationData();
        MobFoxLocationService.getInstance().emptyData();
    }
}

