/*
 * Decompiled with CFR 0.152.
 */
package com.mobfox.android.dmp.services;

import android.content.Context;
import com.mobfox.android.core.DLog;
import com.mobfox.android.core.MFXConfiguration;
import com.mobfox.android.core.networking.AsyncCallback;
import com.mobfox.android.core.networking.MobFoxRequest;
import com.mobfox.android.core.utils.DateAndTimeUtils;
import com.mobfox.android.dmp.utils.DMPUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ServerSenderService {
    private static final String TAG = "ServerSenderService";
    private static final String KEY = "Q29g>24UcxCv!u(x2ROwgDx4euflG8sKn0iWsW3{6imocswrG)4T><OAN17Wf8PTo6HR7ABvB8lOPH(XET@?uCjz}WTZwEqH";

    static void sendDmp(Context ctx, String id2, JSONObject data, AsyncCallback callback) throws JSONException {
        if (id2 == null || data == null) {
            return;
        }
        JSONObject main = new JSONObject();
        main.put("IDFA", (Object)id2);
        main.put("DATA", (Object)data);
        main.put("JSNVER", 1.006);
        main.put("UOFFST", DateAndTimeUtils.getOffset());
        if (!data.toString().equals("{}")) {
            String xorData = DMPUtils.encodeXor(main.toString(), KEY);
            JSONArray u = ServerSenderService.getBundle(xorData);
            if (u == null || u.toString() != null && u.toString().equals("")) {
                return;
            }
            ServerSenderService.sendToServer(ctx, u, callback);
        } else {
            DLog.d(TAG, "No data " + data.toString());
        }
    }

    private static void sendToServer(Context ctx, Object data, AsyncCallback callback) {
        String url = MFXConfiguration.sharedInstance(ctx).getUrlDMP(ctx);
        MobFoxRequest req = new MobFoxRequest(url);
        req.setTestMode(true);
        req.setData(data);
        req.setHeader("Content-Length", String.valueOf(data.toString().length()));
        req.setHeader("Content-type", "application/json");
        req.post(callback);
    }

    private static JSONArray getBundle(String xorData) {
        JSONObject updateObj = new JSONObject();
        JSONArray array = new JSONArray();
        try {
            updateObj.put("body", (Object)xorData);
            array.put((Object)updateObj);
        }
        catch (JSONException e) {
            return null;
        }
        return array;
    }
}

