/*
 * Decompiled with CFR 0.152.
 */
package com.mobfox.android.dmp.Process;

import android.content.Context;
import android.os.Build;
import com.mobfox.android.core.DLog;
import com.mobfox.android.dmp.SyncJsonArray;
import org.json.JSONArray;

public abstract class BaseProcess
extends Thread {
    static final String TAG = "BaseProcess";
    static final long DEFAULT_DURATION = 30000L;
    Context context;
    SyncJsonArray dataArray = new SyncJsonArray();
    String dataName;
    long duration;
    static boolean permitted = true;
    static boolean enabled = true;

    public BaseProcess(Context context, String name, String dataId) {
        super(name);
        this.dataName = dataId;
        this.context = context.getApplicationContext();
        this.duration = 30000L;
    }

    @Override
    public void run() {
        try {
            this.updatePermissions();
            while (permitted && enabled) {
                this.collectData();
                BaseProcess.sleep(this.getDuration());
            }
        }
        catch (Exception err) {
            DLog.d(TAG, "mobFoxRunnable " + this.dataName + " err: " + err.toString());
        }
        catch (Throwable t) {
            DLog.d(TAG, "mobFoxRunnable err " + this.dataName + " err: " + t.toString());
        }
    }

    public String getDataId() {
        return this.dataName;
    }

    public JSONArray getDataArray() {
        return this.dataArray.getDataArray();
    }

    public boolean hasData() {
        return this.dataArray != null && this.dataArray.hasData();
    }

    public void emptyData() {
        try {
            if (Build.VERSION.SDK_INT >= 19) {
                this.dataArray.emptyData();
            }
        }
        catch (Exception e) {
            DLog.d(TAG, "error in emptying data " + e.toString());
        }
        if (this.dataArray.length() > 0) {
            this.dataArray = new SyncJsonArray();
        }
    }

    public void setDuration(long d) {
        this.duration = d;
    }

    public long getDuration() {
        return this.duration;
    }

    protected abstract void collectData();

    public abstract void updatePermissions();
}

