/*
 * Decompiled with CFR 0.152.
 */
package com.mobfox.android.dmp.BroadcastRecivers;

import android.content.Context;
import android.content.Intent;
import android.net.NetworkInfo;
import androidx.core.content.ContextCompat;
import com.mobfox.android.core.DLog;
import com.mobfox.android.core.utils.DateAndTimeUtils;
import com.mobfox.android.dmp.BroadcastRecivers.BaseReceiver;
import org.json.JSONException;
import org.json.JSONObject;

public class WifiChangedReceiver
extends BaseReceiver {
    static final String TAG = "WifiChangedReceiver";
    static final String JSON_ID = "Connt";
    private Context context;

    public WifiChangedReceiver(Context c) {
        super(JSON_ID);
        this.context = c.getApplicationContext();
    }

    @Override
    public void onActionReceived(Context context, Intent intent) {
        NetworkInfo info = (NetworkInfo)intent.getParcelableExtra("networkInfo");
        if (info == null) {
            return;
        }
        try {
            JSONObject json = new JSONObject();
            json.put("uTm", (Object)DateAndTimeUtils.getTimeFormat());
            json.put("state", (Object)info.getState().toString());
            json.put("info", (Object)info.getExtraInfo());
            json.put("IStr", (Object)info.toString());
            this.dataArray.put(json);
        }
        catch (JSONException e) {
            DLog.d(TAG, "Error : " + e.getLocalizedMessage());
        }
    }

    @Override
    public void initReceiver() {
    }

    @Override
    void fillActions() {
        this.intentActions.add("android.net.wifi.STATE_CHANGE");
    }

    @Override
    public boolean hasPermissions() {
        return ContextCompat.checkSelfPermission((Context)this.context, (String)"android.permission.ACCESS_NETWORK_STATE") == 0;
    }
}

