/*
 * Decompiled with CFR 0.152.
 */
package com.mobfox.android.dmp.BroadcastRecivers;

import android.app.KeyguardManager;
import android.content.Context;
import android.content.Intent;
import com.mobfox.android.core.DLog;
import com.mobfox.android.core.utils.DateAndTimeUtils;
import com.mobfox.android.dmp.BroadcastRecivers.BaseReceiver;
import org.json.JSONException;
import org.json.JSONObject;

public class ScreenReceiver
extends BaseReceiver {
    static final String TAG = "ScreenReceiver";
    static final String JSON_ID = "Scr";

    public ScreenReceiver() {
        super(JSON_ID);
    }

    @Override
    public void onActionReceived(Context context, Intent intent) {
        String strAction = intent.getAction();
        KeyguardManager myKM = (KeyguardManager)context.getSystemService("keyguard");
        if (strAction.equals("android.intent.action.SCREEN_OFF") || strAction.equals("android.intent.action.SCREEN_ON")) {
            try {
                JSONObject json = new JSONObject();
                if (strAction.equals("android.intent.action.SCREEN_OFF")) {
                    json.put("scr", (Object)"off");
                } else if (strAction.equals("android.intent.action.SCREEN_ON")) {
                    json.put("scr", (Object)"on");
                }
                json.put("lock", myKM.inKeyguardRestrictedInputMode());
                json.put("uTm", (Object)DateAndTimeUtils.getTimeFormat());
                this.dataArray.put(json);
            }
            catch (JSONException e) {
                DLog.d(TAG, "Error: " + e.getLocalizedMessage());
            }
        }
    }

    @Override
    public void initReceiver() {
    }

    @Override
    void fillActions() {
        this.intentActions.add("android.intent.action.SCREEN_ON");
        this.intentActions.add("android.intent.action.SCREEN_OFF");
        this.intentActions.add("android.intent.action.USER_PRESENT");
    }

    @Override
    public boolean hasPermissions() {
        return true;
    }
}

