/*
 * Decompiled with CFR 0.152.
 */
package com.mobfox.android.dmp.BroadcastRecivers;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import com.mobfox.android.core.DLog;
import com.mobfox.android.dmp.SyncJsonArray;
import java.util.ArrayList;
import org.json.JSONArray;

public abstract class BaseReceiver
extends BroadcastReceiver {
    final String TAG = "BaseReceiver";
    SyncJsonArray dataArray = new SyncJsonArray();
    String dataName;
    long lastTime;
    ArrayList<String> intentActions;

    BaseReceiver(String dataId) {
        this.dataName = dataId;
        this.intentActions = new ArrayList();
        this.lastTime = 0L;
        this.fillActions();
    }

    public abstract void initReceiver();

    public void onReceive(Context context, Intent intent) {
        try {
            if (this.lastTime == 0L || this.notTooOften()) {
                this.onActionReceived(context, intent);
                this.lastTime = System.currentTimeMillis();
            }
        }
        catch (Exception err) {
            DLog.e("MobfoxSDK", "mobFoxReceiver err " + err.toString());
        }
        catch (Throwable t) {
            DLog.e("MobfoxSDK", "mobFoxReceiver throwable " + t.toString());
        }
    }

    private boolean notTooOften() {
        long newTime = System.currentTimeMillis();
        return newTime - this.lastTime > 60000L;
    }

    public String getDataId() {
        return this.dataName;
    }

    public JSONArray getDataArray() {
        return this.dataArray.getDataArray();
    }

    public boolean hasData() {
        return this.dataArray != null && this.dataArray.hasData();
    }

    public void emptyData() {
        try {
            if (Build.VERSION.SDK_INT >= 19) {
                this.dataArray.emptyData();
            }
        }
        catch (Exception e) {
            DLog.e("MobfoxSDK", "error in emptying data " + e.toString());
        }
        if (this.dataArray.length() > 0) {
            this.dataArray = new SyncJsonArray();
        }
    }

    public IntentFilter getIntentFilter() {
        IntentFilter filter = new IntentFilter();
        for (int i = 0; i < this.intentActions.size(); ++i) {
            filter.addAction(this.intentActions.get(i));
        }
        return filter;
    }

    abstract void fillActions();

    public abstract boolean hasPermissions();

    abstract void onActionReceived(Context var1, Intent var2);
}

