/*
 * Decompiled with CFR 0.152.
 */
package com.mobfox.android.core.utils;

import android.graphics.Point;
import java.util.ArrayList;
import java.util.List;

public class SizeUtils {
    public static final int DEFAULT_BANNER_WIDTH = 320;
    public static final int DEFAULT_BANNER_HEIGHT = 50;
    public static final int DEFAULT_INTERSTITIAL_WIDTH = 320;
    public static final int DEFAULT_INTERSTITIAL_HEIGHT = 480;
    private static final float MAX_DISTANCE = 1.5f;

    public static List<Point> SIZES() {
        ArrayList<Point> points = new ArrayList<Point>();
        points.add(new Point(300, 50));
        points.add(new Point(320, 50));
        points.add(new Point(300, 250));
        points.add(new Point(320, 480));
        points.add(new Point(480, 320));
        points.add(new Point(728, 90));
        points.add(new Point(90, 728));
        points.add(new Point(600, 1024));
        points.add(new Point(1024, 600));
        points.add(new Point(768, 1024));
        points.add(new Point(1024, 768));
        return points;
    }

    public static List<Point> INTER_SIZES() {
        ArrayList<Point> points = new ArrayList<Point>();
        points.add(new Point(320, 480));
        points.add(new Point(480, 320));
        points.add(new Point(600, 1024));
        points.add(new Point(1024, 600));
        points.add(new Point(768, 1024));
        points.add(new Point(1024, 768));
        return points;
    }

    public static Point getNearestFitSupported(Point point, boolean isInterstitial) {
        Point winner = SizeUtils.getNearestSupported(point, isInterstitial);
        if (SizeUtils.isTooFarOff(point, winner)) {
            winner = point;
        }
        return winner;
    }

    public static Point getNearestSupported(Point point, boolean isInterstitial) {
        if (isInterstitial) {
            return SizeUtils.getNearest(point, SizeUtils.INTER_SIZES());
        }
        return SizeUtils.getNearest(point, SizeUtils.SIZES());
    }

    public static Point getNearest(Point point, List<Point> points) {
        double minDist = -1.0;
        Point min = null;
        for (Point thisPoint : points) {
            double dist = SizeUtils.calcDist(point, thisPoint);
            if (minDist != -1.0 && (!(dist < minDist) || !SizeUtils.isLarger(point, thisPoint))) continue;
            minDist = dist;
            min = thisPoint;
        }
        return min;
    }

    public static double calcDist(Point point1, Point point2) {
        return Math.pow(point1.x - point2.x, 2.0) + Math.pow(point1.y - point2.y, 2.0);
    }

    public static boolean isLarger(Point point, Point nearPoint) {
        return point.x >= nearPoint.x && point.y >= nearPoint.y;
    }

    private static boolean isTooFarOff(Point point, Point winner) {
        if (!SizeUtils.isLarger(point, winner)) {
            return true;
        }
        float distX = point.x / winner.x;
        float distY = point.y / winner.y;
        return distX > 1.5f || distY > 1.5f;
    }
}

