/*
 * Decompiled with CFR 0.152.
 */
package com.mobfox.android.core.services;

import android.content.Context;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.Looper;
import androidx.core.content.ContextCompat;
import com.mobfox.android.core.DLog;
import com.mobfox.android.core.services.SyncJsonArray;
import com.mobfox.android.core.utils.DateAndTimeUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MobFoxLocationService
implements LocationListener {
    private LocationManager locationManager;
    private static final int LOCATION_INTERVAL = 60000;
    private static final float LOCATION_DISTANCE = 100.0f;
    static SyncJsonArray dataArray;
    private static final String TAG = "MobFoxLocationService";
    private static final String JSON_ID = "LocEv";
    private static MobFoxLocationService instance;

    private MobFoxLocationService() {
        dataArray = new SyncJsonArray();
    }

    public static MobFoxLocationService getInstance() {
        if (instance == null) {
            instance = new MobFoxLocationService();
        }
        return instance;
    }

    public void initManager(Context context) {
        try {
            if (this.locationManager != null) {
                return;
            }
            if (ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_FINE_LOCATION") == 0 || ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_COARSE_LOCATION") == 0) {
                this.locationManager = (LocationManager)context.getSystemService("location");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean hasPermission(Context context) {
        return ContextCompat.checkSelfPermission((Context)context.getApplicationContext(), (String)"android.permission.ACCESS_COARSE_LOCATION") == 0 || ContextCompat.checkSelfPermission((Context)context.getApplicationContext(), (String)"android.permission.ACCESS_FINE_LOCATION") == 0;
    }

    public void requestPassiveLocation(Context c) {
        Context context = c.getApplicationContext();
        this.initManager(context);
        if (this.locationManager == null) {
            return;
        }
        if (ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_FINE_LOCATION") == 0) {
            this.locationManager.requestLocationUpdates("passive", 60000L, 100.0f, (LocationListener)this, Looper.getMainLooper());
        }
    }

    public void onLocationChanged(Location location) {
        try {
            JSONObject data;
            if (location != null && (data = this.locationInJson(location)) != null && !data.toString().equals("{}")) {
                dataArray.put(data);
            }
        }
        catch (Exception e) {
            DLog.e(TAG, "onLocationChanged exception " + e.getLocalizedMessage());
        }
        catch (Throwable t) {
            DLog.e(TAG, "onLocationChanged throwable " + t.getLocalizedMessage());
        }
    }

    public void onStatusChanged(String s, int i, Bundle bundle) {
    }

    public void onProviderEnabled(String s) {
    }

    public void onProviderDisabled(String s) {
    }

    public void stopLocationUpdates() {
        if (this.locationManager != null) {
            this.locationManager.removeUpdates((LocationListener)this);
        }
    }

    public String getDataId() {
        return JSON_ID;
    }

    public JSONArray getDataArray() {
        return dataArray.getDataArray();
    }

    public boolean hasData() {
        return dataArray != null && dataArray.hasData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void emptyData() {
        SyncJsonArray syncJsonArray = dataArray;
        synchronized (syncJsonArray) {
            dataArray = new SyncJsonArray();
        }
    }

    public JSONObject getLastLocationJson(Context context) {
        Location location = this.getLocation(context);
        JSONObject result = this.locationInJson(location);
        return result;
    }

    private JSONObject locationInJson(Location location) {
        JSONObject data = new JSONObject();
        try {
            data.put("lat", location.getLatitude());
            data.put("lon", location.getLongitude());
            data.put("hAcc", (double)location.getAccuracy());
            data.put("alt", location.getAltitude());
            data.put("pro", (Object)location.getProvider());
            data.put("spd", (double)location.getSpeed());
            data.put("uTm", (Object)DateAndTimeUtils.getTimeFormat());
            data.put("lTm", (Object)DateAndTimeUtils.getTimeFormat(location.getTime()));
            if (location.hasBearing()) {
                data.put("dirc", (double)location.getBearing());
            }
        }
        catch (JSONException e) {
            DLog.d("", "Error in location data: " + e.getLocalizedMessage());
        }
        return data;
    }

    public Location getLocation(Context context) {
        Location location = null;
        try {
            this.initManager(context.getApplicationContext());
            if (this.locationManager == null) {
                return null;
            }
            boolean isGPSEnabled = this.locationManager.isProviderEnabled("gps");
            boolean isNetworkEnabled = this.locationManager.isProviderEnabled("network");
            if (!isGPSEnabled && !isNetworkEnabled) {
                return null;
            }
            if (isGPSEnabled && this.locationManager != null) {
                location = this.locationManager.getLastKnownLocation("gps");
            }
            if (isNetworkEnabled && location == null && this.locationManager != null) {
                location = this.locationManager.getLastKnownLocation("network");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return location;
    }
}

