/*
 * Decompiled with CFR 0.152.
 */
package com.mobfox.android.core.networking;

import com.android.volley.Cache;
import com.android.volley.NetworkResponse;
import com.android.volley.ParseError;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.HttpHeaderParser;
import com.android.volley.toolbox.StringRequest;
import com.mobfox.android.core.networking.NetworkRequestManager;
import java.io.UnsupportedEncodingException;
import java.util.Map;

public class StringRequestWithHeaders
extends StringRequest {
    Listener listener;
    private Map<String, String> responseHeaders;

    public StringRequestWithHeaders(int method, String url, Listener listener, Response.ErrorListener errorListener) {
        super(method, url, null, errorListener);
        this.listener = listener;
    }

    protected Response<String> parseNetworkResponse(NetworkResponse response) {
        Cache.Entry cacheEntry = NetworkRequestManager.HandleCachingInRequest(response);
        try {
            String str = new String(response.data, HttpHeaderParser.parseCharset((Map)response.headers, (String)"UTF-8"));
            this.responseHeaders = response.headers;
            return Response.success((Object)str, (Cache.Entry)cacheEntry);
        }
        catch (UnsupportedEncodingException e) {
            return Response.error((VolleyError)new ParseError((Throwable)e));
        }
    }

    protected void deliverResponse(String response) {
        this.listener.onResponse(response, this.responseHeaders);
    }

    public static interface Listener {
        public void onResponse(String var1, Map<String, String> var2);
    }
}

