/*
 * Decompiled with CFR 0.152.
 */
package com.mobfox.android.core.networking;

import android.content.Context;
import com.android.volley.Cache;
import com.android.volley.Header;
import com.android.volley.NetworkResponse;
import com.android.volley.ParseError;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.HttpHeaderParser;
import com.android.volley.toolbox.JsonObjectRequest;
import com.android.volley.toolbox.StringRequest;
import com.android.volley.toolbox.Volley;
import com.mobfox.android.core.DLog;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class NetworkRequestManager {
    private Context context;

    public NetworkRequestManager(Context cont) {
        this.context = cont;
    }

    public void sendStringRequest(String url, int method, Response.Listener<String> successListener, Response.ErrorListener errorListener) {
        RequestQueue queue = Volley.newRequestQueue((Context)this.context);
        StringRequest stringRequest = new StringRequest(method, url, successListener, errorListener);
        queue.add((Request)stringRequest);
    }

    public void sendJsonRequest(String url, int method, JSONObject request, Response.Listener<JSONObject> successListener, Response.ErrorListener errorListener) {
        RequestQueue queue = Volley.newRequestQueue((Context)this.context);
        MetaRequest requestWithHeaders = new MetaRequest(method, url, request, successListener, errorListener);
        queue.add((Request)requestWithHeaders);
    }

    private int getMethodFromString(String method) {
        if (method != null && method.toLowerCase().equals("post")) {
            return 1;
        }
        return 0;
    }

    public static Cache.Entry HandleCachingInRequest(NetworkResponse in_response) {
        Cache.Entry cacheEntry = HttpHeaderParser.parseCacheHeaders((NetworkResponse)in_response);
        if (cacheEntry == null) {
            cacheEntry = new Cache.Entry();
        }
        boolean bForceNoCache = false;
        long age = 0L;
        List allHeaders = in_response.allHeaders;
        int tot = allHeaders.size();
        for (int i = 0; i < tot; ++i) {
            String maxAgeString;
            int index;
            int indexOfMaxAge;
            Header rec = (Header)allHeaders.get(i);
            if (!rec.getName().equalsIgnoreCase("Cache-Control")) continue;
            String value = rec.getValue();
            if ((value = value.toLowerCase()).contains("no-cache") || value.contains("no-store") || value.contains("must-revalidate")) {
                bForceNoCache = true;
            }
            if ((indexOfMaxAge = value.indexOf("max-age")) == -1 || (index = (maxAgeString = value.substring(indexOfMaxAge)).indexOf("=")) <= 0) continue;
            String szAge = maxAgeString.substring(index + 1);
            age = Long.parseLong(szAge) * 1000L;
        }
        if (bForceNoCache) {
            age = 0L;
        }
        DLog.d("MobFoxAnalytics", "dbg: ### age is " + age);
        long now = System.currentTimeMillis();
        cacheEntry.softTtl = now + age;
        cacheEntry.ttl = now + age;
        cacheEntry.data = in_response.data;
        String headerValue = (String)in_response.headers.get("Date");
        if (headerValue != null) {
            cacheEntry.serverDate = HttpHeaderParser.parseDateAsEpoch((String)headerValue);
        }
        if ((headerValue = (String)in_response.headers.get("Last-Modified")) != null) {
            cacheEntry.lastModified = HttpHeaderParser.parseDateAsEpoch((String)headerValue);
        }
        cacheEntry.responseHeaders = in_response.headers;
        return cacheEntry;
    }

    private class MetaRequest
    extends JsonObjectRequest {
        MetaRequest(int method, String url, JSONObject jsonRequest, Response.Listener<JSONObject> listener, Response.ErrorListener errorListener) {
            super(method, url, jsonRequest, listener, errorListener);
        }

        protected Response<JSONObject> parseNetworkResponse(NetworkResponse response) {
            Cache.Entry cacheEntry = NetworkRequestManager.HandleCachingInRequest(response);
            try {
                String jsonString = new String(response.data, HttpHeaderParser.parseCharset((Map)response.headers, (String)"utf-8"));
                JSONObject jsonResponse = new JSONObject(jsonString);
                jsonResponse.put("headers", (Object)new JSONObject(response.headers));
                return Response.success((Object)jsonResponse, (Cache.Entry)cacheEntry);
            }
            catch (UnsupportedEncodingException e) {
                return Response.error((VolleyError)new ParseError((Throwable)e));
            }
            catch (JSONException je) {
                return Response.error((VolleyError)new ParseError((Throwable)je));
            }
        }
    }
}

