/*
 * Decompiled with CFR 0.152.
 */
package com.mobfox.android.core.networking;

import com.android.volley.Cache;
import com.android.volley.NetworkResponse;
import com.android.volley.ParseError;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.HttpHeaderParser;
import com.android.volley.toolbox.StringRequest;
import com.mobfox.android.core.DLog;
import com.mobfox.android.core.networking.NetworkRequestManager;
import java.util.Map;
import org.json.JSONObject;

public class MetaRequest
extends StringRequest {
    public MetaRequest(int method, String url, Response.Listener<String> listener, Response.ErrorListener errorListener) {
        super(method, url, listener, errorListener);
    }

    protected Response<String> parseNetworkResponse(NetworkResponse response) {
        Cache.Entry cacheEntry = NetworkRequestManager.HandleCachingInRequest(response);
        JSONObject jsonResponse = null;
        try {
            String jsonString = new String(response.data, HttpHeaderParser.parseCharset((Map)response.headers, (String)"utf-8"));
            if (response != null && response.headers != null && response.headers.containsKey("X-Android-Sent-Millis") && response.headers.containsKey("X-Android-Received-Millis")) {
                long timeSent = Long.parseLong((String)response.headers.get("X-Android-Sent-Millis"));
                long timeReceived = Long.parseLong((String)response.headers.get("X-Android-Received-Millis"));
                long timeSpent = timeReceived - timeSent;
                DLog.v("MobfoxSDK", "dbg: ###");
                DLog.v("MobfoxSDK", "dbg: ### Request handled in " + timeSpent + " mSec ###");
                DLog.v("MobfoxSDK", "dbg: ###");
            }
            jsonResponse = new JSONObject(jsonString);
            jsonResponse.put("headers", (Object)new JSONObject(response.headers));
        }
        catch (Exception e) {
            return Response.error((VolleyError)new ParseError((Throwable)e));
        }
        return Response.success((Object)jsonResponse.toString(), (Cache.Entry)cacheEntry);
    }
}

