/*
 * Decompiled with CFR 0.152.
 */
package com.mobfox.android.core.logging;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteBlobTooBigException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.mobfox.android.core.DLog;
import com.mobfox.android.core.logging.sReportsFlatItem;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ReportsQueueDB {
    public static final String REPORT_GROUP_CRASH = "crash";
    public static final String REPORT_GROUP_BANNER = "banner";
    public static final String REPORT_GROUP_INTERSTITIAL = "interstitial";
    public static final String KEY_SESSION_GUID = "report_session_GUID";
    public static final String KEY_SESSION_START_TIME = "report_session_START_TIME";
    public static final String KEY_SESSION_UTC = "report_session_UTC";
    public static final String KEY_SESSION_APP_ID = "report_session_APP_ID";
    public static final String KEY_SESSION_APP_NAME = "report_session_APP_NAME";
    public static final String KEY_SESSION_APP_VER = "report_session_APP_VER";
    public static final String KEY_SESSION_SDK_VER = "report_session_SDK_VER";
    public static final String KEY_SESSION_UA = "report_session_UA";
    public static final String KEY_SESSION_PLATFORM = "report_session_PLATFORM";
    public static final String KEY_LOGS_ARRAY = "logs_array";
    public static final String KEY_CRASHES_ARRAY = "crashes_array";
    public static final String KEY_ROWID = "_id";
    private DatabaseHelper dbHelper;
    private SQLiteDatabase db;
    private Context mCtx = null;
    private static final String DATABASE_NAME = "reports12_db";
    private static final String DATABASE_TABLE = "reports12_queue";
    private static final int DATABASE_VERSION = 1;
    private static final String DATABASE_CREATE = "create table reports12_queue (_id integer primary key autoincrement, report_session_GUID text not null,report_session_START_TIME text not null,report_session_UTC long,report_session_APP_ID text not null,report_session_APP_NAME text not null,report_session_APP_VER text not null,report_session_SDK_VER text not null,report_session_UA text not null,report_session_PLATFORM text not null,logs_array text not null,crashes_array text not null);";

    public ReportsQueueDB(Context ctx) {
        this.mCtx = ctx;
    }

    public ReportsQueueDB open() throws Exception {
        if (this.mCtx == null) {
            return null;
        }
        try {
            this.dbHelper = new DatabaseHelper(this.mCtx);
            this.db = this.dbHelper.getWritableDatabase();
            return this;
        }
        catch (SQLException sqlE) {
            if (sqlE != null && sqlE.getMessage() != null) {
                DLog.v("ReportsQueueDB.Open", sqlE.getMessage());
            }
            throw new Exception("Unable to open reports DB");
        }
    }

    public void close() {
        if (this.dbHelper != null) {
            this.dbHelper.close();
        }
    }

    public long createReportItem(sReportsFlatItem rec) {
        rec.validate();
        ContentValues vals = new ContentValues();
        vals.put(KEY_SESSION_GUID, rec.sessionGUID);
        vals.put(KEY_SESSION_START_TIME, rec.sessionStartTime);
        vals.put(KEY_SESSION_UTC, Long.valueOf(rec.sessionUTC));
        vals.put(KEY_SESSION_APP_ID, rec.sessionAppID);
        vals.put(KEY_SESSION_APP_NAME, rec.sessionAppName);
        vals.put(KEY_SESSION_APP_VER, rec.sessionAppVer);
        vals.put(KEY_SESSION_SDK_VER, rec.sessionSdkVer);
        vals.put(KEY_SESSION_UA, rec.sessionUserAgent);
        vals.put(KEY_SESSION_PLATFORM, rec.sessionPlatform);
        vals.put(KEY_LOGS_ARRAY, rec.jsonArrayLogs);
        vals.put(KEY_CRASHES_ARRAY, rec.jsonArrayCrashes);
        return this.db.insert(DATABASE_TABLE, null, vals);
    }

    public boolean deleteMessageItem(long rowId) {
        return this.db.delete(DATABASE_TABLE, "_id=" + rowId, null) > 0;
    }

    public boolean deleteAllReports() {
        return this.db.delete(DATABASE_TABLE, null, null) > 0;
    }

    public Cursor fetchAllReportItems() {
        try {
            return this.db.query(DATABASE_TABLE, new String[]{KEY_SESSION_GUID, KEY_SESSION_START_TIME, KEY_SESSION_UTC, KEY_SESSION_APP_ID, KEY_SESSION_APP_NAME, KEY_SESSION_APP_VER, KEY_SESSION_SDK_VER, KEY_SESSION_UA, KEY_SESSION_PLATFORM, KEY_LOGS_ARRAY, KEY_CRASHES_ARRAY, KEY_ROWID}, null, null, null, null, null, null);
        }
        catch (Exception e) {
            String tt = e.getMessage();
            return null;
        }
    }

    public static int TryGetCount(Cursor cur) {
        try {
            return cur.getCount();
        }
        catch (SQLiteBlobTooBigException tbe) {
            DLog.e("MobfoxSDK", "SQL blob too big error (get count)");
            return 0;
        }
    }

    public static boolean TryMoveToFirst(Cursor cur) {
        try {
            return cur.moveToFirst();
        }
        catch (SQLiteBlobTooBigException tbe) {
            DLog.e("MobfoxSDK", "SQL blob too big error (move to first)");
            return false;
        }
    }

    public static boolean TryMoveToNext(Cursor cur) {
        try {
            return cur.moveToNext();
        }
        catch (SQLiteBlobTooBigException tbe) {
            DLog.e("MobfoxSDK", "SQL blob too big error (move to next)");
            return false;
        }
    }

    public boolean addLogItemToMessage(long rowId, JSONObject logItem) {
        boolean bRes = false;
        Cursor ret = this.db.query(DATABASE_TABLE, new String[]{KEY_LOGS_ARRAY, KEY_ROWID}, "_id=" + rowId, null, null, null, null, null);
        if (ret != null) {
            if (ReportsQueueDB.TryGetCount(ret) > 0 && ReportsQueueDB.TryMoveToFirst(ret)) {
                String logsArrayString = ret.getString(ret.getColumnIndex(KEY_LOGS_ARRAY));
                if (logsArrayString == null) {
                    logsArrayString = "[]";
                }
                try {
                    JSONArray old = new JSONArray(logsArrayString);
                    if (old != null) {
                        old.put((Object)logItem);
                        ContentValues vals = new ContentValues();
                        vals.put(KEY_LOGS_ARRAY, old.toString());
                        if (this.db.update(DATABASE_TABLE, vals, "_id=" + rowId, null) > 0) {
                            bRes = true;
                        }
                    }
                }
                catch (SQLiteBlobTooBigException tbe) {
                    DLog.e("MobfoxSDK", "SQL blob too big error (update)");
                    ret.close();
                    ret = null;
                }
                catch (JSONException e) {
                    ret.close();
                    ret = null;
                }
                catch (Exception ee) {
                    ret.close();
                    ret = null;
                }
            }
            if (ret != null) {
                ret.close();
            }
        }
        return bRes;
    }

    public boolean addCrashItemToMessage(long rowId, JSONObject crashItem) throws Exception {
        boolean bRes = false;
        Cursor ret = this.db.query(DATABASE_TABLE, new String[]{KEY_CRASHES_ARRAY, KEY_ROWID}, "_id=" + rowId, null, null, null, null, null);
        if (ret != null) {
            if (ReportsQueueDB.TryGetCount(ret) > 0 && ReportsQueueDB.TryMoveToFirst(ret)) {
                String crashesArrayString = ret.getString(ret.getColumnIndex(KEY_CRASHES_ARRAY));
                if (crashesArrayString == null) {
                    crashesArrayString = "[]";
                }
                try {
                    JSONArray old = new JSONArray(crashesArrayString);
                    if (old != null) {
                        old.put((Object)crashItem);
                        ContentValues vals = new ContentValues();
                        vals.put(KEY_CRASHES_ARRAY, old.toString());
                        if (this.db.update(DATABASE_TABLE, vals, "_id=" + rowId, null) > 0) {
                            bRes = true;
                        }
                    }
                }
                catch (SQLiteBlobTooBigException tbe) {
                    DLog.e("MobfoxSDK", "SQL blob too big error (update)");
                    ret.close();
                    ret = null;
                }
                catch (JSONException e) {
                    ret.close();
                    ret = null;
                }
                catch (Exception ee) {
                    ret.close();
                    ret = null;
                }
            }
            if (ret != null) {
                ret.close();
            }
        }
        return bRes;
    }

    private static class DatabaseHelper
    extends SQLiteOpenHelper {
        DatabaseHelper(Context ctx) {
            super(ctx, ReportsQueueDB.DATABASE_NAME, null, 1);
        }

        public void onCreate(SQLiteDatabase db) {
            db.execSQL(ReportsQueueDB.DATABASE_CREATE);
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            db.execSQL("DROP IF TABLE EXISTS reports12_db");
            this.onCreate(db);
        }
    }
}

