/*
 * Decompiled with CFR 0.152.
 */
package com.mobfox.android.core.logging;

import android.content.Context;
import com.mobfox.android.core.logging.MobFoxReport;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONObject;

public class RemoteLogger {
    private static JSONObject getJSON(Context context, String invh, String short_message, String facility, String extraData) {
        return RemoteLogger.getJSON(context, invh, short_message, facility, extraData, null);
    }

    private static JSONObject getJSON(Context context, String invh, String short_message, String facility, String extraData, Exception err) {
        try {
            JSONObject json = new JSONObject();
            json.put("ua", (Object)MobFoxReport.getUserAgent(context));
            json.put("id", (Object)UUID.randomUUID().toString());
            json.put("host", (Object)context.getPackageName());
            if (err == null) {
                json.put("core", (Object)"Core_4.3.2");
            } else {
                StackTraceElement[] elements;
                json.put("error", (Object)err.toString());
                JSONArray stack = new JSONArray();
                for (StackTraceElement ste : elements = err.getStackTrace()) {
                    String s = ste.getClassName() + ", " + ste.getFileName() + ":" + ste.getLineNumber() + " >> " + ste.getMethodName() + "()";
                    stack.put((Object)s);
                }
                json.put("core", (Object)stack);
            }
            json.put("invh", (Object)invh);
            json.put("message", (Object)short_message);
            json.put("facility", (Object)facility);
            json.put("extra", (Object)extraData);
            json.put("platform", (Object)"android");
            return json;
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static enum Message {
        NO_FILL,
        LOADED,
        ERROR,
        REQUEST,
        REQUEST_INTERSTITIAL,
        NO_FILL_INTERSTITIAL,
        LOADED_INTERSTITIAL,
        ERROR_INTERSTITIAL,
        SHOWN_INTERSTITIAL;

    }
}

