/*
 * Decompiled with CFR 0.152.
 */
package com.mobfox.android.core.javascriptengine;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Base64;
import android.webkit.ValueCallback;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.android.volley.Cache;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.NetworkResponse;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.RetryPolicy;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.HttpHeaderParser;
import com.android.volley.toolbox.RequestFuture;
import com.android.volley.toolbox.StringRequest;
import com.android.volley.toolbox.Volley;
import com.mobfox.android.JSInterface.LocalStorageAPI;
import com.mobfox.android.JSInterface.NetworkingAPI;
import com.mobfox.android.core.DLog;
import com.mobfox.android.core.MFXUtils;
import com.mobfox.android.core.networking.MetaRequest;
import com.mobfox.android.core.networking.NetworkRequestManager;
import com.mobfox.android.core.networking.StringRequestWithHeaders;
import com.mobfox.android.core.utils.MobFoxRunnable;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import org.json.JSONException;
import org.json.JSONObject;

public class JavascriptEngine {
    private Map<String, String> responseMap = new HashMap<String, String>();
    private static RequestQueue mRequestQueue;
    protected final Handler mainHandler;
    RetryPolicy policy;
    private WebView webView;
    private Context mContext;
    OnReadyCallback readyCB;
    boolean ready;
    private String requireCode = "if(typeof(mobfoxCBMap)===\"undefined\") mobfoxCBMap = {};\n\ngetCallbackId = function(callback){\n  var key = \"\";\n  var possible = \"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789\";\n\n  for (var i = 0; i < 16; i++)\n    key += possible.charAt(Math.floor(Math.random() * possible.length));\n\n  mobfoxCBMap[key] = callback;\n  return key;\n};\n\nrequire = function(str){eval(Android.require(str))};\nrequestJSON = function(url, params, method,callback){\n    Android.requestJSON(url,params,method,callback);\n};\nrequest = function(url, params, method, callback){\n    Android.request(url,params,method,callback);\n};\nMFTimeout = function(callback,timeout){\n    Android.MFTimeout(getCallbackId(callback),timeout);\n};";

    public JavascriptEngine(Context ctx, String htmlToLoad, OnReadyCallback cb) throws JavascriptEngineInitException {
        this.mContext = ctx.getApplicationContext();
        this.readyCB = cb;
        this.ready = false;
        this.mainHandler = new Handler(this.mContext.getMainLooper());
        try {
            this.webView = new WebView(this.mContext);
        }
        catch (Throwable t) {
            throw new JavascriptEngineInitException("unable to init js engine, webview engine probably too old");
        }
        if (Build.VERSION.SDK_INT >= 19) {
            WebView.setWebContentsDebuggingEnabled((boolean)true);
        }
        this.webView.getSettings().setJavaScriptEnabled(true);
        this.webView.getSettings().setAppCacheEnabled(true);
        this.webView.getSettings().setDomStorageEnabled(true);
        if (Build.VERSION.SDK_INT >= 21) {
            this.webView.getSettings().setMixedContentMode(0);
        }
        if (Build.VERSION.SDK_INT >= 19) {
            this.webView.getSettings().setMediaPlaybackRequiresUserGesture(false);
        }
        this.webView.addJavascriptInterface((Object)new NetworkingAPI(ctx, this), "Android");
        this.webView.addJavascriptInterface((Object)new LocalStorageAPI(), "mfLocalStorage");
        String loadHtml = "<html><body></body></html";
        if (htmlToLoad != null) {
            loadHtml = htmlToLoad;
        }
        final JavascriptEngine self = this;
        this.webView.setWebViewClient(new WebViewClient(){

            public void onPageFinished(WebView view, String url) {
                if (self.ready) {
                    return;
                }
                DLog.d("MobfoxSDK", "dbg: ### Controller READY! ###");
                self.ready = true;
                if (JavascriptEngine.this.readyCB != null) {
                    JavascriptEngine.this.readyCB.onReady(self);
                }
            }
        });
        this.mainHandler.postDelayed((Runnable)new MobFoxRunnable(this.mContext){

            @Override
            public void mobFoxRun() {
                if (self.ready) {
                    return;
                }
                DLog.d("MobfoxSDK", "dbg: ### Controller READY(1)! ###");
                self.ready = true;
                JavascriptEngine.this.readyCB.onReady(self);
            }
        }, 3000L);
        this.policy = new DefaultRetryPolicy(5000, 1, 1.0f);
        String unencodedHtml = loadHtml;
        String encodedHtml = Base64.encodeToString((byte[])unencodedHtml.getBytes(), (int)1);
        this.webView.loadData(encodedHtml, "text/html", "base64");
    }

    public String require(String sourceURL) {
        RequestQueue queue = this.getRequestQueue();
        RequestFuture future = RequestFuture.newFuture();
        StringRequest request = new StringRequest(0, sourceURL, (Response.Listener)future, (Response.ErrorListener)future);
        request.setRetryPolicy(this.policy);
        queue.add((Request)request);
        String response = "";
        try {
            response = (String)future.get();
        }
        catch (Throwable t) {
            DLog.e("MobfoxSDK", "JS require failed" + t.getMessage());
        }
        return response;
    }

    public String getResponse(String key) {
        return this.responseMap.get(key);
    }

    public void request(String url, String params, String method, final String cb_id) {
        StringRequestWithHeaders req;
        DLog.v("MobfoxSDK", "dbg: ### CONTROLLER calls request(" + cb_id + ") ###");
        DLog.release("MobfoxSDK", "dbg: ###");
        DLog.release("MobfoxSDK", "dbg: ### CONTROLLER calls request(" + url + ", " + method + ") ###");
        DLog.release("MobfoxSDK", "dbg: ###");
        RequestQueue queue = this.getRequestQueue();
        if (method != null && method.equalsIgnoreCase("POST")) {
            final Map<String, String> postParamsMap = this.getPostParamsMap(params);
            if (postParamsMap == null) {
                this.callCallback(cb_id, this.jsString(String.format("Error: Unable to build URL %s,%s", url, params)));
                return;
            }
            req = new StringRequestWithHeaders(1, url, new StringRequestWithHeaders.Listener(){

                @Override
                public void onResponse(String response, Map<String, String> headers) {
                    JSONObject headersObj = JavascriptEngine.getHeadersObj(headers);
                    String key = JavascriptEngine.randomString();
                    JavascriptEngine.this.responseMap.put(key, headersObj.toString());
                    DLog.v("MobfoxSDK", "dbg: ### <== ANDROID calls callCallback for request(" + cb_id + ", null, response) ###");
                    DLog.release("MobfoxSDK", "dbg: ###");
                    DLog.release("MobfoxSDK", "dbg: ### <== RESPONSE: " + response);
                    DLog.release("MobfoxSDK", "dbg: ###");
                    JavascriptEngine.this.callCallback(cb_id, "null", JavascriptEngine.this.jsString(response), JavascriptEngine.this.getJSResponse(key));
                }
            }, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError volleyError) {
                    String errMsg = MFXUtils.TranslateVolleyError(volleyError);
                    DLog.release("MobfoxSDK", "dbg: ###");
                    DLog.release("MobfoxSDK", "dbg: ### <== onErrorResponse(1): " + errMsg);
                    DLog.release("MobfoxSDK", "dbg: ###");
                    DLog.v("MobfoxSDK", "dbg: ### <== ANDROID calls callCallback for request(" + cb_id + ", " + errMsg + ", null) ###");
                    JavascriptEngine.this.callCallback(cb_id, JavascriptEngine.this.jsString(errMsg));
                }
            }){

                protected Map<String, String> getParams() {
                    return postParamsMap;
                }
            };
        } else {
            String fullURL = this.getFullURL(url, params);
            if (fullURL == null) {
                this.callCallback(cb_id, this.jsString(String.format("unable to build URL %s,%s", url, params)));
                return;
            }
            DLog.v("MobfoxSDK", "dbg: ### CONTROLLER calls fullURL: " + fullURL + " ###");
            req = new StringRequestWithHeaders(0, fullURL, new StringRequestWithHeaders.Listener(){

                @Override
                public void onResponse(String response, Map<String, String> headers) {
                    JSONObject headersObj = JavascriptEngine.getHeadersObj(headers);
                    String key = JavascriptEngine.randomString();
                    JavascriptEngine.this.responseMap.put(key, headersObj.toString());
                    DLog.v("MobfoxSDK", "dbg: ### <== ANDROID calls callCallback for request(" + cb_id + ", null, response) ###");
                    DLog.release("MobfoxSDK", "dbg: ###");
                    DLog.release("MobfoxSDK", "dbg: ### <== RESPONSE: " + response);
                    DLog.release("MobfoxSDK", "dbg: ###");
                    JavascriptEngine.this.callCallback(cb_id, "null", JavascriptEngine.this.jsString(response), JavascriptEngine.this.getJSResponse(key));
                }
            }, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError volleyError) {
                    String errMsg = MFXUtils.TranslateVolleyError(volleyError);
                    DLog.release("MobfoxSDK", "dbg: ###");
                    DLog.release("MobfoxSDK", "dbg: ### <== onErrorResponse(2): " + errMsg);
                    DLog.release("MobfoxSDK", "dbg: ###");
                    DLog.v("MobfoxSDK", "dbg: ### <== ANDROID calls callCallback for request(" + cb_id + ", " + errMsg + ", null) ###");
                    JavascriptEngine.this.callCallback(cb_id, JavascriptEngine.this.jsString(errMsg));
                }
            });
        }
        req.setRetryPolicy(this.policy);
        queue.add((Request)req);
    }

    public void requestJSON(String url, String params, String method, final String cb_id) {
        MetaRequest req;
        JavascriptEngine self = this;
        RequestQueue queue = this.getRequestQueue();
        if (method != null && method.equalsIgnoreCase("POST")) {
            DLog.v("MobfoxSDK", "dbg: ###");
            DLog.v("MobfoxSDK", "dbg: ### CONTROLLER calls requestJSON(" + url + ", " + params + ", POST, " + cb_id + ") ###");
            DLog.v("MobfoxSDK", "dbg: ###");
            DLog.release("MobfoxSDK", "dbg: ###");
            DLog.release("MobfoxSDK", "dbg: ### CONTROLLER calls requestJSON(" + url + ", " + params + ", POST) ###");
            DLog.release("MobfoxSDK", "dbg: ###");
            final Map<String, String> postParamsMap = this.getPostParamsMap(params);
            if (postParamsMap == null) {
                this.callCallback(cb_id, this.jsString(String.format("Error: Unable to build URL %s,%s", url, params)));
                return;
            }
            req = new MetaRequest(1, url, (Response.Listener)new Response.Listener<String>(){

                public void onResponse(String jsonStr) {
                    DLog.v("MobfoxSDK", "dbg: ###");
                    DLog.v("MobfoxSDK", "dbg: ### <== RESPONSE: " + jsonStr);
                    DLog.v("MobfoxSDK", "dbg: ###");
                    DLog.release("MobfoxSDK", "dbg: ###");
                    DLog.release("MobfoxSDK", "dbg: ### <== RESPONSE: " + jsonStr);
                    DLog.release("MobfoxSDK", "dbg: ###");
                    String key = JavascriptEngine.randomString();
                    JavascriptEngine.this.responseMap.put(key, jsonStr);
                    DLog.v("MobfoxSDK", "dbg: ### <== ANDROID calls callCallback for requestJSON(" + cb_id + ", null, response) ###");
                    JavascriptEngine.this.callCallback(cb_id, "null", JavascriptEngine.this.getJSResponse(key), JavascriptEngine.this.getJSResponse(key, "headers"));
                }
            }, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError volleyError) {
                    String errMsg = MFXUtils.TranslateVolleyError(volleyError);
                    DLog.release("MobfoxSDK", "dbg: ###");
                    DLog.release("MobfoxSDK", "dbg: ### <== onErrorResponse(3): " + errMsg);
                    DLog.release("MobfoxSDK", "dbg: ###");
                    DLog.v("MobfoxSDK", "dbg: ### <== ANDROID calls callCallback for requestJSON(" + cb_id + ", " + errMsg + ", null) ###");
                    JavascriptEngine.this.callCallback(cb_id, JavascriptEngine.this.jsString(errMsg));
                }
            }){

                protected Map<String, String> getParams() {
                    return postParamsMap;
                }
            };
        } else {
            DLog.v("MobfoxSDK", "dbg: ###");
            DLog.v("MobfoxSDK", "dbg: ### CONTROLLER calls requestJSON(" + url + ", GET, " + cb_id + ") ###");
            DLog.v("MobfoxSDK", "dbg: ###");
            DLog.v("MobfoxSDK", "dbg: ### CONTROLLER calls requestJSON with " + params + " ###");
            DLog.v("MobfoxSDK", "dbg: ###");
            DLog.release("MobfoxSDK", "dbg: ###");
            DLog.release("MobfoxSDK", "dbg: ### CONTROLLER calls requestJSON(" + url + ", " + params + ", GET) ###");
            DLog.release("MobfoxSDK", "dbg: ###");
            String fullURL = this.getFullURL(url, params);
            if (fullURL == null) {
                this.callCallback(cb_id, this.jsString(String.format("Error: Unable to build URL %s,%s", url, params)));
                return;
            }
            req = new MetaRequest(0, fullURL, new Response.Listener<String>(){

                public void onResponse(String jsonStr) {
                    String key = JavascriptEngine.randomString();
                    JavascriptEngine.this.responseMap.put(key, jsonStr);
                    DLog.v("MobfoxSDK", "dbg: ###");
                    DLog.v("MobfoxSDK", "dbg: ### <== RESPONSE: " + jsonStr);
                    DLog.v("MobfoxSDK", "dbg: ###");
                    DLog.v("MobfoxSDK", "dbg: ### <== ANDROID calls callCallback for requestJSON(" + cb_id + ", null, response) ###");
                    DLog.v("MobfoxSDK", "dbg: ###");
                    DLog.release("MobfoxSDK", "dbg: ###");
                    DLog.release("MobfoxSDK", "dbg: ### <== RESPONSE: " + jsonStr);
                    DLog.release("MobfoxSDK", "dbg: ###");
                    JavascriptEngine.this.callCallback(cb_id, "null", JavascriptEngine.this.getJSResponse(key), JavascriptEngine.this.getJSResponse(key, "headers"));
                }
            }, new Response.ErrorListener(){

                public void onErrorResponse(VolleyError volleyError) {
                    String errMsg = MFXUtils.TranslateVolleyError(volleyError);
                    DLog.release("MobfoxSDK", "dbg: ###");
                    DLog.release("MobfoxSDK", "dbg: ### <== onErrorResponse(4): " + errMsg);
                    DLog.release("MobfoxSDK", "dbg: ###");
                    DLog.v("MobfoxSDK", "dbg: ### <== ANDROID calls callCallback for requestJSON(" + cb_id + ", " + errMsg + ", null) ###");
                    JavascriptEngine.this.callCallback(cb_id, JavascriptEngine.this.jsString(errMsg));
                }
            });
        }
        req.setRetryPolicy(this.policy);
        queue.add((Request)req);
    }

    public void MFTimeout(final String cb_id, int timeoutInMillisecs) {
        final JavascriptEngine self = this;
        this.mainHandler.postDelayed((Runnable)new MobFoxRunnable(this.mContext){

            @Override
            public void mobFoxRun() {
                self.callCallback(cb_id);
            }
        }, (long)timeoutInMillisecs);
    }

    public void evaluate(String code) {
        this.evaluate(code, null);
    }

    public void evaluate(String code, ValueCallback<String> resultCallback) {
        this.webView.evaluateJavascript(this.requireCode + code, resultCallback);
    }

    public void evaluateFromURL(String url) {
        this.evaluateFromURL(url, null);
    }

    public void evaluateFromURL(String url, final JavascriptEngineCallback cb) {
        final JavascriptEngine self = this;
        RequestQueue queue = this.getRequestQueue();
        CacheStringRequest req1 = new CacheStringRequest(0, url, new Response.Listener<NetworkResponse>(){

            public void onResponse(NetworkResponse response) {
                try {
                    String code = new String(response.data, HttpHeaderParser.parseCharset((Map)response.headers));
                    self.evaluate(code, new ValueCallback<String>(){

                        public void onReceiveValue(String value) {
                            if (cb != null) {
                                cb.onResponse(null, value);
                            }
                        }
                    });
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
            }
        });
        req1.setRetryPolicy(this.policy);
        queue.add((Request)req1);
    }

    protected void callCallback(String cb_id) {
        if (cb_id == null) {
            return;
        }
        if (cb_id.equalsIgnoreCase("undefined")) {
            return;
        }
        final String cbStr = String.format("mobfoxCBMap[\"%s\"]()", cb_id);
        if (Thread.currentThread() == this.mainHandler.getLooper().getThread()) {
            this.webView.evaluateJavascript(cbStr, null);
        } else {
            final JavascriptEngine self = this;
            this.mainHandler.post(new Runnable(){

                @Override
                public void run() {
                    self.webView.evaluateJavascript(cbStr, null);
                }
            });
        }
    }

    protected void callCallback(String cb_id, String ... args) {
        if (cb_id == null) {
            return;
        }
        if (cb_id.equalsIgnoreCase("undefined")) {
            return;
        }
        String argStr = TextUtils.join((CharSequence)",", (Object[])args);
        final String cbStr = String.format("mobfoxCBMap[\"%s\"](%s)", cb_id, argStr);
        if (Thread.currentThread() == this.mainHandler.getLooper().getThread()) {
            this.webView.evaluateJavascript(cbStr, null);
        } else {
            final JavascriptEngine self = this;
            this.mainHandler.post(new Runnable(){

                @Override
                public void run() {
                    self.webView.evaluateJavascript(cbStr, null);
                }
            });
        }
    }

    protected void callCallbackWithTwoStrings(String cb_id, String error, String result) {
        if (cb_id == null) {
            return;
        }
        if (cb_id.equalsIgnoreCase("undefined")) {
            return;
        }
        JSONObject jsParams = new JSONObject();
        try {
            if (error != null) {
                jsParams.put("error", (Object)error);
            }
            if (result != null) {
                jsParams.put("result", (Object)result);
            }
            final String cbStr = String.format("mobfoxCBMap[\"%s\"](%s)", cb_id, jsParams);
            if (Thread.currentThread() == this.mainHandler.getLooper().getThread()) {
                this.webView.evaluateJavascript(cbStr, null);
            } else {
                final JavascriptEngine self = this;
                this.mainHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        self.webView.evaluateJavascript(cbStr, null);
                    }
                });
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    protected String getJSResponse(String responseKey) {
        return this.getJSResponse(responseKey, null);
    }

    protected String getJSResponse(String responseKey, String path) {
        String jsResponse = path == null ? String.format("JSON.parse(Android.getResponse(\"%s\"))", responseKey) : String.format("JSON.parse(Android.getResponse(\"%s\")).%s", responseKey, path);
        return jsResponse;
    }

    protected String jsString(String s) {
        if (s != null && s.length() > 0) {
            s = s.replace("\n", "\\n");
            s = s.replace("\"", "\\\"");
        }
        return String.format("\"%s\"", s);
    }

    public boolean isEngineReady() {
        return this.ready;
    }

    String getFullURL(String url, String params) {
        Uri.Builder builder = Uri.parse((String)url).buildUpon();
        JSONObject paramsObj = null;
        try {
            paramsObj = new JSONObject(params);
        }
        catch (JSONException e) {
            return null;
        }
        Iterator keys = paramsObj.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String value = "";
            try {
                value = paramsObj.getString(key);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            builder.appendQueryParameter(key, value);
        }
        return builder.build().toString();
    }

    Map<String, String> getPostParamsMap(String params) {
        JSONObject paramsObj = null;
        try {
            paramsObj = new JSONObject(params);
        }
        catch (JSONException e) {
            return null;
        }
        HashMap<String, String> trg_params = new HashMap<String, String>();
        Iterator keys = paramsObj.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String value = "";
            try {
                value = paramsObj.getString(key);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            trg_params.put(key, value);
        }
        return trg_params;
    }

    public static JSONObject getHeadersObj(Map<String, String> headers) {
        JSONObject headersObj = new JSONObject();
        if (headers != null) {
            headersObj = new JSONObject(headers);
        }
        return headersObj;
    }

    @SuppressLint(value={"JavascriptInterface"})
    public void addJSInterface(Object js_interface, String name) {
        this.webView.addJavascriptInterface(js_interface, name);
    }

    protected static String randomString() {
        Random generator = new Random();
        StringBuilder randomStringBuilder = new StringBuilder();
        for (int i = 0; i < 16; ++i) {
            char tempChar = (char)(generator.nextInt(27) + 97);
            randomStringBuilder.append(tempChar);
        }
        return randomStringBuilder.toString();
    }

    protected synchronized RequestQueue getRequestQueue() {
        if (mRequestQueue == null) {
            mRequestQueue = Volley.newRequestQueue((Context)this.mContext.getApplicationContext());
        }
        return mRequestQueue;
    }

    public class JavascriptEngineInitException
    extends Exception {
        public JavascriptEngineInitException() {
        }

        public JavascriptEngineInitException(String message) {
            super(message);
        }
    }

    public static interface JavascriptEngineCallback {
        public void onResponse(Exception var1, String var2);
    }

    private class CacheStringRequest
    extends Request<NetworkResponse> {
        private final Response.Listener<NetworkResponse> mListener;
        private final Response.ErrorListener mErrorListener;

        public CacheStringRequest(int method, String url, Response.Listener<NetworkResponse> listener, Response.ErrorListener errorListener) {
            super(method, url, errorListener);
            this.mListener = listener;
            this.mErrorListener = errorListener;
        }

        protected Response<NetworkResponse> parseNetworkResponse(NetworkResponse response) {
            Cache.Entry cacheEntry = NetworkRequestManager.HandleCachingInRequest(response);
            return Response.success((Object)response, (Cache.Entry)cacheEntry);
        }

        protected void deliverResponse(NetworkResponse response) {
            this.mListener.onResponse((Object)response);
        }

        protected VolleyError parseNetworkError(VolleyError volleyError) {
            return super.parseNetworkError(volleyError);
        }

        public void deliverError(VolleyError error) {
            this.mErrorListener.onErrorResponse(error);
        }
    }

    public static interface OnReadyCallback {
        public void onReady(JavascriptEngine var1);
    }
}

