/*
 * Decompiled with CFR 0.152.
 */
package com.mobfox.android.core.javascriptengine;

import android.content.Context;
import android.os.Build;
import android.webkit.ValueCallback;
import com.mobfox.android.Ads.BannerInner;
import com.mobfox.android.Ads.InterstitialInner;
import com.mobfox.android.Ads.NativeInner;
import com.mobfox.android.JSInterface.ControllerAPI;
import com.mobfox.android.JSInterface.ListenerAPI;
import com.mobfox.android.JSInterface.StorageAPI;
import com.mobfox.android.JSInterface.SystemAPI;
import com.mobfox.android.MobfoxSDK;
import com.mobfox.android.core.DLog;
import com.mobfox.android.core.InAppBrowser;
import com.mobfox.android.core.MFXStorage;
import com.mobfox.android.core.javascriptengine.JavascriptEngine;
import com.mobfox.android.core.utils.MobFoxRunnable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ControllerEngine
extends JavascriptEngine {
    private static ControllerEngine instance;
    private static Semaphore sdkMutex;
    private static ControllerAPI mControllerAPI;
    private static ListenerAPI mListenerAPI;
    private static HashMap<String, BannerInner> mBannersMap;
    private static HashMap<String, InterstitialInner> mIntersMap;
    private static HashMap<String, NativeInner> mNativesMap;
    private final Context context;
    private Listener listener;

    public static ControllerEngine sharedInstance(Context ctx, String htmlToLoad, JavascriptEngine.OnReadyCallback cb) throws JavascriptEngine.JavascriptEngineInitException {
        if (instance == null) {
            instance = new ControllerEngine(ctx, htmlToLoad, cb);
        } else if (cb != null) {
            cb.onReady(instance);
        }
        return instance;
    }

    public static ControllerEngine getInstance() {
        return instance;
    }

    public static boolean controllerReady() {
        if (instance == null || !instance.isEngineReady()) {
            DLog.e("MobfoxSDK", "### Looks like you MobfoxSDK is not ready yet ###");
            return false;
        }
        return true;
    }

    public ControllerEngine(Context ctx, String htmlToLoad, JavascriptEngine.OnReadyCallback cb) throws JavascriptEngine.JavascriptEngineInitException {
        super(ctx, htmlToLoad, cb);
        this.context = ctx;
        sdkMutex = new Semaphore(1, true);
        mControllerAPI = new ControllerAPI(this.context, this, this.mainHandler);
        mListenerAPI = new ListenerAPI(this.context, this.mainHandler);
        this.addJSInterface(new SystemAPI(this.context), "MFXSystem");
        this.addJSInterface(new StorageAPI(this.context), "MFXStorage");
        this.addJSInterface(mControllerAPI, "MFXController");
        this.addJSInterface(mListenerAPI, "MFXListener");
    }

    public static boolean aquirePrefsLock() {
        return ControllerEngine.aquireSdkLock();
    }

    public static boolean releasePrefsLock() {
        return ControllerEngine.releaseSdkLock();
    }

    public static boolean aquireSdkLock() {
        if (sdkMutex == null) {
            sdkMutex = new Semaphore(1, true);
        }
        try {
            sdkMutex.acquire();
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    public static boolean releaseSdkLock() {
        if (sdkMutex != null) {
            sdkMutex.release();
        }
        return true;
    }

    public void callBannerLoad(final Context ctx, final BannerInner bannerAd, final BannerInner.BannerInnerListener listener) {
        final String guid = bannerAd.getGuid();
        final String invh = bannerAd.getInvh();
        final int adWidth = bannerAd.getAdWidth();
        final int adHeight = bannerAd.getAdHeight();
        final String coppa = MFXStorage.sharedInstance(ctx).getPrefString("key_subject_to_coppa", "0");
        final String ccpa = MFXStorage.sharedInstance(ctx).getPrefString("us_privacy", "");
        if (Build.VERSION.SDK_INT < 19) {
            DLog.release("MobfoxSDK", "dbg: >>>> ### call Banner Load fails (KITKAT) ###");
            if (listener != null) {
                this.mainHandler.post((Runnable)new MobFoxRunnable(ctx){

                    @Override
                    public void mobFoxRun() {
                        DLog.release("MobfoxSDK", "dbg: >>>> ### onBannerLoadFailed(No fill) ###");
                        listener.onBannerLoadFailed(bannerAd, "No fill");
                    }
                });
            }
            return;
        }
        final ControllerEngine self = this;
        if (!ControllerEngine.controllerReady()) {
            return;
        }
        String function = String.format("init();", new Object[0]);
        DLog.release("MobfoxSDK", "dbg: >>>> ### call Banner Load: calling " + function + "... ###");
        self.evaluate(function, new ValueCallback<String>(){

            public void onReceiveValue(String value) {
                block3: {
                    JSONObject jsParams = new JSONObject();
                    try {
                        jsParams.put("guid", (Object)guid);
                        jsParams.put("invh", (Object)invh);
                        jsParams.put("adspace_width", adWidth);
                        jsParams.put("adspace_height", adHeight);
                        jsParams.put("supportCaching", true);
                        jsParams.put("coppa", (Object)coppa);
                        jsParams.put("ccpa", (Object)ccpa);
                        float floorPrice = bannerAd.getBannerFloorPrice();
                        if (floorPrice >= 0.0f) {
                            jsParams.put("r_floor", (double)floorPrice);
                        }
                        String function1 = String.format("BannerLoad(%s);", jsParams);
                        DLog.release("MobfoxSDK", "dbg: >>>> ### call Banner Load: calling " + function1 + "... ###");
                        self.evaluate(function1, new ValueCallback<String>(){

                            public void onReceiveValue(String value) {
                            }
                        });
                    }
                    catch (JSONException e) {
                        DLog.release("MobfoxSDK", "dbg: >>>> ### call Banner Load Failed(" + e.getLocalizedMessage() + ") ###");
                        if (listener == null) break block3;
                        ControllerEngine.this.mainHandler.post((Runnable)new MobFoxRunnable(ctx){

                            @Override
                            public void mobFoxRun() {
                                DLog.release("MobfoxSDK", "dbg: >>>> ### onBannerLoadFailed(" + e.getLocalizedMessage() + ") ###");
                                listener.onBannerLoadFailed(bannerAd, e.getLocalizedMessage());
                            }
                        });
                    }
                }
            }
        });
    }

    public void callShowBanner(Context ctx, final BannerInner bannerAd, String renderArgs, final BannerInner.BannerInnerListener listener) {
        block5: {
            if (Build.VERSION.SDK_INT >= 19) {
                String guid = bannerAd.getGuid();
                String invh = bannerAd.getInvh();
                if (!ControllerEngine.controllerReady()) {
                    return;
                }
                if (renderArgs == null || renderArgs.length() == 0) {
                    return;
                }
                ControllerEngine self = this;
                JSONObject jsParams = new JSONObject();
                try {
                    jsParams.put("guid", (Object)guid);
                    jsParams.put("args", (Object)renderArgs);
                    String function = String.format("ShowBanner(%s);", jsParams);
                    DLog.release("MobfoxSDK", "dbg: >>>> ### call Show Banner: calling ShowBanner... ###");
                    self.evaluate(function, new ValueCallback<String>(){

                        public void onReceiveValue(String value) {
                        }
                    });
                }
                catch (JSONException e) {
                    if (listener == null) break block5;
                    this.mainHandler.post((Runnable)new MobFoxRunnable(ctx){

                        @Override
                        public void mobFoxRun() {
                            DLog.release("MobfoxSDK", "dbg: >>>> ### onBannerLoadFailed(" + e.getLocalizedMessage() + ") ###");
                            listener.onBannerLoadFailed(bannerAd, e.getLocalizedMessage());
                        }
                    });
                }
            }
        }
    }

    public void releaseBanner(String guid) {
        BannerInner bannerAd = ControllerEngine.getBannerByGUID(guid);
        if (bannerAd != null) {
            this.callNewBannerDeallocated(bannerAd);
        }
    }

    public void callNewBannerDeallocated(BannerInner bannerAd) {
        if (!ControllerEngine.controllerReady()) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 19) {
            String function = String.format("DeallocatedBanner('%s','%s');", bannerAd.getGuid(), bannerAd.getInvh());
            this.evaluate(function);
        }
    }

    public void callInterstitialLoad(final Context ctx, final InterstitialInner interstitialAd, final InterstitialInner.InterstitialInnerListener listener) {
        final String guid = interstitialAd.getGuid();
        final String invh = interstitialAd.getInvh();
        final int adWidth = interstitialAd.getAdWidth();
        final int adHeight = interstitialAd.getAdHeight();
        final boolean isRewarded = interstitialAd.getIsRewarded();
        final String coppa = MFXStorage.sharedInstance(ctx).getPrefString("key_subject_to_coppa", "0");
        final String ccpa = MFXStorage.sharedInstance(ctx).getPrefString("us_privacy", "");
        if (Build.VERSION.SDK_INT < 19) {
            DLog.release("MobfoxSDK", "dbg: >>>> ### call Interstitial/rewarded Load fails (KITKAT) ###");
            if (listener != null) {
                this.mainHandler.post((Runnable)new MobFoxRunnable(ctx){

                    @Override
                    public void mobFoxRun() {
                        DLog.release("MobfoxSDK", "dbg: >>>> ### onInterstitialLoadFailed(No fill) ###");
                        listener.onInterstitialLoadFailed(interstitialAd, "No fill");
                    }
                });
            }
            return;
        }
        if (!ControllerEngine.controllerReady()) {
            return;
        }
        final ControllerEngine self = this;
        String function = String.format("init();", new Object[0]);
        DLog.release("MobfoxSDK", "dbg: >>>> ### call Interstitial/rewarded Load: calling " + function + "... ###");
        self.evaluate(function, new ValueCallback<String>(){

            public void onReceiveValue(String value) {
                block4: {
                    JSONObject jsParams = new JSONObject();
                    try {
                        jsParams.put("guid", (Object)guid);
                        jsParams.put("invh", (Object)invh);
                        jsParams.put("adspace_width", adWidth);
                        jsParams.put("adspace_height", adHeight);
                        jsParams.put("v_rewarded", (Object)(isRewarded ? "1" : "0"));
                        jsParams.put("coppa", (Object)coppa);
                        jsParams.put("ccpa", (Object)ccpa);
                        float floorPrice = interstitialAd.getInterstitialFloorPrice();
                        if (floorPrice >= 0.0f) {
                            jsParams.put("r_floor", (double)floorPrice);
                        }
                        String funcName = "InterstitialLoad";
                        if (isRewarded) {
                            funcName = "RewardedVideoLoad";
                            String endpoint = interstitialAd.getRewardedCallbackServer();
                            jsParams.put("endpoint", (Object)endpoint);
                        }
                        String function1 = String.format("%s(%s);", funcName, jsParams);
                        DLog.release("MobfoxSDK", "dbg: >>>> ### call " + funcName + ": calling " + function1 + "... ###");
                        self.evaluate(function1, new ValueCallback<String>(){

                            public void onReceiveValue(String value) {
                            }
                        });
                    }
                    catch (JSONException e) {
                        DLog.release("MobfoxSDK", "dbg: >>>> ### call Interstitial/rewarded Load Failed(" + e.getLocalizedMessage() + ") ###");
                        if (listener == null) break block4;
                        ControllerEngine.this.mainHandler.post((Runnable)new MobFoxRunnable(ctx){

                            @Override
                            public void mobFoxRun() {
                                DLog.release("MobfoxSDK", "dbg: >>>> ### onInterstitialLoadFailed(" + e.getLocalizedMessage() + ") ###");
                                listener.onInterstitialLoadFailed(interstitialAd, e.getLocalizedMessage());
                            }
                        });
                    }
                }
            }
        });
    }

    public void releaseInterstitial(String guid) {
        InterstitialInner interAd = ControllerEngine.getInterstitialByGUID(guid);
        if (interAd != null) {
            this.callNewInterstitialDeallocated(interAd);
        }
    }

    public void callNewInterstitialDeallocated(InterstitialInner interstitialAd) {
        if (!ControllerEngine.controllerReady()) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 19) {
            boolean isRewarded = interstitialAd.getIsRewarded();
            String funcName = "DeallocatedInterstitial";
            if (isRewarded) {
                funcName = "DeallocatedRewardedVideo";
            }
            String function = String.format("%s('%s','%s');", funcName, interstitialAd.getGuid(), interstitialAd.getInvh());
            this.evaluate(function);
        }
    }

    public void callShowInterstitial(Context ctx, final InterstitialInner interstitialAd, String adResponse, final InterstitialInner.InterstitialInnerListener listener) {
        block5: {
            if (Build.VERSION.SDK_INT >= 19) {
                String guid = interstitialAd.getGuid();
                String invh = interstitialAd.getInvh();
                boolean isRewarded = interstitialAd.getIsRewarded();
                if (!ControllerEngine.controllerReady()) {
                    return;
                }
                ControllerEngine self = this;
                JSONObject jsParams = new JSONObject();
                try {
                    jsParams.put("guid", (Object)guid);
                    jsParams.put("resp", (Object)adResponse);
                    jsParams.put("v_rewarded", (Object)(isRewarded ? "1" : "0"));
                    String funcName = "ShowInterstitial";
                    if (isRewarded) {
                        funcName = "ShowRewardedVideo";
                        String endpoint = interstitialAd.getRewardedCallbackServer();
                        jsParams.put("endpoint", (Object)endpoint);
                    }
                    String function = String.format("%s(%s);", funcName, jsParams);
                    DLog.release("MobfoxSDK", "dbg: >>>> ### call " + funcName + ": calling ShowInterstitial... ###");
                    self.evaluate(function, new ValueCallback<String>(){

                        public void onReceiveValue(String value) {
                        }
                    });
                }
                catch (JSONException e) {
                    if (listener == null) break block5;
                    this.mainHandler.post((Runnable)new MobFoxRunnable(ctx){

                        @Override
                        public void mobFoxRun() {
                            DLog.release("MobfoxSDK", "dbg: >>>> ### onInterstitialLoadFailed(" + e.getLocalizedMessage() + ") ###");
                            listener.onInterstitialLoadFailed(interstitialAd, e.getLocalizedMessage());
                        }
                    });
                }
            }
        }
    }

    public void callNativeLoad(Context ctx, final NativeInner nativeAd, final JSONObject jsParams, final NativeInner.NativeInnerListener listener) {
        String guid = nativeAd.getGuid();
        String invh = nativeAd.getInvh();
        if (Build.VERSION.SDK_INT < 19) {
            if (listener != null) {
                this.mainHandler.post((Runnable)new MobFoxRunnable(ctx){

                    @Override
                    public void mobFoxRun() {
                        DLog.release("MobfoxSDK", "dbg: >>>> ### onNativeLoadFailed(No fill) ###");
                        listener.onNativeLoadFailed(nativeAd, "No fill");
                    }
                });
            }
            return;
        }
        if (!ControllerEngine.controllerReady()) {
            return;
        }
        final ControllerEngine self = this;
        String function = String.format("init();", new Object[0]);
        self.evaluate(function, new ValueCallback<String>(){

            public void onReceiveValue(String value) {
                String function = String.format("NativeLoad(%s);", jsParams);
                self.evaluate(function, new ValueCallback<String>(){

                    public void onReceiveValue(String value) {
                    }
                });
            }
        });
    }

    public void releaseNative(String guid) {
        NativeInner nativeAd = ControllerEngine.getNativeByGUID(guid);
        if (nativeAd != null) {
            this.callNewNativeDeallocated(nativeAd);
        }
    }

    public void callNewNativeDeallocated(NativeInner nativeAd) {
        if (Build.VERSION.SDK_INT >= 19 && ControllerEngine.controllerReady()) {
            String function = String.format("DeallocatedNative('%s','%s');", nativeAd.getGuid(), nativeAd.getInvh());
            this.evaluate(function);
        }
        ControllerEngine.removeNativeFromMap(nativeAd);
    }

    public void callControllerCallback(String cb_id, String error, String result) {
        this.callCallbackWithTwoStrings(cb_id, error, result);
    }

    public static void saveRenderArgs(String guid, String renderArgs) {
        BannerInner bannerAd = ControllerEngine.getBannerByGUID(guid);
        if (bannerAd != null) {
            bannerAd.saveRenderArgs(renderArgs);
        }
    }

    public static void callControllerFunc(Context ctx, String guid, String name) {
        ControllerEngine.callControllerFunc(ctx, guid, name, null);
    }

    public static void callControllerFunc(Context ctx, String guid, String name, String fieldName, String fieldValue) {
        JSONObject json = new JSONObject();
        try {
            json.put(fieldName, (Object)fieldValue);
            ControllerEngine.callControllerFunc(ctx, guid, name, json.toString());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public static void callControllerFunc(Context context, String guid, String name, String strJson) {
        ControllerEngine ctrlEngine;
        MobfoxSDK sdk;
        if (context != null && (sdk = MobfoxSDK.sharedInstance(context)) != null && (ctrlEngine = ControllerEngine.getInstance()) != null && mControllerAPI != null) {
            try {
                InterstitialInner interAd;
                String url;
                BannerInner bannerAd;
                JSONObject jsParams = new JSONObject();
                if (strJson != null && !strJson.equalsIgnoreCase("null") && !strJson.equalsIgnoreCase("undefined")) {
                    jsParams = new JSONObject(strJson);
                }
                if (guid != null) {
                    jsParams.put("guid", (Object)guid);
                }
                if (name.equalsIgnoreCase("BannerListener.Loaded") && (bannerAd = ControllerEngine.getBannerByGUID(guid)) != null) {
                    bannerAd.setBannerStageLoaded();
                }
                if (name.equalsIgnoreCase("BannerListener.Clicked") && (bannerAd = ControllerEngine.getBannerByGUID(guid)) != null) {
                    url = jsParams.getString("url");
                    InAppBrowser.OpenBrowserWithURL(context, url, bannerAd.getInvh());
                }
                if (name.equalsIgnoreCase("InterstitialListener.Clicked") && (interAd = ControllerEngine.getInterstitialByGUID(guid)) != null) {
                    url = jsParams.getString("url");
                    InAppBrowser.OpenBrowserWithURL(context, url, interAd.getInvh());
                }
                mControllerAPI.callFunc("MFXController", name, jsParams.toString());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
    }

    public void onPause(Context appCtx) {
        JSONArray arrGUIDs = new JSONArray();
        for (Map.Entry<String, BannerInner> entry : mBannersMap.entrySet()) {
            BannerInner banner = entry.getValue();
            banner.onPause(appCtx);
            arrGUIDs.put((Object)banner.getGuid());
        }
        for (Map.Entry<String, Object> entry : mIntersMap.entrySet()) {
            InterstitialInner inter = (InterstitialInner)entry.getValue();
            inter.onPause(appCtx);
            arrGUIDs.put((Object)inter.getGuid());
        }
        if (!ControllerEngine.controllerReady()) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 19) {
            String string = String.format("OnPause('%s');", arrGUIDs.toString());
            this.evaluate(string);
        }
    }

    public void onResume(Context appCtx) {
        JSONArray arrGUIDs = new JSONArray();
        for (Map.Entry<String, BannerInner> entry : mBannersMap.entrySet()) {
            BannerInner banner = entry.getValue();
            banner.onResume(appCtx);
            arrGUIDs.put((Object)banner.getGuid());
        }
        for (Map.Entry<String, Object> entry : mIntersMap.entrySet()) {
            InterstitialInner inter = (InterstitialInner)entry.getValue();
            inter.onResume(appCtx);
            arrGUIDs.put((Object)inter.getGuid());
        }
        if (!ControllerEngine.controllerReady()) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 19) {
            String string = String.format("OnResume('%s');", arrGUIDs.toString());
            this.evaluate(string);
        }
    }

    public static void onDestroy(Context appCtx) {
        for (Map.Entry<String, BannerInner> entry : mBannersMap.entrySet()) {
            BannerInner bannerAd = entry.getValue();
            ControllerEngine.getInstance().callNewBannerDeallocated(bannerAd);
        }
        for (Map.Entry<String, Object> entry : mIntersMap.entrySet()) {
            InterstitialInner interAd = (InterstitialInner)entry.getValue();
            ControllerEngine.getInstance().callNewInterstitialDeallocated(interAd);
        }
        for (Map.Entry<String, Object> entry : mNativesMap.entrySet()) {
            NativeInner nativeAd = (NativeInner)entry.getValue();
            ControllerEngine.getInstance().callNewNativeDeallocated(nativeAd);
        }
    }

    public static boolean onBackPressed(Context appCtx) {
        boolean res = false;
        for (Map.Entry<String, InterstitialInner> pair : mIntersMap.entrySet()) {
            InterstitialInner interAd = pair.getValue();
            if (!interAd.onBackPressed(appCtx)) continue;
            res = true;
        }
        return res;
    }

    public static BannerInner getBannerByGUID(String guid) {
        return mBannersMap.get(guid);
    }

    public static void addBannerToMap(BannerInner bannerAd) {
        mBannersMap.put(bannerAd.getGuid(), bannerAd);
    }

    public static void removeBannerFromMap(BannerInner bannerAd) {
        mBannersMap.remove(bannerAd.getGuid());
    }

    public static InterstitialInner getInterstitialByGUID(String guid) {
        return mIntersMap.get(guid);
    }

    public static void addInterstitialToMap(InterstitialInner interstitialAd) {
        mIntersMap.put(interstitialAd.getGuid(), interstitialAd);
    }

    public static void removeInterstitialFromMap(InterstitialInner interstitialAd) {
        mIntersMap.remove(interstitialAd.getGuid());
    }

    public static NativeInner getNativeByGUID(String guid) {
        return mNativesMap.get(guid);
    }

    public static void addNativeToMap(NativeInner nativeAd) {
        mNativesMap.put(nativeAd.getGuid(), nativeAd);
    }

    public static void removeNativeFromMap(NativeInner nativeAd) {
        mNativesMap.remove(nativeAd.getGuid());
    }

    static {
        sdkMutex = null;
        mControllerAPI = null;
        mListenerAPI = null;
        mBannersMap = new HashMap();
        mIntersMap = new HashMap();
        mNativesMap = new HashMap();
    }

    public static interface Listener {
        public void onMobFoxControllerLoaded();

        public void onError(Exception var1);
    }
}

