/*
 * Decompiled with CFR 0.152.
 */
package com.mobfox.android.core;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.AsyncTask;
import android.preference.PreferenceManager;
import com.mobfox.android.core.DLog;
import com.mobfox.android.core.javascriptengine.ControllerEngine;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;

public class MobfoxSettings {
    private static String AndroidIdInSP = "AndroidDeviceId";
    private static String DoNotTrackInSP = "DoNotTrackInSP";
    private static String LAST_UPDATED = "LastUpdated";
    private static String KEY_PREF_REPORT_EVENT_GROUPS = "prefReportEventGroups1";
    private static String KEY_PREF_REPORT_CRASH_EVENTS = "prefReportCrashEvents";
    private static final int VAL_PREF_REPORT_DMP_EVENTS_DEF = 0;
    private static final int VAL_PREF_REPORT_DMP_EVENTS_NO = 1;
    private static final int VAL_PREF_REPORT_DMP_EVENTS_YES = 2;
    private static String KEY_PREF_REPORT_DMP_EVENTS = "prefReportDMPEvents1";
    private static MobfoxSettings instance;
    private static String O_ANDADVID;
    private static Boolean DO_NOT_TRACK;
    private static String bundleId;

    public static MobfoxSettings getInstance(Context context) {
        if (instance == null) {
            instance = new MobfoxSettings(context);
        }
        return instance;
    }

    private MobfoxSettings(Context c) {
        bundleId = c.getPackageName();
        this.setAdId(c);
    }

    private void setAdId(Context context) {
        SharedPreferences shared = PreferenceManager.getDefaultSharedPreferences((Context)context);
        String androidId = shared.getString(AndroidIdInSP, "");
        boolean doNotTrack = shared.getBoolean(DoNotTrackInSP, true);
        O_ANDADVID = androidId;
        DO_NOT_TRACK = doNotTrack;
        GetDeviceAdId updatingTask = new GetDeviceAdId(context, null);
        updatingTask.execute(new Void[0]);
    }

    public void getAndDvId(Context context, boolean forceUpdate, Listener listener) {
        if (!forceUpdate) {
            if (O_ANDADVID != null) {
                if (listener != null) {
                    listener.onFinish(O_ANDADVID, DO_NOT_TRACK);
                }
                return;
            }
            SharedPreferences shared = PreferenceManager.getDefaultSharedPreferences((Context)context);
            String androidId = shared.getString(AndroidIdInSP, "");
            boolean doNotTrack = shared.getBoolean(DoNotTrackInSP, true);
            O_ANDADVID = androidId;
            DO_NOT_TRACK = doNotTrack;
            if (listener != null) {
                listener.onFinish(O_ANDADVID, DO_NOT_TRACK);
            }
            return;
        }
        GetDeviceAdId task = new GetDeviceAdId(context, listener);
        task.execute(new Void[0]);
    }

    private void updateIDInPreferences(Context context, String idValue, boolean dntValue) {
        O_ANDADVID = idValue;
        DO_NOT_TRACK = dntValue;
        ControllerEngine.aquireSdkLock();
        SharedPreferences shared = PreferenceManager.getDefaultSharedPreferences((Context)context);
        SharedPreferences.Editor editor = shared.edit();
        editor.putString(AndroidIdInSP, idValue);
        editor.putBoolean(DoNotTrackInSP, dntValue);
        editor.putLong(LAST_UPDATED, System.currentTimeMillis());
        editor.apply();
        ControllerEngine.releaseSdkLock();
    }

    public String get_oAndadvid() {
        return O_ANDADVID;
    }

    public boolean get_doNotTrack() {
        return DO_NOT_TRACK;
    }

    public String getBundleId() {
        return bundleId;
    }

    public Set<String> getAnalyticsPrefReportEventGroups(Context context) {
        SharedPreferences shared = PreferenceManager.getDefaultSharedPreferences((Context)context);
        HashSet<String> currVal = new HashSet<String>();
        String val = shared.getString(KEY_PREF_REPORT_EVENT_GROUPS, "[]");
        try {
            JSONArray js = new JSONArray(val);
            if (js != null) {
                int tot = js.length();
                for (int i = 0; i < tot; ++i) {
                    String group = js.getString(i);
                    currVal.add(group);
                }
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return currVal;
    }

    public void setAnalyticsPrefReportEventGroups(Context context, Set<String> newVal) {
        SharedPreferences shared = PreferenceManager.getDefaultSharedPreferences((Context)context);
        SharedPreferences.Editor editor = shared.edit();
        JSONArray js = new JSONArray(newVal);
        editor.putString(KEY_PREF_REPORT_EVENT_GROUPS, js.toString());
        editor.apply();
    }

    public void setAnalyticsPrefReportCrashEvents(Context context, boolean newVal) {
        SharedPreferences shared = PreferenceManager.getDefaultSharedPreferences((Context)context);
        SharedPreferences.Editor editor = shared.edit();
        editor.putBoolean(KEY_PREF_REPORT_CRASH_EVENTS, newVal);
        editor.apply();
    }

    public boolean getAnalyticsPrefReportCrashEvents(Context context) {
        SharedPreferences shared = PreferenceManager.getDefaultSharedPreferences((Context)context);
        return shared.getBoolean(KEY_PREF_REPORT_CRASH_EVENTS, false);
    }

    public void setAnalyticsPrefReportDMPEvents(Context context, boolean newVal) {
        SharedPreferences shared = PreferenceManager.getDefaultSharedPreferences((Context)context);
        SharedPreferences.Editor editor = shared.edit();
        editor.putInt(KEY_PREF_REPORT_DMP_EVENTS, newVal ? 2 : 1);
        editor.apply();
    }

    public boolean getAnalyticsPrefReportDMPEvents(Context context) {
        SharedPreferences shared = PreferenceManager.getDefaultSharedPreferences((Context)context);
        int res = shared.getInt(KEY_PREF_REPORT_DMP_EVENTS, 0);
        return res != 1;
    }

    static {
        O_ANDADVID = null;
        DO_NOT_TRACK = true;
        bundleId = "";
    }

    private class GetDeviceAdId
    extends AsyncTask<Void, Void, String> {
        Context context;
        Listener listener;

        GetDeviceAdId(Context con, Listener lis) {
            this.context = con;
            this.listener = lis;
        }

        protected String doInBackground(Void ... params) {
            try {
                Class<?> AdvertisingIdClient_clazz = Class.forName("com.google.android.gms.ads.identifier.AdvertisingIdClient");
                Method getAdvertisingIdInfo = AdvertisingIdClient_clazz.getMethod("getAdvertisingIdInfo", Context.class);
                Object idInfo = getAdvertisingIdInfo.invoke(null, this.context);
                String advertisingIdClientInfoStr = idInfo.toString();
                String gaid = advertisingIdClientInfoStr.substring(1).split("\\}")[0];
                boolean dnt = advertisingIdClientInfoStr.substring(1).split("\\}")[1].equals("true");
                if (dnt) {
                    gaid = "";
                    DLog.release("MobfoxSDK", "dbg: ### Querying info.. ###");
                } else if (gaid != null && gaid.length() > 0) {
                    DLog.release("MobfoxSDK", "dbg: ### Querying info... ###");
                } else {
                    DLog.release("MobfoxSDK", "dbg: ### Querying info.... ###");
                }
                return gaid;
            }
            catch (Throwable t) {
                DLog.release("MobfoxSDK", "dbg: ### Read info ###");
                if (t != null && t.getMessage() != null) {
                    DLog.d("MobfoxSDK", "google play throwable " + t.getMessage());
                } else {
                    DLog.d("MobfoxSDK", "google play throwable");
                }
                return "";
            }
        }

        protected void onPostExecute(String advertId) {
            boolean dnt;
            boolean bl = dnt = advertId == null || advertId.isEmpty();
            if (dnt) {
                DLog.release("MobfoxSDK", "dbg: ### Got info.. ###");
            } else {
                DLog.release("MobfoxSDK", "dbg: ### Got info... ###");
            }
            MobfoxSettings.this.updateIDInPreferences(this.context, advertId, dnt);
            if (this.listener != null) {
                this.listener.onFinish(advertId, dnt);
            }
        }
    }

    public static interface Listener {
        public void onFinish(String var1, boolean var2);
    }
}

