/*
 * Decompiled with CFR 0.152.
 */
package com.mobfox.android.core;

import android.content.Context;
import android.content.SharedPreferences;
import android.location.Location;
import com.mobfox.android.core.MFXUtils;
import com.mobfox.android.core.MobfoxSettings;
import com.mobfox.android.core.ccpa.CCPAParams;
import com.mobfox.android.core.gdpr.GDPRConsentString;
import com.mobfox.android.core.gdpr.GDPRParams;
import com.mobfox.android.core.javascriptengine.ControllerEngine;
import com.mobfox.android.core.logging.MobFoxReport;
import com.mobfox.android.core.services.MobFoxLocationService;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;

public class MFXStorage {
    private static final String PREFS_NAME = "MFX_Storage";
    private static MFXStorage instance;
    private SharedPreferences mPrefs;
    public static final String O_ANDADVID = "o_andadvid";
    public static final String DEV_DNT = "dev_dnt";
    public static final String C_MRAID = "c_mraid";
    public static final String RT = "rt";
    public static final String SUB_BUNDLE_ID = "sub_bundle_id";
    public static final String C_CUSTOM_EVENTS = "c_customevents";
    public static final String U = "u";
    public static final String AUDIENCE_ENABLED = "f_audience_reporting_enabled";
    public static final String VERSION = "v";
    public static final String R_RESP = "r_resp";
    public static final String HEIGHT = "adspace_height";
    public static final String WIDTH = "adspace_width";
    public static final String INVENTORY_HASH = "s";
    public static final String GDPR = "gdpr";
    public static final String GDPR_CONSENT = "gdpr_consent";
    public static final String COPPA = "coppa";
    public static final String CCPA = "us_privacy";
    public static final String LATITUDE = "latitude";
    public static final String LONGITUDE = "longitude";
    public static final String ADAPTER_LATITUDE = "adapter_latitude";
    public static final String ADAPTER_LONGITUDE = "adapter_longitude";
    public static final String KEY_SUBJECT_TO_COPPA = "key_subject_to_coppa";
    public static final String IMP_SECURE = "imp_secure";
    public static final String R_FLOOR = "r_floor";
    public static final String ADSPACE_STRICT = "adspace_strict";
    public static final String DEV_LMT = "dev_lmt";
    public static final String DEV_JS = "dev_js";
    public static final String S_SUBID = "s_subid";
    public static final String SUB_NAME = "sub_name";
    public static final String SUB_DOMAIN = "sub_domain";
    public static final String SUB_STOREURL = "sub_storeurl";
    public static final String R_TYPE = "r_type";
    public static final String V_REWARDED = "v_rewarded";
    public static final String V_REWARDED_ENDPOINT = "v_rewarded_endpoint";
    public static final String DEBUG_REQUEST_URL = "debugRequestURL";
    public static final String DEBUG_WATERFALL = "debugWaterfall";
    public static final String DEBUG_VIDEO_REQUEST_URL = "debugVideoRequestURL";
    public static final String DEMO_AGE = "demo_age";
    public static final String DEMO_GENDER = "demo_gender";
    public static final String DEMO_KEYWORDS = "demo_keywords";

    public String getPrefString(String key, String defValue) {
        if (instance == null || MFXStorage.instance.mPrefs == null) {
            return defValue;
        }
        ControllerEngine.aquirePrefsLock();
        String res = this.mPrefs.getString(key.toLowerCase(), defValue);
        ControllerEngine.releasePrefsLock();
        return res;
    }

    public void setPrefString(String key, String value) {
        if (instance != null && MFXStorage.instance.mPrefs != null) {
            ControllerEngine.aquirePrefsLock();
            this.mPrefs.edit().putString(key.toLowerCase(), value).apply();
            ControllerEngine.releasePrefsLock();
        }
    }

    public void deletePrefString(String key) {
        if (instance != null && MFXStorage.instance.mPrefs != null) {
            ControllerEngine.aquirePrefsLock();
            this.mPrefs.edit().remove(key.toLowerCase()).apply();
            ControllerEngine.releasePrefsLock();
        }
    }

    public long getPrefLong(String key, long defValue) {
        if (instance == null || MFXStorage.instance.mPrefs == null) {
            return defValue;
        }
        ControllerEngine.aquirePrefsLock();
        long res = this.mPrefs.getLong(key.toLowerCase(), defValue);
        ControllerEngine.releasePrefsLock();
        return res;
    }

    public void setPrefLong(String key, long value) {
        if (instance != null && MFXStorage.instance.mPrefs != null) {
            ControllerEngine.aquirePrefsLock();
            this.mPrefs.edit().putLong(key.toLowerCase(), value).apply();
            ControllerEngine.releasePrefsLock();
        }
    }

    public void deletePrefLong(String key) {
        if (instance != null && MFXStorage.instance.mPrefs != null) {
            ControllerEngine.aquirePrefsLock();
            this.mPrefs.edit().remove(key.toLowerCase()).apply();
            ControllerEngine.releasePrefsLock();
        }
    }

    public double getPrefDouble(String key, double defValue) {
        if (instance == null || MFXStorage.instance.mPrefs == null) {
            return defValue;
        }
        ControllerEngine.aquirePrefsLock();
        double res = this.mPrefs.getFloat(key.toLowerCase(), (float)defValue);
        ControllerEngine.releasePrefsLock();
        return res;
    }

    public void setPrefDouble(String key, double value) {
        if (instance != null && MFXStorage.instance.mPrefs != null) {
            ControllerEngine.aquirePrefsLock();
            this.mPrefs.edit().putFloat(key.toLowerCase(), (float)value).apply();
            ControllerEngine.releasePrefsLock();
        }
    }

    public void deletePrefDouble(String key) {
        if (instance != null && MFXStorage.instance.mPrefs != null) {
            ControllerEngine.aquirePrefsLock();
            this.mPrefs.edit().remove(key.toLowerCase()).apply();
            ControllerEngine.releasePrefsLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPrefInt(String key, int defValue) {
        int res;
        block10: {
            if (instance == null || MFXStorage.instance.mPrefs == null) {
                return defValue;
            }
            ControllerEngine.aquirePrefsLock();
            res = defValue;
            try {
                res = this.mPrefs.getInt(key.toLowerCase(), defValue);
            }
            catch (ClassCastException e1) {
                try {
                    String strVal = this.mPrefs.getString(key.toLowerCase(), "");
                    if (strVal == null || strVal.length() <= 0) break block10;
                    try {
                        res = Integer.valueOf(strVal);
                    }
                    catch (NumberFormatException nfe) {
                        res = defValue;
                    }
                }
                catch (ClassCastException e2) {
                    res = defValue;
                }
            }
            finally {
                ControllerEngine.releasePrefsLock();
            }
        }
        return res;
    }

    public void setPrefInt(String key, int value) {
        if (instance != null && MFXStorage.instance.mPrefs != null) {
            ControllerEngine.aquirePrefsLock();
            this.mPrefs.edit().putInt(key.toLowerCase(), value).apply();
            ControllerEngine.releasePrefsLock();
        }
    }

    public void deletePrefInt(String key) {
        if (instance != null && MFXStorage.instance.mPrefs != null) {
            ControllerEngine.aquirePrefsLock();
            this.mPrefs.edit().remove(key.toLowerCase()).apply();
            ControllerEngine.releasePrefsLock();
        }
    }

    public boolean getPrefBool(String key, boolean defValue) {
        if (instance == null || MFXStorage.instance.mPrefs == null) {
            return defValue;
        }
        ControllerEngine.aquirePrefsLock();
        boolean res = this.mPrefs.getBoolean(key.toLowerCase(), defValue);
        ControllerEngine.releasePrefsLock();
        return res;
    }

    public void setPrefBool(String key, boolean value) {
        if (instance != null && MFXStorage.instance.mPrefs != null) {
            ControllerEngine.aquirePrefsLock();
            this.mPrefs.edit().putBoolean(key.toLowerCase(), value).apply();
            ControllerEngine.releasePrefsLock();
        }
    }

    public void deletePrefBool(String key) {
        if (instance != null && MFXStorage.instance.mPrefs != null) {
            this.mPrefs.edit().remove(key.toLowerCase()).apply();
        }
    }

    private MFXStorage() {
    }

    public static MFXStorage sharedInstance(Context ctx) {
        if (instance == null) {
            instance = new MFXStorage();
        }
        if (MFXStorage.instance.mPrefs == null) {
            MFXStorage.instance.mPrefs = ctx.getSharedPreferences(PREFS_NAME, 0);
        }
        return instance;
    }

    public void setBasicParams(Context context, String adapterName) {
        String dev_dnt = MobfoxSettings.getInstance(context).get_doNotTrack() ? "1" : "0";
        String coppa = this.getPrefString(KEY_SUBJECT_TO_COPPA, "0");
        String ccpa = CCPAParams.getCCPAString(context);
        this.setPrefString(DEV_DNT, dev_dnt);
        this.setPrefString(COPPA, coppa);
        this.setPrefString(C_MRAID, "2");
        this.setPrefString(RT, "android_app");
        this.setPrefString(SUB_BUNDLE_ID, MFXUtils.getBundleId(context));
        this.setPrefString(C_CUSTOM_EVENTS, "1");
        this.setPrefString(VERSION, "4.3.2_" + adapterName);
        this.setPrefString(R_RESP, "json");
        if (this.canWeSendPrivateInfo(context)) {
            String andAdId = MobfoxSettings.getInstance(context).get_oAndadvid();
            this.setPrefString(O_ANDADVID, andAdId);
        } else {
            this.deletePrefString(O_ANDADVID);
        }
        if (ccpa != null) {
            this.setPrefString(CCPA, ccpa);
        } else {
            this.deletePrefString(CCPA);
        }
        String ua = MobFoxReport.getUserAgent(context);
        this.setPrefString(U, ua);
        boolean ae = MFXUtils.hasPermissions(context);
        if (ae) {
            this.setPrefString(AUDIENCE_ENABLED, "1");
        }
    }

    public void setBannerParams(int width, int height, String invh) {
        this.setPrefString(WIDTH, "" + width);
        this.setPrefString(HEIGHT, "" + height);
        this.setPrefString(INVENTORY_HASH, invh);
    }

    public void setInterstitialParams(int width, int height, String invh, boolean isRewarded, String endpoint) {
        this.setBannerParams(width, height, invh);
        this.setPrefString(V_REWARDED, isRewarded ? "1" : "0");
        if (isRewarded && endpoint != null) {
            this.setPrefString(V_REWARDED_ENDPOINT, endpoint);
        }
    }

    public void setLocationParams(Context context) {
        if (!this.canWeSendPrivateInfo(context)) {
            this.deletePrefString(LATITUDE);
            this.deletePrefString(LONGITUDE);
            this.deletePrefString(ADAPTER_LATITUDE);
            this.deletePrefString(ADAPTER_LONGITUDE);
            return;
        }
        double lat = this.getPrefDouble(ADAPTER_LATITUDE, 0.0);
        double lon = this.getPrefDouble(ADAPTER_LONGITUDE, 0.0);
        if (lat != 0.0 && lon != 0.0) {
            this.setPrefString(LATITUDE, String.format("%f", lat));
            this.setPrefString(LONGITUDE, String.format("%f", lon));
            return;
        }
        try {
            Location loc = MobFoxLocationService.getInstance().getLocation(context);
            if (loc != null) {
                this.setPrefString(LATITUDE, String.format("%f", loc.getLatitude()));
                this.setPrefString(LONGITUDE, String.format("%f", loc.getLongitude()));
            } else {
                this.deletePrefString(LATITUDE);
                this.deletePrefString(LONGITUDE);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setGDPRParams(Context context) {
        String subjectToGDPR = GDPRParams.isSubjectToGDPR(context);
        if (subjectToGDPR != null) {
            this.setPrefString(GDPR, subjectToGDPR);
            GDPRConsentString consentString = new GDPRConsentString(context);
            this.setPrefString(GDPR_CONSENT, consentString.toString());
        }
    }

    public boolean canWeSendPrivateInfo(Context context) {
        return true;
    }

    public static String toQuery(HashMap<String, String> params) {
        ArrayList<String> kvs = new ArrayList<String>();
        for (String key : params.keySet()) {
            String value = params.get(key);
            if (value == null) continue;
            try {
                kvs.add(String.format("%s=%s", key, URLEncoder.encode(value, "UTF-8")));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        StringBuffer buf = new StringBuffer();
        for (String kv : kvs) {
            buf.append(kv + "&");
        }
        String url = buf.toString();
        if (url.length() >= 1) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }
}

