/*
 * Decompiled with CFR 0.152.
 */
package com.mobfox.android.core;

import android.app.Activity;
import android.content.Context;
import android.os.CountDownTimer;
import android.os.Handler;
import android.os.Looper;
import android.util.Base64;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonArrayRequest;
import com.android.volley.toolbox.JsonObjectRequest;
import com.android.volley.toolbox.StringRequest;
import com.mobfox.android.core.DLog;
import com.mobfox.android.core.MFXStorage;
import com.mobfox.android.core.MFXUtils;
import com.mobfox.android.core.Networking;
import com.mobfox.android.core.javascriptengine.ControllerEngine;
import com.mobfox.android.dmp.utils.DMPUtils;
import java.net.URLEncoder;
import java.util.ArrayList;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MFXConfiguration {
    private static MFXConfiguration instance;
    private static CountDownTimer mConfigPollingCounter;
    private static Context mConfigPollingContext;
    private static CountDownTimer mPubsPollingCounter;
    private static Context mPubsPollingContext;
    private ArrayList<JSONObject> mArrPublications = new ArrayList();
    private static final String SENTENCE_1 = "steams-against";
    private static final String APP_IDENTIFIER = "app_identifier";
    private static final String SSP_URL = "ssp_url";
    private static final String DMP_URL = "dmp_url";
    private static final String CONVOY_URL = "convoy_url";
    private static final String CONVOY_VERSION = "convoy_version";
    private static final String REPORTING_SERVER_URL = "reporting_server_url";
    private static final String TTL = "ttl";
    private static final String PUBS_TTL = "PUBLICATIONS_TTL";
    private static final String SCRIPTS_TTL = "SCRIPTS_TTL";
    public static final String USE_DMP = "USE_DMP";
    private static final String FORCE_UPDATE = "FORCE_UPDATE";
    private static final String FORCE_UPDATE_PUBS = "FORCE_UPDATE_PUBS";
    private static final String FORCE_UPDATE_SCRIPTS = "FORCE_UPDATE_SCRIPTS";
    private static final String KILL_SWITCH = "KILL";
    private static final String REFRESH_RATE = "refreshRate";
    private static final String CONFIGURATION_TS = "CONFIGURATION_TS";
    private static final String PUBLICATIONS_TS = "PUBLICATIONS_TS";
    private static final String SENTENCE_3 = "a-bath";
    private static final String PUBLICATIONS_ARRAY = "publications_array";
    private static final String CONTROLLER_HTML = "controller.html";
    private static final String TAG_HTML = "tag.html";
    private static final String VIDEO_HTML = "player.html";
    private static final String SENTENCE_2 = "The-well";
    private static final String PREFS_LAST_TIME_GOT_CONFIG = "prefsLastTimeGotConfig";
    private static final String PREFS_LAST_TIME_GOT_PUBS = "prefsLastTimeGotPubs";
    private static final String PREFS_LOCAL_PUBS_TS = "prefsLocalPubsTS";
    public static final int USE_DMP_UNKNOWN = 0;
    public static final int USE_DMP_NO = 1;
    public static final int USE_DMP_YES = 2;
    public static final String USE_DMP_OR_UNKNOWN = "USE_DMP_OR_UNKNOWN";
    public static final int INTER_VIDEO_ORIENTAION_LOCKED_AT_LOAD = 0;
    public static final int INTER_VIDEO_ORIENTAION_LOCKED_AT_SHOW = 1;
    public static final int INTER_VIDEO_ORIENTAION_REALTIME = 2;
    public static final int INTER_VIDEO_ORIENTAION_TREATMENT_DEFAULT = 1;
    private static final String INTER_VIDEO_ORIENTAION_TREATMENT = "INTER_VIDEO_ORIENTAION_TREATMENT";
    public static final int INTER_HTML_ORIENTAION_LOCKED_AT_LOAD = 0;
    public static final int INTER_HTML_ORIENTAION_LOCKED_AT_SHOW = 1;
    public static final int INTER_HTML_ORIENTAION_REALTIME = 2;
    public static final int INTER_HTML_ORIENTAION_TREATMENT_DEFAULT = 1;
    private static final String INTER_HTML_ORIENTAION_TREATMENT = "INTER_HTML_ORIENTAION_TREATMENT";
    private int mConfigExists = 0;
    private int mPubsExist = 0;
    private int mScriptsExist = 0;

    private MFXConfiguration(Context ctx) {
        this.parsePublicationsJson(ctx);
    }

    public static MFXConfiguration sharedInstance(Context ctx) {
        if (instance == null) {
            instance = new MFXConfiguration(ctx);
        }
        return instance;
    }

    public void makeSureConfigsAreLoaded(final Context ctx, final OnConfigCallback makeSureCallback) {
        DLog.v("MobfoxSDK", "dbg: ### make Sure Configs Are Loaded ###");
        this.checkConfig(ctx, new OnConfigCallback(){

            @Override
            public void onConfigResult(String error, String returnedConvoyVersion) {
                if (error != null) {
                    ControllerEngine.aquireSdkLock();
                    MFXConfiguration.this.mConfigExists = 1;
                    MFXConfiguration.this.mScriptsExist = 1;
                    ControllerEngine.releaseSdkLock();
                    MFXConfiguration.this.checkIfCheckingDone(ctx, "errCongfig", makeSureCallback);
                } else {
                    ControllerEngine.aquireSdkLock();
                    MFXConfiguration.this.mConfigExists = 2;
                    ControllerEngine.releaseSdkLock();
                    DLog.v("MobfoxSDK", "dbg: ### Convoy Version: " + MFXConfiguration.sharedInstance(ctx).getConvoyVersion(ctx));
                    MFXConfiguration.this.checkScripts(ctx, returnedConvoyVersion, new OnConfigCallback(){

                        @Override
                        public void onConfigResult(String error, String value) {
                            ControllerEngine.aquireSdkLock();
                            if (error != null) {
                                MFXConfiguration.this.mScriptsExist = 1;
                            } else {
                                MFXConfiguration.this.mScriptsExist = 2;
                            }
                            ControllerEngine.releaseSdkLock();
                            MFXConfiguration.this.checkPublications(ctx, new OnConfigCallback(){

                                @Override
                                public void onConfigResult(String error, String value) {
                                    ControllerEngine.aquireSdkLock();
                                    if (error != null) {
                                        MFXConfiguration.this.mPubsExist = 1;
                                    } else {
                                        MFXConfiguration.this.mPubsExist = 2;
                                    }
                                    ControllerEngine.releaseSdkLock();
                                    MFXConfiguration.this.checkIfCheckingDone(ctx, "checkedPubs", makeSureCallback);
                                }
                            });
                        }
                    });
                }
            }
        });
    }

    private void checkIfCheckingDone(Context ctx, String calledFrom, OnConfigCallback cb) {
        boolean bAllFlagsSet = false;
        boolean bFailed = true;
        ControllerEngine.aquireSdkLock();
        if (this.mConfigExists != 0 && this.mPubsExist != 0 && this.mScriptsExist != 0 && this.mConfigExists != 3 && this.mPubsExist != 3 && this.mScriptsExist != 3) {
            bAllFlagsSet = true;
            boolean bl = bFailed = this.mConfigExists == 1 || this.mPubsExist == 1 || this.mScriptsExist == 1;
            if (!bFailed) {
                this.mConfigExists = 3;
                this.mScriptsExist = 3;
                this.mPubsExist = 3;
            }
        }
        ControllerEngine.releaseSdkLock();
        if (bAllFlagsSet) {
            if (bFailed) {
                cb.onConfigResult("no config", null);
            } else {
                DLog.d("MobfoxSDK", "makeSure OK from " + calledFrom + ", C=" + this.mConfigExists + ", S=" + this.mScriptsExist + ", P=" + this.mPubsExist);
                cb.onConfigResult(null, null);
            }
            this.handleQueriesIfNeeded(ctx);
        }
    }

    private void checkConfig(Context ctx, final OnConfigCallback cb) {
        String val1 = MFXConfiguration.sharedInstance(ctx).getUrlSSP(ctx);
        String val2 = MFXConfiguration.sharedInstance(ctx).getConvoyVersion(ctx);
        if (val1 != null && val1.length() > 0 && val2 != null && val2.length() > 0) {
            cb.onConfigResult(null, val2);
        } else {
            this.TryToGetConfiguration(ctx, new OnConfigCallback(){

                @Override
                public void onConfigResult(String error, String value) {
                    cb.onConfigResult(error, value);
                }
            });
        }
    }

    private void checkPublications(Context ctx, final OnConfigCallback cb) {
        JSONArray arrPubs = MFXConfiguration.sharedInstance(ctx).readPublicationsJson(ctx);
        if (arrPubs.length() > 0) {
            cb.onConfigResult(null, null);
        } else {
            this.TryToGetPublications(ctx, new OnConfigCallback(){

                @Override
                public void onConfigResult(String error, String value) {
                    cb.onConfigResult(error, null);
                }
            });
        }
    }

    private void checkScripts(Context ctx, String convoyVersion, final OnConfigCallback cb) {
        String val = MFXConfiguration.sharedInstance(ctx).getControllerScript(ctx);
        if (val.length() > 0) {
            cb.onConfigResult(null, null);
        } else {
            this.TryToGetScripts(ctx, convoyVersion, new OnConfigCallback(){

                @Override
                public void onConfigResult(String error, String value) {
                    cb.onConfigResult(error, null);
                }
            });
        }
    }

    private void handleQueriesIfNeeded(Context ctx) {
        long ttlConfig;
        long lastTimeConfig;
        long now = System.currentTimeMillis();
        if (now > (lastTimeConfig = MFXStorage.sharedInstance(ctx).getPrefLong(PREFS_LAST_TIME_GOT_CONFIG, 0L)) + (ttlConfig = this.getTTLConfig(ctx))) {
            this.SetNextConfigPollingTrigger(ctx, 100L);
        } else {
            this.SetNextConfigPollingTrigger(ctx, lastTimeConfig + ttlConfig - now);
        }
        long lastTimePubs = MFXStorage.sharedInstance(ctx).getPrefLong(PREFS_LAST_TIME_GOT_PUBS, 0L);
        long ttlPubs = this.getPublicationsTTLConfig(ctx);
        if (now > lastTimePubs + ttlPubs || this.getForceUpdatePublications(ctx)) {
            this.SetNextPubsPollingTrigger(ctx, 100L);
        } else {
            this.SetNextPubsPollingTrigger(ctx, lastTimePubs + ttlPubs - now);
        }
    }

    private void StopConfigPollingCounter() {
        if (mConfigPollingCounter != null) {
            mConfigPollingCounter.cancel();
            mConfigPollingCounter = null;
        }
    }

    private void SetNextConfigPollingTrigger(final Context ctx, final long delay) {
        Activity ctxForUse = null;
        try {
            ctxForUse = (Activity)ctx;
            ctxForUse.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    MFXConfiguration.this.ReallySetNextConfigPollingTrigger(ctx, delay);
                }
            });
        }
        catch (ClassCastException cce) {
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    MFXConfiguration.this.ReallySetNextConfigPollingTrigger(ctx, delay);
                }
            });
        }
    }

    private void ReallySetNextConfigPollingTrigger(Context ctx, long delay) {
        this.StopConfigPollingCounter();
        mConfigPollingContext = ctx;
        DLog.d("MobfoxSDK", "dbg: ### Trigger next Config query for: " + delay);
        long period = delay / 20L;
        if (period == 0L) {
            period = 1L;
        }
        if ((mConfigPollingCounter = new CountDownTimer(delay, period){

            public void onTick(long millisUntilFinished) {
            }

            public void onFinish() {
                mConfigPollingCounter = null;
                MFXConfiguration.sharedInstance(mConfigPollingContext).TryToGetConfiguration(mConfigPollingContext, null);
            }
        }) != null) {
            mConfigPollingCounter.start();
        }
    }

    private void StopPubsPollingCounter() {
        if (mPubsPollingCounter != null) {
            mPubsPollingCounter.cancel();
            mPubsPollingCounter = null;
        }
    }

    private void SetNextPubsPollingTrigger(final Context ctx, final long delay) {
        Activity ctxForUse = null;
        try {
            ctxForUse = (Activity)ctx;
            ctxForUse.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    MFXConfiguration.this.ReallySetNextPubsPollingTrigger(ctx, delay);
                }
            });
        }
        catch (ClassCastException cce) {
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    MFXConfiguration.this.ReallySetNextPubsPollingTrigger(ctx, delay);
                }
            });
        }
    }

    private void ReallySetNextPubsPollingTrigger(final Context ctx, long delay) {
        this.StopPubsPollingCounter();
        mPubsPollingContext = ctx;
        DLog.d("MobfoxSDK", "dbg: ### Trigger next Publications query for: " + delay);
        long period = delay / 20L;
        if (period == 0L) {
            period = 1L;
        }
        if ((mPubsPollingCounter = new CountDownTimer(delay, period){

            public void onTick(long millisUntilFinished) {
            }

            public void onFinish() {
                mPubsPollingCounter = null;
                long localPublicationsTS = MFXStorage.sharedInstance(ctx).getPrefLong(MFXConfiguration.PREFS_LOCAL_PUBS_TS, 0L);
                long serverPublicationsTS = MFXStorage.sharedInstance(ctx).getPrefLong(MFXConfiguration.PUBLICATIONS_TS, 0L);
                if (localPublicationsTS == 0L || serverPublicationsTS == 0L || serverPublicationsTS > localPublicationsTS) {
                    MFXConfiguration.sharedInstance(mPubsPollingContext).TryToGetPublications(mPubsPollingContext, null);
                } else {
                    DLog.v("MobfoxSDK", "dbg: ### Publications timestamp is up to date, so re-trigerring ###");
                    MFXConfiguration.this.SetNextPubsPollingTrigger(ctx, MFXConfiguration.this.getPublicationsTTLConfig(ctx));
                }
            }
        }) != null) {
            mPubsPollingCounter.start();
        }
    }

    private void TryToGetConfiguration(final Context ctx, final OnConfigCallback cb) {
        String url = "https://sdk.starbolt.io/api/init";
        String ts = String.valueOf(System.currentTimeMillis());
        String pkg = ctx.getPackageName();
        String key = this.GetAsafStuff(ts, pkg);
        long lastConfigTS = MFXStorage.sharedInstance(ctx).getPrefLong(CONFIGURATION_TS, 0L);
        url = url + "?ts=" + ts;
        url = url + "&app_identifier=" + pkg;
        url = url + "&key=" + key;
        if (lastConfigTS != 0L) {
            url = url + "&config_ts=" + lastConfigTS;
        }
        url = url + "&platform=android";
        DLog.d("MobfoxSDK", "dbg: ### Config url: " + url);
        long now = System.currentTimeMillis();
        MFXStorage.sharedInstance(ctx).setPrefLong(PREFS_LAST_TIME_GOT_CONFIG, now);
        StringRequest strRequest = new StringRequest(0, url, (Response.Listener)new Response.Listener<String>(){

            public void onResponse(String response) {
                block6: {
                    if (response != null && response.equalsIgnoreCase("ok")) {
                        MFXConfiguration.this.SetNextConfigPollingTrigger(ctx, MFXConfiguration.this.getTTLConfig(ctx));
                        if (cb != null) {
                            cb.onConfigResult(null, MFXConfiguration.this.getConvoyVersion(ctx));
                        }
                        return;
                    }
                    try {
                        JSONObject jsonResponse = new JSONObject(response);
                        String returnedConfig = MFXConfiguration.this.saveConfigJson(ctx, jsonResponse, cb == null);
                        MFXConfiguration.this.SetNextConfigPollingTrigger(ctx, MFXConfiguration.this.getTTLConfig(ctx));
                        if (cb != null) {
                            cb.onConfigResult(null, returnedConfig);
                        }
                    }
                    catch (JSONException e) {
                        DLog.e("MobfoxSDK", "dbg: ### Config json err: " + e.getMessage());
                        MFXConfiguration.this.SetNextConfigPollingTrigger(ctx, MFXConfiguration.this.getTTLConfig(ctx));
                        if (cb == null) break block6;
                        if (e == null || e.toString() == null || e.toString().length() == 0) {
                            cb.onConfigResult("unknown error", null);
                        }
                        cb.onConfigResult(e.getMessage(), null);
                    }
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                DLog.e("MobfoxSDK", "dbg: ### Config err: " + error.toString());
                MFXConfiguration.this.SetNextConfigPollingTrigger(ctx, MFXConfiguration.this.getTTLConfig(ctx));
                if (cb != null) {
                    if (error == null || error.toString() == null || error.toString().length() == 0) {
                        cb.onConfigResult("unknown error", null);
                    } else {
                        cb.onConfigResult(error.toString(), null);
                    }
                }
            }
        });
        Networking.sharedInstance(ctx).StartVolleyRequest(ctx, strRequest);
    }

    private void TryToGetPublications(final Context ctx, final OnConfigCallback cb) {
        String url = "https://sdk.starbolt.io/api/publications";
        String ts = String.valueOf(System.currentTimeMillis());
        String pkg = ctx.getPackageName();
        String key = this.GetAsafStuff(ts, pkg);
        url = url + "?ts=" + ts;
        url = url + "&platform=android";
        url = url + "&app_identifier=" + pkg;
        url = url + "&key=" + key;
        DLog.d("MobfoxSDK", "dbg: ### Publications url: " + url);
        long now = System.currentTimeMillis();
        MFXStorage.sharedInstance(ctx).setPrefLong(PREFS_LAST_TIME_GOT_PUBS, now);
        JsonArrayRequest jsonRequest = new JsonArrayRequest(0, url, null, (Response.Listener)new Response.Listener<JSONArray>(){

            public void onResponse(JSONArray response) {
                MFXConfiguration.this.savePublicationsJson(ctx, response);
                MFXConfiguration.this.parsePublicationsJson(ctx);
                MFXConfiguration.this.SetNextPubsPollingTrigger(ctx, MFXConfiguration.this.getPublicationsTTLConfig(ctx));
                DLog.v("MobfoxSDK", "dbg: ### Publications read OK, so updating local timestamp ###");
                long serverPublicationsTS = MFXStorage.sharedInstance(ctx).getPrefLong(MFXConfiguration.PUBLICATIONS_TS, 0L);
                MFXStorage.sharedInstance(ctx).setPrefLong(MFXConfiguration.PREFS_LOCAL_PUBS_TS, serverPublicationsTS);
                if (cb != null) {
                    cb.onConfigResult(null, null);
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                DLog.e("MobfoxSDK", "dbg: ### Publications err: " + error.toString());
                MFXConfiguration.this.SetNextPubsPollingTrigger(ctx, MFXConfiguration.this.getPublicationsTTLConfig(ctx));
                if (cb != null) {
                    if (error == null || error.toString() == null || error.toString().length() == 0) {
                        cb.onConfigResult("unknown error", null);
                    } else {
                        cb.onConfigResult(error.toString(), null);
                    }
                }
            }
        });
        Networking.sharedInstance(ctx).StartVolleyRequest(ctx, jsonRequest);
    }

    private void TryToGetScripts(final Context ctx, String convoyVersion, final OnConfigCallback cb) {
        String url = "https://sdk.starbolt.io/api/scripts";
        String ts = String.valueOf(System.currentTimeMillis());
        String pkg = ctx.getPackageName();
        String key = this.GetAsafStuff(ts, pkg);
        url = url + "?ts=" + ts;
        url = url + "&app_identifier=" + pkg;
        url = url + "&key=" + key;
        url = url + "&convoy_version=" + convoyVersion;
        url = url + "&platform=android";
        DLog.d("MobfoxSDK", "dbg: ### Scripts url: " + url);
        JsonObjectRequest jsonRequest = new JsonObjectRequest(0, url, null, (Response.Listener)new Response.Listener<JSONObject>(){

            public void onResponse(JSONObject response) {
                MFXConfiguration.this.saveScriptsJson(ctx, response);
                if (cb != null) {
                    cb.onConfigResult(null, null);
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                DLog.e("MobfoxSDK", "dbg: ### Scripts err: " + error.toString());
                if (cb != null) {
                    if (error == null || error.toString() == null || error.toString().length() == 0) {
                        cb.onConfigResult("unknown error", null);
                    } else {
                        cb.onConfigResult(error.toString(), null);
                    }
                }
            }
        });
        Networking.sharedInstance(ctx).StartVolleyRequest(ctx, jsonRequest);
    }

    private String GetAsafStuff(String ts, String pkg) {
        try {
            String stuff = "The-well-steams-against-a-bath";
            String message = ts + pkg;
            Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
            SecretKeySpec secret_key = new SecretKeySpec(stuff.getBytes(), "HmacSHA256");
            sha256_HMAC.init(secret_key);
            String hash = Base64.encodeToString((byte[])sha256_HMAC.doFinal(message.getBytes()), (int)2);
            return URLEncoder.encode(hash, "UTF-8");
        }
        catch (Exception e) {
            return null;
        }
    }

    private String saveConfigJson(Context ctx, JSONObject response, boolean andTryScriptsIfNeeded) {
        DLog.d("MobfoxSDK", "dbg: ### Config resp: " + response.toString());
        String currConvoyVersion = this.getConvoyVersion(ctx);
        String convoy_version = "";
        try {
            String reporting_server_url;
            String convoy_url;
            String dmp_url;
            String ssp_url;
            String app_identifier = response.optString(MFXUtils.validateName(response, APP_IDENTIFIER));
            if (app_identifier != null) {
                MFXStorage.sharedInstance(ctx).setPrefString(APP_IDENTIFIER, app_identifier);
            }
            if ((ssp_url = response.optString(MFXUtils.validateName(response, SSP_URL))) != null) {
                MFXStorage.sharedInstance(ctx).setPrefString(SSP_URL, ssp_url);
            }
            if ((dmp_url = response.optString(MFXUtils.validateName(response, DMP_URL))) != null) {
                MFXStorage.sharedInstance(ctx).setPrefString(DMP_URL, dmp_url);
            }
            if ((convoy_url = response.optString(MFXUtils.validateName(response, CONVOY_URL))) != null) {
                MFXStorage.sharedInstance(ctx).setPrefString(CONVOY_URL, convoy_url);
            }
            if ((convoy_version = response.optString(MFXUtils.validateName(response, CONVOY_VERSION))) != null) {
                MFXStorage.sharedInstance(ctx).setPrefString(CONVOY_VERSION, convoy_version);
            }
            if ((reporting_server_url = response.optString(MFXUtils.validateName(response, REPORTING_SERVER_URL))) != null) {
                MFXStorage.sharedInstance(ctx).setPrefString(REPORTING_SERVER_URL, reporting_server_url);
            }
            int refreshRate = -1;
            if (response.has(REFRESH_RATE)) {
                refreshRate = response.optInt(MFXUtils.validateName(response, REFRESH_RATE));
                MFXStorage.sharedInstance(ctx).setPrefInt(REFRESH_RATE, refreshRate);
            }
            long ttl = response.optLong(MFXUtils.validateName(response, "TTL"));
            MFXStorage.sharedInstance(ctx).setPrefLong(TTL, ttl);
            long pubs_ttl = response.optLong(MFXUtils.validateName(response, PUBS_TTL));
            if (pubs_ttl <= 0L) {
                pubs_ttl = ttl;
            }
            MFXStorage.sharedInstance(ctx).setPrefLong(PUBS_TTL, pubs_ttl);
            long scripts_ttl = response.optLong(MFXUtils.validateName(response, SCRIPTS_TTL));
            if (scripts_ttl <= 0L) {
                scripts_ttl = ttl;
            }
            MFXStorage.sharedInstance(ctx).setPrefLong(SCRIPTS_TTL, scripts_ttl);
            long new_config_ts = response.optLong(MFXUtils.validateName(response, CONFIGURATION_TS));
            MFXStorage.sharedInstance(ctx).setPrefLong(CONFIGURATION_TS, new_config_ts);
            long new_pubs_ts = response.optLong(MFXUtils.validateName(response, PUBLICATIONS_TS));
            MFXStorage.sharedInstance(ctx).setPrefLong(PUBLICATIONS_TS, new_pubs_ts);
            boolean force_update = response.optBoolean(MFXUtils.validateName(response, FORCE_UPDATE));
            MFXStorage.sharedInstance(ctx).setPrefBool(FORCE_UPDATE, force_update);
            MFXStorage.sharedInstance(ctx).setPrefBool(FORCE_UPDATE_PUBS, force_update);
            MFXStorage.sharedInstance(ctx).setPrefBool(FORCE_UPDATE_SCRIPTS, force_update);
            boolean kill_switch = response.optBoolean(MFXUtils.validateName(response, KILL_SWITCH));
            MFXStorage.sharedInstance(ctx).setPrefBool(KILL_SWITCH, kill_switch);
            boolean use_dmp = response.optBoolean(MFXUtils.validateName(response, USE_DMP));
            MFXStorage.sharedInstance(ctx).setPrefBool(USE_DMP, use_dmp);
            int last_use_dmp = MFXStorage.sharedInstance(ctx).getPrefInt(USE_DMP_OR_UNKNOWN, 0);
            MFXStorage.sharedInstance(ctx).setPrefInt(USE_DMP_OR_UNKNOWN, use_dmp ? 2 : 1);
            switch (last_use_dmp) {
                case 0: 
                case 1: {
                    if (!use_dmp) break;
                    DMPUtils.postDMPFromDMP(ctx);
                    DMPUtils.startMobFoxServiceFromDMP(ctx, true);
                    break;
                }
                case 2: {
                    if (use_dmp) break;
                    DMPUtils.stopMobFoxServiceFromDMP(ctx);
                }
            }
            int interVideoOrientationtreatment = 1;
            if (response.has(INTER_VIDEO_ORIENTAION_TREATMENT)) {
                interVideoOrientationtreatment = response.optInt(MFXUtils.validateName(response, INTER_VIDEO_ORIENTAION_TREATMENT));
            }
            MFXStorage.sharedInstance(ctx).setPrefInt(INTER_VIDEO_ORIENTAION_TREATMENT, interVideoOrientationtreatment);
            int interHtmlOrientationtreatment = 1;
            if (response.has(INTER_HTML_ORIENTAION_TREATMENT)) {
                interHtmlOrientationtreatment = response.optInt(MFXUtils.validateName(response, INTER_HTML_ORIENTAION_TREATMENT));
            }
            MFXStorage.sharedInstance(ctx).setPrefInt(INTER_HTML_ORIENTAION_TREATMENT, interHtmlOrientationtreatment);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (andTryScriptsIfNeeded && (this.getControllerScript(ctx).length() == 0 || !currConvoyVersion.equalsIgnoreCase(convoy_version) || this.getForceUpdateScripts(ctx))) {
            this.TryToGetScripts(ctx, convoy_version, null);
        }
        return convoy_version;
    }

    private void savePublicationsJson(Context ctx, JSONArray response) {
        DLog.d("MobfoxSDK", "dbg: ### Publications resp: " + response.toString());
        try {
            MFXStorage.sharedInstance(ctx).setPrefString(PUBLICATIONS_ARRAY, response.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private JSONArray readPublicationsJson(Context ctx) {
        String publicationsStr = MFXStorage.sharedInstance(ctx).getPrefString(PUBLICATIONS_ARRAY, "[]");
        String fromFile = MFXUtils.readFileContentFromAssetsFolder(ctx, "publications.json");
        if (fromFile != null) {
            publicationsStr = fromFile;
        }
        JSONArray arrPubs = new JSONArray();
        try {
            arrPubs = new JSONArray(publicationsStr);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return arrPubs;
    }

    private void parsePublicationsJson(Context ctx) {
        JSONArray arrPubs = this.readPublicationsJson(ctx);
        this.mArrPublications.clear();
        try {
            if (arrPubs != null && arrPubs.length() > 0) {
                int tot = arrPubs.length();
                for (int i = 0; i < tot; ++i) {
                    JSONObject jsonRec = arrPubs.getJSONObject(i);
                    this.mArrPublications.add(jsonRec);
                }
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public boolean openInExternal(String in_invh) {
        if (this.mArrPublications != null && this.mArrPublications.size() > 0) {
            for (JSONObject rec : this.mArrPublications) {
                JSONObject features;
                String invh;
                if (rec == null || (invh = MFXUtils.getStringFromDict(rec, "invh")) == null || !invh.equalsIgnoreCase(in_invh) || (features = MFXUtils.getDictFromDict(rec, "features")) == null) continue;
                return MFXUtils.getBoolFromDict(features, "openInExternal");
            }
        }
        return false;
    }

    public int getPublicationRefreshPeriod(String in_invh) {
        if (this.mArrPublications != null && this.mArrPublications.size() > 0) {
            for (JSONObject rec : this.mArrPublications) {
                String invh;
                if (rec == null || (invh = MFXUtils.getStringFromDict(rec, "invh")) == null || !invh.equalsIgnoreCase(in_invh) || !rec.has(REFRESH_RATE)) continue;
                return MFXUtils.getIntFromDict(rec, REFRESH_RATE);
            }
        }
        return -1;
    }

    public JSONObject getPublicationForInvh(String in_invh) {
        if (this.mArrPublications != null && this.mArrPublications.size() > 0) {
            for (JSONObject rec : this.mArrPublications) {
                String invh;
                if (rec == null || (invh = MFXUtils.getStringFromDict(rec, "invh")) == null || !invh.equalsIgnoreCase(in_invh)) continue;
                return rec;
            }
        }
        return null;
    }

    private void saveScriptsJson(Context ctx, JSONObject response) {
        try {
            String video_html;
            String tag_html;
            String controller_html = response.optString(MFXUtils.validateName(response, CONTROLLER_HTML));
            if (controller_html != null) {
                DLog.d("MobfoxSDK", "dbg: ### Scripts resp: Got controller OK");
                MFXStorage.sharedInstance(ctx).setPrefString(CONTROLLER_HTML, controller_html);
            }
            if ((tag_html = response.optString(MFXUtils.validateName(response, TAG_HTML))) != null) {
                DLog.d("MobfoxSDK", "dbg: ### Scripts resp: Got tag.html OK");
                MFXStorage.sharedInstance(ctx).setPrefString(TAG_HTML, tag_html);
            }
            if ((video_html = response.optString(MFXUtils.validateName(response, VIDEO_HTML))) != null) {
                DLog.d("MobfoxSDK", "dbg: ### Scripts resp: Got video.html OK");
                MFXStorage.sharedInstance(ctx).setPrefString(VIDEO_HTML, video_html);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getControllerScript(Context ctx) {
        String res = MFXStorage.sharedInstance(ctx).getPrefString(CONTROLLER_HTML, "");
        return res;
    }

    public String getTagScript(Context ctx) {
        String res = MFXStorage.sharedInstance(ctx).getPrefString(TAG_HTML, "");
        return res;
    }

    public String getVideoScript(Context ctx) {
        String res = MFXStorage.sharedInstance(ctx).getPrefString(VIDEO_HTML, "");
        return res;
    }

    protected String getUrlSSP(Context ctx) {
        String res = MFXStorage.sharedInstance(ctx).getPrefString(SSP_URL, "");
        return res;
    }

    public String getUrlDMP(Context ctx) {
        String res = MFXStorage.sharedInstance(ctx).getPrefString(DMP_URL, "");
        return res;
    }

    protected String getConvoySSP(Context ctx) {
        String res = MFXStorage.sharedInstance(ctx).getPrefString(CONVOY_URL, "");
        return res;
    }

    protected String getConvoyVersion(Context ctx) {
        String res = MFXStorage.sharedInstance(ctx).getPrefString(CONVOY_VERSION, "");
        return res;
    }

    protected String getUrlReportingServer(Context ctx) {
        String res = MFXStorage.sharedInstance(ctx).getPrefString(REPORTING_SERVER_URL, "");
        return res;
    }

    protected long getTTLConfig(Context ctx) {
        long res = MFXStorage.sharedInstance(ctx).getPrefLong(TTL, 3600000L);
        return res;
    }

    protected long getPublicationsTTLConfig(Context ctx) {
        long res = MFXStorage.sharedInstance(ctx).getPrefLong(PUBS_TTL, 3600000L);
        return res;
    }

    protected long getScriptsTTLConfig(Context ctx) {
        long res = MFXStorage.sharedInstance(ctx).getPrefLong(SCRIPTS_TTL, 3600000L);
        return res;
    }

    public int getRefreshRateConfig(Context ctx) {
        int res = MFXStorage.sharedInstance(ctx).getPrefInt(REFRESH_RATE, 10);
        return res;
    }

    protected boolean getForceUpdate(Context ctx) {
        boolean res = MFXStorage.sharedInstance(ctx).getPrefBool(FORCE_UPDATE, false);
        if (res) {
            DLog.v("MobfoxSDK", "dbg: ### FORCE_UPDATE ###");
        }
        return res;
    }

    protected boolean getForceUpdatePublications(Context ctx) {
        boolean res = MFXStorage.sharedInstance(ctx).getPrefBool(FORCE_UPDATE_PUBS, false);
        MFXStorage.sharedInstance(ctx).setPrefBool(FORCE_UPDATE_PUBS, false);
        if (res) {
            DLog.v("MobfoxSDK", "dbg: ### FORCE_UPDATE_PUBS ###");
        }
        return res;
    }

    protected boolean getForceUpdateScripts(Context ctx) {
        boolean res = MFXStorage.sharedInstance(ctx).getPrefBool(FORCE_UPDATE_SCRIPTS, false);
        MFXStorage.sharedInstance(ctx).setPrefBool(FORCE_UPDATE_SCRIPTS, false);
        if (res) {
            DLog.v("MobfoxSDK", "dbg: ### FORCE_UPDATE_SCRIPTS ###");
        }
        return res;
    }

    protected boolean getKillSwitch(Context ctx) {
        boolean res = MFXStorage.sharedInstance(ctx).getPrefBool(KILL_SWITCH, false);
        return res;
    }

    public int getUseDMPOrUnknown(Context ctx) {
        int res = MFXStorage.sharedInstance(ctx).getPrefInt(USE_DMP_OR_UNKNOWN, 0);
        return res;
    }

    public boolean needToStartDMP(Context ctx) {
        int res = this.getUseDMPOrUnknown(ctx);
        return res == 2;
    }

    public int getInterstitialVideoTreatment(Context ctx) {
        int res = MFXStorage.sharedInstance(ctx).getPrefInt(INTER_VIDEO_ORIENTAION_TREATMENT, 1);
        return res;
    }

    public int getInterstitialHtmlTreatment(Context ctx) {
        int res = MFXStorage.sharedInstance(ctx).getPrefInt(INTER_HTML_ORIENTAION_TREATMENT, 1);
        return res;
    }

    static {
        mConfigPollingCounter = null;
        mConfigPollingContext = null;
        mPubsPollingCounter = null;
        mPubsPollingContext = null;
    }

    public static interface OnConfigCallback {
        public void onConfigResult(String var1, String var2);
    }
}

