/*
 * Decompiled with CFR 0.152.
 */
package com.mobfox.android.core;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.util.DisplayMetrics;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.JsResult;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import androidx.core.graphics.drawable.DrawableCompat;
import com.mobfox.android.JSInterface.LocalStorageAPI;
import com.mobfox.android.core.DLog;
import com.mobfox.android.core.MFXConfiguration;
import com.mobfox.android.core.logging.MobFoxReport;

public class InAppBrowser
extends Activity {
    protected static final String FIELD_NAME_URL = "url";
    private static final int BAR_COLOR = -986896;
    private static final int DARK_COLOR = -8421505;
    private static final int LITE_COLOR = -4144960;
    private static Intent mBrowserIntent = null;
    private ScrollView mScrollView;
    private LinearLayout mLinearLayout;
    private WebView mWebView = null;
    private TextView mTitle;
    private LeftArrowButton mBtnPrev;
    private Button mBtnNext;
    private Button mBtnClose;
    private Button mBtnOpenExternal;
    private Button mBtnRefresh;
    private ProgressBar actInd;
    private String mHomeURL;
    private String mCurrURL;
    private static int mButtonHeight;
    private static int mButtonStroke;
    boolean loadingFinished = true;
    boolean redirect = false;
    private Context mCtx = null;
    private Handler mOpenWebTimerHandler = new Handler();
    private long mOpenWebTimerStartTime = 0L;
    private Runnable mOpenWebTimerTask = new Runnable(){

        @Override
        public void run() {
            if (InAppBrowser.this.mOpenWebTimerStartTime != 0L) {
                InAppBrowser.this.mOpenWebTimerHandler.removeCallbacks(InAppBrowser.this.mOpenWebTimerTask);
                InAppBrowser.this.mOpenWebTimerStartTime = 0L;
                if (InAppBrowser.this.mWebView != null) {
                    InAppBrowser.this.mWebView.loadUrl(InAppBrowser.this.mCurrURL);
                }
                InAppBrowser.this.UpdateButtons();
            }
        }
    };
    private static double g_fScreenRatio;
    private static int g_nScreenWidth;

    private static boolean NeedsSystemToOpenUrl(String url) {
        if (url.startsWith("market://") || url.startsWith("intent://") || url.startsWith("deeplink://") || url.startsWith("tel://") || url.startsWith("sms://") || url.startsWith("mailto://")) {
            return true;
        }
        if (!(url.startsWith("www") || url.startsWith("http://") || url.startsWith("https://"))) {
            return true;
        }
        return url.startsWith("https://play.google.com/store/apps/details");
    }

    public static void OpenBrowserWithURL(final Context ctx, final String url, final String invh) {
        if (url == null) {
            return;
        }
        DLog.i("MobfoxSDK", "dbg: ### Open url: " + url);
        new Handler(ctx.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                if (InAppBrowser.NeedsSystemToOpenUrl(url)) {
                    InAppBrowser.OpenURL(ctx, url);
                    return;
                }
                if (!MFXConfiguration.sharedInstance(ctx).openInExternal(invh)) {
                    try {
                        mBrowserIntent = new Intent(ctx, InAppBrowser.class);
                        mBrowserIntent.setFlags(0x10000000);
                        mBrowserIntent.putExtra(InAppBrowser.FIELD_NAME_URL, url);
                        ctx.startActivity(mBrowserIntent);
                        return;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                InAppBrowser.OpenURL(ctx, url);
            }
        });
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        this.mCtx = this;
        MobFoxReport.register((Context)this);
        InAppBrowser.CalcScreenRatio((Context)this);
        mButtonHeight = InAppBrowser.CalcDPIToReal((Context)this, 50);
        mButtonStroke = InAppBrowser.CalcDPIToReal((Context)this, 3);
        try {
            Intent intent = this.getIntent();
            this.mHomeURL = intent.getStringExtra(FIELD_NAME_URL);
            int n = this.getResources().getConfiguration().orientation;
        }
        catch (Exception e) {
            this.deallocateBrowser();
            return;
        }
        this.SetupViews();
        if (this.mWebView != null) {
            if (Build.VERSION.SDK_INT >= 19) {
                WebView.setWebContentsDebuggingEnabled((boolean)true);
            }
            this.mWebView.getSettings().setJavaScriptEnabled(true);
            this.mWebView.getSettings().setAppCacheEnabled(true);
            this.mWebView.getSettings().setDomStorageEnabled(true);
            if (Build.VERSION.SDK_INT >= 21) {
                this.mWebView.getSettings().setMixedContentMode(0);
            }
            if (Build.VERSION.SDK_INT >= 19) {
                this.mWebView.getSettings().setMediaPlaybackRequiresUserGesture(false);
            }
            this.mWebView.addJavascriptInterface((Object)new LocalStorageAPI(), "localStorage");
            this.mWebView.setWebViewClient((WebViewClient)new HellomWebViewClient());
            this.mWebView.setInitialScale(100);
            this.mWebView.setScrollBarStyle(0x2000000);
            this.mWebView.setVerticalScrollBarEnabled(false);
            this.mScrollView.setVerticalScrollBarEnabled(false);
            this.mWebView.requestFocus(130);
            this.mWebView.getSettings().setLoadWithOverviewMode(true);
            this.mWebView.getSettings().setUseWideViewPort(true);
            this.mWebView.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View v, MotionEvent event) {
                    switch (event.getAction()) {
                        case 0: 
                        case 1: {
                            if (v.hasFocus()) break;
                            v.requestFocus();
                        }
                    }
                    return false;
                }
            });
            this.mWebView.setWebChromeClient(new WebChromeClient(){

                public boolean onJsAlert(WebView view, String url, String message, final JsResult result) {
                    new AlertDialog.Builder((Context)InAppBrowser.this).setTitle((CharSequence)"javaScript dialog").setMessage((CharSequence)message).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface arg0, int arg1) {
                            result.confirm();
                        }
                    }).setCancelable(false).create().show();
                    return true;
                }
            });
        }
        this.mCurrURL = this.mHomeURL;
        this.StartOpenWebTimer();
        this.UpdateButtons();
    }

    public void onResume() {
        super.onResume();
        if (this.mWebView != null) {
            this.mWebView.setInitialScale(100);
        }
    }

    public void onPause() {
        super.onPause();
    }

    private void TurnRotatingIndicatorOnOff(boolean bOn) {
        this.actInd.setVisibility(bOn ? 0 : 4);
    }

    private void StartOpenWebTimer() {
        if (this.mOpenWebTimerStartTime == 0L) {
            this.mOpenWebTimerStartTime = System.currentTimeMillis();
            this.mOpenWebTimerHandler.removeCallbacks(this.mOpenWebTimerTask);
            this.mOpenWebTimerHandler.postDelayed(this.mOpenWebTimerTask, 200L);
            this.TurnRotatingIndicatorOnOff(true);
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            if (this.mWebView != null && this.mWebView.canGoBack()) {
                this.mWebView.goBack();
            } else {
                this.deallocateBrowser();
            }
            return true;
        }
        if (keyCode == 82) {
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    private void UpdateButtons() {
        if (this.mWebView != null) {
            this.mBtnPrev.setEnabled(this.mWebView.canGoBack());
            this.mBtnNext.setEnabled(this.mWebView.canGoForward());
        }
    }

    private void btnClosePressed() {
        this.deallocateBrowser();
    }

    private void deallocateBrowser() {
        if (this.mWebView != null) {
            this.mWebView.destroy();
            this.mWebView = null;
        }
        this.finish();
    }

    private void btnRefreshPressed() {
        this.StartOpenWebTimer();
    }

    private void btnHomePressed() {
        this.mCurrURL = this.mHomeURL;
        this.StartOpenWebTimer();
    }

    private void btnPrevPressed() {
        if (this.mWebView == null) {
            return;
        }
        if (this.mWebView.canGoBack()) {
            this.mWebView.goBack();
        }
    }

    private void btnNextPressed() {
        if (this.mWebView == null) {
            return;
        }
        if (this.mWebView.canGoForward()) {
            this.mWebView.goForward();
        }
    }

    private void btnOpenExternalPressed() {
        InAppBrowser.OpenURL((Context)this, this.mHomeURL);
    }

    private static void OpenURL(Context ctx, String url) {
        String[] parts;
        if (url.startsWith("https://play.google.com/store/apps/details?id") && (parts = url.split("=")).length > 1) {
            String marketUrl = "market://details?id=" + parts[1];
            InAppBrowser.OpenURL(ctx, marketUrl);
            return;
        }
        if (InAppBrowser.OpenURLWithBrowser(ctx, url, "com.android.chrome")) {
            return;
        }
        if (InAppBrowser.OpenURLWithBrowser(ctx, url, "com.android.browser")) {
            return;
        }
        InAppBrowser.OpenURLWithBrowser(ctx, url, null);
    }

    private static boolean OpenURLWithBrowser(Context ctx, String url, String browserPackage) {
        Intent i = new Intent();
        i.setAction("android.intent.action.VIEW");
        i.addCategory("android.intent.category.BROWSABLE");
        if (browserPackage != null) {
            i.setPackage(browserPackage);
        }
        i.setData(Uri.parse((String)url));
        try {
            ctx.startActivity(i);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (resultCode == 1) {
            this.deallocateBrowser();
        }
    }

    @SuppressLint(value={"ResourceType"})
    private void SetupViews() {
        int nWidth = this.getResources().getDisplayMetrics().widthPixels;
        int nHeight = this.getResources().getDisplayMetrics().heightPixels;
        int barHeight = mButtonHeight;
        int statusBarHeight = 0;
        int resourceId = this.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            statusBarHeight = this.getResources().getDimensionPixelSize(resourceId);
        }
        nHeight = nHeight - 2 * barHeight - statusBarHeight;
        if (Build.VERSION.SDK_INT >= 21) {
            this.getWindow().setStatusBarColor(-16777216);
        }
        LinearLayout relAll = new LinearLayout((Context)this);
        LinearLayout.LayoutParams relLP = new LinearLayout.LayoutParams(-1, nHeight);
        relAll.setOrientation(1);
        relAll.setLayoutParams((ViewGroup.LayoutParams)relLP);
        relAll.setBackgroundColor(-16777216);
        this.setContentView((View)relAll);
        LinearLayout relTopBar = new LinearLayout((Context)this);
        LinearLayout.LayoutParams relTop = new LinearLayout.LayoutParams(-1, barHeight);
        relTopBar.setOrientation(0);
        relTopBar.setLayoutParams((ViewGroup.LayoutParams)relTop);
        relTopBar.setBackgroundColor(-986896);
        relAll.addView((View)relTopBar);
        if (Build.VERSION.SDK_INT >= 21) {
            relTopBar.setElevation(2.0f);
        }
        this.mBtnClose = new XButton((Context)this);
        LinearLayout.LayoutParams relX = new LinearLayout.LayoutParams(barHeight, barHeight);
        this.mBtnClose.setLayoutParams((ViewGroup.LayoutParams)relX);
        this.mBtnClose.setBackgroundColor(0);
        relTopBar.addView((View)this.mBtnClose);
        this.mBtnClose.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                InAppBrowser.this.btnClosePressed();
            }
        });
        this.mTitle = new TextView((Context)this);
        LinearLayout.LayoutParams titleLP = new LinearLayout.LayoutParams(0, barHeight);
        titleLP.weight = 1.0f;
        this.mTitle.setLayoutParams((ViewGroup.LayoutParams)titleLP);
        this.mTitle.setBackgroundColor(0);
        this.mTitle.setTextColor(-8421505);
        this.mTitle.setGravity(17);
        this.mTitle.setTextSize(18.0f);
        this.mTitle.setText((CharSequence)"");
        relTopBar.addView((View)this.mTitle);
        this.mBtnRefresh = new RefreshButton((Context)this);
        LinearLayout.LayoutParams relRefresh = new LinearLayout.LayoutParams(barHeight, barHeight);
        this.mBtnRefresh.setLayoutParams((ViewGroup.LayoutParams)relRefresh);
        this.mBtnRefresh.setBackgroundColor(0);
        relTopBar.addView((View)this.mBtnRefresh);
        this.mBtnRefresh.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                InAppBrowser.this.btnRefreshPressed();
            }
        });
        this.mScrollView = new ScrollView((Context)this);
        LinearLayout.LayoutParams scrollLP = new LinearLayout.LayoutParams(-1, 0);
        scrollLP.weight = 1.0f;
        this.mScrollView.setLayoutParams((ViewGroup.LayoutParams)scrollLP);
        this.mScrollView.setBackgroundColor(-1);
        relAll.addView((View)this.mScrollView);
        this.mLinearLayout = new LinearLayout((Context)this);
        LinearLayout.LayoutParams linearParams = new LinearLayout.LayoutParams(nWidth, nHeight);
        this.mLinearLayout.setOrientation(1);
        this.mLinearLayout.setLayoutParams((ViewGroup.LayoutParams)linearParams);
        this.mLinearLayout.setBackgroundColor(-1);
        this.mScrollView.addView((View)this.mLinearLayout);
        this.mWebView = new WebView((Context)this);
        if (this.mWebView != null) {
            LinearLayout.LayoutParams linearParams1 = new LinearLayout.LayoutParams(nWidth, nHeight);
            this.mWebView.setLayoutParams((ViewGroup.LayoutParams)linearParams1);
            this.mWebView.setBackgroundColor(-1);
            this.mLinearLayout.addView((View)this.mWebView);
        }
        RelativeLayout relBottomBar = new RelativeLayout((Context)this);
        RelativeLayout.LayoutParams relBottom = new RelativeLayout.LayoutParams(-1, barHeight);
        relBottomBar.setLayoutParams((ViewGroup.LayoutParams)relBottom);
        relBottomBar.setBackgroundColor(-986896);
        relAll.addView((View)relBottomBar);
        if (Build.VERSION.SDK_INT >= 21) {
            relBottomBar.setElevation(2.0f);
        }
        this.mBtnPrev = new LeftArrowButton((Context)this);
        this.mBtnPrev.setId(9898);
        RelativeLayout.LayoutParams relPrev = new RelativeLayout.LayoutParams(barHeight, barHeight);
        this.mBtnPrev.setLayoutParams((ViewGroup.LayoutParams)relPrev);
        this.mBtnPrev.setBackgroundColor(0);
        relBottomBar.addView((View)this.mBtnPrev);
        this.mBtnPrev.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                InAppBrowser.this.btnPrevPressed();
            }
        });
        this.mBtnNext = new RightArrowButton((Context)this);
        RelativeLayout.LayoutParams relNext = new RelativeLayout.LayoutParams(barHeight, barHeight);
        relNext.addRule(1, this.mBtnPrev.getId());
        this.mBtnNext.setLayoutParams((ViewGroup.LayoutParams)relNext);
        this.mBtnNext.setBackgroundColor(0);
        relBottomBar.addView((View)this.mBtnNext);
        this.mBtnNext.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                InAppBrowser.this.btnNextPressed();
            }
        });
        this.actInd = new ProgressBar((Context)this);
        RelativeLayout.LayoutParams relActInd = new RelativeLayout.LayoutParams(barHeight / 2, barHeight / 2);
        relActInd.addRule(13);
        this.actInd.setLayoutParams((ViewGroup.LayoutParams)relActInd);
        if (Build.VERSION.SDK_INT < 21) {
            Drawable wrapDrawable = DrawableCompat.wrap((Drawable)this.actInd.getIndeterminateDrawable());
            DrawableCompat.setTint((Drawable)wrapDrawable, (int)-8421505);
            this.actInd.setIndeterminateDrawable(DrawableCompat.unwrap((Drawable)wrapDrawable));
        } else {
            this.actInd.getIndeterminateDrawable().setColorFilter(-8421505, PorterDuff.Mode.SRC_IN);
        }
        this.actInd.setIndeterminate(true);
        relBottomBar.addView((View)this.actInd);
        this.mBtnOpenExternal = new GetOutButton((Context)this);
        RelativeLayout.LayoutParams relOpenExternal = new RelativeLayout.LayoutParams(barHeight, barHeight);
        relOpenExternal.addRule(11);
        this.mBtnOpenExternal.setLayoutParams((ViewGroup.LayoutParams)relOpenExternal);
        this.mBtnOpenExternal.setBackgroundColor(0);
        relBottomBar.addView((View)this.mBtnOpenExternal);
        this.mBtnOpenExternal.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                InAppBrowser.this.btnOpenExternalPressed();
            }
        });
    }

    protected static void CalcScreenRatio(Context ctx) {
        int nHeight = ctx.getResources().getDisplayMetrics().heightPixels;
        int nWidth = ctx.getResources().getDisplayMetrics().widthPixels;
        if (nHeight > nWidth) {
            g_nScreenWidth = nWidth;
            g_fScreenRatio = (double)nWidth / 320.0;
        } else {
            g_nScreenWidth = nHeight;
            g_fScreenRatio = (double)nHeight / 320.0;
        }
    }

    protected static int CalcDPIToReal(Context ctx, int dp) {
        DisplayMetrics metrics = ctx.getResources().getDisplayMetrics();
        return (int)((double)((float)dp * metrics.density) + 0.5);
    }

    static {
        g_fScreenRatio = 1.0;
        g_nScreenWidth = 320;
    }

    @SuppressLint(value={"AppCompatCustomView"})
    private static class RefreshButton
    extends Button {
        public RefreshButton(Context context) {
            super(context);
            this.setFocusable(true);
        }

        protected void onDraw(Canvas canvas) {
            float x2 = 0.25f * (float)mButtonHeight;
            float x5 = 0.5f * (float)mButtonHeight;
            float x6 = 0.6f * (float)mButtonHeight;
            float x8 = 0.75f * (float)mButtonHeight;
            canvas.drawColor(0);
            Paint p = new Paint();
            p.setAntiAlias(true);
            p.setColor(this.isEnabled() ? -8421505 : -4144960);
            p.setStrokeWidth((float)mButtonStroke);
            p.setAlpha(255);
            Paint p2 = new Paint();
            p2.setAntiAlias(true);
            p2.setColor(-986896);
            p2.setStrokeWidth((float)mButtonStroke);
            p2.setAlpha(255);
            Paint p3 = new Paint();
            p3.setAntiAlias(true);
            p3.setStyle(Paint.Style.FILL_AND_STROKE);
            p3.setColor(this.isEnabled() ? -8421505 : -4144960);
            p3.setStrokeWidth(2.0f);
            p3.setAlpha(255);
            RectF rc1 = new RectF(x2, x2, x8, x8);
            canvas.drawArc(rc1, -100.0f, 315.0f, true, p);
            RectF rc2 = new RectF(x2 + (float)mButtonStroke, x2 + (float)mButtonStroke, x8 - (float)mButtonStroke, x8 - (float)mButtonStroke);
            canvas.drawArc(rc2, 0.0f, 360.0f, true, p2);
            Path path = new Path();
            path.setFillType(Path.FillType.EVEN_ODD);
            path.moveTo(x5 - (float)(mButtonStroke * 2), x2 + (float)(mButtonStroke / 2));
            path.lineTo(x5 + (float)(mButtonStroke / 2), x2 - (float)mButtonStroke);
            path.lineTo(x5 + (float)(mButtonStroke / 2), x2 + (float)(2 * mButtonStroke));
            path.lineTo(x5 - (float)(mButtonStroke * 2), x2 + (float)(mButtonStroke / 2));
            path.close();
            canvas.drawPath(path, p3);
        }
    }

    @SuppressLint(value={"AppCompatCustomView"})
    private static class GetOutButton
    extends Button {
        public GetOutButton(Context context) {
            super(context);
            this.setFocusable(true);
        }

        protected void onDraw(Canvas canvas) {
            float x1 = 0.1f * (float)mButtonHeight;
            float x2 = 0.2f * (float)mButtonHeight;
            float x3 = 0.3f * (float)mButtonHeight;
            float x35 = 0.35f * (float)mButtonHeight;
            float x4 = 0.4f * (float)mButtonHeight;
            float x5 = 0.5f * (float)mButtonHeight;
            float x6 = 0.6f * (float)mButtonHeight;
            float x65 = 0.65f * (float)mButtonHeight;
            float x7 = 0.7f * (float)mButtonHeight;
            float x8 = 0.8f * (float)mButtonHeight;
            float x9 = 0.9f * (float)mButtonHeight;
            canvas.drawColor(0);
            Paint p = new Paint();
            p.setAntiAlias(true);
            p.setColor(this.isEnabled() ? -8421505 : -4144960);
            p.setStrokeWidth((float)mButtonStroke);
            p.setAlpha(255);
            canvas.drawLine(x35, x35 - x1, x5, x1, p);
            canvas.drawLine(x5, x1, x65, x35 - x1, p);
            canvas.drawLine(x5, x1, x5, x6, p);
            canvas.drawLine(x3, x4, x4, x4, p);
            canvas.drawLine(x6, x4, x7, x4, p);
            canvas.drawLine(x7, x4, x7, x8, p);
            canvas.drawLine(x7, x8, x3, x8, p);
            canvas.drawLine(x3, x8, x3, x4, p);
        }
    }

    @SuppressLint(value={"AppCompatCustomView"})
    private static class RightArrowButton
    extends Button {
        public RightArrowButton(Context context) {
            super(context);
            this.setFocusable(true);
        }

        protected void onDraw(Canvas canvas) {
            float x2 = 0.2f * (float)mButtonHeight;
            float x4 = 0.4f * (float)mButtonHeight;
            float x5 = 0.5f * (float)mButtonHeight;
            float x6 = 0.6f * (float)mButtonHeight;
            float x8 = 0.8f * (float)mButtonHeight;
            canvas.drawColor(0);
            Paint p = new Paint();
            p.setAntiAlias(true);
            p.setColor(this.isEnabled() ? -8421505 : -4144960);
            p.setStrokeWidth((float)mButtonStroke);
            p.setAlpha(255);
            canvas.drawLine(x4, x2, x6, x5, p);
            canvas.drawLine(x6, x5, x4, x8, p);
        }
    }

    @SuppressLint(value={"AppCompatCustomView"})
    private static class XButton
    extends Button {
        public XButton(Context context) {
            super(context);
            this.setFocusable(true);
        }

        protected void onDraw(Canvas canvas) {
            float x3 = 0.3f * (float)mButtonHeight;
            float x7 = 0.7f * (float)mButtonHeight;
            canvas.drawColor(0);
            Paint p = new Paint();
            p.setAntiAlias(true);
            p.setColor(this.isEnabled() ? -8421505 : -4144960);
            p.setStrokeWidth((float)mButtonStroke);
            p.setAlpha(255);
            canvas.drawLine(x3, x3, x7, x7, p);
            canvas.drawLine(x3, x7, x7, x3, p);
        }
    }

    @SuppressLint(value={"AppCompatCustomView"})
    private static class LeftArrowButton
    extends Button {
        public LeftArrowButton(Context context) {
            super(context);
            this.setFocusable(true);
        }

        protected void onDraw(Canvas canvas) {
            float x2 = 0.2f * (float)mButtonHeight;
            float x4 = 0.4f * (float)mButtonHeight;
            float x5 = 0.5f * (float)mButtonHeight;
            float x6 = 0.6f * (float)mButtonHeight;
            float x8 = 0.8f * (float)mButtonHeight;
            canvas.drawColor(0);
            Paint p = new Paint();
            p.setAntiAlias(true);
            p.setColor(this.isEnabled() ? -8421505 : -4144960);
            p.setStrokeWidth((float)mButtonStroke);
            p.setAlpha(255);
            canvas.drawLine(x6, x2, x4, x5, p);
            canvas.drawLine(x4, x5, x6, x8, p);
        }
    }

    private class HellomWebViewClient
    extends WebViewClient {
        private HellomWebViewClient() {
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            if (!InAppBrowser.this.loadingFinished) {
                InAppBrowser.this.redirect = true;
            }
            InAppBrowser.this.loadingFinished = false;
            DLog.i("MobfoxSDK", "dbg: ### Check redirect: " + url);
            if (InAppBrowser.NeedsSystemToOpenUrl(url) && InAppBrowser.this.mCtx != null) {
                InAppBrowser.OpenURL(InAppBrowser.this.mCtx, url);
                return true;
            }
            InAppBrowser.this.mCurrURL = url;
            view.loadUrl(url);
            InAppBrowser.this.UpdateButtons();
            return true;
        }

        public void onPageStarted(WebView view, String url, Bitmap facIcon) {
            InAppBrowser.this.loadingFinished = false;
            InAppBrowser.this.TurnRotatingIndicatorOnOff(true);
            InAppBrowser.this.UpdateButtons();
        }

        public void onPageFinished(WebView view, String url) {
            if (!InAppBrowser.this.redirect) {
                InAppBrowser.this.loadingFinished = true;
            }
            if (InAppBrowser.this.loadingFinished && !InAppBrowser.this.redirect) {
                InAppBrowser.this.mCurrURL = url;
                InAppBrowser.this.mTitle.setText((CharSequence)view.getTitle());
                if (InAppBrowser.this.mWebView != null) {
                    InAppBrowser.this.mWebView.requestFocusFromTouch();
                }
                InAppBrowser.this.TurnRotatingIndicatorOnOff(false);
                InAppBrowser.this.UpdateButtons();
            } else {
                InAppBrowser.this.redirect = false;
            }
        }
    }
}

