/*
 * Decompiled with CFR 0.152.
 */
package com.mobfox.android.JSInterface;

import android.content.Context;
import android.webkit.JavascriptInterface;
import com.mobfox.android.core.DLog;
import com.mobfox.android.core.javascriptengine.JavascriptEngine;
import com.mobfox.android.core.javascriptengine.proxies.ProxyFactory;

public class NetworkingAPI {
    private JavascriptEngine mEngine = null;
    private ProxyFactory proxy;

    public NetworkingAPI(Context context, JavascriptEngine engine) {
        this.mEngine = engine;
        this.proxy = ProxyFactory.getOurProxy(context);
    }

    @JavascriptInterface
    public String require(String sourceURL) {
        if (this.mEngine != null) {
            return this.mEngine.require(sourceURL);
        }
        return "";
    }

    @JavascriptInterface
    public String getResponse(String key) {
        if (this.mEngine != null) {
            return this.mEngine.getResponse(key);
        }
        return "";
    }

    @JavascriptInterface
    public void request(String url, String params, String method, String cb_id) {
        if (this.mEngine != null) {
            this.mEngine.request(url, params, method, cb_id);
        }
    }

    @JavascriptInterface
    public void requestJSON(String url, String params, String method, String cb_id) {
        if (this.mEngine != null) {
            this.mEngine.requestJSON(url, params, method, cb_id);
        }
    }

    @JavascriptInterface
    public void log(String msg) {
        DLog.d("MobfoxSDK", msg);
    }

    @JavascriptInterface
    public void MFTimeout(String cb_id, int timeoutInMillisecs) {
        if (this.mEngine != null) {
            this.mEngine.MFTimeout(cb_id, timeoutInMillisecs);
        }
    }

    @JavascriptInterface
    public String cacheVideoURL(String url) {
        if (this.proxy != null) {
            String local = this.proxy.getOurProxyUrl(url, false);
            return local;
        }
        return url;
    }
}

