/*
 * Decompiled with CFR 0.152.
 */
package com.mobfox.android.JSInterface;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.webkit.JavascriptInterface;
import com.mobfox.android.Ads.BannerInner;
import com.mobfox.android.Ads.InterstitialInner;
import com.mobfox.android.core.DLog;
import com.mobfox.android.core.MFXConfiguration;
import com.mobfox.android.core.javascriptengine.ControllerEngine;
import org.json.JSONObject;

public class ControllerAPI {
    Context mContext;
    ControllerEngine mControllerEngine;
    Handler mMainHandler;

    public ControllerAPI(Context context, ControllerEngine engine, Handler handler) {
        this.mContext = context;
        this.mControllerEngine = engine;
        this.mMainHandler = handler;
    }

    @JavascriptInterface
    public void SaveRenderArgs(String guid, String renderArgs) {
        ControllerEngine.saveRenderArgs(guid, renderArgs);
    }

    @JavascriptInterface
    public String readPublication(String invh) {
        DLog.v("MobfoxSDK", "dbg: ### CONTROLLER calls readPublication(" + invh + ") ###");
        JSONObject res = null;
        if (this.mContext != null) {
            res = MFXConfiguration.sharedInstance(this.mContext).getPublicationForInvh(invh);
        }
        if (res == null) {
            DLog.e("MobfoxSDK", "dbg: ### No publication for hash code ###");
            res = new JSONObject();
        }
        return res.toString();
    }

    @JavascriptInterface
    public void setHTML(String guid, String html, String params, String cb_id) {
        DLog.v("MobfoxSDK", "dbg: ### CONTROLLER calls setHTML(" + guid + ") ###");
        BannerInner bannerAd = ControllerEngine.getBannerByGUID(guid);
        if (bannerAd != null) {
            bannerAd.setTagHTML(guid, html, params, cb_id);
            return;
        }
        InterstitialInner interAd = ControllerEngine.getInterstitialByGUID(guid);
        if (interAd != null) {
            interAd.setTagHTML(guid, html, params, cb_id);
            return;
        }
    }

    @JavascriptInterface
    public void callFunc(String guid, String name, String params) {
        this.callFunc(guid, name, params, null);
    }

    @JavascriptInterface
    public void callFunc(String guid, String name, String params, String cb_id) {
        DLog.v("MobfoxSDK", "dbg: ### CONTROLLER calls callFunc(" + guid + ", " + name + ") ###");
        if (guid.equalsIgnoreCase("MFXController")) {
            if (Build.VERSION.SDK_INT >= 19) {
                final String cbStr = String.format("%s(%s)", name, params);
                DLog.v("MobfoxSDK", "dbg: ### CONTROLLER calls " + cbStr + " ###");
                if (Thread.currentThread() == this.mMainHandler.getLooper().getThread()) {
                    this.mControllerEngine.evaluate(cbStr, null);
                } else {
                    this.mMainHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            ControllerAPI.this.mControllerEngine.evaluate(cbStr, null);
                        }
                    });
                }
            }
            return;
        }
        BannerInner bannerAd = ControllerEngine.getBannerByGUID(guid);
        if (bannerAd != null) {
            bannerAd.callTagFunc(name, params, cb_id);
            return;
        }
        InterstitialInner interAd = ControllerEngine.getInterstitialByGUID(guid);
        if (interAd != null) {
            interAd.callTagFunc(name, params, cb_id);
            return;
        }
    }

    @JavascriptInterface
    public void SetRefreshTimeout(String guid) {
        DLog.v("MobfoxSDK", "dbg: ### CONTROLLER calls SetRefreshTimeout(" + guid + ") ###");
        BannerInner bannerAd = ControllerEngine.getBannerByGUID(guid);
        if (bannerAd != null) {
            int refreshRateFromCfg = MFXConfiguration.sharedInstance(this.mContext).getRefreshRateConfig(this.mContext);
            int refreshRateFromApp = bannerAd.getAppRefreshRate();
            int refreshRateFromPub = MFXConfiguration.sharedInstance(this.mContext).getPublicationRefreshPeriod(bannerAd.getInvh());
            int nextRefreshIn = refreshRateFromCfg;
            if (refreshRateFromApp != -1) {
                nextRefreshIn = refreshRateFromApp;
            }
            if (refreshRateFromPub != -1) {
                nextRefreshIn = refreshRateFromPub;
            }
            if (nextRefreshIn == 0 || refreshRateFromApp == 0) {
                return;
            }
            bannerAd.triggerRefreshIn(nextRefreshIn);
            return;
        }
    }

    @JavascriptInterface
    public void CloseAd(String guid) {
        DLog.v("MobfoxSDK", "dbg: ### CONTROLLER calls CloseAd(" + guid + ") ###");
        BannerInner bannerAd = ControllerEngine.getBannerByGUID(guid);
        if (bannerAd != null) {
            bannerAd.closeTagAd();
            ControllerEngine.removeBannerFromMap(bannerAd);
            return;
        }
        InterstitialInner interAd = ControllerEngine.getInterstitialByGUID(guid);
        if (interAd != null) {
            ControllerEngine.removeInterstitialFromMap(interAd);
            interAd.closeTagAd();
            return;
        }
    }

    @JavascriptInterface
    public void KillWV(String guid) {
        DLog.v("MobfoxSDK", "dbg: ### CONTROLLER calls KillWV(" + guid + ") ###");
        BannerInner bannerAd = ControllerEngine.getBannerByGUID(guid);
        if (bannerAd != null) {
            return;
        }
        InterstitialInner interAd = ControllerEngine.getInterstitialByGUID(guid);
        if (interAd != null) {
            return;
        }
    }
}

