/*
 * Decompiled with CFR 0.152.
 */
package com.mobfox.android.Ads;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.graphics.Point;
import android.os.Build;
import android.os.Handler;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.mobfox.android.Ads.InterstitialCommunication;
import com.mobfox.android.MobfoxSDK;
import com.mobfox.android.core.DLog;
import com.mobfox.android.core.MFXConfiguration;
import com.mobfox.android.core.MFXStorage;
import com.mobfox.android.core.MFXUtils;
import com.mobfox.android.core.MobfoxSettings;
import com.mobfox.android.core.image.WatermarkProvider;
import com.mobfox.android.core.javascriptengine.ControllerEngine;
import com.mobfox.android.core.logging.MobFoxReport;
import com.mobfox.android.core.logging.ReportsQueueManager;
import com.mobfox.android.core.tags.BaseTag;
import com.mobfox.android.core.tags.InterstitialHtmlTag;
import com.mobfox.android.core.tags.InterstitialVideoTag;
import com.mobfox.android.core.utils.LayoutUtils;
import com.mobfox.android.core.utils.MobFoxRunnable;
import com.mobfox.android.core.utils.SizeUtils;
import java.util.HashMap;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

public class InterstitialInner {
    private InterstitialInnerListener emptyListener = new InterstitialInnerListener(){

        @Override
        public void onInterstitialLoaded(InterstitialInner interstitial) {
        }

        @Override
        public void onInterstitialLoadFailed(InterstitialInner interstitial, String error) {
        }

        @Override
        public void onInterstitialClosed(InterstitialInner interstitial) {
        }

        @Override
        public void onInterstitialClicked(InterstitialInner interstitial, String url) {
        }

        @Override
        public void onInterstitialShown(InterstitialInner interstitial) {
        }

        @Override
        public void onInterstitialFinished(InterstitialInner interstitial) {
        }
    };
    private InterstitialInnerListener mInterstitialListener = null;
    private InternalListener internal_listener;
    private String mGuid = null;
    private String mInvh = null;
    private int mWidth = 0;
    private int mHeight = 0;
    private String mType = null;
    private String mHtml = null;
    private Double mCPM = null;
    private Context mContext = null;
    private float mFloorPrice = -1.0f;
    private String mAdapterName = "core";
    boolean manualSize = false;
    private Handler mainHandler;
    private String mAdResponse = null;
    private int mOrientationAtLoad = 0;
    private boolean mIsRewarded = false;
    private String mCallbackServer = null;
    private int mOldUiOptions = 0;
    InterstitialVideoTag interstitialVideoTag;
    InterstitialHtmlTag interstitialHtmlTag;
    String mCbId = null;
    int mOrientationAtShow = 0;
    int mLockedOrientation = 0;
    private WatermarkProvider watermarkProvider;
    private RelativeLayout mInterstitialLayout = null;

    public InterstitialInner(Context context, String hash, boolean isRewarded) {
        if (!MobfoxSDK.isInitialized()) {
            return;
        }
        this.mContext = context;
        this.mAdapterName = "core";
        this.mIsRewarded = isRewarded;
        ReportsQueueManager.getInstance().initAnalyticsSession(context, hash, "interstitial");
        MobFoxReport.register(context);
        ReportsQueueManager.getInstance().addEventLog("Interstitial constructor", "interstitial", ReportsQueueManager.getLineNumber());
        this.mCPM = null;
        this.mInvh = hash;
        this.mGuid = UUID.randomUUID().toString();
        ControllerEngine.addInterstitialToMap(this);
        this.mType = null;
        this.mainHandler = new Handler(context.getMainLooper());
        this.mInterstitialListener = this.emptyListener;
        this.mAdResponse = null;
        final InterstitialInner self = this;
        this.internal_listener = new InternalListener(){

            @Override
            public void onError(String error) {
                DLog.d("MobfoxSDK", "error: " + error);
            }

            @Override
            public void onClosed() {
                InterstitialInner.this.mInterstitialListener.onInterstitialClosed(self);
            }

            @Override
            public void onClicked(String url) {
                InterstitialInner.this.mInterstitialListener.onInterstitialClicked(self, url);
            }

            @Override
            public void onShown() {
                InterstitialInner.this.mInterstitialListener.onInterstitialShown(self);
            }

            @Override
            public void onFinished() {
                InterstitialInner.this.mInterstitialListener.onInterstitialFinished(self);
            }
        };
        MobfoxSettings.getInstance(context);
    }

    public InterstitialInner(Context context, String hash, boolean isRewarded, InterstitialInnerListener listener) {
        this(context, hash, isRewarded);
        if (!MobfoxSDK.isInitialized()) {
            return;
        }
        this.setListener(listener);
    }

    public void onDestroy() {
        InterstitialCommunication.getInstance().unregisterInternalListener();
        ControllerEngine.getInstance().callNewInterstitialDeallocated(this);
    }

    public void loadWithSize(int w, int h) {
        this.mWidth = w;
        this.mHeight = h;
        this.manualSize = true;
        this.load();
    }

    public void load() {
        if (!MFXUtils.isConnected(this.mContext)) {
            if (this.mInterstitialListener != null) {
                this.mInterstitialListener.onInterstitialLoadFailed(null, "No internet connection");
            }
            return;
        }
        if (!MobfoxSDK.isInitialized()) {
            if (this.mInterstitialListener != null) {
                this.mInterstitialListener.onInterstitialLoadFailed(null, "Mobfox SDK not initialized");
            }
            return;
        }
        if (this.mInterstitialListener == null) {
            return;
        }
        InterstitialCommunication.getInstance().registerInternalListener(this.internal_listener);
        this.loadWhenReady();
    }

    private void loadWhenReady() {
        MobfoxSDK.sharedInstance(this.mContext).performSdkLoadWithCompletion(this.mContext, "InterstitialLoad", new MobfoxSDK.OnLoadSdkCallback(){

            @Override
            public void onLoadResult(String error) {
                if (error != null) {
                    DLog.d("MobfoxSDK", "dbg: ### interstitial load when ready error: " + error);
                } else {
                    DLog.d("MobfoxSDK", "dbg: ### interstitial load when ready ###");
                }
                if (error != null) {
                    if (InterstitialInner.this.mInterstitialListener != null) {
                        InterstitialInner.this.mInterstitialListener.onInterstitialLoadFailed(null, error);
                    }
                    return;
                }
                InterstitialInner.this.mainHandler.postDelayed((Runnable)new MobFoxRunnable(InterstitialInner.this.mContext){

                    @Override
                    public void mobFoxRun() {
                        DLog.release("MobfoxSDK", "dbg: ### Init loading interstitial... ###");
                        MobfoxSettings.getInstance(InterstitialInner.this.mContext).getAndDvId(InterstitialInner.this.mContext, true, new MobfoxSettings.Listener(){

                            @Override
                            public void onFinish(String and_id, boolean do_not_track) {
                                DLog.release("MobfoxSDK", "dbg: ### Loading interstitial ###");
                                InterstitialInner.this.ReallyLoad();
                            }
                        });
                    }
                }, 200L);
            }
        });
    }

    private void ReallyLoad() {
        if (this.mInvh == null || this.mInvh.isEmpty()) {
            this.reportError("No inventory hash set");
            return;
        }
        if (!this.manualSize) {
            this.calculateSize();
        }
        this.mOrientationAtLoad = this.mContext.getResources().getConfiguration().orientation;
        if (this.mOrientationAtLoad == 2) {
            if (this.mWidth < this.mHeight) {
                int tmp = this.mWidth;
                this.mWidth = this.mHeight;
                this.mHeight = tmp;
            }
        } else if (this.mWidth > this.mHeight) {
            int tmp = this.mWidth;
            this.mWidth = this.mHeight;
            this.mHeight = tmp;
        }
        MFXStorage.sharedInstance(this.mContext).setBasicParams(this.mContext, this.mAdapterName);
        MFXStorage.sharedInstance(this.mContext).setInterstitialParams(this.mWidth, this.mHeight, this.mInvh, this.mIsRewarded, this.mCallbackServer);
        MFXStorage.sharedInstance(this.mContext).setLocationParams(this.mContext);
        MFXStorage.sharedInstance(this.mContext).setGDPRParams(this.mContext);
        ControllerEngine.getInstance().callInterstitialLoad(this.mContext, this, this.mInterstitialListener);
    }

    public void show() {
        if (this.mInterstitialListener == null) {
            this.mInterstitialListener.onInterstitialLoadFailed(null, "Mobfox SDK not initialized");
            return;
        }
        if (this.mAdResponse == null || this.mAdResponse.length() == 0) {
            this.reportError("please call show() only after onInterstitialLoaded");
            return;
        }
        ReportsQueueManager.getInstance().addEventLog("show", "interstitial", ReportsQueueManager.getLineNumber());
        ControllerEngine.getInstance().callShowInterstitial(this.mContext, this, this.mAdResponse, this.mInterstitialListener);
    }

    public void onPause(Context ctx) {
        if (this.interstitialVideoTag != null) {
            this.interstitialVideoTag.onPauseVideo();
        }
        if (this.interstitialHtmlTag != null) {
            // empty if block
        }
    }

    public void onResume(Context ctx) {
        this.hideBar(ctx);
        if (this.interstitialVideoTag != null) {
            this.interstitialVideoTag.onResumeVideo();
        }
        if (this.interstitialHtmlTag != null) {
            this.interstitialHtmlTag.onResume();
        }
    }

    public boolean onBackPressed(Context ctx) {
        boolean res = false;
        if (this.interstitialHtmlTag != null) {
            res = true;
            this.interstitialHtmlTag.notifyBackPressToJS();
        }
        if (this.interstitialVideoTag != null) {
            res = true;
            this.interstitialVideoTag.notifyBackPressToJS();
        }
        return res;
    }

    public void setInterstitialFloorPrice(float floorPrice) {
        this.mFloorPrice = floorPrice;
    }

    public float getInterstitialFloorPrice() {
        return this.mFloorPrice;
    }

    public void setInterstitialAdapterName(String adapterName) {
        this.mAdapterName = adapterName;
    }

    public void setRewardedCallbackServer(String endpoint) {
        this.mCallbackServer = endpoint;
    }

    public String getRewardedCallbackServer() {
        if (this.mCallbackServer == null) {
            return "";
        }
        return this.mCallbackServer;
    }

    public void setAdResponse(String adResponse) {
        this.mAdResponse = adResponse;
    }

    public String getGuid() {
        return this.mGuid;
    }

    public String getInvh() {
        return this.mInvh;
    }

    public int getAdWidth() {
        return this.mWidth;
    }

    public int getAdHeight() {
        return this.mHeight;
    }

    public boolean getIsRewarded() {
        return this.mIsRewarded;
    }

    public InterstitialInnerListener getListener() {
        return this.mInterstitialListener;
    }

    public void setListener(InterstitialInnerListener interstitialListener) {
        this.mInterstitialListener = interstitialListener != null ? interstitialListener : this.emptyListener;
    }

    public String getHtml() {
        String res = this.mHtml;
        this.mHtml = null;
        return res;
    }

    public void reportError(String error) {
        if (this.mInterstitialListener != null) {
            this.mInterstitialListener.onInterstitialLoadFailed(this, error);
        }
        DLog.e("MobfoxSDK", "Error getting interstitial: " + error);
    }

    private void calculateSize() {
        this.mWidth = 320;
        this.mHeight = 480;
        try {
            Point size = LayoutUtils.getScreenSize(this.mContext);
            Point nearest = SizeUtils.getNearestSupported(size, true);
            this.mWidth = nearest.x;
            this.mHeight = nearest.y;
        }
        catch (Exception e) {
            DLog.d("MobfoxSDK", "Error in getting size from screen using default");
        }
    }

    public void setTagHTML(String guid, String html, String adResponse, String cb_id) {
        InterstitialInner self = this;
        DLog.v("MobfoxSDK", "dbg: ### ==> Interstitial got setTagHTML cb_id=" + cb_id);
        try {
            ReportsQueueManager.getInstance().updateFlags(adResponse);
            JSONObject response = new JSONObject(adResponse);
            JSONObject metaData = new JSONObject();
            String ad = null;
            Object type = null;
            this.mCPM = MFXUtils.getCPM(response);
            if (response.has("ad")) {
                Object adRes = response.get("ad");
                ad = adRes.toString();
                this.mType = response.getString("type");
                this.mHtml = html;
                this.mCbId = cb_id;
                ReportsQueueManager.getInstance().addEventLog("onMobFoxAdLoaded", "interstitial", ReportsQueueManager.getLineNumber());
                new Handler(this.mContext.getMainLooper()).post(new Runnable(){

                    @Override
                    public void run() {
                        InterstitialInner.this.CreateInterstitial(InterstitialInner.this.mContext);
                    }
                });
            }
        }
        catch (JSONException e) {
            String code = "Unknown Error";
            if (e != null && e.getLocalizedMessage() != null) {
                code = e.getLocalizedMessage();
            }
            DLog.v("MobfoxSDK", "dbg: ### <== Interstitial calls callCallback for setHTML ###");
            ControllerEngine.getInstance().callControllerCallback(cb_id, code, null);
        }
    }

    private boolean addMobfoxInterstitialToViewIfNeeded() {
        ViewGroup v1;
        if (this.mInterstitialLayout == null && (v1 = (ViewGroup)((Activity)this.mContext).findViewById(0x1020002)) != null) {
            this.mInterstitialLayout = new RelativeLayout(this.mContext);
            this.mInterstitialLayout.setBackgroundColor(Color.parseColor((String)"#000000"));
            RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-1, -1);
            this.mInterstitialLayout.setLayoutParams((ViewGroup.LayoutParams)lp);
            v1.addView((View)this.mInterstitialLayout);
            return true;
        }
        return false;
    }

    private void removeOldInterstitialLayoutIfNeeded(Context ctx) {
        if (this.mInterstitialLayout != null) {
            ViewGroup v1 = (ViewGroup)((Activity)this.mContext).findViewById(0x1020002);
            int index = v1.indexOfChild((View)this.mInterstitialLayout);
            if (index != -1) {
                v1.removeViewAt(index);
            }
            this.mInterstitialLayout = null;
        }
    }

    @SuppressLint(value={"SourceLockedOrientationActivity"})
    private void LockOrientation(Context ctx, int accordingToOrientation) {
        this.mLockedOrientation = accordingToOrientation;
        switch (accordingToOrientation) {
            case 2: {
                ((Activity)ctx).setRequestedOrientation(0);
                break;
            }
            case 1: {
                ((Activity)ctx).setRequestedOrientation(1);
                break;
            }
        }
    }

    private void UnockOrientation(Context ctx) {
        ((Activity)ctx).setRequestedOrientation(4);
    }

    private void CreateInterstitial(Context ctx) {
        block14: {
            this.watermarkProvider = WatermarkProvider.getInstance();
            this.mOrientationAtShow = ctx.getResources().getConfiguration().orientation;
            String response = this.mAdResponse;
            if (this.mAdapterName == null || this.mAdapterName.length() == 0) {
                this.mAdapterName = "core";
            }
            String html = ControllerEngine.getInterstitialByGUID(this.mGuid).getHtml();
            this.saveCurrentUiState(ctx);
            this.hideBar(ctx);
            try {
                if (this.mType.equals("html")) {
                    switch (MFXConfiguration.sharedInstance(ctx).getInterstitialHtmlTreatment(ctx)) {
                        case 0: {
                            this.LockOrientation(ctx, this.mOrientationAtLoad);
                            break;
                        }
                        case 1: {
                            this.LockOrientation(ctx, this.mOrientationAtShow);
                            break;
                        }
                    }
                    this.loadInterstitial(html, response, null);
                } else if (this.mType.equals("video")) {
                    switch (MFXConfiguration.sharedInstance(ctx).getInterstitialVideoTreatment(ctx)) {
                        case 0: {
                            this.LockOrientation(ctx, this.mOrientationAtLoad);
                            break;
                        }
                        case 1: {
                            this.LockOrientation(ctx, this.mOrientationAtShow);
                            break;
                        }
                    }
                    this.loadVideo(html, response, null);
                }
            }
            catch (Exception e) {
                InternalListener listener = InterstitialCommunication.getInstance().getInternalListener();
                if (listener == null) break block14;
                listener.onError("MobfoxSDK" + e.getLocalizedMessage());
            }
        }
    }

    private void loadInterstitial(String html, String response, HashMap<String, String> params) throws Exception {
        this.interstitialHtmlTag = new InterstitialHtmlTag((Activity)this.mContext, this.mAdapterName, html, this.mGuid, this.mInvh, response, this.mWidth, this.mHeight, true, params, new BaseTag.OnTagReadyCallback(){

            @Override
            public void onTagReady(BaseTag tag) {
                DLog.v("MobfoxSDK", "dbg: ### <== Interstitial Activity calls callCallback(" + InterstitialInner.this.mCbId + ") for setHTML(html) ###");
                ControllerEngine.getInstance().callControllerCallback(InterstitialInner.this.mCbId, null, "ok");
            }
        });
        if (this.addMobfoxInterstitialToViewIfNeeded()) {
            RelativeLayout.LayoutParams rllp = new RelativeLayout.LayoutParams(-1, -1);
            rllp.addRule(13);
            this.mInterstitialLayout.addView((View)this.interstitialHtmlTag, (ViewGroup.LayoutParams)rllp);
        }
        this.interstitialHtmlTag.load();
        this.addWatermark(this.mContext);
    }

    private void loadVideo(String html, String response, HashMap<String, String> params) throws Exception {
        this.interstitialVideoTag = new InterstitialVideoTag((Activity)this.mContext, this.mAdapterName, html, this.mWidth, this.mHeight, response, this.mGuid, this.mInvh, this.mIsRewarded, this.mCallbackServer, new BaseTag.OnTagReadyCallback(){

            @Override
            public void onTagReady(BaseTag tag) {
                DLog.v("MobfoxSDK", "dbg: ### <== Interstitial Activity calls callCallback(" + InterstitialInner.this.mCbId + ") for setHTML(video) ###");
                ControllerEngine.getInstance().callControllerCallback(InterstitialInner.this.mCbId, null, "ok");
            }
        });
        if (this.addMobfoxInterstitialToViewIfNeeded()) {
            RelativeLayout.LayoutParams rllp = new RelativeLayout.LayoutParams(-1, -1);
            rllp.addRule(13);
            this.mInterstitialLayout.addView((View)this.interstitialVideoTag, (ViewGroup.LayoutParams)rllp);
        }
        this.interstitialVideoTag.load();
        this.addWatermark(this.mContext);
    }

    public void closeTagAd() {
        this.UnockOrientation(this.mContext);
        Activity ctxForUse = (Activity)this.mContext;
        ctxForUse.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                InterstitialInner.this.removeOldInterstitialLayoutIfNeeded(InterstitialInner.this.mContext);
                if (InterstitialInner.this.interstitialHtmlTag != null) {
                    InterstitialInner.this.interstitialHtmlTag.closeTagAd();
                    InterstitialInner.this.interstitialHtmlTag.destroy();
                }
                if (InterstitialInner.this.interstitialVideoTag != null) {
                    InterstitialInner.this.interstitialVideoTag.onPauseVideo();
                    InterstitialInner.this.interstitialVideoTag.closeTagAd();
                    InterstitialInner.this.interstitialVideoTag.destroy();
                }
                InterstitialInner.this.restoreCurrentUiState(InterstitialInner.this.mContext);
            }
        });
    }

    public void callTagFunc(String name, String params, String cb_id) {
        if (this.interstitialHtmlTag != null) {
            this.interstitialHtmlTag.callTagFunc(name, params, cb_id);
            return;
        }
        if (this.interstitialVideoTag != null) {
            this.interstitialVideoTag.callTagFunc(name, params, cb_id);
            return;
        }
    }

    private void hideBar(Context ctx) {
        View decorView = ((Activity)ctx).getWindow().getDecorView();
        int uiOptions = 4358;
        decorView.setSystemUiVisibility(uiOptions);
        if (Build.VERSION.SDK_INT >= 19) {
            Window window = ((Activity)ctx).getWindow();
            window.setFlags(512, 512);
        }
    }

    private void saveCurrentUiState(Context ctx) {
        View decorView = ((Activity)ctx).getWindow().getDecorView();
        this.mOldUiOptions = decorView.getSystemUiVisibility();
    }

    private void restoreCurrentUiState(Context ctx) {
        View decorView = ((Activity)ctx).getWindow().getDecorView();
        decorView.setSystemUiVisibility(this.mOldUiOptions);
        if (Build.VERSION.SDK_INT >= 19) {
            Window window = ((Activity)ctx).getWindow();
            window.setFlags(0, 512);
        }
    }

    private void addWatermark(Context ctx) {
        boolean isVideo = this.mType.equals("video");
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(80, 80);
        WatermarkProvider.WatermarkGravity watermarkGravity = WatermarkProvider.WatermarkGravity.GRAVITY_CENTER;
        if (this.mLockedOrientation == 1) {
            watermarkGravity = WatermarkProvider.WatermarkGravity.GRAVITY_BOTTOM_RIGHT;
            params.gravity = 85;
            params.setMargins(0, 0, 16, 16);
        } else if (isVideo) {
            watermarkGravity = WatermarkProvider.WatermarkGravity.GRAVITY_BOTTOM_LEFT;
            params.gravity = 83;
            params.setMargins(16, 0, 0, 16);
        } else {
            watermarkGravity = WatermarkProvider.WatermarkGravity.GRAVITY_BOTTOM_RIGHT;
            params.gravity = 85;
            params.setMargins(0, 0, 16, 16);
        }
        ImageView imageView = this.watermarkProvider.getImageView(this.mContext, WatermarkProvider.WatermarkSize.LARGE, watermarkGravity);
        if (this.mInterstitialLayout != null) {
            this.mInterstitialLayout.addView((View)imageView, imageView.getLayoutParams());
        } else {
            ((Activity)ctx).addContentView((View)imageView, imageView.getLayoutParams());
        }
    }

    public static interface InternalListener {
        public void onError(String var1);

        public void onClosed();

        public void onClicked(String var1);

        public void onShown();

        public void onFinished();
    }

    public static interface InterstitialInnerListener {
        public void onInterstitialLoaded(InterstitialInner var1);

        public void onInterstitialLoadFailed(InterstitialInner var1, String var2);

        public void onInterstitialClosed(InterstitialInner var1);

        public void onInterstitialClicked(InterstitialInner var1, String var2);

        public void onInterstitialShown(InterstitialInner var1);

        public void onInterstitialFinished(InterstitialInner var1);
    }
}

