/*
 * Decompiled with CFR 0.152.
 */
package com.mobfox.android.Ads;

import android.content.Context;
import android.os.Handler;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.mobfox.android.MobfoxSDK;
import com.mobfox.android.core.DLog;
import com.mobfox.android.core.MFXStorage;
import com.mobfox.android.core.MFXUtils;
import com.mobfox.android.core.MobfoxSettings;
import com.mobfox.android.core.image.WatermarkProvider;
import com.mobfox.android.core.javascriptengine.ControllerEngine;
import com.mobfox.android.core.logging.MobFoxReport;
import com.mobfox.android.core.logging.ReportsQueueManager;
import com.mobfox.android.core.tags.BannerHtmlTag;
import com.mobfox.android.core.tags.BannerVideoTag;
import com.mobfox.android.core.tags.BaseTag;
import com.mobfox.android.core.utils.LayoutUtils;
import com.mobfox.android.core.utils.MobFoxRunnable;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

public class BannerInner
extends RelativeLayout {
    private static final String NAMESPACE_MOBFOX = "http://schemas.android.com/apk/lib/com.mobfox.android.MobfoxSDK";
    private String mGuid = null;
    private String mInvh = null;
    private int mWidth = 0;
    private int mHeight = 0;
    private Double mCPM = null;
    private Context mContext = null;
    private boolean mLayoutReady = false;
    private Handler mainHandler;
    private int mAppRefreshRate = -1;
    private float mFloorPrice = -1.0f;
    private String mAdapterName = "core";
    private ViewGroup mMyTargetView = null;
    private WatermarkProvider watermarkProvider;
    private boolean mBannerIsVideo = false;
    private static final int BANNER_STAGE_IDLE = 0;
    private static final int BANNER_STAGE_CREATED = 1;
    private static final int BANNER_STAGE_LOADING = 2;
    private static final int BANNER_STAGE_LOADED = 3;
    private static final int BANNER_STAGE_SHOWN = 4;
    private int mBannerStage = 0;
    private BannerInnerListener mBannerListener = null;
    private BannerInnerListener emptyListener = new BannerInnerListener(){

        @Override
        public void onBannerLoadFailed(BannerInner banner, String code) {
        }

        @Override
        public void onBannerLoaded(BannerInner banner) {
        }

        @Override
        public void onBannerShown(BannerInner banner) {
        }

        @Override
        public void onBannerClosed(BannerInner banner) {
        }

        @Override
        public void onBannerFinished(BannerInner banner) {
        }

        @Override
        public void onBannerClicked(BannerInner banner, String url) {
        }
    };
    private String mRenderArgs = null;
    private String mAdResponse;
    private BannerHtmlTag mBannerHtmlTag = null;
    private BannerVideoTag mBannerVideoTag = null;

    public BannerInner(final Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.watermarkProvider = WatermarkProvider.getInstance();
        if (!MobfoxSDK.isInitialized()) {
            return;
        }
        this.mAppRefreshRate = -1;
        this.mBannerHtmlTag = null;
        this.mBannerVideoTag = null;
        this.mAdapterName = "core";
        this.mMyTargetView = null;
        this.mBannerIsVideo = false;
        this.mainHandler = new Handler(context.getMainLooper());
        this.mInvh = attrs.getAttributeValue(NAMESPACE_MOBFOX, "inventory");
        this.mGuid = UUID.randomUUID().toString();
        ControllerEngine.addBannerToMap(this);
        ReportsQueueManager.getInstance().initAnalyticsSession(context, this.mInvh, "banner");
        MobFoxReport.register(context);
        ReportsQueueManager.getInstance().addEventLog("Banner constructor(1)", "banner", ReportsQueueManager.getLineNumber());
        BannerInner self = this;
        self.post(new MobFoxRunnable(context, (View)self){
            final /* synthetic */ View val$self;
            {
                this.val$self = view;
                super(context3);
            }

            @Override
            public void mobFoxRun() {
                DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
                int width = (int)Math.ceil((float)this.val$self.getWidth() / displayMetrics.density);
                int height = (int)Math.ceil((float)this.val$self.getHeight() / displayMetrics.density);
                if (height > 45 && height < 55) {
                    height = 50;
                }
                if (height > 85 && height < 95) {
                    height = 90;
                }
                if (height > 245 && height < 255) {
                    height = 250;
                }
                BannerInner.this._init(context, width, height, BannerInner.this.mInvh, true, null);
            }
        });
    }

    public BannerInner(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs);
    }

    public BannerInner(Context context, int width, int height, String invh, BannerInnerListener listener) {
        super(context);
        this.mContext = context;
        this.watermarkProvider = WatermarkProvider.getInstance();
        this.mAdapterName = "core";
        this.mMyTargetView = null;
        this.mBannerIsVideo = false;
        this.mBannerListener = listener;
        this.mAppRefreshRate = -1;
        this.mBannerHtmlTag = null;
        this.mBannerVideoTag = null;
        this.mainHandler = new Handler(context.getMainLooper());
        this.mInvh = invh;
        this.mGuid = UUID.randomUUID().toString();
        ControllerEngine.addBannerToMap(this);
        ReportsQueueManager.getInstance().initAnalyticsSession(context, invh, "banner");
        MobFoxReport.register(context);
        ReportsQueueManager.getInstance().addEventLog("Banner constructor(2)", "banner", ReportsQueueManager.getLineNumber());
        this._init(context, width, height, this.mInvh, false, listener);
    }

    private void _init(Context context, int w, int h, String invh, boolean hasLayout, BannerInnerListener listener) {
        if (!hasLayout) {
            this.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(LayoutUtils.convertDpToPixel(w, context), LayoutUtils.convertDpToPixel(h, context)));
        }
        this.mWidth = w;
        this.mHeight = h;
        this.mContext = context;
        this.mLayoutReady = true;
        this.mCPM = null;
        if (listener != null) {
            this.mBannerListener = listener;
        } else if (this.mBannerListener == null) {
            this.mBannerListener = this.emptyListener;
        }
        this.mBannerStage = 1;
        DLog.release("MobfoxSDK", "dbg: Banner stage set to CREATED ### ");
    }

    public void load() {
        if (!MFXUtils.isConnected(this.mContext)) {
            if (this.mBannerListener != null) {
                this.mBannerListener.onBannerLoadFailed(null, "No internet connection");
            }
            return;
        }
        if (!MobfoxSDK.isInitialized()) {
            if (this.mBannerListener != null) {
                this.mBannerListener.onBannerLoadFailed(null, "Mobfox SDK not initialized");
            }
            return;
        }
        this.loadWhenReady();
    }

    private void loadWhenReady() {
        this.mBannerStage = 2;
        DLog.release("MobfoxSDK", "dbg: Banner stage set to LOADING ### ");
        MobfoxSDK.sharedInstance(this.mContext).performSdkLoadWithCompletion(this.mContext, "BannerLoad", new MobfoxSDK.OnLoadSdkCallback(){

            @Override
            public void onLoadResult(String error) {
                if (error != null) {
                    DLog.d("MobfoxSDK", "dbg: ### banner load when ready error: " + error);
                } else {
                    DLog.d("MobfoxSDK", "dbg: ### banner load when ready ###");
                }
                if (error != null) {
                    if (BannerInner.this.mBannerListener != null) {
                        BannerInner.this.mBannerListener.onBannerLoadFailed(null, error);
                    }
                    return;
                }
                BannerInner.this.mainHandler.postDelayed((Runnable)new MobFoxRunnable(BannerInner.this.mContext){

                    @Override
                    public void mobFoxRun() {
                        DLog.release("MobfoxSDK", "dbg: ### Init loading banner... ###");
                        MobfoxSettings.getInstance(BannerInner.this.mContext).getAndDvId(BannerInner.this.mContext, true, new MobfoxSettings.Listener(){

                            @Override
                            public void onFinish(String and_id, boolean do_not_track) {
                                DLog.release("MobfoxSDK", "dbg: ### Loading banner ###");
                                BannerInner.this.ReallyLoad();
                            }
                        });
                    }
                }, 200L);
            }
        });
    }

    private void ReallyLoad() {
        if (this.mBannerStage != 2) {
            DLog.release("MobfoxSDK", "dbg: Banner stage set to LOADING ### ");
        }
        this.mBannerStage = 2;
        MFXStorage.sharedInstance(this.mContext).setBasicParams(this.mContext, this.mAdapterName);
        MFXStorage.sharedInstance(this.mContext).setBannerParams(this.mWidth, this.mHeight, this.mInvh);
        MFXStorage.sharedInstance(this.mContext).setLocationParams(this.mContext);
        MFXStorage.sharedInstance(this.mContext).setGDPRParams(this.mContext);
        ReportsQueueManager.getInstance().addEventLog("entered loadWhenReady", "banner", ReportsQueueManager.getLineNumber());
        ControllerEngine.getInstance().callBannerLoad(this.mContext, this, this.mBannerListener);
    }

    public void triggerRefreshIn(int nextRefreshIn) {
        DLog.v("MobfoxSDK", "dbg: ### trigger refresh in " + nextRefreshIn);
        if (nextRefreshIn == 0) {
            return;
        }
        this.mainHandler.postDelayed((Runnable)new MobFoxRunnable(this.mContext){

            @Override
            public void mobFoxRun() {
                if (ControllerEngine.controllerReady()) {
                    BannerInner.this.ReallyLoad();
                } else {
                    BannerInner.this.loadWhenReady();
                }
            }
        }, (long)(nextRefreshIn * 1000));
    }

    public void onPause(Context ctx) {
        if (this.mBannerHtmlTag != null) {
            this.mBannerHtmlTag.onPause();
            return;
        }
        if (this.mBannerVideoTag != null) {
            this.mBannerVideoTag.onPauseVideo();
            return;
        }
    }

    public void onResume(Context ctx) {
        if (this.mBannerHtmlTag != null) {
            this.mBannerHtmlTag.onResume();
            return;
        }
        if (this.mBannerVideoTag != null) {
            this.mBannerVideoTag.onResumeVideo();
            return;
        }
    }

    public void setTagHTML(final String guid, final String html, final String adResponse, final String cb_id) {
        BannerInner self = this;
        this.mainHandler.post((Runnable)new MobFoxRunnable(this.mContext){

            @Override
            public void mobFoxRun() {
                try {
                    Object adRes;
                    String type;
                    JSONObject response = new JSONObject(adResponse);
                    ReportsQueueManager.getInstance().updateFlags(adResponse);
                    boolean bIsVideoBanner = false;
                    if (response.has("type") && (type = response.getString("type")) != null && type.equalsIgnoreCase("video")) {
                        bIsVideoBanner = true;
                    }
                    BannerInner.this.mBannerIsVideo = bIsVideoBanner;
                    if (bIsVideoBanner) {
                        if (response.has("ad")) {
                            adRes = response.get("ad");
                            BannerInner.this.mAdResponse = adRes.toString();
                        }
                        if (BannerInner.this.mAdResponse != null) {
                            BannerInner.this.mCPM = MFXUtils.getCPM(response);
                            ReportsQueueManager.getInstance().addEventLog("onMobFoxAdLoaded(Video)", "banner", ReportsQueueManager.getLineNumber());
                            BannerInner.this.loadVideoBannerTag(guid, html, cb_id);
                        }
                    } else {
                        if (response.has("ad")) {
                            adRes = response.getJSONObject("ad");
                            BannerInner.this.mAdResponse = adRes.toString();
                        }
                        if (BannerInner.this.mAdResponse != null) {
                            BannerInner.this.mCPM = MFXUtils.getCPM(response);
                            ReportsQueueManager.getInstance().addEventLog("onMobFoxAdLoaded", "banner", ReportsQueueManager.getLineNumber());
                            BannerInner.this.loadHtmlBannerTag(guid, html, cb_id);
                        }
                    }
                }
                catch (JSONException e) {
                    String code = "Unknown Error";
                    if (e != null && e.getLocalizedMessage() != null) {
                        code = e.getLocalizedMessage();
                    }
                    DLog.e("MobfoxSDK", "dbg: ### <== Banner calls callCallback for setHTML ###");
                    ControllerEngine.getInstance().callControllerCallback(cb_id, code, null);
                }
            }
        });
    }

    public void closeTagAd() {
        if (this.mainHandler != null) {
            this.mainHandler.removeCallbacksAndMessages(null);
        }
        if (this.mBannerHtmlTag != null) {
            if (Thread.currentThread() == this.mainHandler.getLooper().getThread()) {
                this.mBannerHtmlTag.closeTagAd();
                this.mBannerHtmlTag = null;
            } else {
                this.mainHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        BannerInner.this.mBannerHtmlTag.closeTagAd();
                        BannerInner.this.mBannerHtmlTag = null;
                    }
                });
            }
            return;
        }
        if (this.mBannerVideoTag != null) {
            if (Thread.currentThread() == this.mainHandler.getLooper().getThread()) {
                this.mBannerVideoTag.closeTagAd();
                this.mBannerVideoTag = null;
            } else {
                this.mainHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        BannerInner.this.mBannerVideoTag.closeTagAd();
                        BannerInner.this.mBannerVideoTag = null;
                    }
                });
            }
            return;
        }
    }

    public void callTagFunc(String name, String params, String cb_id) {
        if (this.mBannerHtmlTag != null) {
            this.mBannerHtmlTag.callTagFunc(name, params, cb_id);
            return;
        }
        if (this.mBannerVideoTag != null) {
            this.mBannerVideoTag.callTagFunc(name, params, cb_id);
            return;
        }
    }

    private void loadHtmlBannerTag(String guid, String html, final String cb_id) {
        BannerInner self = this;
        if (this.mBannerHtmlTag != null) {
            self.removeAllViews();
            this.mBannerHtmlTag.closeTagAd();
            this.mBannerHtmlTag = null;
        }
        try {
            this.mBannerHtmlTag = new BannerHtmlTag(this.mContext, this.mAdapterName, this.mWidth, this.mHeight, html, this.mGuid, this.mInvh, new BaseTag.OnTagReadyCallback(){

                @Override
                public void onTagReady(BaseTag tag) {
                    DLog.v("MobfoxSDK", "dbg: ### <== Banner calls callCallback for loadHtmlBannerTag ###");
                    ControllerEngine.getInstance().callControllerCallback(cb_id, null, "ok");
                }
            });
        }
        catch (Exception e) {
            String code = "Unknown Error";
            if (e != null && e.getLocalizedMessage() != null) {
                code = e.getLocalizedMessage();
            }
            DLog.e("MobfoxSDK", "dbg: ### <== Banner calls callCallback for loadHtmlBannerTag ###");
            ControllerEngine.getInstance().callControllerCallback(cb_id, code, null);
        }
        self.addView((View)this.mBannerHtmlTag);
    }

    private void loadVideoBannerTag(String guid, String html, final String cb_id) {
        BannerInner self = this;
        if (this.mBannerVideoTag != null) {
            self.removeAllViews();
            this.mBannerVideoTag.closeTagAd();
            this.mBannerVideoTag = null;
        }
        try {
            this.mBannerVideoTag = new BannerVideoTag(this.mContext, this.mAdapterName, html, this.mWidth, this.mHeight, this.mAdResponse, this.mGuid, this.mInvh, new BaseTag.OnTagReadyCallback(){

                @Override
                public void onTagReady(BaseTag tag) {
                    DLog.v("MobfoxSDK", "dbg: ### <== Banner calls callCallback for loadVideoBannerTag ###");
                    ControllerEngine.getInstance().callControllerCallback(cb_id, null, "ok");
                }
            });
        }
        catch (Exception e) {
            String code = "Unknown Error";
            if (e != null && e.getLocalizedMessage() != null) {
                code = e.getLocalizedMessage();
            }
            DLog.e("MobfoxSDK", "dbg: ### <== Banner calls callCallback for loadVideoBannerTag ###");
            ControllerEngine.getInstance().callControllerCallback(cb_id, code, null);
        }
        self.addView((View)this.mBannerVideoTag);
    }

    public void setBannerFloorPrice(float floorPrice) {
        this.mFloorPrice = floorPrice;
    }

    public float getBannerFloorPrice() {
        return this.mFloorPrice;
    }

    public void setBannerAdapterName(String adapterName) {
        this.mAdapterName = adapterName;
    }

    public int getAppRefreshRate() {
        return this.mAppRefreshRate;
    }

    public void setAppRefreshRate(int newVal) {
        this.mAppRefreshRate = newVal;
    }

    public String getGuid() {
        return this.mGuid;
    }

    public String getInvh() {
        return this.mInvh;
    }

    public int getAdWidth() {
        return this.mWidth;
    }

    public int getAdHeight() {
        return this.mHeight;
    }

    public void setListener(BannerInnerListener listener) {
        this.mBannerListener = listener != null ? listener : this.emptyListener;
    }

    public BannerInnerListener getListener() {
        return this.mBannerListener;
    }

    public void addBannerViewTo(ViewGroup targetView) {
        int index;
        if (!MobfoxSDK.isInitialized()) {
            if (this.mBannerListener != null) {
                this.mBannerListener.onBannerLoadFailed(null, "Mobfox SDK not initialized");
            }
            return;
        }
        if (this.mMyTargetView != null && this.mMyTargetView != targetView && (index = this.mMyTargetView.indexOfChild((View)this)) != -1) {
            targetView.removeViewAt(index);
        }
        this.mMyTargetView = targetView;
        index = targetView.indexOfChild((View)this);
        if (index == -1) {
            targetView.addView((View)this);
            this.addWatermark();
            if (this.mBannerStage == 3) {
                ControllerEngine.getInstance().callShowBanner(this.mContext, this, this.mRenderArgs, this.mBannerListener);
                this.mBannerStage = 4;
                DLog.release("MobfoxSDK", "dbg: Banner stage set to SHOWN ### ");
            }
        }
    }

    public void setBannerStageLoaded() {
        final BannerInner self = this;
        this.mBannerStage = 3;
        DLog.release("MobfoxSDK", "dbg: Banner stage set to LOADED ### ");
        if (this.mMyTargetView != null) {
            this.mainHandler.post((Runnable)new MobFoxRunnable(this.mContext){

                @Override
                public void mobFoxRun() {
                    ControllerEngine.getInstance().callShowBanner(BannerInner.this.mContext, self, BannerInner.this.mRenderArgs, BannerInner.this.mBannerListener);
                    if (BannerInner.this.mBannerStage != 4) {
                        BannerInner.this.mBannerStage = 4;
                        DLog.release("MobfoxSDK", "dbg: Banner stage set to SHOWN ### ");
                        BannerInner.this.addWatermark();
                    }
                }
            });
        }
    }

    private void addWatermark() {
        ImageView watermark = this.watermarkProvider.getImageView(this.mContext, WatermarkProvider.WatermarkSize.SMALL, this.mBannerIsVideo ? WatermarkProvider.WatermarkGravity.GRAVITY_BOTTOM_LEFT : WatermarkProvider.WatermarkGravity.GRAVITY_BOTTOM_RIGHT);
        watermark.setTag((Object)"watermark");
        this.addView((View)watermark);
    }

    public void saveRenderArgs(String renderArgs) {
        this.mRenderArgs = renderArgs;
    }

    public static interface BannerInnerListener {
        public void onBannerLoadFailed(BannerInner var1, String var2);

        public void onBannerLoaded(BannerInner var1);

        public void onBannerShown(BannerInner var1);

        public void onBannerClosed(BannerInner var1);

        public void onBannerFinished(BannerInner var1);

        public void onBannerClicked(BannerInner var1, String var2);
    }
}

