/*
 * Decompiled with CFR 0.152.
 */
package com.github.mmin18.widget;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.support.v8.renderscript.Allocation;
import android.support.v8.renderscript.Element;
import android.support.v8.renderscript.RSRuntimeException;
import android.support.v8.renderscript.RenderScript;
import android.support.v8.renderscript.ScriptIntrinsicBlur;
import android.support.v8.renderscript.Type;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewTreeObserver;
import com.github.mmin18.realtimeblurview.R;

public class RealtimeBlurView
extends View {
    private float mDownsampleFactor;
    private int mOverlayColor;
    private float mBlurRadius;
    private boolean mDirty;
    private Bitmap mBitmapToBlur;
    private Bitmap mBlurredBitmap;
    private Canvas mBlurringCanvas;
    private RenderScript mRenderScript;
    private ScriptIntrinsicBlur mBlurScript;
    private Allocation mBlurInput;
    private Allocation mBlurOutput;
    private boolean mIsRendering;
    private final Rect mRectSrc = new Rect();
    private final Rect mRectDst = new Rect();
    private static int RENDERING_COUNT;
    private final ViewTreeObserver.OnPreDrawListener preDrawListener = new ViewTreeObserver.OnPreDrawListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean onPreDraw() {
            int[] locations = new int[2];
            if (RealtimeBlurView.this.isShown() && RealtimeBlurView.this.prepare()) {
                View decor = ((Activity)RealtimeBlurView.this.getContext()).getWindow().getDecorView();
                decor.getLocationInWindow(locations);
                int x = -locations[0];
                int y = -locations[1];
                RealtimeBlurView.this.getLocationInWindow(locations);
                x += locations[0];
                y += locations[1];
                if (decor.getBackground() instanceof ColorDrawable) {
                    RealtimeBlurView.this.mBitmapToBlur.eraseColor(((ColorDrawable)decor.getBackground()).getColor());
                } else {
                    RealtimeBlurView.this.mBitmapToBlur.eraseColor(0);
                }
                int rc = RealtimeBlurView.this.mBlurringCanvas.save();
                RealtimeBlurView.this.mIsRendering = true;
                RENDERING_COUNT++;
                try {
                    RealtimeBlurView.this.mBlurringCanvas.scale(1.0f * (float)RealtimeBlurView.this.mBlurredBitmap.getWidth() / (float)RealtimeBlurView.this.getWidth(), 1.0f * (float)RealtimeBlurView.this.mBlurredBitmap.getHeight() / (float)RealtimeBlurView.this.getHeight());
                    RealtimeBlurView.this.mBlurringCanvas.translate((float)(-x), (float)(-y));
                    decor.draw(RealtimeBlurView.this.mBlurringCanvas);
                }
                catch (StopException stopException) {
                }
                finally {
                    RealtimeBlurView.this.mIsRendering = false;
                    RENDERING_COUNT--;
                    RealtimeBlurView.this.mBlurringCanvas.restoreToCount(rc);
                }
                RealtimeBlurView.this.blur();
            }
            return true;
        }
    };
    private static StopException STOP_EXCEPTION;

    public RealtimeBlurView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.RealtimeBlurView);
        this.mBlurRadius = a.getDimension(R.styleable.RealtimeBlurView_realtimeBlurRadius, TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)context.getResources().getDisplayMetrics()));
        this.mDownsampleFactor = a.getFloat(R.styleable.RealtimeBlurView_realtimeDownsampleFactor, 4.0f);
        this.mOverlayColor = a.getColor(R.styleable.RealtimeBlurView_realtimeOverlayColor, -1426063361);
        a.recycle();
    }

    public void setBlurRadius(float radius) {
        if (this.mBlurRadius != radius) {
            this.mBlurRadius = radius;
            this.mDirty = true;
            this.invalidate();
        }
    }

    public void setDownsampleFactor(float factor) {
        if (factor <= 0.0f) {
            throw new IllegalArgumentException("Downsample factor must be greater than 0.");
        }
        if (this.mDownsampleFactor != factor) {
            this.mDownsampleFactor = factor;
            this.mDirty = true;
            this.releaseBitmap();
            this.invalidate();
        }
    }

    public void setOverlayColor(int color) {
        if (this.mOverlayColor != color) {
            this.mOverlayColor = color;
            this.invalidate();
        }
    }

    private void releaseBitmap() {
        if (this.mBlurInput != null) {
            this.mBlurInput.destroy();
            this.mBlurInput = null;
        }
        if (this.mBlurOutput != null) {
            this.mBlurOutput.destroy();
            this.mBlurOutput = null;
        }
        if (this.mBitmapToBlur != null) {
            this.mBitmapToBlur.recycle();
            this.mBitmapToBlur = null;
        }
        if (this.mBlurredBitmap != null) {
            this.mBlurredBitmap.recycle();
            this.mBlurredBitmap = null;
        }
    }

    private void releaseScript() {
        if (this.mRenderScript != null) {
            this.mRenderScript.destroy();
            this.mRenderScript = null;
        }
        if (this.mBlurScript != null) {
            this.mBlurScript.destroy();
            this.mBlurScript = null;
        }
    }

    protected void release() {
        this.releaseBitmap();
        this.releaseScript();
    }

    protected boolean prepare() {
        if (this.mBlurRadius == 0.0f) {
            this.release();
            return false;
        }
        float downsampleFactor = this.mDownsampleFactor;
        if (this.mDirty || this.mRenderScript == null) {
            if (this.mRenderScript == null) {
                try {
                    this.mRenderScript = RenderScript.create((Context)this.getContext());
                    this.mBlurScript = ScriptIntrinsicBlur.create((RenderScript)this.mRenderScript, (Element)Element.U8_4((RenderScript)this.mRenderScript));
                }
                catch (RSRuntimeException e) {
                    if (e.getMessage() != null && e.getMessage().startsWith("Error loading RS jni library: java.lang.UnsatisfiedLinkError:")) {
                        throw new RuntimeException("Error loading RS jni library, Upgrade buildToolsVersion=\"23.0.3\" or higher may solve this issue");
                    }
                    throw e;
                }
            }
            this.mDirty = false;
            float radius = this.mBlurRadius / downsampleFactor;
            if (radius > 25.0f) {
                downsampleFactor = downsampleFactor * radius / 25.0f;
                radius = 25.0f;
            }
            this.mBlurScript.setRadius(radius);
        }
        int width = this.getWidth();
        int height = this.getHeight();
        int scaledWidth = (int)((float)width / downsampleFactor);
        int scaledHeight = (int)((float)height / downsampleFactor);
        if (this.mBlurringCanvas == null || this.mBlurredBitmap == null || this.mBlurredBitmap.getWidth() != scaledWidth || this.mBlurredBitmap.getHeight() != scaledHeight) {
            this.releaseBitmap();
            this.mBitmapToBlur = Bitmap.createBitmap((int)scaledWidth, (int)scaledHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            if (this.mBitmapToBlur == null) {
                return false;
            }
            this.mBlurredBitmap = Bitmap.createBitmap((int)scaledWidth, (int)scaledHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            if (this.mBlurredBitmap == null) {
                return false;
            }
            this.mRectSrc.right = scaledWidth;
            this.mRectSrc.bottom = scaledHeight;
            this.mBlurringCanvas = new Canvas(this.mBitmapToBlur);
            this.mBlurInput = Allocation.createFromBitmap((RenderScript)this.mRenderScript, (Bitmap)this.mBitmapToBlur, (Allocation.MipmapControl)Allocation.MipmapControl.MIPMAP_NONE, (int)1);
            this.mBlurOutput = Allocation.createTyped((RenderScript)this.mRenderScript, (Type)this.mBlurInput.getType());
        }
        return true;
    }

    protected void blur() {
        this.mBlurInput.copyFrom(this.mBitmapToBlur);
        this.mBlurScript.setInput(this.mBlurInput);
        this.mBlurScript.forEach(this.mBlurOutput);
        this.mBlurOutput.copyTo(this.mBlurredBitmap);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.getViewTreeObserver().addOnPreDrawListener(this.preDrawListener);
    }

    protected void onDetachedFromWindow() {
        this.getViewTreeObserver().removeOnPreDrawListener(this.preDrawListener);
        this.release();
        super.onDetachedFromWindow();
    }

    public void draw(Canvas canvas) {
        if (this.mIsRendering) {
            throw STOP_EXCEPTION;
        }
        if (RENDERING_COUNT <= 0) {
            super.draw(canvas);
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mBlurredBitmap != null) {
            this.mRectDst.right = this.getWidth();
            this.mRectDst.bottom = this.getHeight();
            canvas.drawBitmap(this.mBlurredBitmap, this.mRectSrc, this.mRectDst, null);
        }
        canvas.drawColor(this.mOverlayColor);
    }

    static {
        STOP_EXCEPTION = new StopException();
        try {
            RealtimeBlurView.class.getClassLoader().loadClass("android.support.v8.renderscript.RenderScript");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("RenderScript support not enabled. Add \"android { defaultConfig { renderscriptSupportModeEnabled true }}\" in your build.gradle");
        }
    }

    private static class StopException
    extends RuntimeException {
        private StopException() {
        }
    }
}

