/*
 * Decompiled with CFR 0.152.
 */
package com.github.mmin18.widget;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.support.v8.renderscript.Allocation;
import android.support.v8.renderscript.Element;
import android.support.v8.renderscript.RenderScript;
import android.support.v8.renderscript.ScriptIntrinsicBlur;
import android.support.v8.renderscript.Type;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import com.github.mmin18.realtimeblurview.R;

public class RealtimeBlurView
extends View {
    private float mDownsampleFactor;
    private int mOverlayColor;
    private float mBlurRadius;
    private boolean mDownsampleFactorChanged;
    private Bitmap mBitmapToBlur;
    private Bitmap mBlurredBitmap;
    private Canvas mBlurringCanvas;
    private RenderScript mRenderScript;
    private ScriptIntrinsicBlur mBlurScript;
    private Allocation mBlurInput;
    private Allocation mBlurOutput;
    private boolean mIsRendering;
    private final Rect mRectSrc = new Rect();
    private final Rect mRectDst = new Rect();
    private final ViewTreeObserver.OnPreDrawListener preDrawListener = new ViewTreeObserver.OnPreDrawListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean onPreDraw() {
            if (RealtimeBlurView.this.isShown() && RealtimeBlurView.this.prepare()) {
                View decor = ((Activity)RealtimeBlurView.this.getContext()).getWindow().getDecorView();
                int x = RealtimeBlurView.this.getLeft();
                int y = RealtimeBlurView.this.getTop();
                RealtimeBlurView v = RealtimeBlurView.this;
                while (v.getParent() instanceof ViewGroup && (v = (View)v.getParent()) != decor) {
                    x += v.getLeft();
                    y += v.getTop();
                }
                if (decor.getBackground() instanceof ColorDrawable) {
                    RealtimeBlurView.this.mBitmapToBlur.eraseColor(((ColorDrawable)decor.getBackground()).getColor());
                } else {
                    RealtimeBlurView.this.mBitmapToBlur.eraseColor(0);
                }
                RealtimeBlurView.this.mIsRendering = true;
                int rc = RealtimeBlurView.this.mBlurringCanvas.save();
                try {
                    RealtimeBlurView.this.mBlurringCanvas.scale(1.0f * (float)RealtimeBlurView.this.mBlurredBitmap.getWidth() / (float)RealtimeBlurView.this.getWidth(), 1.0f * (float)RealtimeBlurView.this.mBlurredBitmap.getHeight() / (float)RealtimeBlurView.this.getHeight());
                    RealtimeBlurView.this.mBlurringCanvas.translate((float)(-x), (float)(-y));
                    decor.draw(RealtimeBlurView.this.mBlurringCanvas);
                }
                catch (StopException stopException) {
                }
                finally {
                    RealtimeBlurView.this.mBlurringCanvas.restoreToCount(rc);
                    RealtimeBlurView.this.mIsRendering = false;
                }
                RealtimeBlurView.this.blur();
            }
            return true;
        }
    };
    private static StopException STOP_EXCEPTION = new StopException();

    public RealtimeBlurView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.RealtimeBlurView);
        this.mBlurRadius = a.getInt(R.styleable.RealtimeBlurView_blurRadius, 15);
        this.mDownsampleFactor = a.getInt(R.styleable.RealtimeBlurView_downsampleFactor, 4);
        this.mOverlayColor = a.getColor(R.styleable.RealtimeBlurView_overlayColor, -1426063361);
        a.recycle();
    }

    public void setBlurRadius(int radius) {
        if (this.mBlurScript != null) {
            this.mBlurScript.setRadius((float)radius);
        }
    }

    public void setDownsampleFactor(int factor) {
        if (factor <= 0) {
            throw new IllegalArgumentException("Downsample factor must be greater than 0.");
        }
        if (this.mDownsampleFactor != (float)factor) {
            this.mDownsampleFactor = factor;
            this.mDownsampleFactorChanged = true;
        }
    }

    public void setOverlayColor(int color) {
        this.mOverlayColor = color;
    }

    protected boolean prepare() {
        if (this.mRenderScript == null) {
            this.mRenderScript = RenderScript.create((Context)this.getContext());
            this.mBlurScript = ScriptIntrinsicBlur.create((RenderScript)this.mRenderScript, (Element)Element.U8_4((RenderScript)this.mRenderScript));
            this.mBlurScript.setRadius(this.mBlurRadius);
        }
        int width = this.getWidth();
        int height = this.getHeight();
        int scaledWidth = (int)((float)width / this.mDownsampleFactor);
        int scaledHeight = (int)((float)height / this.mDownsampleFactor);
        if (this.mBlurringCanvas == null || this.mDownsampleFactorChanged || this.mBlurredBitmap == null || this.mBlurredBitmap.getWidth() != scaledWidth || this.mBlurredBitmap.getHeight() != scaledHeight) {
            if (this.mBlurInput != null) {
                this.mBlurInput.destroy();
                this.mBlurInput = null;
            }
            if (this.mBlurOutput != null) {
                this.mBlurOutput = null;
            }
            if (this.mBitmapToBlur != null) {
                this.mBitmapToBlur.recycle();
                this.mBitmapToBlur = null;
            }
            if (this.mBlurredBitmap != null) {
                this.mBlurredBitmap.recycle();
                this.mBlurredBitmap = null;
            }
            this.mDownsampleFactorChanged = false;
            this.mBitmapToBlur = Bitmap.createBitmap((int)scaledWidth, (int)scaledHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            if (this.mBitmapToBlur == null) {
                return false;
            }
            this.mBlurredBitmap = Bitmap.createBitmap((int)scaledWidth, (int)scaledHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            if (this.mBlurredBitmap == null) {
                return false;
            }
            this.mRectSrc.right = scaledWidth;
            this.mRectSrc.bottom = scaledHeight;
            this.mBlurringCanvas = new Canvas(this.mBitmapToBlur);
            this.mBlurInput = Allocation.createFromBitmap((RenderScript)this.mRenderScript, (Bitmap)this.mBitmapToBlur, (Allocation.MipmapControl)Allocation.MipmapControl.MIPMAP_NONE, (int)1);
            this.mBlurOutput = Allocation.createTyped((RenderScript)this.mRenderScript, (Type)this.mBlurInput.getType());
        }
        return true;
    }

    protected void blur() {
        this.mBlurInput.copyFrom(this.mBitmapToBlur);
        this.mBlurScript.setInput(this.mBlurInput);
        this.mBlurScript.forEach(this.mBlurOutput);
        this.mBlurOutput.copyTo(this.mBlurredBitmap);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.getViewTreeObserver().addOnPreDrawListener(this.preDrawListener);
    }

    protected void onDetachedFromWindow() {
        this.getViewTreeObserver().removeOnPreDrawListener(this.preDrawListener);
        if (this.mRenderScript != null) {
            this.mRenderScript.destroy();
            this.mRenderScript = null;
        }
        if (this.mBlurScript != null) {
            this.mBlurScript.destroy();
            this.mBlurScript = null;
        }
        super.onDetachedFromWindow();
    }

    public void draw(Canvas canvas) {
        if (this.mIsRendering) {
            throw STOP_EXCEPTION;
        }
        super.draw(canvas);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mBlurredBitmap != null) {
            this.mRectDst.right = this.getWidth();
            this.mRectDst.bottom = this.getHeight();
            canvas.drawBitmap(this.mBlurredBitmap, this.mRectSrc, this.mRectDst, null);
            canvas.drawColor(this.mOverlayColor);
        }
    }

    private static class StopException
    extends RuntimeException {
        private StopException() {
        }
    }
}

