/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkolisnyk.cucumber.assertions;

import com.github.mkolisnyk.cucumber.assertions.LazyAssertionError;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;

public final class MatcherLazyAssert {
    private MatcherLazyAssert() {
    }

    public static <T> void assertThat(String reason, T actual, Matcher<? super T> matcher) {
        if (!matcher.matches(actual)) {
            StringDescription description = new StringDescription();
            description.appendText(reason).appendText("\nExpected: ").appendDescriptionOf(matcher).appendText("\n     but: ");
            matcher.describeMismatch(actual, (Description)description);
            throw new LazyAssertionError(description.toString());
        }
    }

    public static void assertThat(String reason, boolean assertion) {
        if (!assertion) {
            throw new LazyAssertionError(reason);
        }
    }
}

