/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.utils;

import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class HttpConnection {
    private static final int TIMEOUT_CONNECTION = 3000;
    private static final int TIMEOUT_SOCKET = 10000;
    private static OkHttpClient client;
    private InputStream stream;
    private String mUserAgent;
    private Response response;

    private static OkHttpClient getOkHttpClient() {
        if (client == null) {
            OkHttpClient.Builder b = new OkHttpClient.Builder();
            b.connectTimeout(3000L, TimeUnit.MILLISECONDS);
            b.readTimeout(10000L, TimeUnit.MILLISECONDS);
            client = b.build();
        }
        return client;
    }

    public void setUserAgent(String userAgent) {
        this.mUserAgent = userAgent;
    }

    public void doGet(String url) {
        try {
            Request.Builder request = new Request.Builder().url(url);
            if (this.mUserAgent != null) {
                request.addHeader("User-Agent", this.mUserAgent);
            }
            this.response = HttpConnection.getOkHttpClient().newCall(request.build()).execute();
            Integer status = this.response.code();
            if (status != 200) {
                Log.e((String)"BONUSPACK", (String)("Invalid response from server: " + status.toString()));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public InputStream getStream() {
        if (this.response == null) {
            return null;
        }
        this.stream = this.response.body().byteStream();
        return this.stream;
    }

    public String getContentAsString() {
        try {
            if (this.response == null) {
                return null;
            }
            return this.response.body().string();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void close() {
        if (this.stream != null) {
            try {
                this.stream.close();
                this.stream = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

