/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.os.Build;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import org.osmdroid.bonuspack.utils.HttpConnection;

public class BonusPackHelper {
    public static final String LOG_TAG = "BONUSPACK";
    public static final int UNDEFINED_RES_ID = 0;
    public static final String DEFAULT_USER_AGENT = "OsmBonusPack/1";

    public static boolean isEmulator() {
        return "google_sdk".equals(Build.PRODUCT) || "sdk".equals(Build.PRODUCT);
    }

    private static String readStream(HttpConnection connection) {
        return connection.getContentAsString();
    }

    public static String requestStringFromUrl(String url, String userAgent) {
        HttpConnection connection = new HttpConnection();
        if (userAgent != null) {
            connection.setUserAgent(userAgent);
        }
        connection.doGet(url);
        String result = connection.getContentAsString();
        connection.close();
        return result;
    }

    public static String requestStringFromUrl(String url) {
        return BonusPackHelper.requestStringFromUrl(url, null);
    }

    public static Bitmap loadBitmap(String url) {
        Bitmap bitmap;
        try {
            InputStream is = (InputStream)new URL(url).getContent();
            if (is == null) {
                return null;
            }
            bitmap = BitmapFactory.decodeStream((InputStream)new FlushedInputStream(is));
            bitmap.setDensity(160);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return bitmap;
    }

    public static HashMap<String, String> parseStringMapResource(Context ctx, int stringArrayResourceId) {
        String[] stringArray = ctx.getResources().getStringArray(stringArrayResourceId);
        HashMap<String, String> map = new HashMap<String, String>(stringArray.length);
        for (String entry : stringArray) {
            String[] splitResult = entry.split("\\|", 2);
            map.put(splitResult[0], splitResult[1]);
        }
        return map;
    }

    public static Bitmap getBitmapFromVectorDrawable(Context context, int drawableId) {
        Drawable drawable = ContextCompat.getDrawable((Context)context, (int)drawableId);
        if (Build.VERSION.SDK_INT < 21) {
            drawable = DrawableCompat.wrap((Drawable)drawable).mutate();
        }
        Bitmap bitmap = Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable.draw(canvas);
        return bitmap;
    }

    static class FlushedInputStream
    extends FilterInputStream {
        public FlushedInputStream(InputStream inputStream) {
            super(inputStream);
        }

        @Override
        public long skip(long n) throws IOException {
            long totalBytesSkipped;
            long bytesSkipped;
            for (totalBytesSkipped = 0L; totalBytesSkipped < n; totalBytesSkipped += bytesSkipped) {
                bytesSkipped = this.in.skip(n - totalBytesSkipped);
                if (bytesSkipped != 0L) continue;
                int byteValue = this.read();
                if (byteValue < 0) break;
                bytesSkipped = 1L;
            }
            return totalBytesSkipped;
        }
    }
}

