/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.sharing;

import android.util.Log;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import org.osmdroid.bonuspack.sharing.Friend;
import org.osmdroid.bonuspack.sharing.Partner;
import org.osmdroid.bonuspack.utils.BonusPackHelper;
import org.osmdroid.util.GeoPoint;

public class Friends {
    public ArrayList<Friend> friendsList;
    public ArrayList<Partner> partners;
    public static final String NAV_SERVER_URL = "https://comob.org/sharing/";
    protected String mUserAgent;

    public Friends(String userAgent) {
        this.mUserAgent = userAgent;
    }

    public Friend get(int index) {
        return this.friendsList.get(index);
    }

    public int size() {
        return this.friendsList.size();
    }

    public int getFriendWithId(String friendId) {
        if (friendId == null || this.friendsList == null) {
            return -1;
        }
        for (int i = 0; i < this.size(); ++i) {
            Friend f = this.get(i);
            if (!friendId.equals(f.mId)) continue;
            return i;
        }
        return -1;
    }

    public String callStartSharing(String uniqueId, String nickname, String group, String message) {
        String url = null;
        try {
            url = "https://comob.org/sharing/jstart.php?nickname=" + URLEncoder.encode(nickname, "UTF-8") + "&group_id=" + URLEncoder.encode(group, "UTF-8") + "&user_id=" + URLEncoder.encode(uniqueId, "UTF-8") + "&message=" + URLEncoder.encode(message, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        String result = BonusPackHelper.requestStringFromUrl(url, this.mUserAgent);
        if (result == null) {
            return "Technical error with the server";
        }
        try {
            JsonElement json = JsonParser.parseString((String)result);
            JsonObject jResult = json.getAsJsonObject();
            String answer = jResult.get("answer").getAsString();
            if (!"ok".equals(answer)) {
                return jResult.get("error").getAsString();
            }
            JsonArray jPartners = jResult.get("partners").getAsJsonArray();
            this.partners = new ArrayList(jPartners.size());
            for (JsonElement jPartner : jPartners) {
                JsonObject jPO = jPartner.getAsJsonObject();
                Partner partner = new Partner(jPO);
                this.partners.add(partner);
            }
        }
        catch (JsonSyntaxException e) {
            return "Technical error with the server";
        }
        return null;
    }

    public String callUpdateSharing(String uniqueId, GeoPoint myPosition, double azimuthAngleSpeed) {
        int hasLocation;
        this.friendsList = null;
        int n = hasLocation = myPosition != null ? 1 : 0;
        if (myPosition == null) {
            myPosition = new GeoPoint(0.0, 0.0);
        }
        String url = null;
        try {
            url = "https://comob.org/sharing/jupdate.php?user_id=" + URLEncoder.encode(uniqueId, "UTF-8") + "&has_location=" + hasLocation + "&lat=" + myPosition.getLatitude() + "&lon=" + myPosition.getLongitude() + "&bearing=" + azimuthAngleSpeed;
        }
        catch (UnsupportedEncodingException e) {
            return "Technical error with the server";
        }
        Log.d((String)"BONUSPACK", (String)("callUpdateSharing:" + url));
        String result = BonusPackHelper.requestStringFromUrl(url, this.mUserAgent);
        if (result == null) {
            return "Technical error with the server";
        }
        try {
            JsonElement json = JsonParser.parseString((String)result);
            JsonObject jResult = json.getAsJsonObject();
            String answer = jResult.get("answer").getAsString();
            if (!"ok".equals(answer)) {
                return jResult.get("error").getAsString();
            }
            JsonArray jFriends = jResult.get("people").getAsJsonArray();
            this.friendsList = new ArrayList(jFriends.size());
            for (JsonElement jFriend : jFriends) {
                JsonObject joFriend = (JsonObject)jFriend;
                Friend friend = new Friend(joFriend);
                this.friendsList.add(friend);
            }
        }
        catch (JsonSyntaxException e) {
            return "Technical error with the server";
        }
        return null;
    }

    public String callStopSharing(String uniqueId) {
        this.friendsList = null;
        String url = null;
        try {
            url = "https://comob.org/sharing/jstop.php?user_id=" + URLEncoder.encode(uniqueId, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "Technical error with the server";
        }
        String result = BonusPackHelper.requestStringFromUrl(url, this.mUserAgent);
        if (result == null) {
            return "Technical error with the server";
        }
        try {
            JsonElement json = JsonParser.parseString((String)result);
            JsonObject jResult = json.getAsJsonObject();
            String answer = jResult.get("answer").getAsString();
            if (!"ok".equals(answer)) {
                return jResult.get("error").getAsString();
            }
        }
        catch (JsonSyntaxException e) {
            return "Technical error with the server";
        }
        return null;
    }
}

