/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.routing;

import android.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.osmdroid.bonuspack.routing.Road;
import org.osmdroid.bonuspack.routing.RoadManager;
import org.osmdroid.bonuspack.routing.RoadNode;
import org.osmdroid.bonuspack.utils.BonusPackHelper;
import org.osmdroid.bonuspack.utils.PolylineEncoder;
import org.osmdroid.util.BoundingBox;
import org.osmdroid.util.GeoPoint;

public class GraphHopperRoadManager
extends RoadManager {
    protected static final String SERVICE = "https://graphhopper.com/api/1/route?";
    public static final int STATUS_NO_ROUTE = 3;
    protected String mServiceUrl = "https://graphhopper.com/api/1/route?";
    protected String mKey;
    protected boolean mWithElevation;
    protected boolean mAlternateAvailable;
    static final HashMap<Integer, Integer> MANEUVERS = new HashMap();

    public GraphHopperRoadManager(String apiKey, boolean alternateAvailable) {
        this.mKey = apiKey;
        this.mWithElevation = false;
        this.mAlternateAvailable = alternateAvailable;
    }

    public void setService(String serviceUrl) {
        this.mServiceUrl = serviceUrl;
    }

    public void setElevation(boolean withElevation) {
        this.mWithElevation = withElevation;
    }

    protected String getUrl(ArrayList<GeoPoint> waypoints, boolean getAlternate) {
        StringBuilder urlString = new StringBuilder(this.mServiceUrl);
        urlString.append("key=" + this.mKey);
        for (int i = 0; i < waypoints.size(); ++i) {
            GeoPoint p = waypoints.get(i);
            urlString.append("&point=" + this.geoPointAsString(p));
        }
        urlString.append("&elevation=" + (this.mWithElevation ? "true" : "false"));
        if (getAlternate && this.mAlternateAvailable) {
            urlString.append("&ch.disable=true&algorithm=alternative_route");
        }
        urlString.append(this.mOptions);
        return urlString.toString();
    }

    protected Road[] defaultRoad(ArrayList<GeoPoint> waypoints) {
        Road[] roads = new Road[]{new Road(waypoints)};
        return roads;
    }

    public Road[] getRoads(ArrayList<GeoPoint> waypoints, boolean getAlternate) {
        String url = this.getUrl(waypoints, getAlternate);
        Log.d((String)"BONUSPACK", (String)("GraphHopper.getRoads:" + url));
        String jString = BonusPackHelper.requestStringFromUrl(url);
        if (jString == null) {
            return this.defaultRoad(waypoints);
        }
        try {
            JSONObject jRoot = new JSONObject(jString);
            JSONArray jPaths = jRoot.optJSONArray("paths");
            if (jPaths == null || jPaths.length() == 0) {
                return this.defaultRoad(waypoints);
            }
            Road[] roads = new Road[jPaths.length()];
            for (int r = 0; r < jPaths.length(); ++r) {
                Road road;
                JSONObject jPath = jPaths.getJSONObject(r);
                String route_geometry = jPath.getString("points");
                roads[r] = road = new Road();
                road.mRouteHigh = PolylineEncoder.decode(route_geometry, 10, this.mWithElevation);
                JSONArray jInstructions = jPath.getJSONArray("instructions");
                int n = jInstructions.length();
                for (int i = 0; i < n; ++i) {
                    JSONObject jInstruction = jInstructions.getJSONObject(i);
                    RoadNode node = new RoadNode();
                    JSONArray jInterval = jInstruction.getJSONArray("interval");
                    int positionIndex = jInterval.getInt(0);
                    node.mLocation = road.mRouteHigh.get(positionIndex);
                    node.mLength = jInstruction.getDouble("distance") / 1000.0;
                    node.mDuration = (double)jInstruction.getInt("time") / 1000.0;
                    int direction = jInstruction.getInt("sign");
                    node.mManeuverType = this.getManeuverCode(direction);
                    node.mInstructions = jInstruction.getString("text");
                    road.mNodes.add(node);
                }
                road.mLength = jPath.getDouble("distance") / 1000.0;
                road.mDuration = (double)jPath.getInt("time") / 1000.0;
                JSONArray jBBox = jPath.getJSONArray("bbox");
                road.mBoundingBox = new BoundingBox(jBBox.getDouble(3), jBBox.getDouble(2), jBBox.getDouble(1), jBBox.getDouble(0));
                road.mStatus = 0;
                road.buildLegs(waypoints);
                Log.d((String)"BONUSPACK", (String)"GraphHopper.getRoads - finished");
            }
            return roads;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return this.defaultRoad(waypoints);
        }
    }

    @Override
    public Road[] getRoads(ArrayList<GeoPoint> waypoints) {
        return this.getRoads(waypoints, true);
    }

    @Override
    public Road getRoad(ArrayList<GeoPoint> waypoints) {
        Road[] roads = this.getRoads(waypoints, false);
        return roads[0];
    }

    protected int getManeuverCode(int direction) {
        Integer code = MANEUVERS.get(direction);
        if (code != null) {
            return code;
        }
        return 0;
    }

    static {
        MANEUVERS.put(0, 1);
        MANEUVERS.put(1, 6);
        MANEUVERS.put(2, 7);
        MANEUVERS.put(3, 8);
        MANEUVERS.put(-3, 5);
        MANEUVERS.put(-2, 4);
        MANEUVERS.put(-1, 3);
        MANEUVERS.put(4, 24);
        MANEUVERS.put(5, 24);
    }
}

