/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.routing;

import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Locale;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.osmdroid.bonuspack.routing.GoogleDirectionsHandler;
import org.osmdroid.bonuspack.routing.Road;
import org.osmdroid.bonuspack.routing.RoadLeg;
import org.osmdroid.bonuspack.routing.RoadManager;
import org.osmdroid.bonuspack.utils.HttpConnection;
import org.osmdroid.util.GeoPoint;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GoogleRoadManager
extends RoadManager {
    static final String GOOGLE_DIRECTIONS_SERVICE = "http://maps.googleapis.com/maps/api/directions/xml?";

    protected String getUrl(ArrayList<GeoPoint> waypoints, boolean getAlternates) {
        StringBuilder urlString = new StringBuilder(GOOGLE_DIRECTIONS_SERVICE);
        urlString.append("origin=");
        GeoPoint p = waypoints.get(0);
        urlString.append(this.geoPointAsString(p));
        urlString.append("&destination=");
        int destinationIndex = waypoints.size() - 1;
        p = waypoints.get(destinationIndex);
        urlString.append(this.geoPointAsString(p));
        for (int i = 1; i < destinationIndex; ++i) {
            if (i == 1) {
                urlString.append("&waypoints=");
            } else {
                urlString.append("%7C");
            }
            p = waypoints.get(i);
            urlString.append(this.geoPointAsString(p));
        }
        urlString.append("&alternatives=" + (getAlternates ? "true" : "false"));
        urlString.append("&units=metric");
        Locale locale = Locale.getDefault();
        urlString.append("&language=" + locale.getLanguage());
        urlString.append(this.mOptions);
        return urlString.toString();
    }

    protected Road[] getRoads(ArrayList<GeoPoint> waypoints, boolean getAlternate) {
        String url = this.getUrl(waypoints, getAlternate);
        Log.d((String)"BONUSPACK", (String)("GoogleRoadManager.getRoads:" + url));
        Road[] roads = null;
        HttpConnection connection = new HttpConnection();
        connection.doGet(url);
        InputStream stream = connection.getStream();
        if (stream != null) {
            roads = this.getRoadsXML(stream);
        }
        connection.close();
        if (roads == null || roads.length == 0) {
            roads = new Road[]{new Road(waypoints)};
        } else {
            for (int i = 0; i < roads.length; ++i) {
                Road road = roads[i];
                for (RoadLeg leg : road.mLegs) {
                    road.mDuration += leg.mDuration;
                    road.mLength += leg.mLength;
                }
                road.mStatus = 0;
            }
        }
        Log.d((String)"BONUSPACK", (String)"GoogleRoadManager.getRoads - finished");
        return roads;
    }

    @Override
    public Road[] getRoads(ArrayList<GeoPoint> waypoints) {
        return this.getRoads(waypoints, true);
    }

    @Override
    public Road getRoad(ArrayList<GeoPoint> waypoints) {
        Road[] roads = this.getRoads(waypoints, false);
        return roads[0];
    }

    protected Road[] getRoadsXML(InputStream is) {
        GoogleDirectionsHandler handler = new GoogleDirectionsHandler();
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse(is, (DefaultHandler)handler);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Road[] roads = new Road[handler.mRoads.size()];
        for (int i = 0; i < roads.length; ++i) {
            roads[i] = handler.mRoads.get(i);
        }
        return roads;
    }
}

