/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.location;

import android.graphics.Bitmap;
import android.os.AsyncTask;
import android.os.Parcel;
import android.os.Parcelable;
import android.widget.ImageView;
import org.osmdroid.bonuspack.utils.WebImageCache;
import org.osmdroid.util.GeoPoint;

public class POI
implements Parcelable {
    public static int POI_SERVICE_NOMINATIM = 100;
    public static int POI_SERVICE_GEONAMES_WIKIPEDIA = 200;
    public static int POI_SERVICE_FLICKR = 300;
    public static int POI_SERVICE_PICASA = 400;
    public static int POI_SERVICE_OVERPASS_API = 500;
    private static WebImageCache mThumbnailCache = new WebImageCache(300);
    public int mServiceId;
    public long mId;
    public GeoPoint mLocation;
    public String mCategory;
    public String mType;
    public String mDescription;
    public String mThumbnailPath;
    public Bitmap mThumbnail;
    public String mUrl;
    public int mRank;
    protected int mThumbnailLoadingFailures;
    protected static int MAX_LOADING_ATTEMPTS = 2;
    public static final Parcelable.Creator<POI> CREATOR = new Parcelable.Creator<POI>(){

        public POI createFromParcel(Parcel source) {
            return new POI(source);
        }

        public POI[] newArray(int size) {
            return new POI[size];
        }
    };

    public POI(int serviceId) {
        this.mServiceId = serviceId;
    }

    public Bitmap getThumbnail() {
        if (this.mThumbnail == null && this.mThumbnailPath != null) {
            this.mThumbnail = mThumbnailCache.get(this.mThumbnailPath);
            if (this.mThumbnail == null) {
                ++this.mThumbnailLoadingFailures;
                if (this.mThumbnailLoadingFailures >= MAX_LOADING_ATTEMPTS) {
                    this.mThumbnailPath = null;
                }
            }
        }
        return this.mThumbnail;
    }

    public void fetchThumbnailOnThread(ImageView imageView) {
        if (this.mThumbnail != null) {
            imageView.setImageBitmap(this.mThumbnail);
            imageView.setVisibility(0);
        } else if (this.mThumbnailPath != null) {
            imageView.setVisibility(8);
            new ThumbnailTask(imageView).execute(new ImageView[]{imageView});
        } else {
            imageView.setVisibility(8);
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mServiceId);
        out.writeLong(this.mId);
        out.writeParcelable((Parcelable)this.mLocation, 0);
        out.writeString(this.mCategory);
        out.writeString(this.mType);
        out.writeString(this.mDescription);
        out.writeString(this.mThumbnailPath);
        out.writeParcelable((Parcelable)this.mThumbnail, 0);
        out.writeString(this.mUrl);
        out.writeInt(this.mRank);
        out.writeInt(this.mThumbnailLoadingFailures);
    }

    private POI(Parcel in) {
        this.mServiceId = in.readInt();
        this.mId = in.readLong();
        this.mLocation = (GeoPoint)in.readParcelable(GeoPoint.class.getClassLoader());
        this.mCategory = in.readString();
        this.mType = in.readString();
        this.mDescription = in.readString();
        this.mThumbnailPath = in.readString();
        this.mThumbnail = (Bitmap)in.readParcelable(Bitmap.class.getClassLoader());
        this.mUrl = in.readString();
        this.mRank = in.readInt();
        this.mThumbnailLoadingFailures = in.readInt();
    }

    class ThumbnailTask
    extends AsyncTask<ImageView, Void, ImageView> {
        public ThumbnailTask(ImageView iv) {
            iv.setTag((Object)POI.this.mThumbnailPath);
        }

        protected ImageView doInBackground(ImageView ... params) {
            POI.this.getThumbnail();
            return params[0];
        }

        protected void onPostExecute(ImageView iv) {
            if (iv.getTag() != null && POI.this.mThumbnailPath != null && POI.this.mThumbnailPath.equals(iv.getTag().toString())) {
                iv.setImageBitmap(POI.this.mThumbnail);
                iv.setVisibility(0);
            }
        }
    }
}

