/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.location;

import android.location.Address;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.osmdroid.bonuspack.utils.BonusPackHelper;
import org.osmdroid.util.BoundingBox;

public class GeocoderGraphHopper {
    public static final String GRAPHHOPPER_SERVICE_URL = "https://graphhopper.com/api/1/geocode?";
    protected Locale mLocale;
    protected String mServiceUrl;
    protected String mKey;

    public GeocoderGraphHopper(Locale locale, String appKey) {
        this.mLocale = locale;
        this.setService(GRAPHHOPPER_SERVICE_URL);
        this.mKey = appKey;
    }

    public static boolean isPresent() {
        return true;
    }

    public void setService(String serviceUrl) {
        this.mServiceUrl = serviceUrl;
    }

    protected Address buildAndroidAddress(JsonObject jResult) throws JsonSyntaxException {
        Address gAddress = new Address(this.mLocale);
        String displayName = "";
        if (!jResult.has("point") || !jResult.has("name")) {
            return null;
        }
        JsonObject jPoint = jResult.get("point").getAsJsonObject();
        gAddress.setLatitude(jPoint.get("lat").getAsDouble());
        gAddress.setLongitude(jPoint.get("lng").getAsDouble());
        int addressIndex = 0;
        if (jResult.has("name")) {
            gAddress.setAddressLine(addressIndex++, jResult.get("name").getAsString());
            gAddress.setThoroughfare(jResult.get("name").getAsString());
            displayName = jResult.get("name").getAsString();
        }
        if (jResult.has("postcode")) {
            gAddress.setAddressLine(addressIndex++, jResult.get("postcode").getAsString());
            gAddress.setPostalCode(jResult.get("postcode").getAsString());
            displayName = displayName + ", " + jResult.get("postcode").getAsString();
        }
        if (jResult.has("city")) {
            gAddress.setAddressLine(addressIndex++, jResult.get("city").getAsString());
            gAddress.setLocality(jResult.get("city").getAsString());
            displayName = displayName + ", " + jResult.get("city").getAsString();
        }
        if (jResult.has("state")) {
            gAddress.setAdminArea(jResult.get("state").getAsString());
        }
        if (jResult.has("country")) {
            gAddress.setAddressLine(addressIndex++, jResult.get("country").getAsString());
            gAddress.setCountryName(jResult.get("country").getAsString());
            displayName = displayName + ", " + jResult.get("country").getAsString();
        }
        Bundle extras = new Bundle();
        if (jResult.has("extent")) {
            JsonArray jBoundingBox = jResult.get("extent").getAsJsonArray();
            BoundingBox bb = new BoundingBox(jBoundingBox.get(3).getAsDouble(), jBoundingBox.get(1).getAsDouble(), jBoundingBox.get(1).getAsDouble(), jBoundingBox.get(2).getAsDouble());
            extras.putParcelable("boundingbox", (Parcelable)bb);
        }
        if (jResult.has("osm_id")) {
            long osm_id = jResult.get("osm_id").getAsLong();
            extras.putLong("osm_id", osm_id);
        }
        if (jResult.has("osm_type")) {
            String osm_type = jResult.get("osm_type").getAsString();
            extras.putString("osm_type", osm_type);
        }
        extras.putString("display_name", displayName);
        gAddress.setExtras(extras);
        return gAddress;
    }

    public List<Address> getFromLocation(double latitude, double longitude, int maxResults) throws IOException {
        String url = this.mServiceUrl + "reverse=true";
        if (this.mKey != null) {
            url = url + "&key=" + this.mKey;
        }
        url = url + "&locale=" + this.mLocale.getLanguage() + "&limit=" + maxResults + "&point=" + latitude + "," + longitude;
        Log.d((String)"BONUSPACK", (String)("GeocoderGraphHopper::getFromLocation:" + url));
        String result = BonusPackHelper.requestStringFromUrl(url);
        if (result == null) {
            throw new IOException();
        }
        try {
            JsonParser parser = new JsonParser();
            JsonElement json = parser.parse(result);
            JsonObject jResult = json.getAsJsonObject();
            JsonArray jHits = jResult.getAsJsonArray("hits");
            ArrayList<Address> list = new ArrayList<Address>(jHits.size());
            for (int i = 0; i < jHits.size(); ++i) {
                Address gAddress = this.buildAndroidAddress(jHits.get(i).getAsJsonObject());
                if (gAddress == null) continue;
                list.add(gAddress);
            }
            return list;
        }
        catch (JsonSyntaxException e) {
            throw new IOException();
        }
    }

    public List<Address> getFromLocationName(String locationName, int maxResults, double lowerLeftLatitude, double lowerLeftLongitude, double upperRightLatitude, double upperRightLongitude, boolean bounded) throws IOException {
        String url = this.mServiceUrl;
        if (this.mKey != null) {
            url = url + "key=" + this.mKey + "&";
        }
        url = url + "locale=" + this.mLocale.getLanguage() + "&limit=" + maxResults + "&q=" + URLEncoder.encode(locationName);
        if (lowerLeftLatitude != 0.0 && upperRightLatitude != 0.0) {
            url = url + "&point=" + (upperRightLatitude + upperRightLongitude / 2.0) + "," + (lowerLeftLongitude + lowerLeftLongitude) / 2.0;
        }
        Log.d((String)"BONUSPACK", (String)("GeocoderGraphHopper::getFromLocationName:" + url));
        String result = BonusPackHelper.requestStringFromUrl(url);
        if (result == null) {
            throw new IOException();
        }
        try {
            JsonParser parser = new JsonParser();
            JsonElement json = parser.parse(result);
            JsonObject jResult = json.getAsJsonObject();
            JsonArray jHits = jResult.getAsJsonArray("hits");
            ArrayList<Address> list = new ArrayList<Address>(jHits.size());
            for (int i = 0; i < jHits.size(); ++i) {
                JsonObject jAddress = jHits.get(i).getAsJsonObject();
                Address gAddress = this.buildAndroidAddress(jAddress);
                if (gAddress == null) continue;
                list.add(gAddress);
            }
            return list;
        }
        catch (JsonSyntaxException e) {
            throw new IOException();
        }
    }

    public List<Address> getFromLocationName(String locationName, int maxResults, double lowerLeftLatitude, double lowerLeftLongitude, double upperRightLatitude, double upperRightLongitude) throws IOException {
        return this.getFromLocationName(locationName, maxResults, lowerLeftLatitude, lowerLeftLongitude, upperRightLatitude, upperRightLongitude, true);
    }

    public List<Address> getFromLocationName(String locationName, int maxResults) throws IOException {
        return this.getFromLocationName(locationName, maxResults, 0.0, 0.0, 0.0, 0.0, false);
    }
}

