/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.location;

import android.util.Log;
import java.util.ArrayList;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.osmdroid.bonuspack.location.POI;
import org.osmdroid.bonuspack.utils.BonusPackHelper;
import org.osmdroid.util.BoundingBox;
import org.osmdroid.util.GeoPoint;

public class GeoNamesPOIProvider {
    protected String mUserName;

    public GeoNamesPOIProvider(String account) {
        this.mUserName = account;
    }

    private String getUrlCloseTo(GeoPoint p, int maxResults, double maxDistance) {
        StringBuilder url = new StringBuilder("http://api.geonames.org/findNearbyWikipediaJSON?");
        url.append("lat=" + p.getLatitude());
        url.append("&lng=" + p.getLongitude());
        url.append("&maxRows=" + maxResults);
        url.append("&radius=" + maxDistance);
        url.append("&lang=" + Locale.getDefault().getLanguage());
        url.append("&username=" + this.mUserName);
        return url.toString();
    }

    private String getUrlInside(BoundingBox boundingBox, int maxResults) {
        StringBuilder url = new StringBuilder("http://api.geonames.org/wikipediaBoundingBoxJSON?");
        url.append("south=" + boundingBox.getLatSouth());
        url.append("&north=" + boundingBox.getLatNorth());
        url.append("&east=" + boundingBox.getLonEast());
        url.append("&west=" + boundingBox.getLonWest());
        url.append("&maxRows=" + maxResults);
        url.append("&lang=" + Locale.getDefault().getLanguage());
        url.append("&username=" + this.mUserName);
        return url.toString();
    }

    public ArrayList<POI> getThem(String fullUrl) {
        Log.d((String)"BONUSPACK", (String)("GeoNamesPOIProvider:get:" + fullUrl));
        String jString = BonusPackHelper.requestStringFromUrl(fullUrl);
        if (jString == null) {
            Log.e((String)"BONUSPACK", (String)"GeoNamesPOIProvider: request failed.");
            return null;
        }
        try {
            JSONObject jRoot = new JSONObject(jString);
            JSONArray jPlaceIds = jRoot.getJSONArray("geonames");
            int n = jPlaceIds.length();
            ArrayList<POI> pois = new ArrayList<POI>(n);
            for (int i = 0; i < n; ++i) {
                JSONObject jPlace = jPlaceIds.getJSONObject(i);
                POI poi = new POI(POI.POI_SERVICE_GEONAMES_WIKIPEDIA);
                poi.mLocation = new GeoPoint(jPlace.getDouble("lat"), jPlace.getDouble("lng"), jPlace.optDouble("elevation", 0.0));
                poi.mCategory = jPlace.optString("feature");
                poi.mType = jPlace.getString("title");
                poi.mDescription = jPlace.optString("summary");
                poi.mThumbnailPath = jPlace.optString("thumbnailImg", null);
                poi.mUrl = jPlace.optString("wikipediaUrl", null);
                if (poi.mUrl != null) {
                    poi.mUrl = "http://" + poi.mUrl;
                }
                poi.mRank = jPlace.optInt("rank", 0);
                pois.add(poi);
            }
            Log.d((String)"BONUSPACK", (String)"done");
            return pois;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ArrayList<POI> getPOICloseTo(GeoPoint position, int maxResults, double maxDistance) {
        String url = this.getUrlCloseTo(position, maxResults, maxDistance);
        return this.getThem(url);
    }

    public ArrayList<POI> getPOIInside(BoundingBox boundingBox, int maxResults) {
        String url = this.getUrlInside(boundingBox, maxResults);
        return this.getThem(url);
    }
}

